/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.pde.internal.build.AbstractBuildScriptGenerator;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.pde.internal.build.ant.FileSet;

public abstract class ModelBuildScriptGenerator
extends AbstractBuildScriptGenerator {
    protected PluginModel model;
    protected static final String FULL_NAME = AbstractScriptGenerator.getPropertyFormat("full.name");
    protected static final String PLUGIN_DESTINATION = AbstractScriptGenerator.getPropertyFormat("plugin.destination");
    protected static final String PLUGIN_ZIP_DESTINATION = String.valueOf(PLUGIN_DESTINATION) + "/" + FULL_NAME + ".zip";
    protected static final String PLUGIN_UPDATE_JAR_DESTINATION = String.valueOf(PLUGIN_DESTINATION) + "/" + FULL_NAME + ".jar";

    public void generate() throws CoreException {
        if (this.model == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, Policy.bind("error.missingElement"), null));
        }
        try {
            String custom = (String)((Hashtable)this.getBuildProperties(this.model)).get("custom");
            if (custom != null && custom.equalsIgnoreCase("true")) {
                String root = this.getLocation(this.model);
                File buildFile = new File(root, this.buildScriptName);
                this.updateVersion(buildFile, "version.suffix", this.model.getVersion());
                return;
            }
            String targetLocation = this.getScriptTargetLocation();
            if (targetLocation == null) {
                targetLocation = this.getLocation(this.model);
            }
            File root = new File(targetLocation);
            File target = new File(root, this.buildScriptName);
            AntScript script = new AntScript(new FileOutputStream(target));
            try {
                this.generateBuildScript(script);
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                script.close();
                throw throwable;
            }
            Object var6_11 = null;
            script.close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, Policy.bind("exception.writeScript"), (Throwable)e));
        }
    }

    protected void generateBuildScript(AntScript script) throws CoreException {
        this.generatePrologue(script);
        this.generateBuildUpdateJarTarget(script);
        this.generateGatherBinPartsTarget(script);
        this.generateBuildJarsTarget(script, this.model);
        this.generateBuildZipsTarget(script);
        this.generateGatherSourcesTarget(script);
        this.generateGatherLogTarget(script);
        this.generateCleanTarget(script);
        this.generateRefreshTarget(script);
        this.generateZipPluginTarget(script);
        this.generateZipFolderTarget(script);
        this.generateEpilogue(script);
    }

    private void generateZipFolderTarget(AntScript script) {
        script.printTargetDeclaration(1, "zip.folder", "init", null, null, null);
        script.printZipTask(2, PLUGIN_ZIP_DESTINATION, AbstractBuildScriptGenerator.TEMP_FOLDER, true, "**/*.bin.log", false, null);
        script.printTargetEnd(1);
    }

    protected void generateCleanTarget(AntScript script) throws CoreException {
        int tab = 1;
        script.println();
        Properties properties = this.getBuildProperties(this.model);
        AbstractBuildScriptGenerator.JAR[] availableJars = this.extractJars(properties);
        script.printTargetDeclaration(tab++, "clean", "init", null, null, Policy.bind("build.plugin.clean", this.model.getId()));
        int i = 0;
        while (i < availableJars.length) {
            String jarName = availableJars[i].getName(true);
            script.printDeleteTask(tab, null, this.getJARLocation(jarName), null);
            script.printDeleteTask(tab, null, this.getSRCLocation(jarName), null);
            ++i;
        }
        script.printDeleteTask(tab, null, PLUGIN_UPDATE_JAR_DESTINATION, null);
        script.printDeleteTask(tab, null, PLUGIN_ZIP_DESTINATION, null);
        script.printDeleteTask(tab, AbstractBuildScriptGenerator.TEMP_FOLDER, null, null);
        script.printTargetEnd(--tab);
    }

    protected void generateGatherLogTarget(AntScript script) throws CoreException {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "gather.logs", "init", "destination.temp.folder", null, null);
        Path baseDestination = new Path(AbstractScriptGenerator.getPropertyFormat("destination.temp.folder"));
        baseDestination = baseDestination.append(FULL_NAME);
        ArrayList<IPath> destinations = new ArrayList<IPath>(5);
        Properties properties = this.getBuildProperties(this.model);
        AbstractBuildScriptGenerator.JAR[] availableJars = this.extractJars(properties);
        int i = 0;
        while (i < availableJars.length) {
            String name = availableJars[i].getName(true);
            IPath destination = baseDestination.append(name).removeLastSegments(1);
            if (!destinations.contains(destination)) {
                script.printMkdirTask(tab, destination.toString());
                destinations.add(destination);
            }
            script.printCopyTask(tab, String.valueOf(this.getTempJARFolderLocation(name)) + ".log", destination.toString(), null);
            ++i;
        }
        script.printTargetEnd(--tab);
    }

    protected void generateZipIndividualTarget(AntScript script, String zipName, String source) throws CoreException {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, zipName, "init", null, null, null);
        Path root = new Path(AbstractBuildScriptGenerator.BASEDIR);
        script.printZipTask(tab, root.append(zipName).toString(), root.append(source).toString(), false, null, false, null);
        script.printTargetEnd(--tab);
    }

    protected void generateGatherSourcesTarget(AntScript script) throws CoreException {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "gather.sources", "init", "destination.temp.folder", null, null);
        Path baseDestination = new Path(AbstractScriptGenerator.getPropertyFormat("destination.temp.folder"));
        baseDestination = baseDestination.append(FULL_NAME);
        ArrayList<IPath> destinations = new ArrayList<IPath>(5);
        Properties properties = this.getBuildProperties(this.model);
        AbstractBuildScriptGenerator.JAR[] availableJars = this.extractJars(properties);
        int i = 0;
        while (i < availableJars.length) {
            String jar = availableJars[i].getName(true);
            IPath destination = baseDestination.append(jar).removeLastSegments(1);
            if (!destinations.contains(destination)) {
                script.printMkdirTask(tab, destination.toString());
                destinations.add(destination);
            }
            script.printCopyTask(tab, this.getSRCLocation(jar), destination.toString(), null);
            ++i;
        }
        String include = (String)((Hashtable)this.getBuildProperties(this.model)).get("src.includes");
        String exclude = (String)((Hashtable)this.getBuildProperties(this.model)).get("src.excludes");
        if (include != null || exclude != null) {
            FileSet fileSet = new FileSet(AbstractBuildScriptGenerator.BASEDIR, null, include, null, exclude, null, null);
            script.printCopyTask(tab, null, baseDestination.toString(), new FileSet[]{fileSet});
        }
        script.printTargetEnd(--tab);
    }

    protected void generateGatherBinPartsTarget(AntScript script) throws CoreException {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "gather.bin.parts", "init", "destination.temp.folder", null, null);
        Path destination = new Path(AbstractScriptGenerator.getPropertyFormat("destination.temp.folder"));
        destination = destination.append(FULL_NAME);
        String root = destination.toString();
        script.printMkdirTask(tab, root);
        ArrayList<Object> destinations = new ArrayList<Object>(5);
        destinations.add(destination);
        Properties properties = this.getBuildProperties(this.model);
        AbstractBuildScriptGenerator.JAR[] availableJars = this.extractJars(properties);
        int i = 0;
        while (i < availableJars.length) {
            String jar = availableJars[i].getName(true);
            IPath dest = destination.append(jar).removeLastSegments(1);
            if (!destinations.contains(dest)) {
                script.printMkdirTask(tab, dest.toString());
                destinations.add(dest);
            }
            script.printCopyTask(tab, this.getJARLocation(jar), dest.toString(), null);
            ++i;
        }
        String include = (String)((Hashtable)this.getBuildProperties(this.model)).get("bin.includes");
        String exclude = (String)((Hashtable)this.getBuildProperties(this.model)).get("bin.excludes");
        if (include != null || exclude != null) {
            FileSet fileSet = new FileSet(AbstractBuildScriptGenerator.BASEDIR, null, include, null, exclude, null, null);
            script.printCopyTask(tab, null, root, new FileSet[]{fileSet});
        }
        script.printTargetEnd(--tab);
    }

    protected void generateZipPluginTarget(AntScript script) throws CoreException {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "zip.plugin", "init", null, null, Policy.bind("build.plugin.zipPlugin", this.model.getId()));
        script.printDeleteTask(tab, AbstractBuildScriptGenerator.TEMP_FOLDER, null, null);
        script.printMkdirTask(tab, AbstractBuildScriptGenerator.TEMP_FOLDER);
        script.printAntCallTask(tab, "build.jars", null, null);
        script.printAntCallTask(tab, "build.sources", null, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("destination.temp.folder", String.valueOf(AbstractBuildScriptGenerator.TEMP_FOLDER) + "/");
        script.printAntCallTask(tab, "gather.bin.parts", null, params);
        script.printAntCallTask(tab, "gather.sources", null, params);
        FileSet fileSet = new FileSet(AbstractBuildScriptGenerator.TEMP_FOLDER, null, "**/*.bin.log", null, null, null, null);
        script.printDeleteTask(tab, null, null, new FileSet[]{fileSet});
        script.printAntCallTask(tab, "zip.folder", null, null);
        script.printDeleteTask(tab, AbstractBuildScriptGenerator.TEMP_FOLDER, null, null);
        script.printTargetEnd(--tab);
    }

    protected void generateBuildUpdateJarTarget(AntScript script) {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "build.update.jar", "init", null, null, Policy.bind("build.plugin.buildUpdateJar", this.model.getId()));
        script.printDeleteTask(tab, AbstractBuildScriptGenerator.TEMP_FOLDER, null, null);
        script.printMkdirTask(tab, AbstractBuildScriptGenerator.TEMP_FOLDER);
        script.printAntCallTask(tab, "build.jars", null, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("destination.temp.folder", String.valueOf(AbstractBuildScriptGenerator.TEMP_FOLDER) + "/");
        script.printAntCallTask(tab, "gather.bin.parts", null, params);
        script.printZipTask(tab, PLUGIN_UPDATE_JAR_DESTINATION, String.valueOf(AbstractBuildScriptGenerator.TEMP_FOLDER) + "/" + FULL_NAME, false, null, false, null);
        script.printDeleteTask(tab, AbstractBuildScriptGenerator.TEMP_FOLDER, null, null);
        script.printTargetEnd(--tab);
    }

    protected void generateRefreshTarget(AntScript script) throws CoreException {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "refresh", "init", "eclipse.running", null, null);
        script.printConvertPathTask(tab, new Path(this.getLocation(this.model)).removeLastSegments(0).toOSString(), "resourcePath", false);
        script.printRefreshLocalTask(tab, AbstractScriptGenerator.getPropertyFormat("resourcePath"), "infinite");
        script.printTargetEnd(--tab);
    }

    protected void generateEpilogue(AntScript script) {
        script.println();
        script.printProjectEnd();
    }

    protected void generatePrologue(AntScript script) {
        int tab = 1;
        script.printProjectDeclaration(this.model.getId(), "build.jars", ".");
        script.println();
        script.printProperty(tab, "bootclasspath", "");
        script.printProperty(tab, "ws", BootLoader.getWS());
        script.printProperty(tab, "os", BootLoader.getOS());
        script.printProperty(tab, "arch", BootLoader.getOSArch());
        script.printProperty(tab, "javacFailOnError", "false");
        script.printProperty(tab, "javacDebugInfo", "on");
        script.printProperty(tab, "javacVerbose", "true");
        script.println();
        script.printTargetDeclaration(tab++, "init", "properties", null, null, null);
        script.printProperty(tab, this.getModelTypeName(), this.model.getId());
        script.printProperty(tab, "version.suffix", "_" + this.model.getVersion());
        script.printProperty(tab, "full.name", String.valueOf(AbstractScriptGenerator.getPropertyFormat(this.getModelTypeName())) + AbstractScriptGenerator.getPropertyFormat("version.suffix"));
        script.printProperty(tab, "temp.folder", String.valueOf(AbstractBuildScriptGenerator.BASEDIR) + "/" + "temp.folder");
        script.printProperty(tab, "plugin.destination", AbstractBuildScriptGenerator.BASEDIR);
        script.printProperty(tab, "build.result.folder", AbstractBuildScriptGenerator.BASEDIR);
        script.printTargetEnd(--tab);
        script.println();
        script.printTargetDeclaration(tab++, "properties", null, "eclipse.running", null, null);
        script.printProperty(tab, "build.compiler", "org.eclipse.jdt.core.JDTCompilerAdapter");
        script.printTargetEnd(--tab);
    }

    protected abstract String getModelTypeName();

    public void setModel(PluginModel model) throws CoreException {
        if (model == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, Policy.bind("error.missingElement"), null));
        }
        this.model = model;
    }

    public void setModelId(String modelId) throws CoreException {
        PluginModel newModel = this.getModel(modelId);
        if (newModel == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, Policy.bind("exception.missingElement", modelId), null));
        }
        this.setModel(newModel);
    }

    protected abstract PluginModel getModel(String var1) throws CoreException;

    protected void generateBuildZipsTarget(AntScript script) throws CoreException {
        StringBuffer zips = new StringBuffer();
        Properties props = this.getBuildProperties(this.model);
        Iterator iterator = ((Hashtable)props).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.") || !key.endsWith(".zip")) continue;
            String zipName = key.substring("source.".length());
            zips.append(',');
            zips.append(zipName);
            this.generateZipIndividualTarget(script, zipName, (String)entry.getValue());
        }
        script.println();
        script.printTargetDeclaration(2, "build.zips", "init" + zips.toString(), null, null, null);
        script.printTargetEnd(2);
    }
}

