/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.build.AbstractApplication;
import org.eclipse.pde.internal.build.FetchScriptGenerator;
import org.eclipse.pde.internal.build.Policy;

public class FetchScriptGeneratorApplication
extends AbstractApplication {
    protected boolean children = true;
    protected String[] elements;
    protected String installLocation;
    protected String directoryLocation;
    protected String cvsPassFileLocation;
    protected String scriptName;

    public void run() throws CoreException {
        if (this.elements == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 8, Policy.bind("error.missingElement"), null));
        }
        FetchScriptGenerator generator = new FetchScriptGenerator();
        generator.setDirectoryLocation(this.directoryLocation);
        generator.setInstallLocation(this.installLocation);
        generator.setFetchChildren(this.children);
        generator.setCvsPassFileLocation(this.cvsPassFileLocation);
        generator.setScriptName(this.scriptName);
        int i = 0;
        while (i < this.elements.length) {
            generator.setElement(this.elements[i]);
            generator.generate();
            ++i;
        }
    }

    protected void processCommandLine(List commands) {
        super.processCommandLine(commands);
        if (commands.remove("-nochildren")) {
            this.children = false;
        }
        this.elements = this.getArguments(commands, "-elements");
        String[] arguments = this.getArguments(commands, "-install");
        this.installLocation = arguments[0];
        arguments = this.getArguments(commands, "-directory");
        this.directoryLocation = arguments[0];
        arguments = this.getArguments(commands, "-cvspassfile");
        if (arguments != null) {
            this.cvsPassFileLocation = arguments[0];
        }
        if ((arguments = this.getArguments(commands, "-scriptname")) != null) {
            this.scriptName = arguments[0];
        }
    }

    public void setChildren(boolean children) {
        this.children = children;
    }

    public void setCvsPassFile(String cvsPassFileLocation) {
        this.cvsPassFileLocation = cvsPassFileLocation;
    }

    public void setDirectory(String directoryLocation) {
        this.directoryLocation = directoryLocation;
    }

    public void setElements(String[] elements) {
        this.elements = elements;
    }

    public void setInstall(String installLocation) {
        this.installLocation = installLocation;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }
}

