/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.update.core.Feature;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.internal.core.FeatureExecutableFactory;

public class FetchScriptGenerator
extends AbstractScriptGenerator
implements IPDEBuildConstants {
    protected AntScript script;
    protected boolean fetchChildren = true;
    protected String element;
    protected String installLocation;
    protected String directoryLocation;
    protected String cvsPassFileLocation;
    protected String scriptName = "fetch.xml";
    protected Properties directory;
    protected List mkdirLocations = new ArrayList(5);

    public void generate() throws CoreException {
        try {
            File root = new File(this.installLocation);
            File target = new File(this.scriptName);
            if (!target.isAbsolute()) {
                target = new File(root, this.scriptName);
            }
            this.script = new AntScript(new FileOutputStream(target));
            try {
                this.generateFetchScript();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.script.close();
                throw throwable;
            }
            Object var3_6 = null;
            this.script.close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, Policy.bind("exception.writeScript"), (Throwable)e));
        }
    }

    protected void generateFetchScript() throws CoreException {
        this.generatePrologue();
        this.generateFetchTarget();
        this.generateEpilogue();
    }

    protected void generateFetchTarget() throws CoreException {
        int tab = 1;
        this.script.println();
        this.script.printTargetDeclaration(tab, "fetch", null, null, null, null);
        this.generateFetchEntry(++tab, this.element);
        this.script.printTargetEnd(--tab);
    }

    protected void generateFetchEntry(int tab, String entry) throws CoreException {
        String password;
        String cvsInfo = this.getCVSInfo(entry);
        if (cvsInfo == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 9, Policy.bind("error.missingDirectoryEntry", entry), null));
        }
        int index = entry.indexOf(64);
        String type = entry.substring(0, index);
        String element = entry.substring(index + 1);
        String location = this.getElementLocation(type);
        String[] cvsFields = Utils.getArrayFromString(cvsInfo);
        if (cvsFields.length < 2) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 9, Policy.bind("error.incorrectDirectoryEntry", entry), null));
        }
        String tag = cvsFields[0];
        String cvsRoot = cvsFields[1];
        String string = password = cvsFields.length > 2 ? cvsFields[2] : null;
        if (password != null) {
            this.script.printCVSPassTask(tab, cvsRoot, password, this.cvsPassFileLocation);
        }
        this.generateMkdirs(tab, location);
        this.script.printCVSTask(tab, null, cvsRoot, location, element, tag, AbstractScriptGenerator.getPropertyFormat("quiet"), this.cvsPassFileLocation);
        if (this.fetchChildren && type.equals("feature")) {
            Feature feature = this.retrieveFeature(element, cvsRoot, tag, password);
            this.generateChildrenFetchScript(tab, feature);
        }
    }

    protected void generateMkdirs(int tab, String location) {
        if (this.mkdirLocations.contains(location)) {
            return;
        }
        this.mkdirLocations.add(location);
        this.script.printMkdirTask(tab, location);
    }

    protected void generateChildrenFetchScript(int tab, Feature feature) throws CoreException {
        IPluginEntry[] children = feature.getPluginEntries();
        int i = 0;
        while (i < children.length) {
            String elementId = children[i].getVersionedIdentifier().getIdentifier();
            if (children[i].isFragment()) {
                this.generateFetchEntry(tab, "fragment@" + elementId);
            } else {
                this.generateFetchEntry(tab, "plugin@" + elementId);
            }
            ++i;
        }
    }

    protected Feature retrieveFeature(String element, String cvsRoot, String tag, String password) throws CoreException {
        File root = new File(this.installLocation);
        File target = new File(root, "retrieve.xml");
        try {
            AntScript retrieve = new AntScript(new FileOutputStream(target));
            try {
                retrieve.printProjectDeclaration("RetrieveFeature", "main", ".");
                retrieve.printTargetDeclaration(0, "main", null, null, null, null);
                IPath module = new Path(element).append("feature.xml");
                if (password != null) {
                    retrieve.printCVSPassTask(0, cvsRoot, password, this.cvsPassFileLocation);
                }
                retrieve.printCVSTask(0, null, cvsRoot, null, module.toString(), tag, "true", this.cvsPassFileLocation);
                retrieve.printTargetEnd(0);
                retrieve.printProjectEnd();
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                retrieve.close();
                throw throwable;
            }
            Object var9_14 = null;
            retrieve.close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, Policy.bind("exception.writeScript"), (Throwable)e));
        }
        try {
            AntRunner runner = new AntRunner();
            runner.setBuildFileLocation(target.getAbsolutePath());
            runner.run();
            target.delete();
            FeatureExecutableFactory factory = new FeatureExecutableFactory();
            File featureFolder = new File(root, element);
            Feature feature = (Feature)factory.createFeature(featureFolder.toURL(), null, null);
            FetchScriptGenerator.clear(featureFolder);
            if (feature == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, Policy.bind("exception.missingFeature", new String[]{element}), null));
            }
            return feature;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, Policy.bind("error.creatingFeature", new String[]{element}), (Throwable)e));
        }
    }

    public static boolean clear(File root) {
        String[] list;
        boolean result = true;
        if (root.isDirectory() && (list = root.list()) != null) {
            int i = 0;
            while (i < list.length) {
                result &= FetchScriptGenerator.clear(new File(root, list[i]));
                ++i;
            }
        }
        try {
            if (root.exists()) {
                result &= root.delete();
            }
        }
        catch (Exception exception) {
            result = false;
        }
        return result;
    }

    protected String getElementLocation(String type) {
        Path location = new Path(AbstractScriptGenerator.getPropertyFormat("install"));
        location = type.equals("feature") ? location.append("features") : location.append("plugins");
        return location.toString();
    }

    protected String getCVSInfo(String element) throws CoreException {
        if (this.directory == null) {
            this.readDirectory();
        }
        return this.directory.getProperty(element);
    }

    protected void readDirectory() throws CoreException {
        try {
            this.directory = new Properties();
            File file = new File(this.directoryLocation);
            FileInputStream is = new FileInputStream(file);
            try {
                this.directory.load(is);
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                ((InputStream)is).close();
                throw throwable;
            }
            Object var3_6 = null;
            ((InputStream)is).close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 6, Policy.bind("error.readingDirectory"), (Throwable)e));
        }
    }

    protected void generatePrologue() {
        this.script.println();
        this.script.printComment(0, "Fetch script for " + this.element);
        this.script.println();
        this.script.printProjectDeclaration("FetchScript", "fetch", ".");
        this.script.printProperty(1, "quiet", "true");
    }

    protected void generateEpilogue() {
        this.script.println();
        this.script.printProjectEnd();
    }

    public void setDirectoryLocation(String directoryLocation) {
        this.directoryLocation = directoryLocation;
    }

    public void setElement(String element) {
        this.element = element;
    }

    public void setFetchChildren(boolean fetchChildren) {
        this.fetchChildren = fetchChildren;
    }

    public void setInstallLocation(String installLocation) {
        this.installLocation = installLocation;
    }

    public void setCvsPassFileLocation(String cvsPassFileLocation) {
        this.cvsPassFileLocation = cvsPassFileLocation;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName == null ? "fetch.xml" : scriptName;
    }
}

