/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.pde.internal.build.AbstractBuildScriptGenerator;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.build.PluginBuildScriptGenerator;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.update.core.Feature;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.FeatureExecutableFactory;

public class FeatureBuildScriptGenerator
extends AbstractBuildScriptGenerator {
    protected boolean generateChildrenScript = true;
    protected String featureID;
    protected String featureRootLocation;
    protected Feature feature;
    protected static final String FEATURE_DESTINATION = AbstractScriptGenerator.getPropertyFormat("feature.destination");
    protected static final String FEATURE_FULL_NAME = AbstractScriptGenerator.getPropertyFormat("feature.full.name");
    protected static final String FEATURE_FOLDER_NAME = "features/" + FEATURE_FULL_NAME;
    protected static final String FEATURE_TEMP_FOLDER = AbstractScriptGenerator.getPropertyFormat("feature.temp.folder");
    protected static final String SOURCE_FEATURE_FULL_NAME = String.valueOf(AbstractScriptGenerator.getPropertyFormat("feature")) + ".source" + AbstractScriptGenerator.getPropertyFormat("feature.version.suffix");

    protected List computeElements(boolean fragments) throws CoreException {
        ArrayList<PluginFragmentModel> result = new ArrayList<PluginFragmentModel>(5);
        IPluginEntry[] pluginList = this.feature.getPluginEntries();
        int i = 0;
        while (i < pluginList.length) {
            IPluginEntry entry = pluginList[i];
            if (fragments == entry.isFragment()) {
                VersionedIdentifier identifier = entry.getVersionedIdentifier();
                Object model = fragments ? this.getRegistry().getFragment(identifier.getIdentifier(), identifier.getVersion().toString()) : this.getRegistry().getPlugin(identifier.getIdentifier(), identifier.getVersion().toString());
                if (model == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, Policy.bind("exception.missingPlugin", entry.getVersionedIdentifier().toString()), null));
                }
                result.add((PluginFragmentModel)model);
            }
            ++i;
        }
        return result;
    }

    public void setGenerateChildrenScript(boolean generate) {
        this.generateChildrenScript = generate;
    }

    public String getScriptTargetLocation() {
        String location = super.getScriptTargetLocation();
        if (location != null) {
            return location;
        }
        return this.getFeatureRootLocation();
    }

    public void generate() throws CoreException {
        if (this.featureID == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, Policy.bind("error.missingFeatureId"), null));
        }
        if (this.installLocation == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 2, Policy.bind("error.missingInstallLocation"), null));
        }
        this.readFeature();
        try {
            String custom = (String)((Hashtable)this.getBuildProperties(this.feature)).get("custom");
            if (custom != null && custom.equalsIgnoreCase("true")) {
                File buildFile = new File(this.getFeatureRootLocation(), this.buildScriptName);
                this.updateVersion(buildFile, "feature.version.suffix", this.feature.getFeatureVersion());
                return;
            }
            if (this.generateChildrenScript) {
                this.generateChildrenScripts();
            }
            File root = new File(this.getScriptTargetLocation());
            File target = new File(root, this.buildScriptName);
            AntScript script = new AntScript(new FileOutputStream(target));
            try {
                this.generateBuildScript(script);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                script.close();
                throw throwable;
            }
            Object var5_9 = null;
            script.close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 7, Policy.bind("exception.writeScript"), (Throwable)e));
        }
    }

    protected void generateBuildScript(AntScript script) throws CoreException {
        this.generatePrologue(script);
        this.generateAllPluginsTarget(script);
        this.generateAllChildrenTarget(script);
        this.generateChildrenTarget(script);
        this.generateBuildJarsTarget(script);
        this.generateBuildZipsTarget(script);
        this.generateBuildUpdateJarTarget(script);
        this.generateGatherBinPartsTarget(script);
        this.generateZipDistributionWholeTarget(script);
        this.generateZipSourcesTarget(script);
        this.generateZipLogsTarget(script);
        this.generateZipFolderTarget(script);
        this.generateCleanTarget(script);
        this.generateRefreshTarget(script);
        this.generateEpilogue(script);
    }

    private void generateZipFolderTarget(AntScript script) {
        script.println();
        script.printTargetDeclaration(1, "zip.folder", "init", null, null, null);
        script.printZipTask(2, AbstractScriptGenerator.getPropertyFormat("zipname"), FEATURE_TEMP_FOLDER, true, null, true, null);
        script.printTargetEnd(1);
    }

    protected void generateBuildZipsTarget(AntScript script) throws CoreException {
        StringBuffer zips = new StringBuffer();
        Properties props = this.getBuildProperties(this.feature);
        Iterator iterator = ((Hashtable)props).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.") || !key.endsWith(".zip")) continue;
            String zipName = key.substring("source.".length());
            zips.append(',');
            zips.append(zipName);
            this.generateZipIndividualTarget(script, zipName, (String)entry.getValue());
        }
        script.println();
        int tab = 1;
        script.printTargetDeclaration(tab++, "build.zips", "init" + zips.toString(), null, null, null);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "build.zips");
        script.printAntCallTask(tab, "all.children", null, params);
        script.printTargetEnd(--tab);
    }

    protected void generateZipIndividualTarget(AntScript script, String zipName, String source) throws CoreException {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, zipName, "init", null, null, null);
        script.printZipTask(tab, String.valueOf(FEATURE_DESTINATION) + "/" + zipName, String.valueOf(AbstractBuildScriptGenerator.BASEDIR) + "/" + source, false, null, false, null);
        script.printTargetEnd(--tab);
    }

    protected void generateCleanTarget(AntScript script) throws CoreException {
        int tab = 1;
        script.println();
        Path basedir = new Path(FEATURE_DESTINATION);
        script.printTargetDeclaration(tab++, "clean", "init", null, null, Policy.bind("build.feature.clean", this.featureID));
        script.printDeleteTask(tab, null, basedir.append(String.valueOf(FEATURE_FULL_NAME) + ".jar").toString(), null);
        script.printDeleteTask(tab, null, basedir.append(String.valueOf(FEATURE_FULL_NAME) + ".bin.dist.zip").toString(), null);
        script.printDeleteTask(tab, null, basedir.append(String.valueOf(FEATURE_FULL_NAME) + ".log.zip").toString(), null);
        script.printDeleteTask(tab, null, basedir.append(String.valueOf(FEATURE_FULL_NAME) + ".src.zip").toString(), null);
        script.printDeleteTask(tab, FEATURE_TEMP_FOLDER, null, null);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "clean");
        script.printAntCallTask(tab, "all.children", null, params);
        script.printTargetEnd(--tab);
    }

    protected void generateZipLogsTarget(AntScript script) {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "zip.logs", "init", null, null, null);
        script.printDeleteTask(tab, FEATURE_TEMP_FOLDER, null, null);
        script.printMkdirTask(tab, FEATURE_TEMP_FOLDER);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "gather.logs");
        params.put("destination.temp.folder", new Path(FEATURE_TEMP_FOLDER).append("plugins").toString());
        script.printAntCallTask(tab, "all.children", "false", params);
        params.clear();
        params.put("zipname", String.valueOf(FEATURE_FULL_NAME) + ".log.zip");
        script.printAntCallTask(tab, "zip.folder", null, params);
        script.printDeleteTask(tab, FEATURE_TEMP_FOLDER, null, null);
        script.printTargetEnd(--tab);
    }

    protected void generateZipSourcesTarget(AntScript script) {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "zip.sources", "init", null, null, null);
        script.printDeleteTask(tab, FEATURE_TEMP_FOLDER, null, null);
        script.printMkdirTask(tab, FEATURE_TEMP_FOLDER);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "gather.sources");
        params.put("destination.temp.folder", String.valueOf(FEATURE_TEMP_FOLDER) + "/" + "plugins" + "/" + SOURCE_FEATURE_FULL_NAME + "/" + "src");
        script.printAntCallTask(tab, "all.children", null, params);
        params.clear();
        params.put("zipname", String.valueOf(FEATURE_FULL_NAME) + ".src.zip");
        script.printAntCallTask(tab, "zip.folder", null, params);
        script.printDeleteTask(tab, FEATURE_TEMP_FOLDER, null, null);
        script.printTargetEnd(--tab);
    }

    protected void generateGatherBinPartsTarget(AntScript script) throws CoreException {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "gather.bin.parts", "init", "feature.base", null, null);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "gather.bin.parts");
        params.put("destination.temp.folder", new Path(AbstractScriptGenerator.getPropertyFormat("feature.base")).append("plugins").toString());
        script.printAntCallTask(tab, "children", null, params);
        String include = (String)((Hashtable)this.getBuildProperties(this.feature)).get("bin.includes");
        String exclude = (String)((Hashtable)this.getBuildProperties(this.feature)).get("bin.excludes");
        String root = "${feature.base}/" + FEATURE_FOLDER_NAME;
        script.printMkdirTask(tab, root);
        if (include != null || exclude != null) {
            FileSet fileSet = new FileSet(AbstractBuildScriptGenerator.BASEDIR, null, include, null, exclude, null, null);
            script.printCopyTask(tab, null, root, new FileSet[]{fileSet});
        }
        script.printTargetEnd(--tab);
    }

    protected void generateBuildUpdateJarTarget(AntScript script) {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "build.update.jar", "init", null, null, Policy.bind("build.feature.buildUpdateJar", this.featureID));
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "build.update.jar");
        script.printAntCallTask(tab, "all.children", null, params);
        script.printProperty(tab, "feature.base", FEATURE_TEMP_FOLDER);
        script.printDeleteTask(tab, FEATURE_TEMP_FOLDER, null, null);
        script.printMkdirTask(tab, FEATURE_TEMP_FOLDER);
        params.clear();
        params.put("feature.base", FEATURE_TEMP_FOLDER);
        script.printAntCallTask(tab, "gather.bin.parts", "false", params);
        script.printJarTask(tab, String.valueOf(FEATURE_DESTINATION) + "/" + FEATURE_FULL_NAME + ".jar", String.valueOf(FEATURE_TEMP_FOLDER) + "/" + FEATURE_FOLDER_NAME);
        script.printDeleteTask(tab, FEATURE_TEMP_FOLDER, null, null);
        script.printTargetEnd(--tab);
    }

    protected void generateZipDistributionWholeTarget(AntScript script) {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "zip.distribution", "init", null, null, Policy.bind("build.feature.zips", this.featureID));
        script.printDeleteTask(tab, FEATURE_TEMP_FOLDER, null, null);
        script.printMkdirTask(tab, FEATURE_TEMP_FOLDER);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("feature.base", FEATURE_TEMP_FOLDER);
        params.put("include.children", "true");
        script.printAntCallTask(tab, "gather.bin.parts", null, params);
        params.clear();
        params.put("zipname", String.valueOf(FEATURE_FULL_NAME) + ".bin.dist.zip");
        script.printAntCallTask(tab, "zip.folder", null, params);
        script.printDeleteTask(tab, FEATURE_TEMP_FOLDER, null, null);
        script.printTargetEnd(--tab);
    }

    protected void generateAllChildrenTarget(AntScript script) {
        StringBuffer depends = new StringBuffer();
        depends.append("init");
        depends.append(",");
        depends.append("all.plugins");
        script.println();
        script.printTargetDeclaration(1, "all.children", depends.toString(), null, null, null);
        script.printTargetEnd(1);
    }

    protected void generateAllPluginsTarget(AntScript script) throws CoreException {
        int tab = 1;
        List plugins = this.computeElements(false);
        List fragments = this.computeElements(true);
        String[] sortedPlugins = Utils.computePrerequisiteOrder(plugins.toArray(new PluginModel[plugins.size()]), fragments.toArray(new PluginModel[fragments.size()]));
        script.println();
        script.printTargetDeclaration(tab++, "all.plugins", "init", null, null, null);
        int list = 0;
        while (list < 2) {
            int i = 0;
            while (i < sortedPlugins.length) {
                PluginDescriptorModel plugin = this.getRegistry().getPlugin(sortedPlugins[i]);
                if (plugin == null) {
                    plugin = this.getRegistry().getFragment(sortedPlugins[i]);
                }
                IPath location = Utils.makeRelative((IPath)new Path(this.getLocation((PluginModel)plugin)), (IPath)new Path(this.getFeatureRootLocation()));
                script.printAntTask(tab, this.buildScriptName, location.toString(), AbstractScriptGenerator.getPropertyFormat("target"), null, null, null);
                ++i;
            }
            ++list;
        }
        script.printTargetEnd(--tab);
    }

    protected void generateEpilogue(AntScript script) {
        script.println();
        script.printProjectEnd();
    }

    protected void generatePrologue(AntScript script) {
        int tab = 1;
        script.printProjectDeclaration(this.feature.getFeatureIdentifier(), "build.update.jar", ".");
        script.println();
        script.printTargetDeclaration(tab++, "init", null, null, null, null);
        script.printProperty(tab, "feature", this.feature.getFeatureIdentifier());
        script.printProperty(tab, "feature.version.suffix", "_" + this.feature.getFeatureVersion());
        script.printProperty(tab, "feature.full.name", String.valueOf(AbstractScriptGenerator.getPropertyFormat("feature")) + AbstractScriptGenerator.getPropertyFormat("feature.version.suffix"));
        script.printProperty(tab, "feature.temp.folder", String.valueOf(AbstractBuildScriptGenerator.BASEDIR) + "/" + "feature.temp.folder");
        script.printProperty(tab, "feature.destination", AbstractBuildScriptGenerator.BASEDIR);
        script.printTargetEnd(--tab);
    }

    protected void generateChildrenScripts() throws CoreException {
        this.generateModels(new PluginBuildScriptGenerator(), this.computeElements(false));
        this.generateModels(new PluginBuildScriptGenerator(), this.computeElements(true));
    }

    protected void generateModels(ModelBuildScriptGenerator generator, List models) throws CoreException {
        if (models.isEmpty()) {
            return;
        }
        generator.setInstallLocation(this.installLocation);
        generator.setDevEntries(this.devEntries);
        generator.setPluginPath(this.getPluginPath());
        Iterator iterator = models.iterator();
        while (iterator.hasNext()) {
            PluginModel model = (PluginModel)iterator.next();
            generator.setModel(model);
            generator.generate();
        }
    }

    public void setFeature(String featureID) throws CoreException {
        if (featureID == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, Policy.bind("error.missingFeatureId"), null));
        }
        this.featureID = featureID;
    }

    protected void readFeature() throws CoreException {
        String location = this.getFeatureRootLocation();
        if (location == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, Policy.bind("error.missingFeatureLocation"), null));
        }
        FeatureExecutableFactory factory = new FeatureExecutableFactory();
        File file = new File(location);
        try {
            this.feature = (Feature)factory.createFeature(file.toURL(), null, null);
            if (this.feature == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, Policy.bind("error.creatingFeature", new String[]{this.featureID}), null));
            }
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 1, Policy.bind("error.creatingFeature", new String[]{this.featureID}), (Throwable)e));
        }
    }

    protected String getFeatureRootLocation() {
        if (this.featureRootLocation == null) {
            Path location = new Path(this.installLocation);
            location = location.append("features");
            location = location.append(this.featureID);
            this.featureRootLocation = location.addTrailingSeparator().toOSString();
        }
        return this.featureRootLocation;
    }

    public void setFeatureRootLocation(String location) {
        this.featureRootLocation = location;
    }

    protected Properties getBuildProperties(Feature feature) throws CoreException {
        VersionedIdentifier identifier = feature.getVersionedIdentifier();
        Properties result = (Properties)this.buildProperties.get(identifier);
        if (result == null) {
            result = this.readBuildProperties(this.getFeatureRootLocation());
            this.buildProperties.put(identifier, result);
        }
        return result;
    }

    protected void generateChildrenTarget(AntScript script) {
        script.println();
        script.printTargetDeclaration(1, "children", null, "include.children", null, null);
        script.printAntCallTask(2, "all.children", null, null);
        script.printTargetEnd(1);
    }

    protected void generateBuildJarsTarget(AntScript script) throws CoreException {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "build.jars", "init", null, null, Policy.bind("build.feature.buildJars", this.featureID));
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("target", "build.jars");
        script.printAntCallTask(tab, "all.children", null, params);
        script.printTargetEnd(--tab);
        script.println();
        script.printTargetDeclaration(tab++, "build.sources", "init", null, null, null);
        params.clear();
        params.put("target", "build.sources");
        script.printAntCallTask(tab, "all.children", null, params);
        script.printTargetEnd(--tab);
    }

    protected void generateRefreshTarget(AntScript script) {
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "refresh", "init", "eclipse.running", null, null);
        script.printConvertPathTask(tab, new Path(this.featureRootLocation).removeLastSegments(0).toOSString(), "resourcePath", false);
        script.printRefreshLocalTask(tab, AbstractScriptGenerator.getPropertyFormat("resourcePath"), "infinite");
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("target", "refresh");
        script.printAntCallTask(tab, "all.children", null, params);
        script.printTargetEnd(--tab);
    }
}

