/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.build.FragmentBuildScriptGenerator;
import org.eclipse.pde.internal.build.ModelBuildScriptGenerator;
import org.eclipse.pde.internal.build.PluginBuildScriptGenerator;
import org.eclipse.pde.internal.build.Utils;

public class BuildScriptGenerator {
    protected boolean children = true;
    protected String[] elements;
    protected String installLocation;
    protected String[] devEntries = new String[0];
    protected String[] pluginPath;

    public void run() throws CoreException {
        ArrayList plugins = new ArrayList(5);
        ArrayList fragments = new ArrayList(5);
        ArrayList features = new ArrayList(5);
        this.sortElements(features, plugins, fragments);
        this.generateModels(new PluginBuildScriptGenerator(), plugins);
        this.generateModels(new FragmentBuildScriptGenerator(), fragments);
        this.generateFeatures(features);
    }

    protected void sortElements(List features, List plugins, List fragments) {
        int i = 0;
        while (i < this.elements.length) {
            int index = this.elements[i].indexOf(64);
            String type = this.elements[i].substring(0, index);
            String element = this.elements[i].substring(index + 1);
            if (type.equals("plugin")) {
                plugins.add(element);
            }
            if (type.equals("fragment")) {
                fragments.add(element);
            }
            if (type.equals("feature")) {
                features.add(element);
            }
            ++i;
        }
    }

    protected void generateModels(ModelBuildScriptGenerator generator, List models) throws CoreException {
        if (models.isEmpty()) {
            return;
        }
        generator.setInstallLocation(this.installLocation);
        generator.setDevEntries(this.devEntries);
        generator.setPluginPath(Utils.asURL(this.pluginPath));
        Iterator iterator = models.iterator();
        while (iterator.hasNext()) {
            String model = (String)iterator.next();
            generator.setModelId(model);
            generator.generate();
        }
    }

    protected void generateFeatures(List features) throws CoreException {
        if (features.isEmpty()) {
            return;
        }
        FeatureBuildScriptGenerator generator = new FeatureBuildScriptGenerator();
        generator.setInstallLocation(this.installLocation);
        generator.setDevEntries(this.devEntries);
        generator.setPluginPath(Utils.asURL(this.pluginPath));
        generator.setGenerateChildrenScript(this.children);
        int i = 0;
        while (i < features.size()) {
            generator.setFeature((String)features.get(i));
            generator.generate();
            ++i;
        }
    }

    public void setChildren(boolean children) {
        this.children = children;
    }

    public void setDevEntries(String[] devEntries) {
        this.devEntries = devEntries;
    }

    public void setElements(String[] elements) {
        this.elements = elements;
    }

    public void setPlugins(String[] pluginPath) {
        this.pluginPath = pluginPath;
    }

    public void setInstall(String installLocation) {
        this.installLocation = installLocation;
    }

    public void setPluginPath(String[] pluginPath) {
        this.pluginPath = pluginPath;
    }
}

