/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.IPDEBuildConstants;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.JavacTask;
import org.eclipse.update.core.VersionedIdentifier;

public abstract class AbstractBuildScriptGenerator
extends AbstractScriptGenerator
implements IPDEBuildConstants {
    protected Map buildProperties = new HashMap();
    protected String buildScriptName = "build.xml";
    protected String installLocation;
    protected String scriptTargetLocation;
    private URL[] pluginPath;
    private PluginRegistryModel registry;
    protected String[] devEntries;
    private PluginModel currentModel;
    protected static final String BASEDIR = AbstractScriptGenerator.getPropertyFormat("basedir");
    protected static final String BUILD_RESULT_FOLDER = AbstractScriptGenerator.getPropertyFormat("build.result.folder");
    protected static final String TEMP_FOLDER = AbstractScriptGenerator.getPropertyFormat("temp.folder");

    protected String getClasspath(PluginModel model, JAR jar) throws CoreException {
        this.currentModel = model;
        ArrayList classpath = new ArrayList(20);
        ArrayList pluginChain = new ArrayList(10);
        String location = this.getLocation(model);
        this.addPlugin(this.getPlugin("org.eclipse.core.boot", null), classpath, location);
        this.addSelf(model, jar, classpath, location, pluginChain);
        this.addPrerequisites(model, classpath, location, pluginChain);
        return Utils.getStringFromCollection(classpath, ";");
    }

    protected void addSelf(PluginModel model, JAR jar, List classpath, String location, List pluginChain) throws CoreException {
        String extraClasspath;
        Properties modelProperties;
        String jarOrder;
        if (model instanceof PluginFragmentModel) {
            PluginDescriptorModel plugin = this.getRegistry().getPlugin(((PluginFragmentModel)model).getPlugin());
            this.addPluginAndPrerequisites((PluginModel)plugin, classpath, location, pluginChain);
        }
        if ((jarOrder = (String)((Hashtable)(modelProperties = this.getBuildProperties(model))).get("jars.compile.order")) == null) {
            LibraryModel[] libraries = model.getRuntime();
            if (libraries != null) {
                int i = 0;
                while (i < libraries.length) {
                    String libraryName = libraries[i].getName();
                    if (!jar.getName(false).equals(libraryName)) {
                        boolean isSource;
                        boolean bl = isSource = modelProperties.getProperty("source." + libraryName) != null;
                        if (isSource) {
                            this.addDevEntries(model, location, classpath, Utils.getArrayFromString(modelProperties.getProperty("output." + libraryName)));
                        }
                        this.addPathAndCheck(libraryName, classpath);
                    }
                    ++i;
                }
            }
        } else {
            String[] order = Utils.getArrayFromString(jarOrder);
            int i = 0;
            while (i < order.length) {
                if (order[i].equals(jar.getName(false))) break;
                this.addDevEntries(model, location, classpath, Utils.getArrayFromString((String)((Hashtable)modelProperties).get("output." + order[i])));
                this.addPathAndCheck(order[i], classpath);
                ++i;
            }
            LibraryModel[] libraries = model.getRuntime();
            int i2 = 0;
            while (i2 < libraries.length) {
                String libraryName = libraries[i2].getName();
                if (((Hashtable)modelProperties).get("source." + libraryName) == null) {
                    this.addPathAndCheck(libraryName, classpath);
                }
                ++i2;
            }
        }
        if ((extraClasspath = (String)((Hashtable)modelProperties).get("jars.extra.classpath")) != null) {
            String[] extra = Utils.getArrayFromString(extraClasspath, ";,");
            int i = 0;
            while (i < extra.length) {
                this.addPathAndCheck(this.computeExtraPath(extra[i], location), classpath);
                ++i;
            }
        }
        String[] jarSpecificExtraClasspath = jar.getExtraClasspath();
        int i = 0;
        while (i < jarSpecificExtraClasspath.length) {
            this.addPathAndCheck(this.computeExtraPath(jarSpecificExtraClasspath[i], location), classpath);
            ++i;
        }
    }

    private String computeExtraPath(String url, String location) throws CoreException {
        String relativePath = null;
        String[] urlfragments = Utils.getArrayFromString(url, "/");
        if (urlfragments.length > 2 && urlfragments[0].equals("platform:")) {
            String modelLocation = null;
            if (urlfragments[1].equalsIgnoreCase("plugin")) {
                modelLocation = this.getLocation((PluginModel)this.getRegistry().getPlugin(urlfragments[2]));
            }
            if (urlfragments[1].equalsIgnoreCase("fragment")) {
                modelLocation = this.getLocation((PluginModel)this.getRegistry().getFragment(urlfragments[2]));
            }
            if (urlfragments[1].equalsIgnoreCase("resource")) {
                String message = Policy.bind("exception.url", "build.properties::" + url);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, message, null));
            }
            if (modelLocation != null) {
                int i = 3;
                while (i < urlfragments.length) {
                    modelLocation = i == 3 ? String.valueOf(modelLocation) + urlfragments[i] : String.valueOf(modelLocation) + "/" + urlfragments[i];
                    ++i;
                }
                relativePath = Utils.makeRelative((IPath)new Path(modelLocation), (IPath)new Path(location)).toOSString();
                return relativePath;
            }
        }
        try {
            URL extraURL = new URL(url);
            try {
                relativePath = Utils.makeRelative((IPath)new Path(Platform.resolve((URL)extraURL).getFile()), (IPath)new Path(location)).toOSString();
            }
            catch (IOException e) {
                String message = Policy.bind("exception.url", "build.properties::" + url);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, message, (Throwable)e));
            }
        }
        catch (MalformedURLException malformedURLException) {
            relativePath = url;
        }
        return relativePath;
    }

    protected PluginModel getPlugin(String id, String version) throws CoreException {
        PluginDescriptorModel plugin = this.getRegistry().getPlugin(id, version);
        if (plugin == null) {
            String pluginName = version == null ? id : String.valueOf(id) + "_" + version;
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 5, Policy.bind("exception.missingPlugin", pluginName), null));
        }
        return plugin;
    }

    protected void addDevEntries(PluginModel model, String baseLocation, List classpath, String[] jarSpecificEntries) throws CoreException {
        if (this.devEntries != null && this.devEntries.length == 0) {
            return;
        }
        if (this.devEntries == null && jarSpecificEntries == null) {
            return;
        }
        String[] entries = jarSpecificEntries != null && jarSpecificEntries.length > 0 ? jarSpecificEntries : this.devEntries;
        IPath root = Utils.makeRelative((IPath)new Path(this.getLocation(model)), (IPath)new Path(baseLocation));
        int i = 0;
        while (i < entries.length) {
            String path = root.append(entries[i]).toString();
            this.addPathAndCheck(path, classpath);
            ++i;
        }
    }

    private void addPathAndCheck(String path, List classpath) {
        if (!classpath.contains(path = this.replaceVariables(path))) {
            classpath.add(path);
        }
    }

    protected String getLocation(PluginModel model) throws CoreException {
        try {
            return new URL(model.getLocation()).getFile();
        }
        catch (MalformedURLException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 3, Policy.bind("exception.url"), (Throwable)e));
        }
    }

    public String getScriptTargetLocation() {
        return this.scriptTargetLocation;
    }

    protected void addRuntimeLibraries(PluginModel model, List classpath, String baseLocation) throws CoreException {
        LibraryModel[] libraries = model.getRuntime();
        if (libraries == null) {
            return;
        }
        String root = this.getLocation(model);
        IPath base = Utils.makeRelative((IPath)new Path(root), (IPath)new Path(baseLocation));
        int i = 0;
        while (i < libraries.length) {
            this.addDevEntries(model, baseLocation, classpath, Utils.getArrayFromString(this.getBuildProperties(model).getProperty("output." + libraries[i].getName())));
            String library = base.append(libraries[i].getName()).toString();
            this.addPathAndCheck(library, classpath);
            ++i;
        }
    }

    private void addPlugin(PluginModel plugin, List classpath, String location) throws CoreException {
        this.addRuntimeLibraries(plugin, classpath, location);
        this.addFragmentsLibraries(plugin, classpath, location);
    }

    protected void addFragmentsLibraries(PluginModel plugin, List classpath, String baseLocation) throws CoreException {
        if (!(plugin instanceof PluginDescriptorModel)) {
            return;
        }
        PluginDescriptorModel pluginModel = (PluginDescriptorModel)plugin;
        PluginFragmentModel[] fragments = pluginModel.getFragments();
        if (fragments == null) {
            return;
        }
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i] != this.currentModel) {
                this.addPluginLibrariesToFragmentLocations(plugin, fragments[i], classpath, baseLocation);
                this.addRuntimeLibraries((PluginModel)fragments[i], classpath, baseLocation);
            }
            ++i;
        }
    }

    protected void addPluginLibrariesToFragmentLocations(PluginModel plugin, PluginFragmentModel fragment, List classpath, String baseLocation) throws CoreException {
        LibraryModel[] libraries = plugin.getRuntime();
        if (libraries == null) {
            return;
        }
        String root = this.getLocation((PluginModel)fragment);
        IPath base = Utils.makeRelative((IPath)new Path(root), (IPath)new Path(baseLocation));
        int i = 0;
        while (i < libraries.length) {
            String libraryName = base.append(libraries[i].getName()).toString();
            this.addPathAndCheck(libraryName, classpath);
            ++i;
        }
    }

    protected void addPluginAndPrerequisites(PluginModel target, List classpath, String baseLocation, List pluginChain) throws CoreException {
        this.addPlugin(target, classpath, baseLocation);
        this.addPrerequisites(target, classpath, baseLocation, pluginChain);
    }

    protected void addPrerequisites(PluginModel target, List classpath, String baseLocation, List pluginChain) throws CoreException {
        PluginPrerequisiteModel[] requires;
        if (pluginChain.contains(target)) {
            if (target == this.getPlugin("org.eclipse.core.runtime", null)) {
                return;
            }
            String message = Policy.bind("error.pluginCycle");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 14, message, null));
        }
        if (target != this.getPlugin("org.eclipse.core.runtime", null)) {
            this.addPluginAndPrerequisites(this.getPlugin("org.eclipse.core.runtime", null), classpath, baseLocation, pluginChain);
        }
        if ((requires = target.getRequires()) != null) {
            pluginChain.add(target);
            int i = 0;
            while (i < requires.length) {
                PluginModel plugin = this.getPlugin(requires[i].getPlugin(), requires[i].getVersion());
                if (plugin != null) {
                    this.addPluginAndPrerequisites(plugin, classpath, baseLocation, pluginChain);
                }
                ++i;
            }
            pluginChain.remove(target);
        }
    }

    protected Properties getBuildProperties(PluginModel model) throws CoreException {
        VersionedIdentifier identifier = new VersionedIdentifier(model.getId(), model.getVersion());
        Properties result = (Properties)this.buildProperties.get(identifier);
        if (result == null) {
            result = this.readBuildProperties(this.getLocation(model));
            this.buildProperties.put(identifier, result);
        }
        return result;
    }

    protected Properties readBuildProperties(String rootLocation) throws CoreException {
        Properties result = new Properties();
        File file = new File(rootLocation, "build.properties");
        if (!file.exists()) {
            return result;
        }
        try {
            FileInputStream input = new FileInputStream(file);
            try {
                result.load(input);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                ((InputStream)input).close();
                throw throwable;
            }
            Object var5_8 = null;
            ((InputStream)input).close();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 10, Policy.bind("exception.readingFile"), (Throwable)e));
        }
        return result;
    }

    protected JAR[] extractJars(Properties properties) {
        ArrayList<JAR> result = new ArrayList<JAR>(5);
        int prefixLength = "source.".length();
        Iterator iterator = ((Hashtable)properties).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            if (!key.startsWith("source.") || !key.endsWith(".jar")) continue;
            key = key.substring(prefixLength);
            String[] source = Utils.getArrayFromString((String)entry.getValue());
            String[] output = Utils.getArrayFromString(properties.getProperty("output." + key));
            String[] extraClasspath = Utils.getArrayFromString(properties.getProperty("extra." + key));
            JAR jar = new JAR(key, source, output, extraClasspath);
            result.add(jar);
        }
        return result.toArray(new JAR[result.size()]);
    }

    protected void generateBuildJarsTarget(AntScript script, PluginModel model) throws CoreException {
        String name;
        Properties properties = this.getBuildProperties(model);
        JAR[] availableJars = this.extractJars(properties);
        ArrayList<String> jarNames = new ArrayList<String>(availableJars.length);
        HashMap<String, JAR> jars = new HashMap<String, JAR>(availableJars.length);
        int i = 0;
        while (i < availableJars.length) {
            jars.put(availableJars[i].getName(false), availableJars[i]);
            ++i;
        }
        String jarOrder = (String)((Hashtable)this.getBuildProperties(model)).get("jars.compile.order");
        if (jarOrder != null) {
            String[] order = Utils.getArrayFromString(jarOrder);
            int i2 = 0;
            while (i2 < order.length) {
                JAR jar = (JAR)jars.get(order[i2]);
                if (jar != null) {
                    String name2 = jar.getName(false);
                    jarNames.add(name2);
                    this.generateJARTarget(script, this.getClasspath(model, jar), jar);
                    this.generateSRCTarget(script, jar);
                    jars.remove(order[i2]);
                }
                ++i2;
            }
        }
        Iterator iterator = jars.values().iterator();
        while (iterator.hasNext()) {
            JAR jar = (JAR)iterator.next();
            name = jar.getName(false);
            jarNames.add(name);
            this.generateJARTarget(script, this.getClasspath(model, jar), jar);
            this.generateSRCTarget(script, jar);
        }
        int tab = 1;
        script.println();
        script.printTargetDeclaration(tab++, "build.jars", "init", null, null, Policy.bind("build.plugin.buildJars", model.getId()));
        Iterator iter = jarNames.iterator();
        while (iter.hasNext()) {
            name = (String)iter.next();
            script.printAvailableTask(tab, name, this.getJARLocation(name));
            script.printAntCallTask(tab, name, null, null);
        }
        script.printTargetEnd(--tab);
        script.println();
        script.printTargetDeclaration(tab++, "build.sources", "init", null, null, null);
        iter = jarNames.iterator();
        while (iter.hasNext()) {
            String jarName = (String)iter.next();
            String srcName = this.getSRCName(jarName);
            script.printAvailableTask(tab, srcName, this.replaceVariables(this.getSRCLocation(jarName)));
            script.printAntCallTask(tab, srcName, null, null);
        }
        script.printTargetEnd(--tab);
    }

    protected void generateJARTarget(AntScript script, String classpath, JAR jar) throws CoreException {
        int tab = 1;
        script.println();
        String name = jar.getName(false);
        script.printTargetDeclaration(tab++, name, "init", null, jar.getName(true), Policy.bind("build.plugin.jar", name));
        String destdir = this.getTempJARFolderLocation(jar.getName(true));
        script.printProperty(tab, "destdir", destdir);
        script.printDeleteTask(tab, destdir, null, null);
        script.printMkdirTask(tab, destdir);
        script.printComment(tab, "compile the source code");
        JavacTask javac = new JavacTask();
        javac.setClasspath(classpath);
        javac.setBootClasspath(AbstractScriptGenerator.getPropertyFormat("bootclasspath"));
        javac.setDestdir(destdir);
        javac.setFailOnError(AbstractScriptGenerator.getPropertyFormat("javacFailOnError"));
        javac.setDebug(AbstractScriptGenerator.getPropertyFormat("javacDebugInfo"));
        javac.setVerbose(AbstractScriptGenerator.getPropertyFormat("javacVerbose"));
        javac.setIncludeAntRuntime("no");
        String[] sources = jar.getSource();
        javac.setSrcdir(sources);
        script.print(tab, javac);
        script.printComment(tab, "copy necessary resources");
        FileSet[] fileSets = new FileSet[sources.length];
        int i = 0;
        while (i < sources.length) {
            fileSets[i] = new FileSet(sources[i], null, null, null, "**/*.java", null, null);
            ++i;
        }
        script.printCopyTask(tab, null, destdir, fileSets);
        String jarLocation = this.getJARLocation(jar.getName(true));
        script.printMkdirTask(tab, new Path(jarLocation).removeLastSegments(1).toString());
        script.printJarTask(tab, jarLocation, destdir);
        script.printDeleteTask(tab, destdir, null, null);
        script.printTargetEnd(--tab);
    }

    protected void generateSRCTarget(AntScript script, JAR jar) throws CoreException {
        int tab = 1;
        script.println();
        String name = jar.getName(false);
        String srcName = this.getSRCName(name);
        script.printTargetDeclaration(tab++, srcName, "init", null, this.replaceVariables(name), null);
        String[] sources = jar.getSource();
        FileSet[] fileSets = new FileSet[sources.length];
        int i = 0;
        while (i < sources.length) {
            fileSets[i] = new FileSet(sources[i], null, "**/*.java", null, null, null, null);
            ++i;
        }
        String srcLocation = this.replaceVariables(this.getSRCLocation(name));
        script.printMkdirTask(tab, new Path(srcLocation).removeLastSegments(1).toString());
        script.printZipTask(tab, srcLocation, null, false, null, false, fileSets);
        script.printTargetEnd(--tab);
    }

    protected String getSRCName(String jarName) {
        return String.valueOf(jarName.substring(0, jarName.length() - 4)) + "src.zip";
    }

    protected String getJARLocation(String jarName) {
        Path destination = new Path(BUILD_RESULT_FOLDER);
        destination = destination.append(jarName);
        return destination.toString();
    }

    protected String getSRCLocation(String jarName) {
        return this.getSRCName(this.getJARLocation(jarName));
    }

    protected String getTempJARFolderLocation(String jarName) {
        Path destination = new Path(TEMP_FOLDER);
        destination = destination.append(String.valueOf(jarName) + ".bin");
        return destination.toString();
    }

    protected String replaceVariables(String sourceString) {
        int i = -1;
        String result = sourceString;
        while ((i = result.indexOf("$ws$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "ws/" + AbstractScriptGenerator.getPropertyFormat("ws") + result.substring(i + "$ws$".length());
        }
        while ((i = result.indexOf("$os$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "os/" + AbstractScriptGenerator.getPropertyFormat("os") + result.substring(i + "$os$".length());
        }
        while ((i = result.indexOf("$nl$")) >= 0) {
            result = String.valueOf(result.substring(0, i)) + "nl/" + AbstractScriptGenerator.getPropertyFormat("nl") + result.substring(i + "$nl$".length());
        }
        return result;
    }

    public void setDevEntries(String[] entries) {
        this.devEntries = entries;
    }

    public void setBuildScriptName(String buildScriptName) {
        this.buildScriptName = buildScriptName == null ? "build.xml" : buildScriptName;
    }

    public void setScriptTargetLocation(String location) {
        this.scriptTargetLocation = location;
    }

    public void setInstallLocation(String location) {
        this.installLocation = location;
    }

    protected PluginRegistryModel getRegistry() throws CoreException {
        if (this.registry == null) {
            URL[] pluginPath = this.getPluginPath();
            MultiStatus problems = new MultiStatus("org.eclipse.pde.build", 4, Policy.bind("exception.pluginParse"), null);
            Factory factory = new Factory(problems);
            this.registry = Platform.parsePlugins((URL[])pluginPath, (Factory)factory);
            this.setFragments();
            MultiStatus status = factory.getStatus();
            if (Utils.contains((IStatus)status, 4)) {
                throw new CoreException((IStatus)status);
            }
        }
        return this.registry;
    }

    private void setFragments() {
        PluginFragmentModel[] fragments = this.registry.getFragments();
        int i = 0;
        while (i < fragments.length) {
            String pluginId = fragments[i].getPluginId();
            PluginDescriptorModel plugin = this.registry.getPlugin(pluginId);
            PluginFragmentModel[] existingFragments = plugin.getFragments();
            if (existingFragments == null) {
                plugin.setFragments(new PluginFragmentModel[]{fragments[i]});
            } else {
                PluginFragmentModel[] newFragments = new PluginFragmentModel[existingFragments.length + 1];
                System.arraycopy(existingFragments, 0, newFragments, 0, existingFragments.length);
                newFragments[newFragments.length - 1] = fragments[i];
                plugin.setFragments(newFragments);
            }
            ++i;
        }
    }

    protected URL[] getPluginPath() {
        if (this.pluginPath != null) {
            return this.pluginPath;
        }
        if (this.installLocation != null) {
            try {
                StringBuffer sb = new StringBuffer();
                sb.append("file:");
                sb.append(this.installLocation);
                sb.append("/");
                sb.append("plugins");
                sb.append("/");
                return new URL[]{new URL(sb.toString())};
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public void setPluginPath(URL[] pluginPath) {
        this.pluginPath = pluginPath;
    }

    protected int scan(StringBuffer buf, int start, String target) {
        return this.scan(buf, start, new String[]{target});
    }

    protected int scan(StringBuffer buf, int start, String[] targets) {
        int i = start;
        while (i < buf.length()) {
            int j = 0;
            while (j < targets.length) {
                String match;
                if (i < buf.length() - targets[j].length() && targets[j].equals(match = buf.substring(i, i + targets[j].length()))) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    protected StringBuffer readFile(File target) throws IOException {
        FileInputStream fis = new FileInputStream(target);
        InputStreamReader reader = new InputStreamReader(fis);
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        try {
            int count = reader.read(buf, 0, buf.length);
            while (count != -1) {
                result.append(buf, 0, count);
                count = reader.read(buf, 0, buf.length);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                fis.close();
                reader.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var7_9 = null;
        try {
            fis.close();
            reader.close();
        }
        catch (IOException iOException) {}
        return result;
    }

    protected void updateVersion(File buildFile, String propertyName, String version) throws CoreException, IOException {
        String newVersion;
        int end;
        StringBuffer buffer = this.readFile(buildFile);
        int pos = this.scan(buffer, 0, propertyName);
        if (pos == -1) {
            return;
        }
        if ((pos = this.scan(buffer, pos, "value")) == -1) {
            return;
        }
        int begin = this.scan(buffer, pos, "\"");
        if (begin == -1) {
            return;
        }
        if ((end = this.scan(buffer, ++begin, "\"")) == -1) {
            return;
        }
        String currentVersion = buffer.substring(begin, end);
        if (currentVersion.equals(newVersion = "_" + version)) {
            return;
        }
        buffer.replace(begin, end, newVersion);
        Utils.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(buildFile));
    }

    protected class JAR {
        private String name;
        private String[] source;
        private String[] output;
        private String[] extraClasspath;
        private String resolvedName;

        protected JAR(String name, String[] source, String[] output, String[] extraClasspath) {
            this.name = name;
            this.source = source;
            this.output = output;
            this.extraClasspath = extraClasspath;
        }

        protected String getName(boolean resolved) {
            if (!resolved) {
                return this.name;
            }
            if (this.resolvedName == null) {
                this.resolvedName = AbstractBuildScriptGenerator.this.replaceVariables(this.name);
            }
            return this.resolvedName;
        }

        protected String[] getSource() {
            return this.source;
        }

        public String[] getOutput() {
            return this.output;
        }

        public String[] getExtraClasspath() {
            return this.extraClasspath;
        }
    }
}

