/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.interfaces.webservices.server.deploy;

import com.sap.engine.interfaces.webservices.server.accessors.WSInterfaceResourceAccessor;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.localization.ResourceAccessor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;

public class WSWarningException
extends WarningException {
    public WSWarningException() {
        this(new LocalizableTextFormatter((ResourceAccessor)WSInterfaceResourceAccessor.getResourceAccessor(), "webservices_5998", new Object[0]));
    }

    public WSWarningException(String s) {
        this(new LocalizableTextFormatter((ResourceAccessor)WSInterfaceResourceAccessor.getResourceAccessor(), "webservices_5999", new Object[]{s}));
    }

    public WSWarningException(Throwable cause) {
        this(new LocalizableTextFormatter((ResourceAccessor)WSInterfaceResourceAccessor.getResourceAccessor(), "webservices_5998", new Object[0]), cause);
    }

    public WSWarningException(String patternKey, Object[] args) {
        this(new LocalizableTextFormatter((ResourceAccessor)WSInterfaceResourceAccessor.getResourceAccessor(), patternKey, args));
    }

    public WSWarningException(LocalizableTextFormatter locFormatter) {
        this(locFormatter, null, 200, null);
    }

    public WSWarningException(String patternKey, Object[] args, Throwable cause) {
        this(new LocalizableTextFormatter((ResourceAccessor)WSInterfaceResourceAccessor.getResourceAccessor(), patternKey, args), cause);
    }

    public WSWarningException(LocalizableTextFormatter locFormatter, Throwable cause) {
        this(locFormatter, cause, null, 200, null);
    }

    public WSWarningException(LocalizableTextFormatter locFormatter, Category cat, int severity, Location loc) {
        super(locFormatter, cat, severity, loc);
    }

    public WSWarningException(LocalizableTextFormatter locFormatter, Throwable cause, Category cat, int severity, Location loc) {
        super(locFormatter, cause, cat, severity, loc);
    }

    private Object writeReplace() {
        StringWriter stringWriter = new StringWriter();
        this.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return new Exception(stringWriter.toString());
    }

    public void addWarnings(String[] newWarnings) {
        String[] warnings = this.getWarnings();
        String[] allWarnings = WSWarningException.unifyStrings(new String[][]{warnings, newWarnings});
        this.setWarning(allWarnings);
    }

    public void addWarnings(Vector newWarnings) {
        if (newWarnings == null) {
            return;
        }
        Object[] newWarningsArr = new String[newWarnings.size()];
        newWarnings.copyInto(newWarningsArr);
        this.addWarnings((String[])newWarningsArr);
    }

    public Vector getWarningsVector() {
        String[] warnings = this.getWarnings();
        if (warnings == null) {
            return new Vector();
        }
        Vector<String> warningsVector = new Vector<String>();
        int i = 0;
        while (i < warnings.length) {
            warningsVector.add(warnings[i]);
            ++i;
        }
        return warningsVector;
    }

    public static String[] unifyStrings(String[][] strings) {
        String[] allStrings = new String[]{};
        int i = 0;
        while (i < strings.length) {
            String[] currentStrings = strings[i];
            if (currentStrings != null) {
                String[] newStrings = new String[allStrings.length + currentStrings.length];
                System.arraycopy(allStrings, 0, newStrings, 0, allStrings.length);
                System.arraycopy(currentStrings, 0, newStrings, allStrings.length, currentStrings.length);
                allStrings = newStrings;
            }
            ++i;
        }
        return allStrings;
    }
}

