/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.interfaces.webservices.runtime;

import java.io.Serializable;
import java.util.StringTokenizer;

public class HTTPProxy
implements Serializable {
    private String proxyHost;
    private int proxyPort = 80;
    private String proxyUser;
    private String proxyPass;
    private String excludeList;
    private boolean bypassLocalAddresses = true;

    public String getExcludeList() {
        return this.excludeList;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setExcludeList(String excludeList) {
        this.excludeList = excludeList.toLowerCase();
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean useProxyForAddress(String address) {
        address = address.toLowerCase();
        if (this.bypassLocalAddresses && (address.indexOf(".") == -1 || "127.0.0.1".equals(address))) {
            return false;
        }
        return HTTPProxy.useProxyForSpecificAddress(address, this.excludeList);
    }

    private static boolean useProxyForSpecificAddress(String address, String excludeList) {
        if (excludeList == null || excludeList.trim().length() == 0) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(excludeList, ";, ", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            int starIndex = token.indexOf("*");
            if (starIndex != -1) {
                String start = token.substring(0, starIndex);
                String end = token.substring(starIndex + 1);
                if (!address.startsWith(start) || !address.endsWith(end)) continue;
                return false;
            }
            if (!token.equals(address)) continue;
            return false;
        }
        return true;
    }

    public boolean isBypassLocalAddresses() {
        return this.bypassLocalAddresses;
    }

    public void setBypassLocalAddresses(boolean b) {
        this.bypassLocalAddresses = b;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }
}

