/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.conversion.info;

import com.sap.s2x.DuplicateIDException;
import com.sap.s2x.DuplicatePhaseException;
import com.sap.s2x.DuplicateResnameException;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.conversion.info.InfoDocument;
import com.sap.s2x.core.MarshalException;
import com.sap.s2x.validation.ValidationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class InfoToS2XConverter {
    private InfoToS2XConverter() {
    }

    public static void main(String[] args) {
        File infoFile = null;
        File s2xFile = null;
        long startTs = 0L;
        long duration = 0L;
        if (args.length < 1) {
            System.err.println("Missing parameter: source file.");
            InfoToS2XConverter.printUsage();
            System.exit(-1);
        } else {
            if (!args[0].endsWith(".info")) {
                System.err.println("Source file must be .info file.");
                InfoToS2XConverter.printUsage();
                System.exit(-1);
            }
            int iterations = 1;
            if (args.length > 1) {
                iterations = Integer.parseInt(args[1]);
            }
            infoFile = new File(args[0]);
            StringBuffer sb = new StringBuffer(args[0].length());
            sb.append(args[0].substring(0, args[0].lastIndexOf(46)));
            sb.append(".xlf");
            s2xFile = new File(sb.toString());
            try {
                System.out.print("Converting with own algorithm: " + infoFile + " -> " + s2xFile + "... ");
                startTs = System.currentTimeMillis();
                int i = 0;
                while (i < iterations) {
                    InfoToS2XConverter.doConvert(infoFile, s2xFile, true);
                    ++i;
                }
                duration = System.currentTimeMillis() - startTs;
                System.out.println("OK. Duration: " + duration + " (" + duration / (long)iterations + ") ms.");
            }
            catch (Exception ex) {
                System.out.println("Failed");
                ex.printStackTrace();
                System.out.println();
                System.out.println();
            }
        }
        System.out.println();
        System.out.println("-------------------------------------");
        System.out.println("Finished.");
    }

    private static void printUsage() {
        System.err.println("Usage: src-file [iterations]");
    }

    public static void doConvert(File infoFile, File s2xFile) throws TransformerFactoryConfigurationError, TransformerException, MarshalException, IOException, ParserConfigurationException, SAXException, DuplicateResnameException, DuplicateIDException, DuplicatePhaseException, ValidationException {
        InfoToS2XConverter.doConvert(infoFile, s2xFile, false);
    }

    public static void doConvert(File infoFile, File s2xFile, boolean prettyFormat) throws TransformerFactoryConfigurationError, TransformerException, MarshalException, IOException, ParserConfigurationException, SAXException, DuplicateResnameException, DuplicateIDException, DuplicatePhaseException, ValidationException {
        IOException ex22;
        File tmpFile;
        FileOutputStream os;
        FileInputStream is;
        block25: {
            is = null;
            os = null;
            tmpFile = null;
            try {
                is = new FileInputStream(infoFile);
                if (prettyFormat) {
                    tmpFile = File.createTempFile(s2xFile.getName(), "tmp");
                    os = new FileOutputStream(tmpFile);
                } else {
                    os = new FileOutputStream(s2xFile);
                }
                InfoToS2XConverter.doConvert(is, os);
                Object var7_6 = null;
                if (is == null) break block25;
            }
            catch (Throwable throwable) {
                IOException ex22;
                Object var7_7 = null;
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException ex22) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException ex22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                ((InputStream)is).close();
            }
            catch (IOException ex22) {
                // empty catch block
            }
        }
        if (os != null) {
            try {
                ((OutputStream)os).close();
            }
            catch (IOException ex22) {}
        }
        if (prettyFormat) {
            IOException ex322;
            block26: {
                try {
                    is = new FileInputStream(tmpFile);
                    DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document doc = docBuilder.parse(is);
                    os = new FileOutputStream(s2xFile);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("indent", "yes");
                    transformer.transform(new DOMSource(doc), new StreamResult(os));
                    Object var10_12 = null;
                    if (is == null) break block26;
                }
                catch (Throwable throwable) {
                    IOException ex322;
                    Object var10_13 = null;
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException ex322) {
                            // empty catch block
                        }
                    }
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException ex322) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ex322) {
                    // empty catch block
                }
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ex322) {}
            }
        }
    }

    public static void doConvert(InputStream is, OutputStream os) throws MarshalException, IOException, ParserConfigurationException, SAXException, DuplicateResnameException, DuplicateIDException, DuplicatePhaseException, ValidationException {
        InfoDocument infoDocument = new InfoDocument();
        infoDocument.load(is);
        S2XDocument s2xDocument = infoDocument.toS2XDocument();
        s2xDocument.store(os);
    }
}

