/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.conversion.info;

import com.sap.s2x.DuplicateIDException;
import com.sap.s2x.DuplicatePhaseException;
import com.sap.s2x.DuplicateResnameException;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.S2XTypes;
import com.sap.s2x.core.types.RestypeValue;
import com.sap.s2x.validation.ValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InfoDocument {
    public static final String TOOL_NAME = "Portal Content info file converter";
    public static final String E_ROOT = "ROOT";
    public static final String E_GENERAL = "GENERAL";
    public static final String E_ORIGLANG = "ORIGLANG";
    public static final String E_RESPONSIBLE = "RESPONSIBLE";
    public static final String E_PACKAGE = "PACKAGE";
    public static final String E_DOMAIN = "DOMAIN";
    public static final String E_DESCRIPTION = "DESCRIPTION";
    public static final String E_UID = "UID";
    public static final String E_RESOURCES = "RESOURCES";
    public static final String E_TEXT = "TEXT";
    public static final String A_DESCRIPTION = "DESCRIPTION";
    public static final String A_AKEY = "AKEY";
    public static final String A_TYPE = "TYPE";
    public static final String A_LENGTH = "LENGTH";
    private String domain;
    private String collection;
    private String responsible;
    private String originalLanguage;
    private String description;
    private Uid uid;
    private Map resourceMap;
    private DocumentBuilderFactory documentBuilderFactory;

    public void load(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = this.getDocumentBuilder();
        Document document = builder.parse(is);
        this.parse(document);
    }

    public S2XDocument toS2XDocument() throws IOException, ParserConfigurationException, SAXException, DuplicateResnameException, DuplicateIDException, DuplicatePhaseException, ValidationException {
        S2XDocument s2xDocument = new S2XDocument();
        RestypeValue type = null;
        s2xDocument.setTool(TOOL_NAME);
        s2xDocument.setDevelContact(this.responsible);
        s2xDocument.setDatatype("javaPropertyResourceBundle");
        s2xDocument.addPhase("migration.objectname", "InfoToS2XConversion", TOOL_NAME, new String[]{this.getUid().getId()});
        if (this.collection != null) {
            s2xDocument.addPhase("migration.collection", "InfoToS2XConversion", TOOL_NAME, new String[]{this.collection});
        }
        if (this.domain != null) {
            s2xDocument.addPhase("migration.domain", "InfoToS2XConversion", TOOL_NAME, new String[]{this.domain});
        }
        if (this.originalLanguage != null) {
            s2xDocument.setOriginalLocale(this.originalLanguage.toLowerCase());
        }
        Iterator it = this.getTextResourceKeyIterator();
        while (it.hasNext()) {
            String resKey = (String)it.next();
            TextResource res = this.getTextResource(resKey);
            type = S2XTypes.getInstance().getRestype(res.getType(), "SAP");
            if (type == null) {
                throw new IllegalStateException("No S2X type found for text resource: " + res);
            }
            int maxLen = res.getLength();
            if (maxLen == 0) {
                maxLen = res.getType().startsWith("X") ? 255 : 16384;
            }
            s2xDocument.addText(res.getValue(), res.getKey(), res.getKey(), type.getXLIFFValue(), Integer.toString(maxLen));
        }
        return s2xDocument;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getOriginalLanguage() {
        return this.originalLanguage;
    }

    public String getResponsible() {
        return this.responsible;
    }

    public Uid getUid() {
        return this.uid;
    }

    public void setCollection(String string) {
        this.collection = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public void setOriginalLanguage(String string) {
        this.originalLanguage = string;
    }

    public void setResponsible(String string) {
        this.responsible = string;
    }

    public void setUid(Uid uid) {
        this.uid = uid;
    }

    public TextResource getTextResource(String pKey) {
        if (this.resourceMap == null) {
            return null;
        }
        return (TextResource)this.resourceMap.get(pKey);
    }

    public Iterator getTextResourceKeyIterator() {
        if (this.resourceMap == null) {
            return ((AbstractList)new ArrayList()).iterator();
        }
        return this.resourceMap.keySet().iterator();
    }

    public void addTextResource(TextResource pTextResource) {
        if (this.resourceMap == null) {
            this.resourceMap = new HashMap();
        }
        this.resourceMap.put(pTextResource.getKey(), pTextResource);
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this.documentBuilderFactory == null) {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
                Object var3_2 = null;
                Thread.currentThread().setContextClassLoader(oldClassLoader);
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                throw throwable;
            }
        }
        return this.documentBuilderFactory.newDocumentBuilder();
    }

    private void parse(Document pDocument) {
        Element root = pDocument.getDocumentElement();
        Element el = (Element)root.getElementsByTagName(E_GENERAL).item(0);
        this.originalLanguage = this.parseSingleValueElement(el, E_ORIGLANG);
        this.description = this.parseSingleValueElement(el, "DESCRIPTION");
        this.domain = this.parseSingleValueElement(el, E_DOMAIN);
        this.collection = this.parseSingleValueElement(el, E_PACKAGE);
        this.responsible = this.parseSingleValueElement(el, E_RESPONSIBLE);
        el = (Element)root.getElementsByTagName(E_UID).item(0);
        if (el != null) {
            this.uid = new Uid(this.parseSingleValueElement(el), el.getAttribute("DESCRIPTION"));
        }
        this.resourceMap = new HashMap();
        el = (Element)root.getElementsByTagName(E_RESOURCES).item(0);
        NodeList nodes = el.getElementsByTagName(E_TEXT);
        int i = 0;
        while (i < nodes.getLength()) {
            el = (Element)nodes.item(i);
            String key = el.getAttribute(A_AKEY);
            String type = el.getAttribute(A_TYPE);
            int len = 0;
            String lenStr = el.getAttribute(A_LENGTH);
            if (lenStr != null) {
                try {
                    len = Integer.parseInt(lenStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            String value = this.parseSingleValueElement(el);
            this.resourceMap.put(key, new TextResource(key, type, value, len));
            ++i;
        }
    }

    private String parseSingleValueElement(Element pParentElement, String pElementId) {
        Element el = (Element)pParentElement.getElementsByTagName(pElementId).item(0);
        if (el != null) {
            return this.parseSingleValueElement(el);
        }
        return null;
    }

    private String parseSingleValueElement(Element element) {
        String value = null;
        if (element.hasChildNodes()) {
            value = element.getFirstChild().getNodeValue();
        }
        return !"null".equals(value) ? value : null;
    }

    public static final class TextResource {
        private String key;
        private String type;
        private String value;
        private int length;

        public TextResource(String pKey, String pType, String pValue) {
            this(pKey, pType, pValue, 0);
        }

        public TextResource(String pKey, String pType, String pValue, int pLength) {
            this.key = pKey;
            this.type = pType;
            this.value = pValue;
            this.length = pLength;
        }

        public String getKey() {
            return this.key;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(100);
            sb.append("key=").append(this.key);
            sb.append(";type=").append(this.type);
            sb.append(";length=").append(this.length);
            sb.append(";value=").append(this.value);
            return sb.toString();
        }
    }

    public static final class Uid {
        private String id;
        private String description;

        public Uid(String pId, String pDescription) {
            this.id = pId;
            this.description = pDescription;
        }

        public String getDescription() {
            return this.description;
        }

        public String getId() {
            return this.id;
        }
    }
}

