/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.pcd.ide.eclipse.nwdi.ui;

import com.sap.ide.eclipse.component.wizard.SelectActivityPage;
import com.sap.portal.pcd.ide.eclipse.nwdi.core.PortalContentPlugin;
import com.sap.portal.pcd.ide.eclipse.nwdi.core.PortalContentPluginStatus;
import com.sap.portal.pcd.ide.eclipse.nwdi.core.UpdateEpaOperation;
import com.sap.portal.pcd.ide.eclipse.nwdi.ui.EpaSelectionPage;
import com.sap.portal.pcd.ide.eclipse.nwdi.ui.QueryDialog;
import com.sapportals.portal.transport.app.EpaFile;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class UpdateEpaWizard
extends Wizard
implements IWizard {
    private IWorkbench workbench;
    private IProject project;
    private SelectActivityPage selectActivityPage;
    private EpaSelectionPage epaSelectionPage;
    private IVfsWorkspace workspace;

    public void init(IWorkbench pWorkbench, IProject pProject, IVfsWorkspace pWorkspace) {
        this.workbench = pWorkbench;
        this.project = pProject;
        this.workspace = pWorkspace;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Update EPA");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        EpaSelectionPage epaSelectionPage = (EpaSelectionPage)this.getPage("EpaSelectionPage");
        File selectedFile = epaSelectionPage.getSelectedFile();
        if (selectedFile == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Internal Error", (String)"Selection page returned null");
            return true;
        }
        if (!selectedFile.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)("File not found: " + selectedFile));
            return true;
        }
        EpaFile epaFile = null;
        try {
            try {
                epaFile = new EpaFile(selectedFile);
                QueryDialog continueOnErrorQuery = new QueryDialog(this.getShell(), "Error", "Do you want to continue?", new int[]{2, 4, 3}, 2);
                QueryDialog updateWithDifferentPackageQuery = new QueryDialog(this.getShell(), "Different Packages", "Do you want to continue?", new int[]{2, 3}, 1);
                QueryDialog useXflDataFromDcQuery = new QueryDialog(this.getShell(), "XLF file creation", "Do you want to overwrite the values from the Info file with settings from the Development Component (not recommended for migrated projects)?", new int[]{2, 4, 3, 5, 1}, 3);
                IVfsActivity activity = null;
                if (this.selectActivityPage != null) {
                    activity = this.selectActivityPage.getActivity();
                }
                UpdateEpaOperation runnable = new UpdateEpaOperation(this.project, epaFile, activity, continueOnErrorQuery, updateWithDifferentPackageQuery, useXflDataFromDcQuery);
                WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)runnable);
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (IOException e) {
                IStatus status = PortalContentPluginStatus.get(PortalContentPluginStatus.ERR_OPEN_EPA, e, new String[]{selectedFile.getAbsolutePath()});
                PortalContentPlugin.log(status);
                ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)status.getMessage(), (IStatus)status);
                Object var11_17 = null;
                PortalContentPlugin.close(epaFile);
                return true;
            }
            catch (InvocationTargetException e) {
                this.handleException(e.getTargetException());
                Object var11_18 = null;
                PortalContentPlugin.close(epaFile);
                return true;
            }
            catch (InterruptedException e) {
                boolean activity = true;
                Object var11_19 = null;
                PortalContentPlugin.close(epaFile);
                return activity;
            }
            catch (Exception e) {
                this.handleException(e);
                Object var11_20 = null;
                PortalContentPlugin.close(epaFile);
                return true;
            }
            Object var11_16 = null;
        }
        catch (Throwable throwable) {
            Object var11_21 = null;
            PortalContentPlugin.close(epaFile);
            throw throwable;
        }
        PortalContentPlugin.close(epaFile);
        return true;
    }

    public void addPages() {
        super.addPages();
        this.epaSelectionPage = new EpaSelectionPage("EpaSelectionPage");
        this.addPage(this.epaSelectionPage);
        try {
            if (this.workspace != null) {
                this.selectActivityPage = new SelectActivityPage();
                this.selectActivityPage.setWorkspace(this.workspace);
                this.selectActivityPage.setTitle("Select DTR Activity");
                this.addPage((IWizardPage)this.selectActivityPage);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    private void handleException(Throwable t) {
        String title = "Error";
        IStatus status = null;
        status = t instanceof CoreException ? ((CoreException)t).getStatus() : PortalContentPluginStatus.get(PortalContentPluginStatus.ERR_INTERNAL, t);
        ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
        PortalContentPlugin.log(status);
    }
}

