/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.pcd.ide.eclipse.nwdi.ui;

import com.sap.portal.pcd.ide.eclipse.nwdi.core.IQuery;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class QueryDialog
implements IQuery {
    private Shell shell;
    private String title;
    private String question;
    private int[] allowedAnswers;
    private int defaultAnswerIndex;
    private String[] dialogLabels;

    public QueryDialog(Shell pShell, String pTitle, String pQuestion, int[] pAllowedAnswers, int pDefaultAnswerIndex) {
        this.shell = pShell;
        this.title = pTitle;
        this.question = pQuestion;
        this.allowedAnswers = pAllowedAnswers;
        this.defaultAnswerIndex = pDefaultAnswerIndex;
        this.dialogLabels = new String[this.allowedAnswers.length];
        int i = 0;
        while (i < this.allowedAnswers.length) {
            switch (this.allowedAnswers[i]) {
                case 2: {
                    this.dialogLabels[i] = IDialogConstants.YES_LABEL;
                    break;
                }
                case 3: {
                    this.dialogLabels[i] = IDialogConstants.NO_LABEL;
                    break;
                }
                case 4: {
                    this.dialogLabels[i] = IDialogConstants.YES_TO_ALL_LABEL;
                    break;
                }
                case 5: {
                    this.dialogLabels[i] = IDialogConstants.NEXT_LABEL;
                    break;
                }
                case 1: {
                    this.dialogLabels[i] = IDialogConstants.CANCEL_LABEL;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("allowedAnswers: invalid return code at index " + i + ": " + this.allowedAnswers[i]);
                }
            }
            ++i;
        }
    }

    public int doQuery(IStatus status) {
        final String msg = status != null && status.getMessage() != null ? status.getMessage() + "\n\n" + this.question : this.question;
        final int[] result = new int[1];
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(QueryDialog.this.shell, QueryDialog.this.title, null, msg, 3, QueryDialog.this.dialogLabels, QueryDialog.this.defaultAnswerIndex);
                result[0] = dialog.open();
            }
        });
        return this.allowedAnswers[result[0]];
    }
}

