/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.pcd.ide.eclipse.nwdi.ui;

import java.io.File;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class FileSelectionComposite
extends Composite {
    Listener listener;
    String labelText;
    String[] fileFilterExtensions;
    String initialFileName;
    Label label;
    Text fileNameInputField;
    Button browseButton;
    FileDialog fileDialog;

    public FileSelectionComposite(Composite parent, Listener pListener) {
        super(parent, 0);
        this.listener = pListener;
    }

    public void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        if (this.labelText != null) {
            this.label = new Label((Composite)this, 16640);
            this.label.setText(this.labelText);
            layout.numColumns = 3;
        } else {
            layout.numColumns = 2;
        }
        super.setLayout((Layout)layout);
        this.fileNameInputField = new Text((Composite)this, 2052);
        this.fileNameInputField.setLayoutData((Object)new GridData(768));
        this.fileNameInputField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (FileSelectionComposite.this.listener != null) {
                    FileSelectionComposite.this.listener.handleEvent(new Event());
                }
            }
        });
        this.browseButton = new Button((Composite)this, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.setLayoutData((Object)new GridData(128));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionComposite.this.handleBrowse();
            }
        });
        super.setLayoutData((Object)new GridData(768));
        this.fileDialog = new FileDialog(this.getShell(), 4096);
        this.fileDialog.setFilterExtensions(this.fileFilterExtensions);
    }

    protected void handleBrowse() {
        this.fileDialog.setFileName(this.getSelectedFilePath());
        String selectedFileName = this.fileDialog.open();
        if (selectedFileName != null) {
            this.fileNameInputField.setText(selectedFileName);
        }
    }

    public String getSelectedFilePath() {
        return this.fileNameInputField.getText();
    }

    public File getSelectedFile() {
        String path = this.getSelectedFilePath();
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public String[] getFileFilterExtensions() {
        return this.fileFilterExtensions;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public void setFileFilterExtensions(String[] pExtensions) {
        this.fileFilterExtensions = pExtensions;
    }

    public void setLabelText(String pLabelText) {
        this.labelText = pLabelText;
    }

    public void setInitialFileName(String pString) {
        this.initialFileName = pString;
    }
}

