/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.pcd.ide.eclipse.nwdi.core;

import com.sap.portal.pcd.ide.eclipse.nwdi.core.DtrAccessBroker;
import com.sap.portal.pcd.ide.eclipse.nwdi.core.IQuery;
import com.sap.portal.pcd.ide.eclipse.nwdi.core.PcdNwdiObjectMapping;
import com.sap.portal.pcd.ide.eclipse.nwdi.core.PortalContentPlugin;
import com.sap.portal.pcd.ide.eclipse.nwdi.core.PortalContentPluginStatus;
import com.sap.s2x.conversion.info.InfoToS2XConverter;
import com.sapportals.portal.transport.EptFile;
import com.sapportals.portal.transport.TransportDataEntry;
import com.sapportals.portal.transport.TransportFileException;
import com.sapportals.portal.transport.app.EpaException;
import com.sapportals.portal.transport.app.EpaFile;
import com.sapportals.portal.transport.app.FileUtils;
import com.sapportals.portal.transport.app.IPackageEntry;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class UpdateEpaOperation
implements IRunnableWithProgress {
    private static final TracerI trace = TracingManager.getTracer((Class)(class$com$sap$portal$pcd$ide$eclipse$nwdi$core$UpdateEpaOperation == null ? (class$com$sap$portal$pcd$ide$eclipse$nwdi$core$UpdateEpaOperation = UpdateEpaOperation.class$("com.sap.portal.pcd.ide.eclipse.nwdi.core.UpdateEpaOperation")) : class$com$sap$portal$pcd$ide$eclipse$nwdi$core$UpdateEpaOperation));
    public static final int MONITOR_SUBTASK_MAXLEN = 60;
    private static final int MONITOR_WORK_WEIGHT_EPA_ENTRY = 200;
    private static final int MONITOR_WORK_SYNC_PROJECT = 2000;
    private static final int MONITOR_WORK_REFRESH_PROJECT = 500;
    private static final int MONITOR_WORK_DELETE_REMAINING_FILES = 500;
    private IProject project;
    private EpaFile epaFile;
    private Set existingObjectFolderNamesSet = new HashSet();
    private IVfsActivity activity;
    private Set changedVfsItemsSet = new HashSet();
    private IQuery continueOnErrorQuery;
    private IQuery updateWithDifferentPackageQuery;
    private IQuery useXflDataFromDcQuery;
    private boolean continueOnError = false;
    static /* synthetic */ Class class$com$sap$portal$pcd$ide$eclipse$nwdi$core$UpdateEpaOperation;

    public UpdateEpaOperation(IProject pProject, EpaFile pEpaFile, IVfsActivity pActivity, IQuery pContinueOnErrorQuery, IQuery pUpdateWithDifferentPackageQuery, IQuery pUseXflDataFromDcQuery) {
        this.project = pProject;
        this.epaFile = pEpaFile;
        this.activity = pActivity;
        this.continueOnErrorQuery = pContinueOnErrorQuery;
        this.updateWithDifferentPackageQuery = pUpdateWithDifferentPackageQuery;
        this.useXflDataFromDcQuery = pUpdateWithDifferentPackageQuery;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        DtrAccessBroker dtrBroker = DtrAccessBroker.getBroker();
        try {
            try {
                List epaEntryList;
                try {
                    epaEntryList = this.epaFile.getEntries();
                }
                catch (IOException e) {
                    throw new CoreException(PortalContentPluginStatus.get(PortalContentPluginStatus.ERR_GET_EPA_ENTRYLIST, e, new String[]{this.epaFile.getAbsolutePath()}));
                }
                int totalWork = 500 + (this.activity != null ? 2000 : 0) + epaEntryList.size() * 200 + 500;
                monitor.beginTask("Update EPA ...", totalWork);
                if (this.activity != null) {
                    monitor.subTask("synchronizing project ...");
                    dtrBroker.sync((IResource)this.project);
                    monitor.worked(2000);
                }
                monitor.subTask("refreshing project ...");
                this.project.refreshLocal(2, monitor);
                monitor.worked(500);
                this.updatePackageProperties(monitor);
                IFolder folder = this.project.getFolder("src");
                if (!folder.exists()) {
                    folder.create(true, true, monitor);
                    if (this.activity != null) {
                        this.changedVfsItemsSet.add(dtrBroker.addToDtrControl(this.activity, (IResource)folder));
                    }
                }
                if (!(folder = folder.getFolder("_pcd")).exists()) {
                    folder.create(true, true, monitor);
                    if (this.activity != null) {
                        this.changedVfsItemsSet.add(dtrBroker.addToDtrControl(this.activity, (IResource)folder));
                    }
                } else {
                    File[] existingObjFolders = folder.getLocation().toFile().listFiles();
                    int i = 0;
                    while (i < existingObjFolders.length) {
                        this.existingObjectFolderNamesSet.add(existingObjFolders[i].getName());
                        ++i;
                    }
                }
                Iterator it = epaEntryList.iterator();
                while (it.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    IPackageEntry nextEntry = (IPackageEntry)it.next();
                    try {
                        this.updatePcdObjectFolder(folder, nextEntry, monitor);
                    }
                    catch (CoreException e) {
                        PortalContentPlugin.log(e);
                        if (this.continueOnError) continue;
                        int queryAnswer = this.continueOnErrorQuery.doQuery(e.getStatus());
                        switch (queryAnswer) {
                            case 2: {
                                break;
                            }
                            case 4: {
                                this.continueOnError = true;
                                break;
                            }
                            case 3: {
                                throw new InterruptedException();
                            }
                            default: {
                                throw new IllegalStateException("Illegal return code from continueOnErrorQuery: " + queryAnswer);
                            }
                        }
                    }
                }
                monitor.subTask("deleting remaining files...");
                HashSet<IResource> resourcesToDelete = new HashSet<IResource>();
                Iterator it2 = this.existingObjectFolderNamesSet.iterator();
                while (it2.hasNext()) {
                    String objFolderName = (String)it2.next();
                    IFolder objFolder = folder.getFolder(objFolderName);
                    if (this.activity != null) {
                        IResource[] objFiles = objFolder.members();
                        int i = 0;
                        while (i < objFiles.length) {
                            resourcesToDelete.add(objFiles[i]);
                            ++i;
                        }
                        continue;
                    }
                    objFolder.delete(false, false, monitor);
                }
                if (this.activity != null) {
                    dtrBroker.checkOutAndDelete(this.activity, resourcesToDelete);
                }
                monitor.worked(500);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            Object var14_20 = null;
        }
        catch (Throwable throwable) {
            Object var14_21 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private void updatePackageProperties(IProgressMonitor monitor) throws CoreException, InterruptedException {
        String methodName = "updatePackageProperties";
        try {
            IFolder folder = this.project.getFolder("PACKAGE-INF");
            File folderOs = folder.getLocation().toFile();
            if (!folderOs.exists()) {
                folderOs.mkdirs();
                folder.refreshLocal(0, monitor);
                if (this.activity != null) {
                    this.changedVfsItemsSet.add(DtrAccessBroker.getBroker().addToDtrControl(this.activity, (IResource)folder));
                }
            }
            IFile propertiesFileHandle = folder.getFile("package.properties");
            File propertiesFileOs = propertiesFileHandle.getLocation().toFile();
            Properties properties = this.epaFile.getProperties();
            String packageUrlProp = "com.sap.portal.transport.app.package_url";
            String packageUrl = properties.getProperty("com.sap.portal.transport.app.package_url");
            if (packageUrl == null) {
                throw new EpaException("Invalid EPA file: package property com.sap.portal.transport.app.package_url not found.");
            }
            boolean isNew = true;
            if (propertiesFileOs.exists()) {
                IStatus status;
                isNew = false;
                Properties oldProperties = new Properties();
                FileInputStream is = null;
                try {
                    is = new FileInputStream(propertiesFileOs);
                    oldProperties.load(is);
                    Object var14_14 = null;
                }
                catch (Throwable throwable) {
                    Object var14_15 = null;
                    PortalContentPlugin.close(is, propertiesFileOs.toString());
                    throw throwable;
                }
                PortalContentPlugin.close(is, propertiesFileOs.toString());
                if (((Hashtable)properties).equals(oldProperties) && trace.debug()) {
                    trace.debug("updatePackageProperties", "Skipped update of " + propertiesFileOs + ": properties are equal.");
                    return;
                }
                String oldPackageUrl = oldProperties.getProperty("com.sap.portal.transport.app.package_url");
                if (oldPackageUrl == null) {
                    throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Invalid file " + propertiesFileOs + ": missing property " + "com.sap.portal.transport.app.package_url", null));
                }
                if (!packageUrl.equals(oldPackageUrl) && 3 == this.updateWithDifferentPackageQuery.doQuery(status = PortalContentPluginStatus.get(PortalContentPluginStatus.WARNING_UPDATE_WITH_DIFFERENT_PACKAGE, null, new String[]{packageUrl, oldPackageUrl}))) {
                    throw new InterruptedException();
                }
                if (this.activity != null) {
                    this.changedVfsItemsSet.add(DtrAccessBroker.getBroker().checkOutForEditOrAdd(this.activity, (IResource)propertiesFileHandle, true));
                }
            }
            FileOutputStream os = null;
            try {
                os = new FileOutputStream(propertiesFileOs);
                properties.store(os, PortalContentPlugin.getPluginId());
                Object var16_18 = null;
            }
            catch (Throwable throwable) {
                Object var16_19 = null;
                PortalContentPlugin.close(os, propertiesFileOs.getAbsolutePath());
                throw throwable;
            }
            PortalContentPlugin.close(os, propertiesFileOs.getAbsolutePath());
            propertiesFileHandle.refreshLocal(0, monitor);
            if (this.activity != null && isNew) {
                this.changedVfsItemsSet.add(DtrAccessBroker.getBroker().addToDtrControl(this.activity, (IResource)propertiesFileHandle));
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "I/O exception during update of package.properties.", (Throwable)e));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updatePcdObjectFolder(IFolder pParentFolder, IPackageEntry pPackageEntry, IProgressMonitor monitor) throws InterruptedException, CoreException {
        String methodName = "updatePcdObjectFolder";
        IFile eptFileHandle = null;
        InputStream eptInputStream = null;
        EptFile eptFile = null;
        String eptFileName = null;
        String xlfFileName = null;
        IFile xlfFileHandle = null;
        String pcdUrl = null;
        String folderName = null;
        try {
            block23: {
                try {
                    pcdUrl = pPackageEntry.getObjectUrl();
                    int pcdUrlLen = pcdUrl.length();
                    String subTaskName = pcdUrlLen <= 60 ? pcdUrl : pcdUrl.substring(pcdUrlLen - 60);
                    monitor.subTask(subTaskName);
                    String fileNamePrefix = PcdNwdiObjectMapping.getAtomicNameFromPcdUrl(pcdUrl);
                    eptFileName = fileNamePrefix + ".ept";
                    folderName = PcdNwdiObjectMapping.getUniqueFilenameForPcdUrl(pcdUrl);
                    IFolder objectFolder = pParentFolder.getFolder(folderName);
                    if (!objectFolder.exists()) {
                        objectFolder.create(true, true, monitor);
                        if (this.activity != null) {
                            this.changedVfsItemsSet.add(DtrAccessBroker.getBroker().addToDtrControl(this.activity, (IResource)objectFolder));
                        }
                    }
                    eptFileHandle = objectFolder.getFile(eptFileName);
                    xlfFileName = fileNamePrefix + ".xlf";
                    xlfFileHandle = objectFolder.getFile(xlfFileName);
                    eptInputStream = this.epaFile.getInputStream(pPackageEntry);
                    if (eptInputStream == null) {
                        throw new EpaException("Corrupt EPA file: " + eptFileName + ": no ZIP entry for object " + pcdUrl);
                    }
                    if (!eptFileHandle.exists()) {
                        eptFileHandle.create(eptInputStream, true, monitor);
                        eptFile = new EptFile(eptFileHandle.getLocation().toFile());
                        if (this.activity != null) {
                            Properties dtrProperties = PcdNwdiObjectMapping.getPropertiesForDtr(eptFile, true);
                            this.changedVfsItemsSet.add(DtrAccessBroker.getBroker().addToDtrControl(this.activity, (IResource)eptFileHandle, dtrProperties));
                        }
                        this.updateXlfFile(monitor, xlfFileHandle, eptFile);
                        if (this.activity != null && xlfFileHandle.exists()) {
                            this.changedVfsItemsSet.add(DtrAccessBroker.getBroker().addToDtrControl(this.activity, (IResource)xlfFileHandle));
                        }
                        break block23;
                    }
                    File tmpFile = File.createTempFile(folderName, ".tmp.ept");
                    FileOutputStream tmpOs = null;
                    try {
                        tmpOs = new FileOutputStream(tmpFile);
                        FileUtils.copyStream((InputStream)eptInputStream, (OutputStream)tmpOs);
                        Object var20_22 = null;
                        PortalContentPlugin.close(tmpOs, tmpFile.toString());
                    }
                    catch (Throwable throwable) {
                        Object var20_23 = null;
                        PortalContentPlugin.close(tmpOs, tmpFile.toString());
                        throw throwable;
                    }
                    eptFile = new EptFile(tmpFile);
                    String newEptFingerprint = null;
                    try {
                        newEptFingerprint = PcdNwdiObjectMapping.getEptFingerprint(eptFile);
                    }
                    catch (IOException e) {
                        PortalContentPlugin.log((IStatus)new Status(2, PortalContentPlugin.getPluginId(), 2, "Failed to get EPT fingerprint for file " + eptFileHandle.getFullPath(), (Throwable)e));
                    }
                    if (this.needsUpdate(eptFileHandle, newEptFingerprint)) {
                        IVfsActivityRecordedFolderItem xlfFileVfsItem = null;
                        if (this.activity != null) {
                            Properties dtrProperties = new Properties();
                            dtrProperties.setProperty("EPT:EptFingerprint", newEptFingerprint);
                            this.changedVfsItemsSet.add(DtrAccessBroker.getBroker().checkOutForEditOrAdd(this.activity, (IResource)eptFileHandle, true, dtrProperties));
                            if (xlfFileHandle.exists()) {
                                xlfFileVfsItem = DtrAccessBroker.getBroker().checkOutForEditOrAdd(this.activity, (IResource)xlfFileHandle, true);
                                this.changedVfsItemsSet.add(xlfFileVfsItem);
                            }
                        }
                        this.updateXlfFile(monitor, xlfFileHandle, eptFile);
                        if (this.activity != null && xlfFileHandle.exists() && xlfFileVfsItem == null) {
                            this.changedVfsItemsSet.add(DtrAccessBroker.getBroker().addToDtrControl(this.activity, (IResource)xlfFileHandle));
                        }
                        FileUtils.move((File)tmpFile, (File)eptFileHandle.getLocation().toFile());
                        eptFileHandle.refreshLocal(0, monitor);
                        break block23;
                    }
                    PortalContentPlugin.close(eptFile);
                    eptFile = null;
                    if (!tmpFile.delete()) {
                        PortalContentPlugin.log((IStatus)new Status(2, PortalContentPlugin.getPluginId(), 2, "Failed to remove temporary file " + tmpFile, null));
                    }
                    if (!trace.debug()) break block23;
                    trace.debug("updatePcdObjectFolder", "updatePcdObjectFolder(): skipped file due to equal fingerprint: " + eptFileHandle.getFullPath());
                }
                catch (CoreException e) {
                    if (e.getStatus() instanceof PortalContentPluginStatus) {
                        throw e;
                    }
                    throw new CoreException(PortalContentPluginStatus.get(PortalContentPluginStatus.ERR_UPDATE_SINGLE_OBJECT, e, new String[]{pcdUrl}));
                }
                catch (IOException e) {
                    throw new CoreException(PortalContentPluginStatus.get(PortalContentPluginStatus.ERR_UPDATE_SINGLE_OBJECT, e, new String[]{pcdUrl}));
                }
            }
            Object var23_28 = null;
            PortalContentPlugin.close(eptFile);
            PortalContentPlugin.close(eptInputStream, "EPA file " + eptFileName + ": EPT input stream for object " + pcdUrl);
            if (folderName != null) {
                this.existingObjectFolderNamesSet.remove(folderName);
            }
            monitor.worked(200);
            return;
        }
        catch (Throwable throwable) {
            Object var23_29 = null;
            PortalContentPlugin.close(eptFile);
            PortalContentPlugin.close(eptInputStream, "EPA file " + eptFileName + ": EPT input stream for object " + pcdUrl);
            if (folderName != null) {
                this.existingObjectFolderNamesSet.remove(folderName);
            }
            monitor.worked(200);
            throw throwable;
        }
    }

    private void updateXlfFile(IProgressMonitor monitor, IFile xlfFileHandle, EptFile eptFile) throws CoreException, InterruptedException {
        InputStream infoFileIs = null;
        FileOutputStream xlfFileOs = null;
        File xlfFile = xlfFileHandle.getLocation().toFile();
        File bakXlfFile = null;
        if (xlfFile.exists()) {
            bakXlfFile = new File(xlfFile.getParent(), xlfFile.getName() + ".bak");
            try {
                FileUtils.move((File)xlfFile, (File)bakXlfFile);
            }
            catch (IOException e1) {
                PortalContentPlugin.log(PortalContentPluginStatus.get(PortalContentPluginStatus.WARNING_BACKUP_FILE_FAILED, e1));
                bakXlfFile = null;
            }
        }
        try {
            try {
                TransportDataEntry infoFileEntry = eptFile.getEntry("Texts.info");
                if (infoFileEntry == null) {
                    throw new TransportFileException("Missing Texts.info entry in EPT file: " + eptFile);
                }
                try {
                    infoFileIs = eptFile.getInputStream(infoFileEntry);
                    xlfFileOs = new FileOutputStream(xlfFile);
                    InfoToS2XConverter.doConvert(infoFileIs, xlfFileOs);
                    Object var10_11 = null;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    PortalContentPlugin.close(infoFileIs, "Texts.info file of " + eptFile.getAbsolutePath());
                    PortalContentPlugin.close(xlfFileOs, xlfFileHandle.getProjectRelativePath().toString());
                    throw throwable;
                }
                PortalContentPlugin.close(infoFileIs, "Texts.info file of " + eptFile.getAbsolutePath());
                PortalContentPlugin.close(xlfFileOs, xlfFileHandle.getProjectRelativePath().toString());
                Object var12_15 = null;
            }
            catch (Exception e) {
                if (!xlfFile.exists() || xlfFile.length() == 0L) {
                    if (bakXlfFile != null) {
                        try {
                            FileUtils.move(bakXlfFile, (File)xlfFile);
                        }
                        catch (IOException e2) {
                            PortalContentPlugin.log(PortalContentPluginStatus.get(PortalContentPluginStatus.WARNING_RESTORE_FILE_FAILED, e2));
                        }
                    } else if (xlfFile.exists() && !xlfFile.delete()) {
                        PortalContentPlugin.log(PortalContentPluginStatus.get(PortalContentPluginStatus.WARNING_DELETE_FILE_FAILED));
                    }
                }
                throw new CoreException(PortalContentPluginStatus.get(PortalContentPluginStatus.ERR_XLF_UPDATE, e, new String[]{xlfFileHandle.getProjectRelativePath().toString()}));
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            xlfFileHandle.refreshLocal(0, monitor);
            throw throwable;
        }
        xlfFileHandle.refreshLocal(0, monitor);
    }

    private boolean needsUpdate(IFile pEptFileHandle, String pNewEptFingerprint) throws CoreException {
        String storedEptFingerprint;
        Properties props;
        String methodName = "needsUpdate";
        try {
            props = DtrAccessBroker.getBroker().getEptProperties((IResource)pEptFileHandle);
        }
        catch (CoreException e) {
            PortalContentPlugin.log(e);
            return true;
        }
        if (trace.debug()) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                props.store(bos, "TRACING stored EPT properties for file " + pEptFileHandle.getFullPath());
                trace.debug(bos.toString("UTF-8"));
                bos.close();
            }
            catch (IOException e) {
                trace.warning("needsUpdate", "Tracing DTR properties failed", (Throwable)e);
            }
        }
        if ((storedEptFingerprint = DtrAccessBroker.getBroker().getEptProperty("EPT:EptFingerprint", (IResource)pEptFileHandle)) == null) {
            if (trace.debug()) {
                trace.debug("needsUpdate", "No EPT fingerprint stored for resource " + pEptFileHandle.getFullPath());
            }
            return true;
        }
        if (trace.debug()) {
            trace.debug("needsUpdate", "Old EPT fingerprint: " + storedEptFingerprint + " - new EPT fingerprint: " + pNewEptFingerprint);
        }
        return !storedEptFingerprint.equals(pNewEptFingerprint);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

