/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.pcd.ide.eclipse.nwdi.core;

import com.sap.portal.pcd.ide.eclipse.nwdi.core.PortalContentPluginStatus;
import com.sapportals.portal.transport.EptFile;
import com.sapportals.portal.transport.app.EpaFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PortalContentPlugin
extends AbstractUIPlugin {
    private static PortalContentPlugin plugin;
    private ResourceBundle resourceBundle;
    private static final String PORTALCONTENT_PROJECT_NATURE_EXT = ".portalcontentnature";
    private static String fullProjectNatureId;

    public PortalContentPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.sap.portal.pcd.ide.eclipse.nwdi.core.PortalContentPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static PortalContentPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PortalContentPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static String getPluginId() {
        return PortalContentPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static void log(IStatus status) {
        PortalContentPlugin.getDefault().getLog().log(status);
    }

    public static void log(CoreException e) {
        IStatus status = e.getStatus();
        if (status != null) {
            PortalContentPlugin.log(status);
        } else {
            PortalContentPlugin.log(PortalContentPluginStatus.get(PortalContentPluginStatus.ERR_INTERNAL, (Throwable)e));
        }
    }

    public static String getPortalContentNatureId() {
        if (fullProjectNatureId == null) {
            fullProjectNatureId = PortalContentPlugin.getPluginId() + PORTALCONTENT_PROJECT_NATURE_EXT;
        }
        return fullProjectNatureId;
    }

    public static boolean addPortalContentNature(IProjectDescription pProjectDesc) {
        if (!pProjectDesc.hasNature(PortalContentPlugin.getPortalContentNatureId())) {
            String[] oldNatureIds = pProjectDesc.getNatureIds();
            String[] newNatureIds = new String[oldNatureIds.length + 1];
            System.arraycopy(oldNatureIds, 0, newNatureIds, 0, oldNatureIds.length);
            newNatureIds[oldNatureIds.length] = PortalContentPlugin.getPortalContentNatureId();
            pProjectDesc.setNatureIds(newNatureIds);
            return true;
        }
        return false;
    }

    public static void close(OutputStream os, String name) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                if (name == null) {
                    PortalContentPlugin.log(PortalContentPluginStatus.get(PortalContentPluginStatus.WARNING_CLOSE_STREAM, e));
                }
                PortalContentPlugin.log(PortalContentPluginStatus.get(PortalContentPluginStatus.WARNING_CLOSE_FILE, e, new String[]{name}));
            }
        }
    }

    public static void close(InputStream is, String name) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                if (name == null) {
                    PortalContentPlugin.log(PortalContentPluginStatus.get(PortalContentPluginStatus.WARNING_CLOSE_STREAM, e));
                }
                PortalContentPlugin.log(PortalContentPluginStatus.get(PortalContentPluginStatus.WARNING_CLOSE_FILE, e, new String[]{name}));
            }
        }
    }

    public static void close(EptFile f) {
        if (f != null) {
            try {
                f.close();
            }
            catch (IOException e) {
                PortalContentPlugin.log(PortalContentPluginStatus.get(PortalContentPluginStatus.WARNING_CLOSE_FILE, e, new String[]{f.getName()}));
            }
        }
    }

    public static void close(EpaFile f) {
        if (f != null) {
            try {
                f.close();
            }
            catch (IOException e) {
                PortalContentPlugin.log(PortalContentPluginStatus.get(PortalContentPluginStatus.WARNING_CLOSE_FILE, e, new String[]{f.getName()}));
            }
        }
    }

    static {
        fullProjectNatureId = null;
    }
}

