/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.pcd.ide.eclipse.nwdi.core;

import com.sapportals.portal.transport.EptFile;
import com.sapportals.portal.transport.IObjectDescriptor;
import com.sapportals.portal.transport.TransportDataEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class PcdNwdiObjectMapping {
    public static final int ATOMICNAME_MAXLEN = 24;
    public static final String SRC_FOLDER_NAME = "src";
    public static final String PCDSRC_FOLDER_NAME = "_pcd";
    public static final String PACKAGE_INF_FOLDER_NAME = "PACKAGE-INF";
    public static final String PACKAGE_PROPERTIES_FILE_NAME = "package.properties";
    public static final String PROP_DCTYPE_VERSION = "component-type-version";
    public static final String CURRENT_DCTYPE_VERSION = "1.0";

    private PcdNwdiObjectMapping() {
    }

    public static String getUniqueFilenameForPcdUrl(String pPcdUrl) {
        StringBuffer sb = new StringBuffer(60);
        sb.append(PcdNwdiObjectMapping.getAtomicNameFromPcdUrl(pPcdUrl));
        sb.append('_');
        sb.append(PcdNwdiObjectMapping.getHashForPcdUrl(pPcdUrl));
        return sb.toString();
    }

    public static String getAtomicNameFromPcdUrl(String pPcdUrl) {
        return PcdNwdiObjectMapping.getAtomicNameFromPcdUrl(pPcdUrl, 24);
    }

    private static String getAtomicNameFromPcdUrl(String pPcdUrl, int pLen) {
        int urlLen;
        int dotIdx;
        int slashIdx = pPcdUrl.lastIndexOf(47);
        int startIdx = Math.max(slashIdx, dotIdx = pPcdUrl.lastIndexOf(46)) + 1;
        if (startIdx >= (urlLen = pPcdUrl.length())) {
            throw new IllegalArgumentException("Invalid PCD URL: " + pPcdUrl + " (must not end with / or .)");
        }
        if (pLen >= 0) {
            return pPcdUrl.substring(startIdx, Math.min(startIdx + pLen, urlLen));
        }
        return pPcdUrl.substring(startIdx);
    }

    public static String getHashForPcdUrl(String pPcdUrl) {
        String mdAlgorithmName = "MD5";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(pPcdUrl.getBytes("UTF-8"));
            String hexDigest = PcdNwdiObjectMapping.toHexString(digest);
            return hexDigest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to create hash for PCD URL: MD5  algorithm not available: " + e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Failed to create hash for PCD URL: unsupported encoding: " + e);
        }
    }

    public static Properties getPropertiesForDtr(EptFile pEptFile, boolean isNew) throws IOException {
        Properties props = new Properties();
        if (isNew) {
            IObjectDescriptor objDesc = pEptFile.getObjectDescriptor();
            String objUrl = objDesc.getObjectURL();
            props.setProperty("EPT:ObjectUrl", objUrl);
            props.setProperty("EPT:ObjectType", objDesc.getObjectType());
            props.setProperty("EPT:ImportHandler", objDesc.getImportHandler());
            int idx = objUrl.lastIndexOf("/");
            while (idx == objUrl.length() - 1) {
                objUrl = objUrl.substring(0, idx);
                idx = objUrl.lastIndexOf("/");
            }
            String atomicName = objUrl.substring(idx + 1);
            props.setProperty("EPT:AtomicName", atomicName);
        }
        String eptFingerprint = PcdNwdiObjectMapping.getEptFingerprint(pEptFile);
        props.setProperty("EPT:EptFingerprint", eptFingerprint);
        return props;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getEptFingerprint(File pFile) throws IOException {
        String string;
        EptFile eptFile = null;
        try {
            eptFile = new EptFile(pFile);
            string = PcdNwdiObjectMapping.getEptFingerprint(eptFile);
            Object var4_3 = null;
            if (eptFile == null) return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (eptFile == null) throw throwable;
            try {
                eptFile.close();
                throw throwable;
            }
            catch (IOException e) {}
            throw throwable;
        }
        try {
            eptFile.close();
            return string;
        }
        catch (IOException e) {
            // empty catch block
        }
        return string;
    }

    public static String getEptFingerprint(EptFile pEptFile) throws IOException {
        MessageDigest md;
        String hashAlgorithm = "MD5";
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to generate EPT fingerprint: no implementation for hash algorithm MD5 available.");
        }
        InputStream is = null;
        List entryList = pEptFile.getEntryList();
        Iterator it = entryList.iterator();
        while (it.hasNext()) {
            TransportDataEntry entry = (TransportDataEntry)it.next();
            String entryName = entry.getName();
            is = pEptFile.getInputStream(entry);
            if (entryName.endsWith(".properties")) {
                PcdNwdiObjectMapping.updateMdWithProperties(md, is);
                continue;
            }
            int BUF_SIZE = 8192;
            byte[] buf = new byte[8192];
            int bytesRead = 0;
            while ((bytesRead = is.read(buf)) != -1) {
                md.update(buf, 0, bytesRead);
            }
        }
        String result = PcdNwdiObjectMapping.toHexString(md.digest());
        return result;
    }

    private static String toHexString(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        int i = 0;
        while (i < data.length) {
            int intValue = data[i];
            if (intValue < 0) {
                intValue ^= 0xFFFFFF00;
            }
            sb.append(Integer.toHexString(intValue));
            ++i;
        }
        return sb.toString();
    }

    private static void updateMdWithProperties(MessageDigest pMd, InputStream pIs) throws IOException {
        ArrayList<String> lineList = new ArrayList<String>();
        LineNumberReader lnReader = new LineNumberReader(new BufferedReader(new InputStreamReader(pIs, "UTF-8")));
        String currentLine = null;
        while ((currentLine = lnReader.readLine()) != null) {
            if (currentLine.startsWith("#")) continue;
            lineList.add(currentLine);
        }
        Collections.sort(lineList);
        Iterator it = lineList.iterator();
        while (it.hasNext()) {
            currentLine = (String)it.next();
            pMd.update(currentLine.getBytes("UTF-8"));
        }
    }
}

