/*
 * Decompiled with CFR 0.152.
 */
package com.sap.portal.pcd.ide.eclipse.nwdi.core;

import com.sap.portal.pcd.ide.eclipse.nwdi.core.PortalContentPlugin;
import com.tssap.dtr.client.eclipse.BluebirdPlugin;
import com.tssap.dtr.client.eclipse.DAVTeamProvider;
import com.tssap.dtr.client.eclipse.vfs.VfsManagerProvider;
import com.tssap.dtr.client.lib.vfs.IVersionedFileSystemManager;
import com.tssap.dtr.client.lib.vfs.IVfsActivity;
import com.tssap.dtr.client.lib.vfs.IVfsActivityRecordedFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsFolderItem;
import com.tssap.dtr.client.lib.vfs.IVfsGenericFolder;
import com.tssap.dtr.client.lib.vfs.IVfsProperty;
import com.tssap.dtr.client.lib.vfs.IVfsWorkspace;
import com.tssap.dtr.client.lib.vfs.VfsException;
import com.tssap.dtr.client.lib.vfs.VfsFolderItemLocationState;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DtrAccessBroker {
    private static final TracerI trace = TracingManager.getTracer((Class)(class$com$sap$portal$pcd$ide$eclipse$nwdi$core$DtrAccessBroker == null ? (class$com$sap$portal$pcd$ide$eclipse$nwdi$core$DtrAccessBroker = DtrAccessBroker.class$("com.sap.portal.pcd.ide.eclipse.nwdi.core.DtrAccessBroker")) : class$com$sap$portal$pcd$ide$eclipse$nwdi$core$DtrAccessBroker));
    public static final String EP_NAMESPACE_URI = "urn:sap.com:EP:PCD:TRANS";
    public static final String EP_NAMESPACE_PREFIX = "EPT";
    public static final String PROP_OBJECT_URL = "EPT:ObjectUrl";
    public static final String PROP_OBJECT_TYPE = "EPT:ObjectType";
    public static final String PROP_ATOMIC_NAME = "EPT:AtomicName";
    public static final String PROP_IMPORT_HANDLER = "EPT:ImportHandler";
    public static final String PROP_EPT_FINGERPRINT = "EPT:EptFingerprint";
    public static final String[] ALL_EPT_PROPERTIES = new String[]{"EPT:ObjectUrl", "EPT:ObjectType", "EPT:AtomicName", "EPT:ImportHandler", "EPT:EptFingerprint"};
    private static final DtrAccessBroker instance = new DtrAccessBroker();
    static /* synthetic */ Class class$com$sap$portal$pcd$ide$eclipse$nwdi$core$DtrAccessBroker;

    public static DtrAccessBroker getBroker() {
        return instance;
    }

    private DtrAccessBroker() {
    }

    public void sync(IResource pResource) throws CoreException {
        IVfsActivityRecordedFolderItem actFolderItem = this.getActivityRecordedFolderItem(pResource);
        try {
            actFolderItem.sync();
        }
        catch (VfsException e) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to sync resource(s) from DTR: " + pResource.getFullPath(), (Throwable)e));
        }
    }

    public IVfsActivityRecordedFolderItem addToDtrControl(IVfsActivity pActivity, IResource pResource) throws CoreException {
        return this.addToDtrControl(pActivity, pResource, null);
    }

    public IVfsActivityRecordedFolderItem addToDtrControl(IVfsActivity pActivity, IResource pResource, Properties pEptProperties) throws CoreException {
        IVfsActivityRecordedFolderItem vfsActFolderItem = this.getActivityRecordedFolderItem(pResource);
        try {
            this.createAndCheckout(vfsActFolderItem, pActivity);
            if (pEptProperties != null && !((Hashtable)pEptProperties).isEmpty()) {
                this.setEptProperties(pActivity, vfsActFolderItem, pEptProperties);
            }
            return vfsActFolderItem;
        }
        catch (VfsException e) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to add resource to DTR control: " + pResource.getFullPath(), (Throwable)e));
        }
    }

    private IVfsActivityRecordedFolderItem checkOutForEdit(IVfsActivity pActivity, IResource pResource, boolean exclusive) throws CoreException {
        IVfsActivityRecordedFolderItem vfsActFolderItem = this.getActivityRecordedFolderItem(pResource);
        try {
            vfsActFolderItem.checkOutForEdit(pActivity, exclusive);
            return vfsActFolderItem;
        }
        catch (VfsException e) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to check-out resource for edit: " + pResource.getFullPath(), (Throwable)e));
        }
    }

    public IVfsActivityRecordedFolderItem checkOutForEditOrAdd(IVfsActivity pActivity, IResource pResource, boolean exclusive) throws CoreException {
        return this.checkOutForEditOrAdd(pActivity, pResource, exclusive, null);
    }

    public IVfsActivityRecordedFolderItem checkOutForEditOrAdd(IVfsActivity pActivity, IResource pResource, boolean exclusive, Properties pEptProperties) throws CoreException {
        IVfsActivityRecordedFolderItem vfsActFolderItem = this.getActivityRecordedFolderItem(pResource);
        try {
            VfsFolderItemLocationState locationState = vfsActFolderItem.getLocationState();
            if (VfsFolderItemLocationState.LOCAL_ONLY.equals(locationState)) {
                this.createAndCheckout(vfsActFolderItem, pActivity);
            } else {
                vfsActFolderItem.checkOutForEdit(pActivity, exclusive);
            }
            if (pEptProperties != null && !((Hashtable)pEptProperties).isEmpty()) {
                this.setEptProperties(pActivity, vfsActFolderItem, pEptProperties);
            }
            return vfsActFolderItem;
        }
        catch (VfsException e) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to check-out resource for edit or add: " + pResource.getFullPath(), (Throwable)e));
        }
    }

    public IVfsActivityRecordedFolderItem checkOutAndDelete(IVfsActivity pActivity, IResource pResource) throws CoreException {
        IVfsActivityRecordedFolderItem vfsActFolderItem = this.getActivityRecordedFolderItem(pResource);
        if (VfsFolderItemLocationState.LOCAL_ONLY.equals(vfsActFolderItem.getLocationState())) {
            pResource.delete(true, null);
            return null;
        }
        try {
            IVfsWorkspace vfsWorkspace = vfsActFolderItem.getWorkspace();
            vfsWorkspace.checkoutAndDelete(new IVfsActivityRecordedFolderItem[]{vfsActFolderItem}, pActivity);
            return vfsActFolderItem;
        }
        catch (VfsException e) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to check-out resource for delete: " + pResource.getFullPath(), (Throwable)e));
        }
    }

    public void checkOutAndDelete(IVfsActivity pActivity, Set resourcesToDelete) throws CoreException {
        ArrayList<IVfsActivityRecordedFolderItem> nonLocalVfsFolderItemsToDelete = new ArrayList<IVfsActivityRecordedFolderItem>();
        Iterator it = resourcesToDelete.iterator();
        while (it.hasNext()) {
            IResource resource = (IResource)it.next();
            IVfsActivityRecordedFolderItem vfsActFolderItem = this.getActivityRecordedFolderItem(resource);
            if (VfsFolderItemLocationState.LOCAL_ONLY.equals(vfsActFolderItem.getLocationState())) {
                resource.delete(true, null);
                continue;
            }
            nonLocalVfsFolderItemsToDelete.add(vfsActFolderItem);
        }
        if (!nonLocalVfsFolderItemsToDelete.isEmpty()) {
            IVfsActivityRecordedFolderItem[] folderItemArray = nonLocalVfsFolderItemsToDelete.toArray(new IVfsActivityRecordedFolderItem[nonLocalVfsFolderItemsToDelete.size()]);
            try {
                IVfsWorkspace vfsWorkspace = folderItemArray[0].getWorkspace();
                vfsWorkspace.checkoutAndDelete(folderItemArray, pActivity);
            }
            catch (VfsException e) {
                throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to check-out resources for delete.", (Throwable)e));
            }
        }
    }

    public IVfsActivityRecordedFolderItem getActivityRecordedFolderItem(IResource pResource) throws CoreException {
        if (!pResource.exists()) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Cannot get DTR resource for non-existing local resource: " + pResource.getFullPath(), null));
        }
        DAVTeamProvider teamProvider = this.getTeamProvider(pResource);
        IVfsFolderItem vfsFolderItem = teamProvider.getFolderItem(pResource);
        IVfsActivityRecordedFolderItem vfsActFolderItem = vfsFolderItem.asActivityRecordedFolderItem();
        return vfsActFolderItem;
    }

    public DAVTeamProvider getTeamProvider(IResource pResource) throws CoreException {
        IProject project = pResource.getProject();
        if (project == null) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to get team provider for resource: " + pResource.getName() + ": no project assigned.", null));
        }
        DAVTeamProvider teamProvider = BluebirdPlugin.getDAVTeamProvider((IResource)project);
        if (teamProvider == null) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "No DAV team provider found for project " + project.getName(), null));
        }
        return teamProvider;
    }

    public IVfsWorkspace getWorkspace(IResource pResource) throws CoreException {
        IVersionedFileSystemManager vfsManager = this.getTeamProvider(pResource).getVFSManager();
        if (vfsManager == null) {
            return null;
        }
        IPath localPath = pResource.getLocation();
        if (localPath == null) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to get DTR workspace for resource " + pResource + ": no local path available.", null));
        }
        String localPathStr = localPath.toOSString();
        IVfsWorkspace[] workspaces = vfsManager.getWorkspacesForLocalPath(localPathStr);
        if (workspaces == null) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to get DTR workspace for resource " + pResource + ": vfsManager.getWorkspacesForLocalPath(" + localPathStr + ") returned null.", null));
        }
        switch (workspaces.length) {
            case 0: {
                throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to get DTR workspace for resource " + pResource + ": vfsManager.getWorkspacesForLocalPath(" + localPathStr + ") returned empty array.", null));
            }
            case 1: {
                return workspaces[0];
            }
        }
        throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to get DTR workspace for resource " + pResource + ": vfsManager.getWorkspacesForLocalPath(" + localPathStr + ") returned multiple results. Resource is ambigous.", null));
    }

    public boolean isUserLoggedIn() {
        return VfsManagerProvider.getInstance().isUserLoggedinInSapIDE();
    }

    public Properties getEptProperties(IResource pResource) throws CoreException {
        return this.getEptProperties(this.getActivityRecordedFolderItem(pResource));
    }

    public Properties getEptProperties(IVfsActivityRecordedFolderItem pFolderItem) throws CoreException {
        String methodName = "getEptProperties";
        Properties props = new Properties();
        VfsFolderItemLocationState locationState = pFolderItem.getLocationState();
        if (VfsFolderItemLocationState.LOCAL_ONLY.equals(locationState) || VfsFolderItemLocationState.NOT_MOUNTED.equals(locationState)) {
            trace.warning("getEptProperties", "Cannot get DTR properties for local or unmounted resource: " + pFolderItem.getLocalPath());
            return props;
        }
        this.registerEptNamespace(pFolderItem);
        try {
            Map vfsPropertyMap = pFolderItem.getProperties(ALL_EPT_PROPERTIES);
            Iterator it = vfsPropertyMap.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                IVfsProperty vfsProperty = (IVfsProperty)vfsPropertyMap.get(key);
                String value = vfsProperty.getValue();
                if (value == null) continue;
                props.setProperty(key, value);
            }
            return props;
        }
        catch (VfsException e) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to get DTR properties for resource " + pFolderItem.getLocalPath(), (Throwable)e));
        }
    }

    public String getEptProperty(String pPropertyKey, IResource pResource) throws CoreException {
        return this.getEptProperty(pPropertyKey, this.getActivityRecordedFolderItem(pResource));
    }

    public String getEptProperty(String pPropertyKey, IVfsActivityRecordedFolderItem pFolderItem) throws CoreException {
        String methodName = "getEptProperty";
        VfsFolderItemLocationState locationState = pFolderItem.getLocationState();
        if (VfsFolderItemLocationState.LOCAL_ONLY.equals(locationState) || VfsFolderItemLocationState.NOT_MOUNTED.equals(locationState)) {
            trace.warning("getEptProperty", "Cannot get DTR properties for local or unmounted resource: " + pFolderItem.getLocalPath());
            return null;
        }
        this.registerEptNamespace(pFolderItem);
        try {
            IVfsProperty vfsProperty = pFolderItem.getProperty(pPropertyKey);
            if (vfsProperty != null) {
                return vfsProperty.getValue();
            }
            return null;
        }
        catch (VfsException e) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to get DTR property " + pPropertyKey + " for resource " + pFolderItem.getLocalPath(), (Throwable)e));
        }
    }

    public void setEptProperties(IVfsActivity pActivity, IVfsActivityRecordedFolderItem pFolderItem, Properties pProperties) throws CoreException {
        Enumeration enumeration = ((Hashtable)pProperties).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            this.registerEptNamespace(pFolderItem);
            try {
                pFolderItem.setProperty(key, pProperties.getProperty(key), pActivity);
            }
            catch (VfsException e) {
                throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to set DTR properties for resource " + pFolderItem.getLocalPath(), (Throwable)e));
            }
        }
    }

    private void registerEptNamespace(IVfsActivityRecordedFolderItem pFolderItem) throws CoreException {
        IVersionedFileSystemManager vfsManager = pFolderItem.getVersionedFileSystemManager();
        try {
            String registeredPrefix = vfsManager.getPrefixForNamespaceUri(EP_NAMESPACE_URI);
            if (registeredPrefix == null) {
                vfsManager.registerNamespace(EP_NAMESPACE_PREFIX, EP_NAMESPACE_URI);
            } else if (!registeredPrefix.equals(EP_NAMESPACE_PREFIX)) {
                throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to register EP namespace for DTR properties: urn:sap.com:EP:PCD:TRANS is already registered under prefix " + registeredPrefix, null));
            }
        }
        catch (VfsException e) {
            throw new CoreException((IStatus)new Status(4, PortalContentPlugin.getPluginId(), 4, "Failed to register EP namespace for DTR properties: EPT - urn:sap.com:EP:PCD:TRANS", (Throwable)e));
        }
    }

    private IVfsActivityRecordedFolderItem getRefreshedItemWhenDeleted(IVfsActivityRecordedFolderItem aVfsFolderItem) throws VfsException {
        VfsFolderItemLocationState locationState = aVfsFolderItem.getLocationState();
        if (VfsFolderItemLocationState.DELETED.equals(locationState)) {
            IVfsFolderItem[] refreshedItems;
            IVfsGenericFolder parent = aVfsFolderItem.getParent();
            if (parent != null && (refreshedItems = parent.refreshFolderItems()) != null) {
                int i = 0;
                while (i < refreshedItems.length) {
                    if (refreshedItems[i].getName().equals(aVfsFolderItem.getName())) {
                        return (IVfsActivityRecordedFolderItem)refreshedItems[i];
                    }
                    ++i;
                }
            }
            throw new IllegalStateException("Failed to refresh deleted foletr item: either parent is null or item not contained in result of refreshFolderItems()");
        }
        return aVfsFolderItem;
    }

    private void createAndCheckout(IVfsActivityRecordedFolderItem vfsActFolderItem, IVfsActivity pActivity) throws VfsException {
        IVfsActivityRecordedFolderItem refreshedItem = this.getRefreshedItemWhenDeleted(vfsActFolderItem);
        refreshedItem.createAndCheckout(pActivity);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

