/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.depend;

import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.internal.plugin.depend.PackageLink;
import com.togethersoft.sca.plugin.depend.IPackage;
import com.togethersoft.sca.plugin.depend.IPackageLink;
import java.util.HashMap;
import java.util.Iterator;

class Package
implements IPackage {
    private AstPackage pkg;
    private HashMap dependsOn = new HashMap();
    private HashMap usedBy = new HashMap();
    private boolean linksComputed = false;
    private boolean processing = false;

    Package(AstPackage pkg) {
        this.pkg = pkg;
    }

    public AstPackage getPackage() {
        return this.pkg;
    }

    public IPackageLink[] dependsOn() {
        return this.dependsOn.values().toArray(new IPackageLink[this.dependsOn.size()]);
    }

    public IPackageLink[] usedBy() {
        return this.usedBy.values().toArray(new IPackageLink[this.usedBy.size()]);
    }

    void addDependence(Package pkg) {
        PackageLink link = (PackageLink)this.usedBy.get(pkg.getPackage());
        if (link == null) {
            link = new PackageLink(pkg, this);
            this.usedBy.put(pkg.getPackage(), link);
            pkg.dependsOn.put(this.getPackage(), link);
        }
        ++link.weight;
    }

    void computeClosureSet() {
        this.processing = true;
        PackageLink[] links = this.usedBy.values().toArray(new PackageLink[this.usedBy.size()]);
        int i = 0;
        while (i < links.length) {
            links[i].from.computeUsed(this);
            ++i;
        }
        links = this.dependsOn.values().toArray(new PackageLink[this.dependsOn.size()]);
        int i2 = 0;
        while (i2 < links.length) {
            links[i2].to.computeDepends(this);
            ++i2;
        }
        this.processing = false;
        this.linksComputed = true;
    }

    private void computeUsed(Package p) {
        this.processing = true;
        Iterator i = this.usedBy.values().iterator();
        while (i.hasNext()) {
            PackageLink link = (PackageLink)i.next();
            if (link.from.processing) continue;
            if (!(!this.linksComputed && link.farDependency || p.usedBy.containsKey(link.from.pkg))) {
                PackageLink l = new PackageLink(link.from, p, true);
                p.usedBy.put(link.from.pkg, l);
                link.from.dependsOn.put(p.pkg, l);
            }
            if (this.linksComputed) continue;
            link.from.computeUsed(p);
        }
        this.processing = false;
    }

    private void computeDepends(Package p) {
        this.processing = true;
        Iterator i = this.dependsOn.values().iterator();
        while (i.hasNext()) {
            PackageLink link = (PackageLink)i.next();
            if (link.to.processing) continue;
            if (!(!this.linksComputed && link.farDependency || p.dependsOn.containsKey(link.to.pkg))) {
                PackageLink l = new PackageLink(p, link.to, true);
                p.dependsOn.put(link.to.pkg, l);
                link.to.usedBy.put(p.pkg, l);
            }
            if (this.linksComputed) continue;
            link.to.computeDepends(p);
        }
        this.processing = false;
    }
}

