/*
 * Decompiled with CFR 0.152.
 */
package com.togethersoft.sca.internal.plugin.depend;

import com.togethersoft.sca.ast.AstCompilationUnit;
import com.togethersoft.sca.ast.AstModel;
import com.togethersoft.sca.ast.AstPackage;
import com.togethersoft.sca.ast.AstType;
import com.togethersoft.sca.core.IAnalyzerDescriptor;
import com.togethersoft.sca.core.IAnalyzerRegistry;
import com.togethersoft.sca.core.ICodeInspectorExecutable;
import com.togethersoft.sca.core.ILog;
import com.togethersoft.sca.core.IParameterRegistry;
import com.togethersoft.sca.core.IProject;
import com.togethersoft.sca.core.JobControl;
import com.togethersoft.sca.internal.plugin.depend.Package;
import com.togethersoft.sca.internal.plugin.depend.Type;
import com.togethersoft.sca.plugin.depend.IDependAnalyzer;
import com.togethersoft.sca.plugin.depend.IPackage;
import com.togethersoft.sca.plugin.depend.IPackageLink;
import com.togethersoft.sca.plugin.depend.IType;
import com.togethersoft.sca.plugin.depend.ITypeLink;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class Depend
implements ICodeInspectorExecutable,
IDependAnalyzer {
    private HashMap types = new HashMap(16384);
    private HashMap packages = new HashMap(2048);
    private String args;
    private HashSet selPackages = null;
    private HashSet selTypes = null;
    private ILog log;
    private boolean XMLOutput;
    private static final String MSG_EXPORT = "\tAfferent couplings";
    private static final String MSG_IMPORT = "\tEfferent couplings";

    public IPackage[] getPackages() {
        return this.packages.values().toArray(new IPackage[this.packages.size()]);
    }

    public IType[] getTypes() {
        return this.types.values().toArray(new IType[this.types.size()]);
    }

    public void setParameters(IParameterRegistry registry) {
    }

    public void configureRegistry(IAnalyzerRegistry registry) {
    }

    public void run(IProject project, IAnalyzerDescriptor[] analyzers, JobControl jobControl) {
        this.log = project.getLog();
        this.XMLOutput = project.getLog().isXML();
        this.processModel(null, project, jobControl);
        if (jobControl != null && jobControl.isCanceled()) {
            return;
        }
        this.buildClosure();
        if (jobControl != null && jobControl.isCanceled()) {
            return;
        }
        this.reportDependencies();
    }

    public void processModel(String[] selected, IProject project, JobControl jobControl) {
        if (selected == null) {
            AstPackage[] packages = project.getModel().getPackages();
            int i = 0;
            while (i < packages.length) {
                this.processPackage(packages[i]);
                ++i;
            }
        } else {
            this.selPackages = new HashSet();
            this.selTypes = new HashSet();
            this.deepParse(project, selected);
            Iterator i = this.selPackages.iterator();
            while (i.hasNext()) {
                this.processPackage((AstPackage)i.next());
            }
            i = this.selTypes.iterator();
            while (i.hasNext()) {
                this.processType((AstType)i.next());
            }
        }
    }

    private void buildClosure() {
        if (this.selPackages == null) {
            Iterator i = this.packages.values().iterator();
            while (i.hasNext()) {
                Package pkg = (Package)i.next();
                pkg.computeClosureSet();
            }
        } else {
            Iterator i = this.selPackages.iterator();
            while (i.hasNext()) {
                Package pkg = this.getPackage((AstPackage)i.next());
                pkg.computeClosureSet();
            }
        }
    }

    private void deepParse(IProject project, String[] selected) {
        AstModel model = project.getModel();
        int i = 0;
        while (i < selected.length) {
            AstPackage pkg = model.findPackage(selected[i]);
            if (pkg != null) {
                AstCompilationUnit[] units = pkg.getCompilationUnits();
                int j = 0;
                while (j < units.length) {
                    project.deepUpdate(units[j]);
                    AstType[] types = units[j].getTypes();
                    int k = 0;
                    while (k < types.length) {
                        this.selTypes.add(types[k]);
                        ++k;
                    }
                    ++j;
                }
                this.selPackages.add(pkg);
            } else {
                AstType type = model.findType(selected[i]);
                if (type != null) {
                    AstCompilationUnit cu = type.getCompilationUnit();
                    if (cu != null) {
                        project.deepUpdate(cu);
                    }
                    this.selTypes.add(type);
                }
            }
            ++i;
        }
    }

    private void processPackage(AstPackage pkg) {
        AstPackage[] packages = pkg.getSubpackages();
        int i = 0;
        while (i < packages.length) {
            this.processPackage(packages[i]);
            ++i;
        }
        AstCompilationUnit[] units = pkg.getCompilationUnits();
        int i2 = 0;
        while (i2 < units.length) {
            AstType[] types = units[i2].getTypes();
            int j = 0;
            while (j < types.length) {
                this.processType(types[j]);
                ++j;
            }
            ++i2;
        }
    }

    private void processType(AstType type) {
        AstType[] imports = type.getImportCouplings();
        int i = 0;
        while (i < imports.length) {
            this.addDependence(type, imports[i]);
            ++i;
        }
    }

    private void addDependence(AstType client, AstType server) {
        if (client == null || server == null) {
            return;
        }
        if (client != server && client.isSource() && server.isSource()) {
            this.getType(server).addDependence(this.getType(client));
            AstPackage pkg1 = client.getPackage();
            AstPackage pkg2 = server.getPackage();
            if (pkg1 != pkg2) {
                this.getPackage(pkg2).addDependence(this.getPackage(pkg1));
            }
        }
    }

    private Package getPackage(AstPackage pkg) {
        Package p = (Package)this.packages.get(pkg);
        if (p == null) {
            p = new Package(pkg);
            this.packages.put(pkg, p);
        }
        return p;
    }

    private Type getType(AstType type) {
        Type t = (Type)this.types.get(type);
        if (t == null) {
            t = new Type(type);
            this.types.put(type, t);
        }
        return t;
    }

    private void reportDependencies() {
        if (this.XMLOutput) {
            this.log.log("<dependency>");
        }
        if (this.selPackages == null) {
            Iterator i = this.packages.values().iterator();
            while (i.hasNext()) {
                this.reportPackage((Package)i.next());
            }
        } else {
            Iterator i = this.selPackages.iterator();
            while (i.hasNext()) {
                Package pkg = this.getPackage((AstPackage)i.next());
                this.reportPackage(pkg);
            }
        }
        if (this.XMLOutput) {
            this.log.log("</dependency>");
        }
    }

    private void reportPackage(Package p) {
        if (this.XMLOutput) {
            this.log.log("<package name=\"" + p.getPackage().getQualifiedName() + "\">");
        } else {
            this.log.log(p.getPackage().getQualifiedName() + " (Package)");
            this.log.log(MSG_EXPORT);
        }
        IPackageLink[] links = p.usedBy();
        int i = 0;
        while (i < links.length) {
            if (this.XMLOutput) {
                this.printLink(links[i], true);
            } else {
                this.log.log("\t\t" + links[i].from().getPackage().getQualifiedName() + (links[i].isDirect() ? " direct" : " indirect"));
            }
            ++i;
        }
        if (!this.XMLOutput) {
            this.log.log(MSG_IMPORT);
        }
        links = p.dependsOn();
        int i2 = 0;
        while (i2 < links.length) {
            if (this.XMLOutput) {
                this.printLink(links[i2], false);
            } else {
                this.log.log("\t\t" + links[i2].to().getPackage().getQualifiedName() + (links[i2].isDirect() ? " direct" : " indirect"));
            }
            ++i2;
        }
        AstCompilationUnit[] astcunits = p.getPackage().getCompilationUnits();
        int i3 = 0;
        while (i3 < astcunits.length) {
            AstType[] asttypes = astcunits[i3].getTypes();
            int j = 0;
            while (j < asttypes.length) {
                Type t;
                if ((this.selTypes == null || this.selTypes.contains(asttypes[j])) && (t = (Type)this.types.get(asttypes[j])) != null) {
                    this.reportType(t);
                }
                ++j;
            }
            ++i3;
        }
        if (this.XMLOutput) {
            this.log.log("</package>");
        }
    }

    private void printLink(IPackageLink link, boolean direction) {
        this.log.log("\t<link>");
        this.log.log("\t\t<property name=\"target\" value=\"" + (direction ? link.from().getPackage().getQualifiedName() : link.to().getPackage().getQualifiedName()) + "\" />");
        this.log.log("\t\t<property name=\"direction\" value=\"" + (direction ? "afferent" : "efferent") + "\" />");
        this.log.log("\t\t<property name=\"direct\" value=\"" + link.isDirect() + "\" />");
        this.log.log("\t\t<property name=\"weight\" value=\"" + link.weight() + "\" />");
        this.log.log("\t</link>");
    }

    private void reportType(Type t) {
        if (this.XMLOutput) {
            this.log.log("<type name=\"" + t.getType().getQualifiedName() + "\">");
        } else {
            this.log.log(t.getType().getQualifiedName() + " (Type)");
            this.log.log(MSG_EXPORT);
        }
        ITypeLink[] links = t.usedBy();
        int i = 0;
        while (i < links.length) {
            if (this.XMLOutput) {
                this.log.log("\t<link>");
                this.log.log("\t\t<property name=\"target\" value=\"" + links[i].from().getType().getQualifiedName() + "\" />");
                this.log.log("\t\t<property name=\"direction\" value=\"afferent\" />");
                this.log.log("\t</link>");
            } else {
                this.log.log("\t\t" + links[i].from().getType().getQualifiedName());
            }
            ++i;
        }
        if (!this.XMLOutput) {
            this.log.log(MSG_IMPORT);
        }
        links = t.dependsOn();
        int i2 = 0;
        while (i2 < links.length) {
            if (this.XMLOutput) {
                this.log.log("\t<link>");
                this.log.log("\t\t<property name=\"target\" value=\"" + links[i2].to().getType().getQualifiedName() + "\" />");
                this.log.log("\t\t<property name=\"direction\" value=\"efferent\" />");
                this.log.log("\t</link>");
            } else {
                this.log.log("\t\t" + links[i2].to().getType().getQualifiedName());
            }
            ++i2;
        }
        if (this.XMLOutput) {
            this.log.log("</type>");
        }
    }
}

