/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.j2ee.core.providers.dtr;

import com.tssap.dii.dtri.DtriCheckedObjects;
import com.tssap.dii.dtri.DtriRelevantObjects;
import com.tssap.dii.dtri.DtriUtil;
import com.tssap.j2ee.model.J2eeElementManager;
import com.tssap.j2ee.model.J2eeProjectManager;
import com.tssap.j2ee.model.ejb.IEnterpriseJavaBean;
import com.tssap.j2ee.model.ejb.IEntityBean;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.extension.ObjectPropertyProvider;
import com.tssap.selena.model.extension.filefolder.FileAndFolderManagement;
import com.tssap.util.trace.TracerI;
import com.tssap.util.trace.TracingManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class DTRObjectPropertyProvider
implements ObjectPropertyProvider {
    private static final TracerI TRACER = TracingManager.getTracer((Class)(class$com$tssap$j2ee$core$providers$dtr$DTRObjectPropertyProvider == null ? (class$com$tssap$j2ee$core$providers$dtr$DTRObjectPropertyProvider = DTRObjectPropertyProvider.class$("com.tssap.j2ee.core.providers.dtr.DTRObjectPropertyProvider")) : class$com$tssap$j2ee$core$providers$dtr$DTRObjectPropertyProvider));
    static /* synthetic */ Class class$com$tssap$j2ee$core$providers$dtr$DTRObjectPropertyProvider;

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        return false;
    }

    public Object getObjectPropertyValue(Element element, String propertyName) {
        DtriRelevantObjects ret = null;
        if (propertyName.equals("ObjectPropertyName_DtrRelevantObjects")) {
            DtriCheckedObjects dtrCheckedObjects;
            ArrayList<Object> dtrList = new ArrayList<Object>();
            if (J2eeElementManager.isEjbModule((Element)element.getModel()) && J2eeElementManager.isEnterpriseJavaBean((Element)element)) {
                IEnterpriseJavaBean ejb = J2eeElementManager.getEnterpriseJavaBean((Element)element);
                try {
                    dtrList.add(ejb.getBeanClass().getUnderlyingResource());
                }
                catch (JavaModelException e) {
                    TRACER.error("Retrieve beanclass file for ejb failed", (Throwable)e);
                    return ret;
                }
                if (ejb.getEjbType() != 2) {
                    IType res = ejb.getRemoteInterfaceClass();
                    if (res != null) {
                        try {
                            dtrList.add(res.getUnderlyingResource());
                        }
                        catch (JavaModelException e) {
                            TRACER.log(4, "Retrieve remote interface file for ejb failed", (Throwable)e);
                        }
                    }
                    if ((res = ejb.getHomeInterfaceClass()) != null) {
                        try {
                            dtrList.add(res.getUnderlyingResource());
                        }
                        catch (JavaModelException e) {
                            TRACER.log(4, "Retrieve home interface file for ejb failed", (Throwable)e);
                        }
                    }
                    if ((res = ejb.getLocalInterfaceClass()) != null) {
                        try {
                            dtrList.add(res.getUnderlyingResource());
                        }
                        catch (JavaModelException e) {
                            TRACER.log(4, "Retrieve local interface file for ejb failed", (Throwable)e);
                        }
                    }
                    if ((res = ejb.getLocalHomeInterfaceClass()) != null) {
                        try {
                            dtrList.add(res.getUnderlyingResource());
                        }
                        catch (JavaModelException e) {
                            TRACER.log(4, "Retrieve localhome interface file for ejb failed", (Throwable)e);
                        }
                    }
                    if (ejb instanceof IEntityBean && (res = ((IEntityBean)ejb).getPrimaryKeyClass()) != null) {
                        try {
                            dtrList.add(res.getUnderlyingResource());
                        }
                        catch (JavaModelException e) {
                            TRACER.error("Retrieve primarykey class file for ejb failed", (Throwable)e);
                            return ret;
                        }
                    }
                }
            } else if (J2eeElementManager.isWebServerSource((Element)element) || J2eeElementManager.isWebClientSource((Element)element) || J2eeElementManager.isJavaFile((Element)element)) {
                dtrList.add(J2eeElementManager.getWebSource((Element)element).getFile());
            } else if (J2eeElementManager.isImageResourceFile((Element)element)) {
                dtrList.add(J2eeElementManager.getResourceToElement((Element)element));
            } else if (J2eeElementManager.isEAR((Element)element)) {
                dtrList.add(J2eeElementManager.getEarProject((Element)element.getModel()).getDescriptorLocation());
            } else if (J2eeElementManager.isEjbJar((Element)element)) {
                dtrList.add(J2eeElementManager.getEjbModule((Element)element.getModel()).getDescriptorLocation());
            } else if (J2eeElementManager.isWAR((Element)element)) {
                dtrList.add(J2eeElementManager.getWebModule((Element)element.getModel()).getDescriptorLocation());
            } else if (J2eeProjectManager.getJ2eeProject((String)element.getUniqueName().getName()) != null) {
                IProject prj = J2eeProjectManager.getJ2eeProject((String)element.getUniqueName().getName()).getProject();
                IFolder folder = prj.getParent().getFolder(prj.getLocation());
                dtrList.add(folder);
            }
            if (!dtrList.isEmpty() && (dtrCheckedObjects = DtriUtil.getDtrCheckedObjects(dtrList)).hasDtrRelevantObjects()) {
                ret = new DtriRelevantObjects(dtrCheckedObjects.getDtrRelevantObjectList());
            }
        }
        return ret;
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
    }

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        boolean ret = false;
        if (propertyName.equals("ObjectPropertyName_DtrRelevantObjects")) {
            if (J2eeElementManager.isEnterpriseJavaBean((Element)element)) {
                ret = true;
            } else if (J2eeProjectManager.getJ2eeProject((String)element.getUniqueName().getName()) != null) {
                ret = true;
            } else if (J2eeElementManager.isWebServerSource((Element)element) || J2eeElementManager.isWebClientSource((Element)element) || J2eeElementManager.isJavaFile((Element)element)) {
                ret = true;
            } else if (J2eeElementManager.isImageResourceFile((Element)element)) {
                ret = true;
            } else if (J2eeElementManager.isEAR((Element)element)) {
                ret = true;
            } else if (J2eeElementManager.isEjbJar((Element)element)) {
                ret = true;
            } else if (J2eeElementManager.isWAR((Element)element)) {
                ret = true;
            } else if (FileAndFolderManagement.getInstance().contains(element.getUniqueName())) {
                ret = true;
            }
        }
        return ret;
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        Enumeration ret = null;
        if (propertyName.equals("FileAndFolderDataSource")) {
            Object obj = FileAndFolderManagement.getInstance().getDataSource(element.getUniqueName());
            Vector<Object> coll = new Vector<Object>();
            coll.add(obj);
            ret = Collections.enumeration(coll);
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

