/*
 * Decompiled with CFR 0.152.
 */
package com.sap.localization;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class ResourceAccessor
implements Serializable {
    private String resourceBundleName;
    private transient HashMap bundles = new HashMap(5);

    public ResourceAccessor(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
    }

    public String getMessageText(Locale locale, String patternKey) {
        if (this.bundles == null) {
            this.bundles = new HashMap(5);
        }
        String message = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (this.resourceBundleName != null && patternKey != null) {
            HashMap hashMap = this.bundles;
            synchronized (hashMap) {
                ResourceBundle rb = (ResourceBundle)this.bundles.get(locale);
                if (rb == null) {
                    rb = ResourceBundle.getBundle(this.resourceBundleName, locale, this.getClass().getClassLoader());
                    if (rb != null) {
                        message = rb.getString(patternKey);
                        this.bundles.put(locale, rb);
                    }
                } else {
                    message = rb.getString(patternKey);
                }
            }
        }
        return message;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }
}

