/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.likey;

import com.sap.security.core.server.likey.KeySystem;
import com.sap.security.core.server.likey.LicenseKey;
import com.sap.security.core.server.likey.LogAndTrace;
import com.sap.security.core.server.likey.Persistence;
import com.sap.security.core.server.likey.utils.utils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class LicenseChecker {
    static SimpleDateFormat dateformatter = new SimpleDateFormat("yyyyMMdd");
    private Persistence thisPers;
    private KeySystem thisSystem;
    private LogAndTrace thisLogAndTrace;
    private String hwId;
    private String systemId;
    private Vector licenses = new Vector();

    public static Vector getAllLicenses(Persistence pers, LogAndTrace lat) {
        Vector<LicenseKey> licenses = new Vector<LicenseKey>();
        Properties existingKeys = pers.getKeys();
        if (existingKeys == null) {
            lat.writeError("Could not read any data from the license key store.");
            return null;
        }
        try {
            String currentValue;
            String currentKey;
            Enumeration e = ((Hashtable)existingKeys).keys();
            while (e.hasMoreElements()) {
                currentKey = (String)e.nextElement();
                if (!utils.getFirstValue(currentKey, lat).equals("LK")) continue;
                currentValue = existingKeys.getProperty(currentKey);
                if (currentValue == null) {
                    lat.writeError("LicenseChecker.getAllLicenses internal error: No value found for key \"" + currentKey + "\"");
                    return null;
                }
                LicenseKey likey = new LicenseKey(currentKey, currentValue, lat);
                licenses.addElement(likey);
            }
            e = ((Hashtable)existingKeys).keys();
            block3: while (e.hasMoreElements()) {
                currentKey = (String)e.nextElement();
                if (!utils.getFirstValue(currentKey, lat).equals("LC")) continue;
                currentValue = existingKeys.getProperty(currentKey);
                if (currentValue == null) {
                    lat.writeError("LicenseChecker.getAllLicenses internal error: No value found for key \"" + currentKey + "\"");
                    return null;
                }
                String date = utils.getFirstValue(currentValue, lat);
                for (int i = 0; i < licenses.size(); ++i) {
                    LicenseKey currentLic = (LicenseKey)licenses.elementAt(i);
                    if (!currentLic.createKey("LC").equals(currentKey)) continue;
                    currentLic.setLastSuccessfulCheck(date);
                    continue block3;
                }
            }
            return licenses;
        }
        catch (RuntimeException ex) {
            lat.writeError("There are illegal data in the license key store.");
            return null;
        }
    }

    public LicenseChecker(Persistence sLp, KeySystem sLs, LogAndTrace sLl) {
        Vector allLicenses;
        this.thisSystem = sLs;
        this.thisPers = sLp;
        this.thisLogAndTrace = sLl;
        this.systemId = sLs.getSystemId();
        if (this.systemId == null) {
            this.thisLogAndTrace.writeError("Could not get the system ID. No meaningful check for a license key is possible.");
        }
        this.hwId = sLs.getHwId();
        if (this.hwId == null) {
            this.thisLogAndTrace.writeError("Could not get the hardware key. No meaningful check for a license key is possible.");
        }
        if ((allLicenses = LicenseChecker.getAllLicenses(sLp, sLl)) != null) {
            for (int i = 0; i < allLicenses.size(); ++i) {
                if (!((LicenseKey)allLicenses.elementAt(i)).preCheck(this.systemId, this.hwId)) continue;
                this.licenses.addElement(allLicenses.elementAt(i));
            }
        }
    }

    public boolean check() {
        for (int i = 0; i < this.licenses.size(); ++i) {
            LicenseKey lKey = (LicenseKey)this.licenses.elementAt(i);
            if (!lKey.check()) continue;
            return true;
        }
        return false;
    }

    public boolean check(String swProduct) {
        LicenseKey lKey;
        for (int i = 0; i < this.licenses.size(); ++i) {
            lKey = (LicenseKey)this.licenses.elementAt(i);
            if (!lKey.check(swProduct)) continue;
            if (lKey.isPermanent()) {
                String currDate = dateformatter.format(new Date());
                String lastCheckDate = lKey.setLastSuccessfulCheck(currDate);
                if (lastCheckDate == null) {
                    this.thisPers.insertKey(lKey.createKey("LC"), lKey.createValue("LC"));
                } else if (!lastCheckDate.equals(currDate)) {
                    this.thisPers.updateKey(lKey.createKey("LC"), lKey.createValue("LC"));
                }
            }
            return true;
        }
        if (this.systemId == null) {
            this.thisLogAndTrace.writeError("Could not get the system ID. License check returns false.");
            return false;
        }
        if (this.hwId == null) {
            this.thisLogAndTrace.writeError("Could not get the hardware key. License check returns false.");
            return false;
        }
        Vector<String> vKey = new Vector<String>();
        vKey.addElement("LK");
        vKey.addElement(this.systemId);
        vKey.addElement(this.hwId);
        vKey.addElement(swProduct);
        String key = utils.createLiKeyString(vKey, this.thisLogAndTrace);
        String value = this.thisPers.getKey(key);
        if (value == null) {
            return false;
        }
        try {
            lKey = new LicenseKey(key, value, this.thisLogAndTrace);
        }
        catch (RuntimeException ex) {
            return false;
        }
        if (lKey.preCheck(this.systemId, this.hwId)) {
            this.addOrSubstituteLicenseKey(lKey);
            if (lKey.check(swProduct)) {
                if (lKey.isPermanent()) {
                    String currDate = dateformatter.format(new Date());
                    lKey.setLastSuccessfulCheck(currDate);
                    String lcKey = lKey.createKey("LC");
                    if (this.thisPers.getKey(lcKey) == null) {
                        this.thisPers.insertKey(lcKey, lKey.createValue("LC"));
                    } else {
                        this.thisPers.updateKey(lcKey, lKey.createValue("LC"));
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean check(String swProduct, int counter) {
        LicenseKey lKey;
        for (int i = 0; i < this.licenses.size(); ++i) {
            lKey = (LicenseKey)this.licenses.elementAt(i);
            if (!lKey.check(swProduct, counter)) continue;
            if (lKey.isPermanent()) {
                String currDate = dateformatter.format(new Date());
                String lastCheckDate = lKey.setLastSuccessfulCheck(currDate);
                if (lastCheckDate == null) {
                    this.thisPers.insertKey(lKey.createKey("LC"), lKey.createValue("LC"));
                } else if (!lastCheckDate.equals(currDate)) {
                    this.thisPers.updateKey(lKey.createKey("LC"), lKey.createValue("LC"));
                }
            }
            return true;
        }
        if (this.systemId == null) {
            this.thisLogAndTrace.writeError("Could not get the system ID. License check returns false.");
            return false;
        }
        if (this.hwId == null) {
            this.thisLogAndTrace.writeError("Could not get the hardware key. License check returns false.");
            return false;
        }
        Vector<String> vKey = new Vector<String>();
        vKey.addElement("LK");
        vKey.addElement(this.systemId);
        vKey.addElement(this.hwId);
        vKey.addElement(swProduct);
        String key = utils.createLiKeyString(vKey, this.thisLogAndTrace);
        String value = this.thisPers.getKey(key);
        if (value == null) {
            return false;
        }
        try {
            lKey = new LicenseKey(key, value, this.thisLogAndTrace);
        }
        catch (RuntimeException ex) {
            return false;
        }
        if (lKey.preCheck(this.systemId, this.hwId)) {
            this.addOrSubstituteLicenseKey(lKey);
            if (lKey.check(swProduct, counter)) {
                if (lKey.isPermanent()) {
                    String currDate = dateformatter.format(new Date());
                    lKey.setLastSuccessfulCheck(currDate);
                    String lcKey = lKey.createKey("LC");
                    if (this.thisPers.getKey(lcKey) == null) {
                        this.thisPers.insertKey(lcKey, lKey.createValue("LC"));
                    } else {
                        this.thisPers.updateKey(lcKey, lKey.createValue("LC"));
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void addOrSubstituteLicenseKey(LicenseKey lkey) {
        String myswp = lkey.getSwProduct();
        for (int i = 0; i < this.licenses.size(); ++i) {
            if (!((LicenseKey)this.licenses.elementAt(i)).getSwProduct().equals(myswp)) continue;
            this.licenses.setElementAt(lkey, i);
            return;
        }
        this.licenses.addElement(lkey);
    }

    public Date getValidityDate(String swProduct) {
        LicenseKey likey;
        if (this.systemId == null) {
            this.thisLogAndTrace.writeError("Could not get the system ID. Therefore can't get the validity date.");
            return null;
        }
        if (this.hwId == null) {
            this.thisLogAndTrace.writeError("Could not get the hardware key. Therefore can't get the validity date.");
            return null;
        }
        Vector<String> vKey = new Vector<String>();
        vKey.addElement("LK");
        vKey.addElement(this.systemId);
        vKey.addElement(this.hwId);
        vKey.addElement(swProduct);
        String key = utils.createLiKeyString(vKey, this.thisLogAndTrace);
        String value = this.thisPers.getKey(key);
        if (value == null) {
            return null;
        }
        try {
            likey = new LicenseKey(key, value, this.thisLogAndTrace);
        }
        catch (RuntimeException ex) {
            return null;
        }
        return likey.getEndDateDate();
    }

    public Date getValidityDate(String swProduct, String hwId) {
        LicenseKey likey;
        if (this.systemId == null) {
            this.thisLogAndTrace.writeError("Could not get the system ID. Therefore can't get the validity date.");
            return null;
        }
        Vector<String> vKey = new Vector<String>();
        vKey.addElement("LK");
        vKey.addElement(this.systemId);
        vKey.addElement(hwId);
        vKey.addElement(swProduct);
        String key = utils.createLiKeyString(vKey, this.thisLogAndTrace);
        String value = this.thisPers.getKey(key);
        if (value == null) {
            return null;
        }
        try {
            likey = new LicenseKey(key, value, this.thisLogAndTrace);
        }
        catch (RuntimeException ex) {
            return null;
        }
        return likey.getEndDateDate();
    }
}

