/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.likey;

import com.sap.security.core.server.likey.KeySystem;
import com.sap.security.core.server.likey.LicenseChecker;
import com.sap.security.core.server.likey.LicenseKey;
import com.sap.security.core.server.likey.LogAndTrace;
import com.sap.security.core.server.likey.Persistence;
import com.sap.security.core.server.likey.StdLogAndTrace;
import com.sap.security.core.server.likey.utils.utils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class Admin {
    private static final String dummyInstNo = "0000000000";
    private static final String dummySystemNo = "000000000000000000";
    private Persistence pers;
    private KeySystem system;
    private LogAndTrace lat;
    private String hwKey;
    private String systemId;

    private static void printMessages(Vector messages) {
        for (int index = 0; index < messages.size(); ++index) {
            StdLogAndTrace.formatAndPrint(System.out, (String)messages.elementAt(index));
        }
    }

    private static Persistence getPersistence() {
        String persistenceImpl = System.getProperty("persistence.impl");
        if (persistenceImpl == null) {
            StdLogAndTrace.formatAndPrint(System.out, "No valid implementation of interface Persistence given.");
            StdLogAndTrace.formatAndPrint(System.out, "The name of the implementation must be supplied as system property \"persistence.impl\".");
            return null;
        }
        Persistence pers = null;
        try {
            pers = (Persistence)Class.forName(persistenceImpl).newInstance();
            pers.init();
            return pers;
        }
        catch (Exception ex) {
            StdLogAndTrace.formatAndPrint(System.out, "Cannot load class \"" + persistenceImpl + "\" (implementation of interface Persistence.");
            return null;
        }
    }

    private static KeySystem getKeySystem() {
        String systemImpl = System.getProperty("system.impl");
        if (systemImpl == null) {
            StdLogAndTrace.formatAndPrint(System.out, "No valid implementation of interface KeySystem given.");
            StdLogAndTrace.formatAndPrint(System.out, "The name of the implementation must be supplied as system property \"system.impl\".");
            return null;
        }
        KeySystem sys = null;
        try {
            sys = (KeySystem)Class.forName(systemImpl).newInstance();
            sys.init();
            return sys;
        }
        catch (Exception ex) {
            StdLogAndTrace.formatAndPrint(System.out, "Cannot load class \"" + systemImpl + "\" (implementation of interface KeySystem).");
            return null;
        }
    }

    private static void printHelp(KeySystem sys) {
        StdLogAndTrace.formatAndPrint(System.out, "SAP license key administration toolkit for Java environment");
        StdLogAndTrace.formatAndPrint(System.out, "Usage: " + sys.getCmdPrefix() + " <Option(s)>");
        StdLogAndTrace.formatAndPrint(System.out, "Options:");
        StdLogAndTrace.formatAndPrint(System.out, "-help  . . . . . . . . . . . . . . . . . . . Display this help");
        StdLogAndTrace.formatAndPrint(System.out, "-version . . . . . . . . . . . . . . . . . . Display the tool version");
        StdLogAndTrace.formatAndPrint(System.out, "-get . . . . . . . . . . . . . . . . . . . . Display infos about the system");
        StdLogAndTrace.formatAndPrint(System.out, "-number  . . . . . . . . . . . . . . . . . . Same as -get");
        StdLogAndTrace.formatAndPrint(System.out, "-install <filename>  . . . . . . . . . . . . Install license keys from a file");
        StdLogAndTrace.formatAndPrint(System.out, "-show  . . . . . . . . . . . . . . . . . . . Display license keys");
        StdLogAndTrace.formatAndPrint(System.out, "-temp <Product>  . . . . . . . . . . . . . . Create a temporary license key");
        StdLogAndTrace.formatAndPrint(System.out, "-delete <System Id> <Hardware Key> <Product> Delete license key(s)");
        System.out.println();
        StdLogAndTrace.formatAndPrint(System.out, "For each of the parameters after \"-delete\" you can use \"*\" as a wildcard. Remember to use quotes to mask the \"*\"!");
    }

    public static String getVersion() {
        return LicenseKey.getVersion();
    }

    public static void main(String[] args) {
        if (args.length == 0 || args[0].startsWith("-h")) {
            KeySystem sys = Admin.getKeySystem();
            if (sys != null) {
                Admin.printHelp(sys);
            }
        } else if (args[0].startsWith("-v")) {
            StdLogAndTrace.formatAndPrint(System.out, "SAP License Key version " + Admin.getVersion());
        } else if (args[0].equals("-get") || args[0].equals("-number")) {
            KeySystem sys;
            Persistence pers = Admin.getPersistence();
            if (pers != null && (sys = Admin.getKeySystem()) != null) {
                StdLogAndTrace lat = new StdLogAndTrace();
                Admin admin = new Admin(pers, sys, lat);
                admin.printSystemData();
            }
        } else if (args[0].startsWith("-s")) {
            KeySystem sys;
            Persistence pers = Admin.getPersistence();
            if (pers != null && (sys = Admin.getKeySystem()) != null) {
                StdLogAndTrace lat = new StdLogAndTrace();
                Admin admin = new Admin(pers, sys, lat);
                admin.printLiKeys();
            }
        } else if (args[0].equals("-delete")) {
            KeySystem sys;
            if (args.length != 4) {
                KeySystem sys2 = Admin.getKeySystem();
                if (sys2 != null) {
                    StdLogAndTrace.formatAndPrint(System.out, "Usage: " + sys2.getCmdPrefix() + " -delete <System Id> <Hardware Key> <Product>");
                } else {
                    StdLogAndTrace.formatAndPrint(System.out, "Usage: ... -delete <System Id> <Hardware Key> <Product>");
                }
                return;
            }
            Persistence pers = Admin.getPersistence();
            if (pers != null && (sys = Admin.getKeySystem()) != null) {
                StdLogAndTrace lat = new StdLogAndTrace();
                Admin admin = new Admin(pers, sys, lat);
                Vector messages = new Vector();
                admin.deleteLicenses(args[1], args[2], args[3], messages);
                Admin.printMessages(messages);
            }
        } else if (args[0].equals("-temp")) {
            KeySystem sys;
            if (args.length != 2) {
                KeySystem sys3 = Admin.getKeySystem();
                if (sys3 != null) {
                    StdLogAndTrace.formatAndPrint(System.out, "Usage: ... -temp <Product>");
                } else {
                    StdLogAndTrace.formatAndPrint(System.out, "Usage:  -temp <Product>");
                }
                StdLogAndTrace.formatAndPrint(System.out, "Name of the software product missing.");
                return;
            }
            Persistence pers = Admin.getPersistence();
            if (pers != null && (sys = Admin.getKeySystem()) != null) {
                StdLogAndTrace lat = new StdLogAndTrace();
                Admin admin = new Admin(pers, sys, lat);
                Vector messages = new Vector();
                boolean success = admin.installSubsequentTempLicense(args[1], messages);
                Admin.printMessages(messages);
            }
        } else if (args[0].equals("-install")) {
            KeySystem sys;
            if (args.length != 2) {
                KeySystem sys4 = Admin.getKeySystem();
                if (sys4 != null) {
                    StdLogAndTrace.formatAndPrint(System.out, "Usage: " + sys4.getCmdPrefix() + " -install <filename>");
                } else {
                    StdLogAndTrace.formatAndPrint(System.out, "Usage: ... -install <filename>");
                }
                StdLogAndTrace.formatAndPrint(System.out, "Name of SAP license file missing");
                return;
            }
            Persistence pers = Admin.getPersistence();
            if (pers != null && (sys = Admin.getKeySystem()) != null) {
                StdLogAndTrace lat = new StdLogAndTrace();
                Admin admin = new Admin(pers, sys, lat);
                try {
                    Vector messages = new Vector();
                    admin.installFromFile(args[1], messages);
                    Admin.printMessages(messages);
                }
                catch (Exception ex) {
                    StdLogAndTrace.formatAndPrint(System.out, "License key(s) not completely installed.");
                    StdLogAndTrace.formatAndPrint(System.out, "Error occured: " + ex);
                    ex.printStackTrace();
                }
            }
        } else if (args[0].equals("-dump")) {
            KeySystem sys;
            Persistence pers = Admin.getPersistence();
            if (pers != null && (sys = Admin.getKeySystem()) != null) {
                StdLogAndTrace lat = new StdLogAndTrace();
                Admin admin = new Admin(pers, sys, lat);
                admin.dumpPersistence();
            }
        } else {
            StdLogAndTrace.formatAndPrint(System.out, "Invalid option \"" + args[0] + "\" specified!");
        }
    }

    public Admin(Persistence parPers, KeySystem parSystem, LogAndTrace parLAT) {
        this.pers = parPers;
        this.system = parSystem;
        this.lat = parLAT;
        this.hwKey = this.system.getHwId();
        if (this.hwKey == null) {
            this.lat.writeError("Could not get the hardware key.");
        }
        this.systemId = this.system.getSystemId();
        if (this.systemId == null) {
            this.lat.writeError("Could not get the System ID (SID).");
        }
    }

    public String getInstNo(String hwKey, Vector messages) {
        if (hwKey == null) {
            messages.add("Could not get the installation number because could not get the hardware key!");
            return null;
        }
        if (this.systemId == null) {
            messages.add("Could not get the installation number because could not get the system ID!");
            return null;
        }
        String instno = "";
        Vector licenses = LicenseChecker.getAllLicenses(this.pers, this.lat);
        if (licenses == null) {
            messages.add("Could not get the installation number because could not read the store for license keys!");
            return null;
        }
        for (int i = 0; i < licenses.size(); ++i) {
            LicenseKey lKey = (LicenseKey)licenses.elementAt(i);
            String lkeyInstNo = lKey.getInstNo();
            if (lkeyInstNo.equals(dummyInstNo) || !lKey.getHwKey().equals(hwKey) || !lKey.getSystemId().equals(this.systemId)) continue;
            if ("".equals(instno)) {
                instno = lKey.getInstNo();
                continue;
            }
            if (instno.equals(lkeyInstNo)) continue;
            messages.add("Your system contains license keys with different installation numbers.");
            return null;
        }
        return instno;
    }

    public String getInstNo(Vector messages) {
        return this.getInstNo(this.hwKey, messages);
    }

    public String getSysNo(String hwKey, Vector messages) {
        if (hwKey == null) {
            messages.add("Could not get the system number because could not get the hardware key!");
            return null;
        }
        if (this.systemId == null) {
            messages.add("Could not get the system number because could not get the system ID!");
            return null;
        }
        String sysno = "";
        Vector licenses = LicenseChecker.getAllLicenses(this.pers, this.lat);
        if (licenses == null) {
            messages.add("Could not get the system number because could not read the store for license keys!");
            return null;
        }
        for (int i = 0; i < licenses.size(); ++i) {
            LicenseKey lKey = (LicenseKey)licenses.elementAt(i);
            String lkeySysNo = lKey.getSysNo();
            if (lkeySysNo.equals(dummySystemNo) || !lKey.getHwKey().equals(hwKey) || !lKey.getSystemId().equals(this.systemId)) continue;
            if ("".equals(sysno)) {
                sysno = lKey.getSysNo();
                continue;
            }
            if (sysno.equals(lKey.getSysNo())) continue;
            messages.add("Your system contains license keys with different system numbers");
            return null;
        }
        return sysno;
    }

    public String getSysNo(Vector messages) {
        return this.getSysNo(this.hwKey, messages);
    }

    private void printSystemData() {
        Vector messages = new Vector();
        String instNo = this.getInstNo(messages);
        if (instNo == null) {
            instNo = "*** Error ***";
        } else if (instNo.equals("")) {
            instNo = "*** not yet assigned ***";
        }
        String sysNo = this.getSysNo(messages);
        if (sysNo == null) {
            sysNo = "*** Error ***";
        } else if (sysNo.equals("")) {
            sysNo = "*** not yet assigned ***";
        }
        for (int index = 0; index < messages.size(); ++index) {
            this.lat.writeError((String)messages.elementAt(index));
        }
        Vector products = this.system.getSwProducts();
        if (this.systemId == null) {
            StdLogAndTrace.formatAndPrint(System.out, "System ID. . . . : *** unknown ***");
        } else {
            StdLogAndTrace.formatAndPrint(System.out, "System ID. . . . : " + this.systemId);
        }
        if (this.hwKey == null) {
            StdLogAndTrace.formatAndPrint(System.out, "Hardware Key . . : *** unknown ***");
        } else {
            StdLogAndTrace.formatAndPrint(System.out, "Hardware Key . . : " + this.hwKey);
        }
        StdLogAndTrace.formatAndPrint(System.out, "Installation No. : " + instNo);
        StdLogAndTrace.formatAndPrint(System.out, "System No. . . . : " + sysNo);
        StdLogAndTrace.formatAndPrint(System.out, "Release. . . . . : " + this.system.getBasisRelease());
        for (int index = 0; index < products.size(); ++index) {
            if (index == 0) {
                StdLogAndTrace.formatAndPrint(System.out, "Software products: " + (String)products.elementAt(index));
                continue;
            }
            StdLogAndTrace.formatAndPrint(System.out, "                   " + (String)products.elementAt(index));
        }
    }

    private void printLiKeys() {
        Vector v = LicenseChecker.getAllLicenses(this.pers, this.lat);
        if (v == null) {
            this.lat.writeError("Can't show the license keys because couldn't read the store for license keys!");
            return;
        }
        if (v.size() == 0) {
            StdLogAndTrace.formatAndPrint(System.out, "No license keys found.");
            return;
        }
        StdLogAndTrace.formatAndPrint(System.out, "The following license keys were found:");
        for (int i = 0; i < v.size(); ++i) {
            if (i > 0) {
                System.out.println();
            }
            LicenseKey liKey = (LicenseKey)v.elementAt(i);
            StdLogAndTrace.formatAndPrint(System.out, "System. . . . . : " + liKey.getSystemId());
            StdLogAndTrace.formatAndPrint(System.out, "Hardware Key. . : " + liKey.getHwKey());
            StdLogAndTrace.formatAndPrint(System.out, "SW product. . . : " + liKey.getSwProduct());
            StdLogAndTrace.formatAndPrint(System.out, "SW product Limit: " + liKey.getSwProductLimit());
            if (liKey.getBeginDate() == null) {
                StdLogAndTrace.formatAndPrint(System.out, "Begin date. . . : (no begin date)");
            } else {
                StdLogAndTrace.formatAndPrint(System.out, "Begin date. . . : " + liKey.getBeginDate());
            }
            StdLogAndTrace.formatAndPrint(System.out, "Expiration date : " + liKey.getEndDate());
            StdLogAndTrace.formatAndPrint(System.out, "License key type: " + liKey.getType());
            StdLogAndTrace.formatAndPrint(System.out, "Installation No.: " + liKey.getInstNo());
            StdLogAndTrace.formatAndPrint(System.out, "System No.. . . : " + liKey.getSysNo());
            boolean checkResult = liKey.preCheck(this.systemId, this.hwKey);
            if (checkResult) {
                checkResult = liKey.check();
            }
            if (checkResult) {
                StdLogAndTrace.formatAndPrint(System.out, "Validity. . . . : valid");
                continue;
            }
            StdLogAndTrace.formatAndPrint(System.out, "Validity. . . . : invalid (" + liKey.getCheckReason() + ")");
        }
    }

    public boolean installFirstTempLicense(String swProduct, Vector messages) {
        if (this.systemId == null) {
            messages.add("Can't install a temporary license key because the system ID is unknown.");
            return false;
        }
        if (this.hwKey == null) {
            messages.add("Can't install a temporary license key because the hardware key is unknown.");
            return false;
        }
        Vector<String> lcKeyFields = new Vector<String>();
        lcKeyFields.addElement("LC");
        lcKeyFields.addElement(this.systemId);
        lcKeyFields.addElement(this.hwKey);
        lcKeyFields.addElement(swProduct);
        String lcKey = utils.createLiKeyString(lcKeyFields, this.lat);
        String lcValue = this.pers.getKey(lcKey);
        Vector<String> lkKeyFields = new Vector<String>();
        lkKeyFields.addElement("LK");
        lkKeyFields.addElement(this.systemId);
        lkKeyFields.addElement(this.hwKey);
        lkKeyFields.addElement(swProduct);
        String lkKey = utils.createLiKeyString(lkKeyFields, this.lat);
        String lkValue = this.pers.getKey(lkKey);
        if (lkValue != null) {
            messages.add("A license key for \"" + swProduct + "\" already exists. You can't install " + "another temporary license key for \"" + swProduct + "\".");
            return false;
        }
        if (lcValue != null) {
            messages.add("A permanent license key for \"" + swProduct + "\" already existed in the system. You " + "can't install another temporary license " + "key for \"" + swProduct + "\".");
            return false;
        }
        LicenseKey tempKey = this.generateTemporaryLicenseKey(swProduct, messages);
        return this.pers.insertKey(tempKey.createKey("LK"), tempKey.createValue("LK"));
    }

    public boolean installSubsequentTempLicense(String swProduct, Vector messages) {
        messages.add("Sorry, in the Sneak Preview Edition you can't install another license key.");
        return false;
    }

    private boolean isTempLicensePossible(String product, String lsc, String fingerPrint, Vector messages) {
        String toBeSigned = this.systemId + this.hwKey + product + lsc;
        String calculatedFingerPrint = LicenseKey.calculateFingerPrint(toBeSigned, this.lat);
        if (!calculatedFingerPrint.equals(fingerPrint)) {
            messages.add("It seems that the license key store was manipulated. Installation of a temporary license key aborted.");
            return false;
        }
        Date lastsuccheck = null;
        try {
            lastsuccheck = LicenseChecker.dateformatter.parse(lsc);
        }
        catch (ParseException ex) {
            messages.add("Incorrect value stored as last successful check. Installation of a temporary license key aborted.");
            return false;
        }
        Calendar cal = Calendar.getInstance();
        cal.add(5, -29);
        if (lastsuccheck.after(cal.getTime())) {
            return true;
        }
        messages.add("The temporary license key can't be created because there already was a permanent license key for \"" + product + "\" in the system and the last successful " + "check on this license key is more than " + "four weeks ago.");
        return false;
    }

    private LicenseKey generateTemporaryLicenseKey(String swProduct, Vector messages) {
        String systemNo;
        Calendar cal = Calendar.getInstance();
        String beginDate = LicenseChecker.dateformatter.format(cal.getTime());
        cal.add(5, 180);
        String endDate = LicenseChecker.dateformatter.format(cal.getTime());
        String instno = this.getInstNo(messages);
        if (instno == null || "".equals(instno)) {
            instno = dummyInstNo;
        }
        if ((systemNo = this.getSysNo(messages)) == null || "".equals(systemNo)) {
            systemNo = dummySystemNo;
        }
        String tbsText = this.systemId + this.hwKey + utils.fillup(swProduct, 20) + Integer.MAX_VALUE + beginDate + endDate + instno;
        String signature = LicenseKey.calculateFingerPrint(tbsText, this.lat);
        LicenseKey lKey = new LicenseKey(this.systemId, this.hwKey, swProduct, new Integer(Integer.MAX_VALUE).toString(), beginDate, endDate, "T", signature, instno, systemNo, this.lat);
        return lKey;
    }

    public boolean installFromFile(InputStream inStream, String filename, Vector messages) throws IOException {
        messages.add("Sorry, in the Sneak Preview Edition you can't install another license key.");
        return false;
    }

    public boolean installFromFile(String filename, Vector messages) throws FileNotFoundException, IOException {
        messages.add("Sorry, in the Sneak Preview Edition you can't install another license key.");
        return false;
    }

    private boolean checkAndInsertKey(LicenseKey likey, String sysInstNo, String sysSystemNo, String filename, Vector messages) {
        boolean ret;
        if (!likey.getSystemId().equals(this.systemId)) {
            messages.add("This is system \"" + this.systemId + "\", but there is a license key for system " + "\"" + likey.getSystemId() + "\" in file " + filename + ".");
            return false;
        }
        if (sysInstNo != null && !sysInstNo.equals("") && !likey.getInstNo().equals(sysInstNo)) {
            messages.add("This system's installation number is \"" + sysInstNo + "\", but there is a license key for " + "installation number \"" + likey.getInstNo() + "\" in file " + filename + ".");
            return false;
        }
        if (sysSystemNo != null && !sysSystemNo.equals("") && !likey.getSysNo().equals(sysSystemNo)) {
            messages.add("This system's system number is \"" + sysSystemNo + "\", but there is a license key for " + "system number \"" + likey.getSysNo() + "\" in file " + filename + ".");
            return false;
        }
        if (!likey.checkSignature()) {
            messages.add("The digital signature of the license key for product \"" + likey.getSwProduct() + "\" could not be verified.");
            return false;
        }
        String lkKey = likey.createKey("LK");
        String lkValue = this.pers.getKey(lkKey);
        if (lkValue == null) {
            ret = this.pers.insertKey(lkKey, likey.createValue("LK"));
            if (!ret) {
                messages.add("Error when trying to store (insert) the license key for product \"" + likey.getSwProduct() + "\".");
            }
        } else {
            ret = this.pers.updateKey(lkKey, likey.createValue("LK"));
            if (!ret) {
                messages.add("Error when trying to store (update) the license key for product \"" + likey.getSwProduct() + "\".");
            }
        }
        return ret;
    }

    public boolean deleteLicenses(String sysId, String hwKey, String product, Vector messages) {
        this.lat.writeTrace("deleteLicenses (sysId = \"" + sysId + "\", hwKey = \"" + hwKey + "\", product = \"" + product + "\", .)");
        int problemCount = 0;
        int successCount = 0;
        Properties existingKeys = this.pers.getKeys();
        if (existingKeys == null) {
            this.lat.writeError("Could not read any data from the license key store, therefore no license keys were deleted.");
            return false;
        }
        Enumeration e = ((Hashtable)existingKeys).keys();
        while (e.hasMoreElements()) {
            Vector keyFields;
            String currentKey = (String)e.nextElement();
            try {
                keyFields = utils.parseLiKeyString(currentKey, this.lat);
            }
            catch (RuntimeException ex) {
                messages.add("Deletion of license keys aborted because of inconsistent license data.");
                return false;
            }
            if (keyFields.size() < 4) {
                this.lat.writeError("Internal error: String \"" + currentKey + "\" should consist of at least 4 " + "fields, but it doesn't.");
                messages.add("Deletion of license keys aborted because of inconsistent license data.");
                return false;
            }
            String recordType = (String)keyFields.elementAt(0);
            String recordSysId = (String)keyFields.elementAt(1);
            String recordHwKey = (String)keyFields.elementAt(2);
            String recordProduct = (String)keyFields.elementAt(3);
            this.lat.writeTrace("recordType    = \"" + recordType + "\"");
            this.lat.writeTrace("recordSysId   = \"" + recordSysId + "\"");
            this.lat.writeTrace("recordHwKey   = \"" + recordHwKey + "\"");
            this.lat.writeTrace("recordProduct = \"" + recordProduct + "\"");
            if (!recordType.equals("LK")) {
                this.lat.writeTrace("Not deleted because type is not LK.");
                continue;
            }
            if (!sysId.equals("*") && !sysId.equals(recordSysId)) {
                this.lat.writeTrace("Not deleted because system ID doesn't match.");
                continue;
            }
            if (!hwKey.equals("*") && !hwKey.equals(recordHwKey)) {
                this.lat.writeTrace("Not deleted because hardware key doesn't match.");
                continue;
            }
            if (!product.equals("*") && !product.equals(recordProduct)) {
                this.lat.writeTrace("Not deleted because product doesn't match.");
                continue;
            }
            this.lat.writeTrace("Passed all checks, to be deleted.");
            boolean success = this.pers.deleteKey(currentKey);
            this.lat.writeTrace("success = " + success);
            String message = "The license key for system \"" + recordSysId + "\", hardware key \"" + recordHwKey + "\", product \"" + recordProduct + "\" ";
            if (success) {
                message = message + "was deleted.";
                ++successCount;
            } else {
                message = message + "could not be deleted.";
                ++problemCount;
            }
            messages.add(message);
        }
        if (problemCount > 0) {
            messages.add(problemCount + " license key(s) could not be deleted.");
        }
        if (successCount > 0) {
            messages.add(successCount + " license key(s) were deleted.");
        }
        if (problemCount == 0 && successCount == 0) {
            messages.add("No matching license keys found.");
        }
        return problemCount == 0;
    }

    public void dumpPersistence() {
        int recordCount = 0;
        Properties existingKeys = this.pers.getKeys();
        if (existingKeys == null) {
            this.lat.writeError("Could not read any data from the license key store, therefore no records were dumped.");
            return;
        }
        Enumeration e = ((Hashtable)existingKeys).keys();
        while (e.hasMoreElements()) {
            StdLogAndTrace.formatAndPrint(System.out, "------- " + ++recordCount + ". record -------");
            String currentKey = (String)e.nextElement();
            try {
                Vector keyFields = utils.parseLiKeyString(currentKey, this.lat);
                for (int fieldIndex = 0; fieldIndex < keyFields.size(); ++fieldIndex) {
                    StdLogAndTrace.formatAndPrint(System.out, fieldIndex + 1 + ". key field: \"" + (String)keyFields.elementAt(fieldIndex) + "\"");
                }
            }
            catch (RuntimeException ex) {
                StdLogAndTrace.formatAndPrint(System.out, "Key: \"" + currentKey + "\" (illegal format)");
            }
            String currentValue = existingKeys.getProperty(currentKey);
            if (currentValue == null) {
                this.lat.writeError("Internal error: No value found for key \"" + currentKey + "\"");
                return;
            }
            try {
                Vector valueFields = utils.parseLiKeyString(currentValue, this.lat);
                for (int fieldIndex = 0; fieldIndex < valueFields.size(); ++fieldIndex) {
                    StdLogAndTrace.formatAndPrint(System.out, fieldIndex + 1 + ". value field: \"" + (String)valueFields.elementAt(fieldIndex) + "\"");
                }
            }
            catch (RuntimeException ex) {
                StdLogAndTrace.formatAndPrint(System.out, "Value: \"" + currentValue + "\" (illegal format)");
            }
            System.out.println();
        }
    }

    public String[] getSWProductsWithLikey() {
        if (this.systemId == null) {
            this.lat.writeError("Can't return list of software products because couldn't get the system ID.");
            return null;
        }
        if (this.hwKey == null) {
            this.lat.writeError("Can't return list of software products because couldn't get the hardware key.");
            return null;
        }
        Vector<String> outputVector = new Vector<String>();
        Vector allLicenses = LicenseChecker.getAllLicenses(this.pers, this.lat);
        if (allLicenses == null) {
            return null;
        }
        for (int index = 0; index < allLicenses.size(); ++index) {
            LicenseKey lkey = (LicenseKey)allLicenses.elementAt(index);
            if (!lkey.preCheckWithoutExpiration(this.systemId, this.hwKey)) continue;
            outputVector.add(lkey.getSwProduct());
        }
        String[] outputArray = new String[outputVector.size()];
        for (int index = 0; index < outputVector.size(); ++index) {
            outputArray[index] = (String)outputVector.elementAt(index);
        }
        return outputArray;
    }

    public int getRemainingDays(String product) {
        long factor;
        long diff;
        Vector<String> vKey = new Vector<String>();
        vKey.add("LK");
        vKey.add(this.systemId);
        vKey.add(this.hwKey);
        vKey.add(product);
        String key = utils.createLiKeyString(vKey, this.lat);
        String value = this.pers.getKey(key);
        if (value == null) {
            return Integer.MIN_VALUE;
        }
        LicenseKey likey = new LicenseKey(key, value, this.lat);
        if (!likey.preCheckWithoutExpiration(this.systemId, this.hwKey)) {
            return Integer.MIN_VALUE;
        }
        GregorianCalendar today = new GregorianCalendar();
        today.set(11, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        long todayLong = today.getTime().getTime();
        this.lat.writeTrace("todayLong = " + todayLong);
        Date expiration = likey.getEndDateDate();
        long expireLong = expiration.getTime();
        this.lat.writeTrace("expireLong = " + expireLong);
        long oneHourInMilliseconds = 3600000L;
        long threeHoursInMilliseconds = 10800000L;
        long oneDayInMilliseconds = 86400000L;
        if (expireLong > todayLong) {
            diff = expireLong - todayLong;
            factor = 1L;
        } else {
            diff = todayLong - expireLong;
            factor = -1L;
        }
        this.lat.writeTrace("factor = " + factor);
        this.lat.writeTrace("diff before adding 3 hrs = " + diff);
        this.lat.writeTrace("Remainder before adding 3 hrs = " + diff % 86400000L);
        this.lat.writeTrace("diff after adding 3 hrs = " + (diff += 10800000L));
        this.lat.writeTrace("Remainder after adding 3 hrs = " + diff % 86400000L);
        int diffDays = (int)(diff / 86400000L * factor);
        this.lat.writeTrace("diffDays = " + diffDays);
        return diffDays;
    }
}

