/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.common.implementation;

import com.sap.ide.metamodel.common.CommonMDOEnum;
import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.common.implementation.EmbeddedTemplateInstanceState;
import com.sap.ide.metamodel.common.implementation.MainTemplateInstanceState;
import com.sap.ide.metamodel.common.implementation.TemplateInstanceState;
import com.sap.ide.metamodel.common.implementation.TemplateMarkerState;
import com.sap.ide.metamodel.common.implementation.TemplateSettingState;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.ForeignReference;
import com.sap.ide.metamodel.core.MainDevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.marshalling.XMLMarshaller;
import com.sap.ide.metamodel.general.MDOEnum;
import com.sap.ide.metamodel.general.exception.SaveException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class CommonXMLMarshaller
extends XMLMarshaller {
    protected String mMDOPackage;
    protected String mMDOName;
    protected MDOEnum mMDOType;
    static /* synthetic */ Class class$com$sap$ide$metamodel$common$implementation$MainTemplateInstanceState;

    public void marshal(DevelopmentObjectState state, String path) throws SaveException {
        try {
            this.getMDOProperties(state);
            this.resetIndent();
            String lFolder = new File(path).getParent();
            if (!new File(lFolder).exists()) {
                new File(lFolder).mkdirs();
            }
            BufferedWriter lWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8"));
            lWriter.write(this.buildXMLString(state));
            lWriter.close();
        }
        catch (Exception ex) {
            throw new SaveException(ex);
        }
    }

    public void marshal(DevelopmentObjectState state, OutputStreamWriter writer) throws SaveException {
        try {
            this.getMDOProperties(state);
            this.resetIndent();
            writer.write(this.buildXMLString(state));
        }
        catch (Exception ex) {
            throw new SaveException(ex);
        }
    }

    private void getMDOProperties(DevelopmentObjectState state) {
        if (state.getClass() == (class$com$sap$ide$metamodel$common$implementation$MainTemplateInstanceState == null ? (class$com$sap$ide$metamodel$common$implementation$MainTemplateInstanceState = CommonXMLMarshaller.class$("com.sap.ide.metamodel.common.implementation.MainTemplateInstanceState")) : class$com$sap$ide$metamodel$common$implementation$MainTemplateInstanceState)) {
            this.mMDOType = CommonMDOEnum.MAINTEMPLATEINSTANCE;
        }
        this.mMDOPackage = ((MainDevelopmentObjectState)state).getPackage();
        this.mMDOName = state.getName();
    }

    private String buildXMLString(DevelopmentObjectState state) {
        StringBuffer lBuf = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        if (state.getClass() == (class$com$sap$ide$metamodel$common$implementation$MainTemplateInstanceState == null ? (class$com$sap$ide$metamodel$common$implementation$MainTemplateInstanceState = CommonXMLMarshaller.class$("com.sap.ide.metamodel.common.implementation.MainTemplateInstanceState")) : class$com$sap$ide$metamodel$common$implementation$MainTemplateInstanceState)) {
            this.serializeMainTemplateInstance((MainTemplateInstanceState)state, lBuf, true);
        }
        return lBuf.toString();
    }

    protected void serializeCommonDevelopmentObject(CommonDevelopmentObjectState state, StringBuffer buf, boolean withEnclosingElements) {
        if (state.getTemplateInstanceCount() > 0) {
            Vector lVector = state.getTemplateInstances();
            buf.append(this.indent() + "<CommonDevelopmentObject.TemplateInstances>\n");
            this.pushIndent();
            int i = 0;
            while (i < state.getTemplateInstanceCount()) {
                this.serializeEmbeddedTemplateInstance((EmbeddedTemplateInstanceState)((Object)lVector.get(i)), buf, true);
                ++i;
            }
            buf.append(this.popIndent() + "</CommonDevelopmentObject.TemplateInstances>\n");
        }
    }

    protected void serializeCommonAttributes(CommonDevelopmentObjectState state, StringBuffer buf) {
    }

    private void serializeEmbeddedTemplateInstance(EmbeddedTemplateInstanceState state, StringBuffer buf, boolean withEnclosingElements) {
        if (withEnclosingElements) {
            buf.append(this.indent() + "<EmbeddedTemplateInstance");
            buf.append(" name=\"" + this.escapeXML(state.getName()) + "\"");
            buf.append(">\n");
            this.pushIndent();
        }
        this.serializeTemplateInstance(state, buf, false);
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</EmbeddedTemplateInstance>\n");
        }
    }

    private void serializeMainTemplateInstance(MainTemplateInstanceState state, StringBuffer buf, boolean withEnclosingElements) {
        if (withEnclosingElements) {
            buf.append("<!-- MetaDataAPI generated on: Tuesday, May 4, 2004 10:35:27 AM CEST -->\n");
            buf.append(this.indent() + "<MainTemplateInstance");
            buf.append(" xmlns=\"http://xml.sap.com/2002/10/metamodel/common\"");
            buf.append(" xmlns:IDX=\"urn:sap.com:Common.MainTemplateInstance:2.0\"");
            buf.append(" mmRelease=\"6.30\"");
            buf.append(" mmVersion=\"2.0\"");
            buf.append(" mmTimestamp=\"1083659727221\"");
            buf.append(" name=\"" + state.getName() + "\"");
            buf.append(" package=\"" + state.getPackage() + "\"");
            buf.append(" masterLanguage=\"" + state.getMasterLanguage() + "\"");
            buf.append(">\n");
            this.pushIndent();
        }
        this.serializeMetamodelAnnotations(state, buf);
        this.serializeTemplateInstance(state, buf, false);
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</MainTemplateInstance>\n");
        }
    }

    private void serializeTemplateInstance(TemplateInstanceState state, StringBuffer buf, boolean withEnclosingElements) {
        int i;
        Vector lVector;
        if (state.getTemplateMarkerCount() > 0) {
            lVector = state.getTemplateMarkers();
            buf.append(this.indent() + "<TemplateInstance.TemplateMarkers>\n");
            this.pushIndent();
            i = 0;
            while (i < state.getTemplateMarkerCount()) {
                this.serializeTemplateMarker((TemplateMarkerState)((Object)lVector.get(i)), buf, true);
                ++i;
            }
            buf.append(this.popIndent() + "</TemplateInstance.TemplateMarkers>\n");
        }
        if (state.getTemplateSettingCount() > 0) {
            lVector = state.getTemplateSettings();
            buf.append(this.indent() + "<TemplateInstance.TemplateSettings>\n");
            this.pushIndent();
            i = 0;
            while (i < state.getTemplateSettingCount()) {
                this.serializeTemplateSetting((TemplateSettingState)((Object)lVector.get(i)), buf, true);
                ++i;
            }
            buf.append(this.popIndent() + "</TemplateInstance.TemplateSettings>\n");
        }
    }

    private void serializeTemplateMarker(TemplateMarkerState state, StringBuffer buf, boolean withEnclosingElements) {
        if (withEnclosingElements) {
            buf.append(this.indent() + "<TemplateMarker");
            buf.append(" name=\"" + this.escapeXML(state.getName()) + "\"");
            if (state.hasRole()) {
                buf.append(" role=\"" + this.escapeXML(state.getRole()) + "\"");
            }
            buf.append(">\n");
            this.pushIndent();
        }
        if (state.getParticipant() != null) {
            Reference lReference = state.getParticipant();
            buf.append(this.indent() + "<TemplateMarker.Participant>\n");
            if (lReference instanceof ForeignReference) {
                buf.append(this.pushIndent() + "<Core.ForeignReference modelName=\"" + ((ForeignReference)lReference).getModelName() + "\"");
            } else {
                buf.append(this.pushIndent() + "<Core.Reference");
            }
            if (lReference instanceof ForeignReference || !lReference.getMDOName().equals(this.mMDOName) || !lReference.getMDOPackage().equals(this.mMDOPackage) || lReference.getMDOType() != this.mMDOType || lReference.refersToMDO()) {
                buf.append(" package=\"" + lReference.getMDOPackage() + "\"");
                buf.append(" name=\"" + lReference.getMDOName() + "\"");
                buf.append(" type=\"" + lReference.getMDOType() + "\"");
            }
            if (!lReference.refersToMDO()) {
                buf.append(" path=\"" + lReference.getPath() + "\"");
            }
            buf.append("/>\n");
            buf.append(this.popIndent() + "</TemplateMarker.Participant>\n");
        }
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</TemplateMarker>\n");
        }
    }

    private void serializeTemplateSetting(TemplateSettingState state, StringBuffer buf, boolean withEnclosingElements) {
        if (withEnclosingElements) {
            buf.append(this.indent() + "<TemplateSetting");
            buf.append(" name=\"" + this.escapeXML(state.getName()) + "\"");
            if (state.hasValue()) {
                buf.append(" value=\"" + this.escapeXML(state.getValue()) + "\"");
            }
            buf.append(">\n");
            this.pushIndent();
        }
        if (withEnclosingElements) {
            buf.append(this.popIndent() + "</TemplateSetting>\n");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

