@ECHO OFF
REM ***************************************************
REM **  make.bat  for GSSTEST on Microsoft WinNT     **
REM **   for Intel x86 / Intel ia64 and AMD64        **
REM **                                               **
REM **  Currently supported build environments:      **
REM **    x86  32-bit  Visual Studio 98 (VC6)        **
REM **    x86  32-bit  Visual Studio .NET 2003 (VC7) **
REM **    x86  32-bit  Visual Studio .NET 2005 (VC8) **
REM **                                               **
REM **    x64  64-bit  Windows 2003 SDK sp1/sp2      **
REM **    ia64 64-bit  Windows 2003 SDK sp1/sp2      **
REM ***************************************************

set CC=cl /nologo
set LD=link /nologo
set RM="del 2>NUL"
set OBJ=.obj
set EXE=.exe
set BUILD=
set MAKE=nmake
set LDLIBS=kernel32.lib advapi32.lib
set BASENAME_MACRO="$(@B).c"

set CFLAGS_OPT=
set LFLAGS_OPT=
set CFLAGS_OPT_32=
set LFLAGS_OPT_32=
set CFLAGS_DBG=
set LFLAGS_DBG=
set CFLAGS_DBG_32=
set LFLAGS_DBG_32=
set PLATFORM_CFLAGS=
set PLATFORM_LFLAGS=
set POSTLINK_EXE=
set POSTLINK_DLL=
set PASS_TARGET=

if EXIST "%VCINSTALLDIR%\bin\mt.exe" goto :assume_vs2005
  if "%VCINSTALLDIR%." == "." goto :assume_vs98
  if NOT "%CPU%." == "i386." goto :assume_win2003sdk
  goto assume_vs2003

:assume_vs98
  set BUILDENV_LABEL=VS98
  set RUNTIME_DEBUG_CHECKS=/GZ
  set PLATFORM_LFLAGS= 
  set CFLAGS_OPT=/Og /Oy
  set CFLAGS_OPT_32=/YX /G6 /Zi
  set CFLAGS_DBG_32=/YX /G6 /Z7 /Yd
  set LFLAGS_OPT=/DEBUG /PDBTYPE:SEPT /PDB:"$(*)_s.pdb"
  set LFLAGS_DBG=/DEBUG /PDBTYPE:CON  /PDB:"$(*).pdb"
  goto :common_MSC_definitions

:assume_vs2003
  set BUILDENV_LABEL=VS2003
  set RUNTIME_DEBUG_CHECKS=/GZ
  set PLATFORM_CFLAGS=/Zi
  set PLATFORM_LFLAGS=/DEBUG /PDBSTRIPPED:"$(*)_s.pdb"
  set CFLAGS_OPT=/Og /Oy
  set CFLAGS_OPT_32=/YX /G6
  set CFLAGS_DBG_32=/YX /G6 /Yd
  goto :common_MSC_definitions

:assume_win2003sdk
  set BUILDENV_LABEL=Win2003-SDK
  rem Microsoft totally fubar'ed /GZ in Win2003-SDK (aka /RTCs) 
  set RUNTIME_DEBUG_CHECKS=
  set PLATFORM_CFLAGS=/Zi
  set PLATFORM_LFLAGS=/DEBUG /PDBSTRIPPED:"$(*)_s.pdb"
  set CFLAGS_OPT=/Og /Oy
  goto :common_MSC_definitions

:assume_vs2005
  set BUILDENV_LABEL=VS2005
  set RUNTIME_DEBUG_CHECKS=/RTCs
  set PLATFORM_CFLAGS=/Zi /D_CRT_SECURE_NO_WARNINGS=1 /wd4996
  set PLATFORM_LFLAGS=/MANIFEST /DEBUG /PDBSTRIPPED:"$(*)_s.pdb"
  set CFLAGS_OPT=/Og /Oy
  set POSTLINK_EXE=mt.exe -manifest "$(@).manifest" -outputresource:"$(@)";1
  set POSTLINK_DLL=mt.exe -manifest "$(@).manifest" -outputresource:"$(@)";2

:common_MSC_definitions
rem Microsoft Intrisics optimization (implied by /Ox) gives a pig-slow malloc
set CFLAGS_OPT=%CFLAGS_OPT% /Ob1 /Gs /Gy /Os
set CFLAGS_DBG=%CFLAGS_DBG% /Od /Zi %RUNTIME_DEBUG_CHECKS%
set LFLAGS_OPT=%LFLAGS_OPT%
set LFLAGS_DBG=%LFLAGS_DBG%

if %CPU%. == IA64.  goto :is_ia64
if %CPU%. == AMD64. goto :is_amd64
if %CPU%. == i386.  goto :is_i386
if %CPU%. == .      goto :is_i386

echo !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
echo !! ABORTING --                                !!
echo !! I don't know the "%CPU%" build environment !!
echo !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
goto :done

:is_i386
REM *************************************************
REM ** Intel x86 (traditional Win32)               **
REM *************************************************
REM --- Compiler/Linker flags specific to Opimization
set CFLAGS_OPT=%CFLAGS_OPT% %CFLAGS_OPT_32%
set LFLAGS_OPT=%LFLAGS_OPT% %LFLAGS_OPT_32%
REM --- Compiler/Linker flags specific to Debug
set CFLAGS_DBG=%CFLAGS_DBG%
set LFLAGS_DBG=%LFLAGS_DBG%
set BASE=gss

goto :make_it_so

:is_ia64
REM *************************************************
REM ** Intel IA64 (Win64)                          **
REM *************************************************
rem Microsoft Fubar: without /GS- you must link bufferoverflowu.lib
set PLATFORM_CFLAGS=%PLATFORM_CFLAGS% /Wp64 /GS-
REM --- Compiler/Linker flags specific to Opimization
set CFLAGS_OPT=%CFLAGS_OPT%
set LFLAGS_OPT=%LFLAGS_OPT%
REM --- Compiler/Linker flags specific to Debug
set CFLAGS_DBG=%CFLAGS_DBG%
set LFLAGS_DBG=%LFLAGS_DBG%
set BASE=gi64

goto :make_it_so

:is_amd64
REM *************************************************
REM ** AMD64 (Win64)                               **
REM *************************************************
rem Microsoft Fubar: without /GS- you must link bufferoverflowu.lib
set PLATFORM_CFLAGS=%PLATFORM_CFLAGS% /Wp64 /GS-
REM --- Compiler/Linker flags specific to Opimization
set CFLAGS_OPT=%CFLAGS_OPT%
set LFLAGS_OPT=%LFLAGS_OPT%
REM --- Compiler/Linker flags specific to Debug
set CFLAGS_DBG=%CFLAGS_DBG%
set LFLAGS_DBG=%LFLAGS_DBG%
set BASE=gx64

goto :make_it_so

:make_it_so
echo *************************************************
echo ** Assumed build environment: %BUILDENV_LABEL%
echo *************************************************
REM --- default is debug build
if "%1" == "debug" shift
set CFLAGS=%CFLAGS_DBG% %PLATFORM_CFLAGS%
set LFLAGS=%LFLAGS_DBG% %PLATFORM_LFLAGS%
if "%1" == "opt" set CFLAGS=%CFLAGS_OPT% %PLATFORM_CFLAGS%
if "%1" == "opt" set LFLAGS=%LFLAGS_OPT% %PLATFORM_LFLAGS%
if "%1" == "opt" shift

REM --- add generic Compiler and Linker flags
set COMPILER=$(CC)
set LINKER=$(LD) /out:"$@"
set MT=

set LDTARGET=/out:$(TARGET)
set XD=Debug\

if NOT "%BASE%" == "" set PASS_TARGET=TARGET=$(XD)$(BASE)test$(EXE)

set CFLAGS=-c %CFLAGS% /MD /EHs-c- /GA /TC /W3 /GF /D "_CONSOLE" /D "XDEBUG" /Fp"Debug/gsstest.pch" /Fo"Debug/"
set LDFLAGS=%LFLAGS% /OPT:REF /subsystem:console /libpath:debug

if %1. == clean. nmake win32-clean %PASS_TARGET%
if %1. == all.   nmake do-all      %PASS_TARGET%
if %1. == zip.   nmake zip	   %PASS_TARGET%
if %1. == .      nmake do-all      %PASS_TARGET%

:finis

