 # ********************************************************************
 #  $Id: osftimer.s,v 1.1.1.1 1998/11/06 14:33:18 d019080 Exp $
 # ********************************************************************
 #
 #  (C) Copyright 1998  SAP AG Walldorf
 #
 # Author:  Martin Rex
 # 
 # SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 # INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 # EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 # DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 # PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 # ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 # OF THIS SOFTWARE.
 #
 #
 #-------------------------------------------------------------------;
 # high precisision timer - Assembly routines                        ;
 #                                                                   ;
 # This module reads the 32-bit wide process cycle counter of        ;
 # a DEC Alpha CPU which has the resolution of the CPU clock speed   ;
 # Since it's only 32-bit wide, it will wrap within a matter of      ;
 # seconds (<10sec for 466MHz CPU), therefore one needs to keep      ;
 # track of the gettimeofday() changes as well ...                   ;
 #-------------------------------------------------------------------;
 #
 #   unsigned long read_alpha_pcc( void )
 #   {
 #     return (PCC);
 #   }
 #

	.ugen
	.verstamp       3 11
	.text
	.align  4
	.file   2 "osftimer.s"
        .globl  read_alpha_pcc
        .loc    2 2
 #    1 unsigned long read_alpha_pcc ()
 #    2 {
	.ent    read_alpha_pcc 2
read_alpha_pcc:
	.option O1
	ldgp    $gp, 0($27)
	.frame  $sp, 0, $26, 0
	.prologue       1
	.loc    2 2

	.loc    2 3
 #    3     return (PCC & 0xFFFFFFFF);
	rpcc    $0
	sll     $0, 32, $0
	srl     $0, 32, $0
	.livereg        0xFC7F0002,0x3FC00000
	ret     $31, ($26), 1
	.end    read_alpha_pcc
 #    4 }
