#include "mysccs.h"
SCCSID("@(#)contexts.c   %E%   SAP   %I%")

static char * this_File GNU_UNUSED = __FILE__;

/************************************************************************/
/* $Id: platform.c,v 1.7 2000/07/26 14:41:49 d019080 Exp $
 ************************************************************************
 *
 * Copyright (c) 1998-2000  SAP AG.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * 4. The name "SAP AG" must not be used to endorse or promote products
 *    derived from this software without prior written permission.
 *    For written permission, please contact www.press@sap.com
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by SAP AG"
 *
 * THIS SOFTWARE IS PROVIDED BY SAP AG ``AS IS'' AND ANY EXPRESSED
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. SAP AG SHALL BE LIABLE FOR ANY DAMAGES
 * ARISING OUT OF THE USE OF THIS SOFTWARE ONLY IF CAUSED BY SAP AG'S
 * INTENT OR GROSS NEGLIGENCE. IN CASE SAP AG IS LIABLE UNDER THIS
 * AGREEMENT FOR DAMAGES CAUSED BY SAP AG'S GROSS NEGLIGENCE SAP AG
 * FURTHER SHALL NOT BE LIABLE FOR ANY INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT, AND SHALL NOT BE LIABLE IN EXCESS OF THE AMOUNT OF
 * DAMAGES TYPICALLY FORESEEABLE FOR SAP AG, WHICH SHALL IN NO EVENT
 * EXCEED US$ 500.000.- 
 *
 ************************************************************************/


#include "gsstest.h"
#include "non_ansi.h"
#include <time.h>



float  perf_correction = 1.0;

#ifdef UNIX

#  include <sys/types.h>
#  include <unistd.h>
#  include <sys/utsname.h>
#  include <pwd.h>


/*
 * sys_uts_osname()
 *
 *
 */
int
sys_uts_osname( struct sys_platform_s * p_pls )
{
   struct utsname  uts;
   int             rc;

   memset( &uts, 0, sizeof(uts) );
   rc = uname( &uts );
   if ( rc>=0 ) {
      strncpy( p_pls->os_name, uts.sysname, sizeof(p_pls->os_name) );
      p_pls->os_name[sizeof(p_pls->os_name)-1] = '\0';
      return(0);
   } else {
      XVEB((V_BUG, "uname() failed: %s\n", strerror(errno) ));
      memset( p_pls->os_name, 0, sizeof(p_pls->os_name) );
   }

   return(1);

} /* sys_uts_osname() */


/*
 * sys_uts_osrelease()
 *
 *
 */
int
sys_uts_osrelease( struct sys_platform_s * p_pls )
{
   struct utsname   uts;
   int              rc;

   memset( &uts, 0, sizeof(uts) );
   rc = uname( &uts );
   if ( rc>=0 ) {
      strncpy( p_pls->os_release, uts.release, sizeof(p_pls->os_release) );
      p_pls->os_release[sizeof(p_pls->os_release)-1] = '\0';
      return(0);
   } else {
      XVEB((V_BUG, "uname() failed: %s\n", strerror(errno) ));
      memset( p_pls->os_release, 0, sizeof(p_pls->os_release) );
   }

   return(1);

} /* sys_uts_osrelease() */


/*
 * sys_uts_oshardware()
 *
 *
 */
int
sys_uts_oshardware( struct sys_platform_s * p_pls )
{
   struct utsname  uts;
   int             rc;

   memset( &uts, 0, sizeof(uts) );
   rc = uname( &uts );
   if ( rc>=0 ) {
      strncpy( p_pls->os_hardware, uts.machine, sizeof(p_pls->os_hardware) );
      p_pls->os_hardware[sizeof(p_pls->os_hardware)-1] = '\0';
      return(0);
   } else {
      XVEB((V_BUG, "uname() failed: %s\n", strerror(errno) ));
      memset( p_pls->os_hardware, 0, sizeof(p_pls->os_hardware) );
   }

   return(1);

} /* sys_uts_hardware() */

  
/*
 * sys_gethostname()
 *
 *
 */
int
sys_gethostname( struct sys_platform_s * p_pls )
{
   int    rc;

   memset( p_pls->hostname, 0, sizeof(p_pls->hostname) );
   rc = gethostname( p_pls->hostname, sizeof(p_pls->hostname)-1 );
   if ( rc!=0 ) {
      XVEB((V_BUG, "gethostname() failed: %s\n", strerror(errno) ));
   }

   p_pls->hostname[sizeof(p_pls->hostname)-1] = '\0';

   if ( rc==0 )
      return(rc);

   return(1);

} /* sys_gethostname() */


/*
 * sys_getpwuid()
 *
 *
 */
int
sys_getpwuid( struct sys_platform_s * p_pls )
{
   struct passwd   * result;

   result = getpwuid( getuid() );
   memset( p_pls->user, 0, sizeof(p_pls->user) );
   if ( result==NULL ) {
      XVEB((V_BUG, "getpwent(%lu) failed: %s\n",
	           (unsigned long)getuid(), strerror(errno) ));
   } else {
      strncpy( p_pls->user, result->pw_name, sizeof(p_pls->user) );
      p_pls->user[sizeof(p_pls->user)-1] = '\0';
      return(0);
   }

   return(1);

} /* sys_getpwuid() */



/*
 * sys_popen()
 *
 * read a single line of output from a shell command
 * into a buffer
 *
 */
int
sys_popen( char   * p_command,  char   * p_buf,   size_t  p_buf_max )
{
   FILE   * fp  = NULL;
   size_t   len;
   int	    rc  = 1;

   memset( p_buf, 0, p_buf_max);

   fp = popen( p_command, "r" );
   if ( fp!=NULL ) {
      len = fread( p_buf, 1, p_buf_max-1, fp );
      if ( len>0 ) {
	 /* looks good -- we were able to read from stdout */
	 p_buf[len] = 0;
	 while( len>0 && (p_buf[len-1]=='\r' || p_buf[len-1]=='\n') ) {
	    /* cut end-of-line characters, in case there are any */
	    len--;
	    p_buf[len] = '\0';
	 }
	 if ( len>0 ) {
	    rc = 0; /* success -- we have a non-empty string left */
	 }
      }

      pclose( fp );

   } /* fp!=NULL */

   return(rc);

} /* sys_popen() */


	  
#endif /* UNIX */




#ifdef _WIN32


/*
 * win_osname()
 */
int
win_osname( struct sys_platform_s   * p_pls )
{
   OSVERSIONINFO     osvi;
   char           *  product;

   memset( p_pls->os_name, 0, sizeof(p_pls->os_name) );
   memset( &osvi, 0, sizeof(osvi) );

   osvi.dwOSVersionInfoSize = sizeof(osvi); /* REQUIRED! */
   GetVersionEx( &osvi );

   switch( (int) osvi.dwPlatformId ) {

      case VER_PLATFORM_WIN32s:
		  product = "Microsoft Win32";
		  break;

      case VER_PLATFORM_WIN32_WINDOWS:
		  product = (osvi.dwMinorVersion==0)
			    ? "Microsoft Windows 95" : "Microsoft Windows 98";
		  break;
		     
      case VER_PLATFORM_WIN32_NT:
		  product = "Microsoft Windows NT";
		  break;

      default:	  product = "Windows (?!)";
		  break;

   }

   strncpy( p_pls->os_name, product, sizeof(p_pls->os_name) );
   p_pls->os_name[sizeof(p_pls->os_name)-1] = '\0';

   return(0);

} /* win_osname() */


/*
 * win_osrelease()
 */
int
win_osrelease( struct sys_platform_s   * p_pls )
{
   OSVERSIONINFO     osvi;
   char              tmpbuf[256];

   memset( p_pls->os_release, 0, sizeof(p_pls->os_release) );
   memset( &osvi, 0, sizeof(osvi) );

   osvi.dwOSVersionInfoSize = sizeof(osvi); /* REQUIRED! */
   GetVersionEx( &osvi );

      
   sprintf(tmpbuf, "%d.%d (Build %d)",
		   (int) osvi.dwMajorVersion,
		   (int) osvi.dwMinorVersion,
		   (int) (osvi.dwBuildNumber & 0xFFFF) );

   strncpy( p_pls->os_release, tmpbuf, sizeof(p_pls->os_release) );
   p_pls->os_release[sizeof(p_pls->os_release)-1] = '\0';
   
   return(0);

} /* win_osrelease() */


/*
 * win_hardware()
 */
int
win_hardware( struct sys_platform_s  * p_pls )
{
   SYSTEM_INFO    sinfo;
   size_t	  len;
   char         * cpu  = "(unknown)";
   char         * cpu2 = "";
   char           cpu_level[128];
   char	          cpu_rev[128];

   memset( p_pls->os_hardware, 0, sizeof(p_pls->os_hardware) );
   memset( &sinfo, 0, sizeof(sinfo) );
   GetSystemInfo( &sinfo );

   switch( (int)sinfo.wProcessorArchitecture ) {
      case PROCESSOR_ARCHITECTURE_INTEL:     cpu = "x86";      break;
      case PROCESSOR_ARCHITECTURE_ALPHA:     cpu = "Alpha";    break;
      case PROCESSOR_ARCHITECTURE_PPC:	     cpu = "PowerPC";  break;
      case PROCESSOR_ARCHITECTURE_MIPS:	     cpu = "Mips";     break;
      default:	     break;
   }

#if 0
   if ( sinfo.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_INTEL ) {
      switch( (int)sinfo.dwProcessorType ) {
	 case PROCESSOR_INTEL_386:	     cpu2 = " (386)";  break;
	 case PROCESSOR_INTEL_486:	     cpu2 = " (486)";  break;
	 case PROCESSOR_INTEL_PENTIUM:	     cpu2 = " (Pentium)";  break;
	 default:    break;
      }
   }
#endif

   sprintf( cpu_level, "cpu_level=%ld", (unsigned long)sinfo.wProcessorLevel );
   sprintf( cpu_rev, "cpu_rev=0x%04lx", (unsigned long)sinfo.wProcessorRevision );

   len = strlen(cpu) + strlen(cpu2) + strlen(cpu_level) + strlen(cpu_rev) + 4;
   if ( len < sizeof(p_pls->os_hardware) ) {
      sprintf(p_pls->os_hardware, "%s%s  %s, %s", cpu, cpu2, cpu_level, cpu_rev );
   } else {
      strncpy(p_pls->os_hardware, cpu, sizeof(p_pls->os_hardware));
   }
   p_pls->os_hardware[sizeof(p_pls->os_hardware)-1] = '\0';

   return(0);
   
} /* win_hardware() */


/*
 * win_username()
 */
int
win_username( struct sys_platform_s * p_pls )
{
   BOOL   result;
   DWORD  len;

   len = sizeof(p_pls->user) - 1;
   memset( p_pls->user, 0, sizeof(p_pls->user) );

   result = GetUserName( p_pls->user, &len );
   if ( result==0 ) {
      XVEB((V_BUG, "GetUserName() returned %08lx!\n",
		   (unsigned long) GetLastError() ));
      memset( p_pls->user, 0, sizeof(p_pls->user) ); /* Don't rely on M$ */
      return(1);
   }

   p_pls->user[sizeof(p_pls->user)-1] = '\0';

   return(0);

} /* win_username() */


/*
 * win_computername()
 */
int
win_computername( struct sys_platform_s * p_pls )
{
   BOOL   result;
   DWORD  len;

   len = sizeof(p_pls->hostname) - 1;
   memset( p_pls->hostname, 0, sizeof(p_pls->hostname) );

   result = GetComputerName( p_pls->hostname, &len );
   if (result==0) {
      XVEB((V_BUG, "GetComputerName() returned %08lx!\n",
		   (unsigned long) GetLastError() ));
      memset( p_pls->hostname, 0, sizeof(p_pls->hostname) );
      return(1);
   }

   p_pls->hostname[sizeof(p_pls->hostname)-1] = '\0';


   return(0);

} /* win_computername() */


#endif /* _WIN32 */


static char *days[] =
   { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };

static char *months[] =
   { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
     "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

/*
 * sys_greeting()
 *
 *
 *
 */
void
sys_greeting( char * p_prefix, struct sys_platform_s * p_pls )
{
   struct tm             * ltime   = NULL;
   char			 * unknown = "(unknown)";
   Ulong		   high, low;
   Ulong		   dbg_speed, opt_speed;
   int			   tzoffset;
   int			   tzhours;
   int			   tzrest;
   int			   tzmins;
   time_t		   now;
   int                     rc      = 0;

   XVEB((V_SHOW, "%s=====================================================================\n", p_prefix));

   now   = time(NULL);
   ltime = localtime(&now);
   if ( ltime==NULL ) {
      XVEB((V_BUG, "HUH? localtime() failed!\n"));
   } else {
      tzoffset = timezone;
      if ( daylight!=0 ) { tzoffset -= 3600; }
      tzhours = (tzoffset)/3600;
      tzrest  = tzoffset - tzhours*3600;
      tzmins  = ((tzrest>=0) ? tzrest : tzrest + 3600) / 60 ;
      XVEB((V_SHOW, "%s  Current Date&Time :  %s, %02d-%s-%4d   %02d:%02d:%02d   GMT %+03d:%02d\n", p_prefix,
		    days[ltime->tm_wday],
		    ltime->tm_mday, months[ltime->tm_mon], 1900+ltime->tm_year,
		    ltime->tm_hour, ltime->tm_min, ltime->tm_sec,
		    tzhours, tzmins ));
   }

   Strmaxcpy( p_pls->os_name,     unknown, sizeof(p_pls->os_name)     );
   Strmaxcpy( p_pls->os_release,  unknown, sizeof(p_pls->os_release)  );
   Strmaxcpy( p_pls->os_hardware, unknown, sizeof(p_pls->os_hardware) );
   Strmaxcpy( p_pls->hostname,    unknown, sizeof(p_pls->hostname)    );
   Strmaxcpy( p_pls->user,        unknown, sizeof(p_pls->user)        );

   rc +=  SYS_GET_OSNAME(     p_pls );
   rc +=  SYS_GET_OSRELEASE(  p_pls );
   rc +=  SYS_GET_OSHARDWARE( p_pls );
   rc +=  SYS_GET_HOSTNAME(   p_pls );
   rc +=  SYS_GET_USERNAME(   p_pls );

   XVEB((V_SHOW, "%s  Operating System  :  %.100s\n", p_prefix, p_pls->os_name     ));
   XVEB((V_SHOW, "%s          -Release  :  %.100s\n", p_prefix, p_pls->os_release  ));
   XVEB((V_SHOW, "%s  Hardware/Machine  :  %.100s\n", p_prefix, p_pls->os_hardware ));

   sys_machine_speed( &dbg_speed, &opt_speed );
   high  = opt_speed / 100;
   low   = opt_speed - (high*100);
   XVEB((V_SHOW, "%s  Perf-Index (p-90) :  opt= %lu.%02lu", p_prefix, high, low ));
   high  = dbg_speed / 100;
   low   = dbg_speed - (high*100);
   XVEB((V_SHOW, "   dbg= %lu.%02lu\n", high, low ));

   if (hrtimer_resolution!=0) {
      XVEB((V_SHOW, "%s  Timer Resolution  :  ", p_prefix));
      high = hrtimer_resolution / 1000;
      low  = hrtimer_resolution - (high * 1000);
      XVEB((V_SHOW, "%lu.%03lu millisec using \"%s\"\n", high, low, hrtimer_name ));
   }

   XVEB((V_SHOW, "%s  Hostname          :  %.100s\n", p_prefix, p_pls->hostname ));
   XVEB((V_SHOW, "%s  Current user      :  %.100s\n", p_prefix, p_pls->user     ));

   XVEB((V_SHOW, "%s=====================================================================\n", p_prefix));

   return;

} /* sys_greeting() */




/*
 * sys_machine_speed()
 *
 * Description:
 *   Get a feeling for the CPU power of the current machine
 *   This is used to scale performance-related limits
 *
 */
void
sys_machine_speed( Ulong * dbg_speed, Ulong * opt_speed )
{
   char           * this_Call = "sys_machine_speed";
   Ulong            vals[16];
   Ulong            avg;
   Ulong            speed;
   Ulong            correction;
   unsigned char    digest[16];
   int              i;
   unsigned char  * memory;
   haMD5_CTX        md5_ctx;

   (*opt_speed) = (*dbg_speed) = 0;

   memory = (unsigned char *)malloc(BENCH_MEMSIZE);
   if ( memory==NULL ) {
      XVEB((V_BUG, "%s() error: malloc(%lu) failed!\n", this_Call, (Ulong) BENCH_MEMSIZE));
      return;
   }

   for ( i=0 ; i<16 ; i++ ) {
      start_timer();
      memset( memory, 0x5a, BENCH_MEMSIZE );
      haMD5Init(   &md5_ctx );
      haMD5Update( &md5_ctx, memory, BENCH_MEMSIZE );
      haMD5Final(   digest, &md5_ctx );
      vals[i] = read_timer();
   }

   avg = sample_avg( vals, sizeof(vals)/sizeof(vals[0]) );

   if ( avg>0 ) {
      speed        = (100 * PENTIUM90_SPEED_DBG) / avg;
      (*dbg_speed) = ((speed+5)/10) * 10;

      correction = (*dbg_speed + 70) / 2;
      if ( correction > 100 ) {
	 perf_correction = (float) correction / (float)100.0;
      } else {
	 perf_correction = 1.0;
      }

      speed        = (100 * PENTIUM90_SPEED_OPT) / avg;
      (*opt_speed) = ((speed+5)/10) * 10;
   }

   if ( memory!=NULL ) {
      free( memory );
      memory = NULL;
   }

   return;

} /* sys_machine_speed() */




/*
 * sys_get_hostname()
 *
 */
char *
sys_get_hostname( void )
{
   static struct sys_platform_s  pl;

   Strmaxcpy( pl.hostname,    "(unknown)", sizeof(pl.hostname) );

   SYS_GET_HOSTNAME( &pl );

   return( pl.hostname );

} /* sys_get_hostname() */




