<?php
require('includes/session.inc.php');
require('includes/config.inc.php');
require('includes/functions.inc.php');
require('includes/styles.inc.php');

/* Login check */
if (!isLoggedIn())
{
	printError("Sorry, you must be logged in to view this");
	exit;
}

/* Does the user have credentials to view this? */
if (!checkSecurity())
{
	printError("Sorry, you do not have the credentials to view this page");
	exit;
}

/* Don't print anything if no GET req */
if (!$_GET[problem])
{
	echo "<p align='center'>Please select a problem above</p>";
	exit;
}

/* Filter bogus problems */
if ($_GET[problem] && $_GET[problem] != "" && (!is_numeric($_GET[problem])))
{
	printError("You must pass a problem in GET! Please do not call this script directly");
	exit;
}

$problem = $_GET[problem];

/* SQL */
require("includes/db.inc.php");
$query = "SELECT * FROM $tbl_problems WHERE problem_id = $problem";
$result = pg_exec($query) or die("Query failed : " . pg_last_error($connection));


if (pg_num_rows($result) < 1)
{
	printError("No such problem!");
	exit;
}


$row = pg_fetch_object($result);

/* Print the problem */
echo "<div align='center'>";
echo "<i>Estimated cost: $row->cost</i><br>\n";
echo "<i>Estimated time to fix: $row->estimated_time hours</i><br>\n";

if ($row->actual_time == "" || !$row->actual_time)
	$actual_hours = 0;
else
	$actual_hours = $row->actual_time;

echo "<i>Actual time taken to fix: $actual_hours hours</i><br>\n<br>\n";
echo "<i>$row->description</i><br>\n<br>\n";
?>
