
LIBRARY std;
USE std.textio.ALL;

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;

PACKAGE string_package IS

   CONSTANT ALWAYS : BOOLEAN := FALSE;

   FUNCTION HEX2BIN(char : CHARACTER) RETURN std_ulogic_vector ;

-- the given line is de-allocated, if it is not a null assignment
   PROCEDURE dump (l : INOUT Line);

-- the line has the string supplied appended to the end
   PROCEDURE writeString(l : INOUT Line; s : In String);

-- the next space delimted string is extracted from the first line and placed
-- in the second
   PROCEDURE getString(input_line : INOUT Line; output_line : INOUT Line);

-- the integer is written to the line with supplied number of HEX digits
   PROCEDURE ToHEX(value : IN Integer; lout : INOUT Line; digits : IN Integer);

-- the std_ulogic vector is written to the line as HEX
   PROCEDURE ToHEX(bit_word : IN std_ulogic_vector; lout : INOUT Line);

-- the two supplied strings are compared
   FUNCTION  strcmp(s1, s2 : IN String) RETURN Integer;

-- a method to load hex numbers from a textio line
   PROCEDURE HexRead(input_line :inout LINE; VALUE:out INTEGER );

-- a routine to remove redundant spaces
    PROCEDURE RemoveSpaces(input_line : inout LINE);


END string_package;




LIBRARY std;
USE std.textio.ALL;

-- mentor libraries
-- LIBRARY ieee, arithmetic;
-- USE ieee.std_logic_1164.ALL;
-- USE arithmetic.std_logic_arith.ALL;

-- SYNOPSYS libraries
LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_arith.ALL;

PACKAGE BODY string_package IS

   FUNCTION BIN2HEX(word : IN std_ulogic_vector(3 DOWNTO 0)) RETURN String IS
      VARIABLE i : Integer;
   BEGIN -- FUNCTION BIN2HEX
     CASE word IS
         WHEN "0000" => return "0";
         WHEN "0001" => return "1";
         WHEN "0010" => return "2";
         WHEN "0011" => return "3";
         WHEN "0100" => return "4";
         WHEN "0101" => return "5";
         WHEN "0110" => return "6";
         WHEN "0111" => return "7";
         WHEN "1000" => return "8";
         WHEN "1001" => return "9";
         WHEN "1010" => return "A";
         WHEN "1011" => return "B";
         WHEN "1100" => return "C";
         WHEN "1101" => return "D";
         WHEN "1110" => return "E";
         WHEN "1111" => return "F";
         WHEN OTHERS => return "?";
      END CASE;
   END BIN2HEX;

   FUNCTION HEX2INT(char : CHARACTER) RETURN INTEGER IS
      VARIABLE i : Integer;
   BEGIN -- FUNCTION BIN2HEX
     CASE char IS
         WHEN '0' => RETURN 0;
         WHEN '1' => RETURN 1;
         WHEN '2' => RETURN 2;
         WHEN '3' => RETURN 3;
         WHEN '4' => RETURN 4;
         WHEN '5' => RETURN 5;
         WHEN '6' => RETURN 6;
         WHEN '7' => RETURN 7;
         WHEN '8' => RETURN 8;
         WHEN '9' => RETURN 9;
         WHEN 'A' | 'a' => RETURN 10;
         WHEN 'B' | 'b' => RETURN 11;
         WHEN 'C' | 'c' => RETURN 12;
         WHEN 'D' | 'd' => RETURN 13;
         WHEN 'E' | 'e' => RETURN 14;
         WHEN 'F' | 'f' => RETURN 15;
         WHEN OTHERS => return 255;
      END CASE;
   END HEX2INT;

   FUNCTION HEX2BIN(char : CHARACTER) RETURN std_ulogic_vector IS
      VARIABLE i : Integer;
   BEGIN -- FUNCTION BIN2HEX
     CASE char IS
         WHEN '0' => RETURN "0000";
         WHEN '1' => RETURN "0001";
         WHEN '2' => RETURN "0010";
         WHEN '3' => RETURN "0011";
         WHEN '4' => RETURN "0100";
         WHEN '5' => RETURN "0101";
         WHEN '6' => RETURN "0110";
         WHEN '7' => RETURN "0111";
         WHEN '8' => RETURN "1000";
         WHEN '9' => RETURN "1001";
         WHEN 'A' | 'a' => RETURN "1010";
         WHEN 'B' | 'b' => RETURN "1011";
         WHEN 'C' | 'c' => RETURN "1100";
         WHEN 'D' | 'd' => RETURN "1101";
         WHEN 'E' | 'e' => RETURN "1110";
         WHEN 'F' | 'f' => RETURN "1111";
         WHEN OTHERS => return "0000";
      END CASE;
   END HEX2BIN;

   PROCEDURE dump (l : INOUT Line) IS
   BEGIN -- PROCEDURE dump
      IF l /= NULL THEN
         DEALLOCATE (l);
      END IF;
   END dump;

   PROCEDURE writeString(l : INOUT Line; s : In String) IS
   BEGIN -- PROCEDURE writeString
      write(l, s);
   END writeString;


--
-- this proceedure needs to interpret the 16#abc# and the 2#1101# type numbers 
-- directly, they are not interpreted by all VHDL simulation systems 
--
   PROCEDURE getString(input_line : INOUT Line; output_line : INOUT Line) IS
      VARIABLE c0 : Character;
      TYPE word IS ARRAY (31 DOWNTO 0) OF Character;
      VARIABLE chars : word;
      VARIABLE actual_count : integer;
      VARIABLE count,i  : integer;
      VARIABLE value : integer;

   BEGIN -- PROCEDURE getString
      dump(output_line);
      c0 := '0';
      IF(input_line'length = 0) THEN
         writeString(output_line, "Empty Line");
      END IF;
      RemoveSpaces(input_line);

      WHILE input_line'length > 0 AND c0 /= ' ' LOOP
         read(input_line, c0);
         IF c0 /= ' ' THEN write(output_line, c0); END IF;
      END LOOP;

   END getString;

   PROCEDURE ToHEX(value : IN Integer;lout : INOUT Line;digits : IN Integer) IS
      VARIABLE bit_word : std_ulogic_vector(31 DOWNTO 0); 
      VARIABLE count : Integer;
   BEGIN -- PROCEDURE toHEX
      bit_word := std_ulogic_vector(conv_std_logic_vector(value, 32));
      count := digits*4 -1;
      WHILE count > 0 LOOP
         WRITE (lout, BIN2HEX(bit_word(count DOWNTO count-3)));
         count := count - 4;
      END LOOP;
   END ToHEX;

   PROCEDURE ToHEX(bit_word : IN std_ulogic_vector; lout : INOUT Line) IS
      VARIABLE count : Integer;
      VARIABLE extra_bits   : Integer;
      VARIABLE final_word   : std_ulogic_vector(31 DOWNTO 0);
   BEGIN -- PROCEDURE ToHEX
      extra_bits   := 4;
      final_word   := "00000000000000000000000000000000";
      final_word((bit_word'LENGTH-1) DOWNTO 0) := bit_word;

      IF ((((bit_word'LENGTH)/4)*4) /= bit_word'LENGTH) THEN
         WHILE (((((bit_word'LENGTH)/4)*4)+extra_bits) /= bit_word'LENGTH) LOOP
            extra_bits := extra_bits - 1;
         END LOOP;
      END IF;

      count := bit_word'LENGTH-1+(4 - extra_bits);
      WHILE count > 0 LOOP
         WRITE (lout, BIN2HEX(final_word(count DOWNTO count-3)));
         count := count - 4;
      END LOOP;
   END ToHEX;


   FUNCTION strcmp(s1, s2 : IN String) RETURN Integer IS
      VARIABLE i : Integer;
   BEGIN -- FUNCTION strcmp
      IF s1'length /= s2'length THEN
         RETURN -1;
      ELSE
         i := 1;
         WHILE i <= s1'length LOOP
            IF s1(i) /= s2(i) THEN
               RETURN i;
            END IF;
            i := i + 1;
         END LOOP;
         RETURN 0;
      END IF;
   END strcmp;

   PROCEDURE HexRead(input_line:inout LINE; VALUE:out INTEGER ) IS
   VARIABLE temp_line    : LINE;
   VARIABLE number_line  : LINE;
   VARIABLE c            : CHARACTER;
   VARIABLE count        : INTEGER;
   VARIABLE number_chars : INTEGER;
   VARIABLE good         : BOOLEAN;
   VARIABLE temp_value   : std_ulogic_vector(31 DOWNTO 0);
   BEGIN
     RemoveSpaces(input_line);
     read(input_line, c); -- 1
     read(input_line, c); -- 6
     read(input_line, c); -- remove the first #
     number_chars := 0;
   -- remove the end '#'
     LOOP   
        read(input_line, c, good);
        exit when ((c = '#') OR (not good));
        number_chars := number_chars + 1;
        write(temp_line,c);
     END LOOP;
-- at this point the temp_line contains the string of the hex number only
-- with number_chars digits
     count := (number_chars *4)-1;
     temp_value := "00000000000000000000000000000000";
     WHILE count /= -1 LOOP
        read(temp_line, c);
        temp_value(count DOWNTO count-3) := HEX2BIN(c);
        count := count - 4;
     END LOOP;
-- mentor
--   value := to_integer(temp_value);
-- synopsys
     value := conv_integer(SIGNED(temp_value));
   END HexRead;

   PROCEDURE RemoveSpaces(input_line:inout LINE) IS
   VARIABLE temp_line : LINE;
   VARIABLE c         : CHARACTER;
   VARIABLE good      : BOOLEAN;
   BEGIN
      write(temp_line, input_line.all);
      LOOP 
         read(temp_line,c,good);
         exit when ((NOT(good)) or (c /= ' '));
         read(input_line, c); 
      END LOOP;
   END RemoveSpaces;

END string_package;


