--==========================================================================--
-- Design units : 10/100 Ethernet MAC - RxMAC - RxSyncFIFO
--
-- File name    : rxsyncfifo.vhd
--
-- Purpose      : The RxSyncFIFO is necessary because it's only sure that the
--                MII signals are stable at the rising edge of RxClk. To
--                ensure that all signals are stable within the whole clock
--                cycle the information from MII is latched into the register
--                triggered on RxClk.
--
-- Note         : None
--
-- Limitations  : None
--
-- Errors       : None known
--
-- Library      : EthMAC_Lib
--
-- Dependencies : None
--
-- Author       : Maik Boden (boden@ite.inf.tu-dresden.de)
--                Dresden University of Technology
--                Department of Information Science
--                Institute of Computer Engineering
--
-- Simulator    : VHDL Simili 1.4 Beta, Windows NT 4.0
------------------------------------------------------------------------------
-- Revision list
-- Version  Author  Date        Changes
-- 0.1      MB      2000-09-04  Initial revision
-- 0.1      MB      2000-09-19  Col -> GatedCol (FullDuplex Management)
--==========================================================================--

library IEEE;
use IEEE.Std_Logic_1164.all;

entity RxSyncFIFO is
  port(
    -- Receive clock and asynchronous reset
    RxReset_N: in  Std_ULogic;
    RxClk:     in  Std_ULogic;
    -- Receive signals from MII
    RxD:       in  Std_ULogic_Vector(3 downto 0);
    RxDV:      in  Std_ULogic;
    RxEr:      in  Std_ULogic;
    GatedCol:  in  Std_ULogic;
    -- Receive signals stable and synchronous to RxClk
    RxFifoD:   out Std_ULogic_Vector(3 downto 0);
    RxFifoDV:  out Std_ULogic;
    RxFifoEr:  out Std_ULogic;
    RxFifoCol: out Std_ULogic
  );
end RxSyncFIFO;

--==========================================================================--

library IEEE;
use IEEE.Std_Logic_1164.all;

architecture RTL of RxSyncFIFO is

begin  -- Architecture RTL of RxSyncFIFO

  ----------------------------------------------------------------------------
  -- This process synchronizes the MII receive signals to the receive clock.
  ----------------------------------------------------------------------------
  Synchronizer: process (RxReset_N, RxClk)
  begin
    if RxReset_N = '0' then
      RxFifoD   <= (others => '0');
      RxFifoDV  <= '0';
      RxFifoEr  <= '0';
      RxFifoCol <= '0';
    elsif Rising_Edge(RxClk) then
      RxFifoD   <= RxD;
      RxFifoDV  <= RxDV;
      RxFifoEr  <= RxEr;
      RxFifoCol <= GatedCol;
   end if;
 end process Synchronizer;

end RTL;  -- End of RxSyncFIFO (RTL)
