/*
 * Decompiled with CFR 0.152.
 */
package jcifs.netbios;

import java.io.IOException;
import java.io.InputStream;

abstract class SessionServicePacket {
    static final int SESSION_MESSAGE = 0;
    static final int SESSION_REQUEST = 129;
    static final int POSITIVE_SESSION_RESPONSE = 130;
    static final int NEGATIVE_SESSION_RESPONSE = 131;
    static final int SESSION_RETARGET_RESPONSE = 132;
    static final int SESSION_KEEP_ALIVE = 133;
    static final int MAX_MESSAGE_SIZE = 131071;
    static final int HEADER_LENGTH = 4;
    int type;
    int length;

    SessionServicePacket() {
    }

    static void writeInt2(int val, byte[] dst, int dstIndex) {
        dst[dstIndex++] = (byte)(val >> 8 & 0xFF);
        dst[dstIndex] = (byte)(val & 0xFF);
    }

    static void writeInt4(int val, byte[] dst, int dstIndex) {
        dst[dstIndex++] = (byte)(val >> 24 & 0xFF);
        dst[dstIndex++] = (byte)(val >> 16 & 0xFF);
        dst[dstIndex++] = (byte)(val >> 8 & 0xFF);
        dst[dstIndex] = (byte)(val & 0xFF);
    }

    static int readInt2(byte[] src, int srcIndex) {
        return ((src[srcIndex] & 0xFF) << 8) + (src[srcIndex + 1] & 0xFF);
    }

    static int readInt4(byte[] src, int srcIndex) {
        return ((src[srcIndex] & 0xFF) << 24) + ((src[srcIndex + 1] & 0xFF) << 16) + ((src[srcIndex + 2] & 0xFF) << 8) + (src[srcIndex + 3] & 0xFF);
    }

    static int readLength(byte[] src, int srcIndex) {
        int n = ++srcIndex;
        int n2 = ++srcIndex;
        int n3 = ++srcIndex;
        ++srcIndex;
        return ((src[n] & 1) << 16) + ((src[n2] & 0xFF) << 8) + (src[n3] & 0xFF);
    }

    static int readPacketType(InputStream in, byte[] buffer, int bufferIndex) throws IOException {
        int n = in.read(buffer, bufferIndex, 4);
        if (n != 4) {
            if (n == -1) {
                return -1;
            }
            throw new IOException("unexpected EOF reading netbios session header");
        }
        int t = buffer[bufferIndex] & 0xFF;
        return t;
    }

    int writeWireFormat(byte[] dst, int dstIndex) {
        this.length = this.writeTrailerWireFormat(dst, dstIndex + 4);
        this.writeHeaderWireFormat(dst, dstIndex);
        return 4 + this.length;
    }

    int readWireFormat(InputStream in, byte[] buffer, int bufferIndex) throws IOException {
        this.readHeaderWireFormat(in, buffer, bufferIndex);
        return 4 + this.readTrailerWireFormat(in, buffer, bufferIndex);
    }

    int writeHeaderWireFormat(byte[] dst, int dstIndex) {
        dst[dstIndex++] = (byte)this.type;
        if (this.length > 65535) {
            dst[dstIndex] = 1;
        }
        SessionServicePacket.writeInt2(this.length, dst, ++dstIndex);
        return 4;
    }

    int readHeaderWireFormat(InputStream in, byte[] buffer, int bufferIndex) throws IOException {
        this.type = buffer[bufferIndex++] & 0xFF;
        this.length = ((buffer[bufferIndex] & 1) << 16) + SessionServicePacket.readInt2(buffer, bufferIndex + 1);
        return 4;
    }

    abstract int writeTrailerWireFormat(byte[] var1, int var2);

    abstract int readTrailerWireFormat(InputStream var1, byte[] var2, int var3) throws IOException;
}

