/*
 * File: PerfTest.java
 *
 * Author: Alin Sinpalean
 *
 * Created: Jun 23, 2005
 */
package net.sourceforge.jtds.test;

import java.sql.ResultSet;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * Description of the class; please update this.
 *
 * @author Alin Sinpalean
 * @version $Id: PerfTest.java,v 1.0, 2006-03-15 17:47:22Z, Robert Worsnop$
 */
public class PerfTest extends DatabaseTestCase {
    public PerfTest(String name) {
        super(name);
    }

    public void testMem() throws SQLException {
        Statement stmt = con.createStatement();
        stmt.executeUpdate("CREATE TABLE #Test (x int)");
        stmt.close();

        PreparedStatement pstmt = con.prepareStatement(
                "SELECT * FROM #Test",
                ResultSet.TYPE_SCROLL_SENSITIVE,
                ResultSet.CONCUR_UPDATABLE);
        for (int i = 0; i < 1000; i++) {
            ResultSet rs = pstmt.executeQuery();
            rs.close();
            if (i % 100 == 99) {
                System.out.println(Runtime.getRuntime().totalMemory()
                        + " " + Runtime.getRuntime().freeMemory());
            }
        }
        pstmt.close();
    }
}
