/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import jcifs.Config;
import jcifs.UniAddress;
import jcifs.netbios.NbtAddress;
import jcifs.netbios.NbtException;
import jcifs.netbios.NbtSocket;
import jcifs.smb.AndXServerMessageBlock;
import jcifs.smb.BufferCache;
import jcifs.smb.DfsReferral;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.ServerMessageBlock;
import jcifs.smb.SigningDigest;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbComBlankResponse;
import jcifs.smb.SmbComNegotiate;
import jcifs.smb.SmbComNegotiateResponse;
import jcifs.smb.SmbComTransaction;
import jcifs.smb.SmbComTransactionResponse;
import jcifs.smb.SmbException;
import jcifs.smb.SmbSession;
import jcifs.smb.SmbTree;
import jcifs.smb.Trans2GetDfsReferral;
import jcifs.smb.Trans2GetDfsReferralResponse;
import jcifs.util.Hexdump;
import jcifs.util.LogStream;

class SmbTransport
implements Runnable {
    private static final int DEFAULT_MAX_MPX_COUNT = 10;
    private static final int DEFAULT_RESPONSE_TIMEOUT = 10000;
    private static final int DEFAULT_SO_TIMEOUT = 15000;
    private static final int DEFAULT_RCV_BUF_SIZE = 60416;
    private static final int DEFAULT_SND_BUF_SIZE = 16644;
    private static final int DEFAULT_SSN_LIMIT = 250;
    private static final InetAddress LADDR = Config.getInetAddress("jcifs.smb.client.laddr", null);
    private static final int LPORT = Config.getInt("jcifs.smb.client.lport", 0);
    private static final int SSN_LIMIT = Config.getInt("jcifs.smb.client.ssnLimit", 250);
    private static final int MAX_MPX_COUNT = Config.getInt("jcifs.smb.client.maxMpxCount", 10);
    private static final int SND_BUF_SIZE = Config.getInt("jcifs.smb.client.snd_buf_size", 16644);
    private static final int RCV_BUF_SIZE = Config.getInt("jcifs.smb.client.rcv_buf_size", 60416);
    private static final boolean USE_UNICODE = Config.getBoolean("jcifs.smb.client.useUnicode", true);
    private static final boolean FORCE_UNICODE = Config.getBoolean("jcifs.smb.client.useUnicode", false);
    private static final boolean USE_NTSTATUS = Config.getBoolean("jcifs.smb.client.useNtStatus", true);
    private static final boolean SIGNPREF = Config.getBoolean("jcifs.smb.client.signingPreferred", false);
    private static final boolean USE_NTSMBS = Config.getBoolean("jcifs.smb.client.useNTSmbs", true);
    private static final int DEFAULT_FLAGS2 = 3 | (SIGNPREF ? 4 : 0) | (USE_NTSTATUS ? 16384 : 0) | (USE_UNICODE ? 32768 : 0);
    private static final int DEFAULT_CAPABILITIES = (USE_NTSMBS ? 16 : 0) | (USE_NTSTATUS ? 64 : 0) | (USE_UNICODE ? 4 : 0) | 0x1000;
    private static final int FLAGS2 = Config.getInt("jcifs.smb.client.flags2", DEFAULT_FLAGS2);
    private static final int CAPABILITIES = Config.getInt("jcifs.smb.client.capabilities", DEFAULT_CAPABILITIES);
    private static final int SO_TIMEOUT = Config.getInt("jcifs.smb.client.soTimeout", 15000);
    private static final boolean TCP_NODELAY = Config.getBoolean("jcifs.smb.client.tcpNoDelay", false);
    private static final int RESPONSE_TIMEOUT = Config.getInt("jcifs.smb.client.responseTimeout", 10000);
    private static final int PUSHBACK_BUF_SIZE = 64;
    private static final int MID_OFFSET = 30;
    private static final int FLAGS_RESPONSE = 128;
    private static final int ST_GROUND = 0;
    private static final int ST_NEGOTIATING = 1;
    private static final LinkedList CONNECTIONS = new LinkedList();
    private static final int[] MAGIC = new int[]{255, 83, 77, 66};
    private static byte[] snd_buf = new byte[65535];
    private static byte[] rcv_buf = new byte[65535];
    private NbtSocket socket;
    private HashMap responseTable;
    private InputStream in;
    private OutputStream out;
    private int localPort;
    private InetAddress localAddr;
    private Thread thread;
    private Object outLock;
    private UniAddress address;
    private int port;
    private LinkedList sessions;
    private LinkedList referrals = new LinkedList();
    private int state;
    private Mid[] mids = new Mid[MAX_MPX_COUNT];
    private short mid_next;
    static final String NATIVE_OS = Config.getProperty("jcifs.smb.client.nativeOs", System.getProperty("os.name"));
    static final String NATIVE_LANMAN = Config.getProperty("jcifs.smb.client.nativeLanMan", "jCIFS");
    static final int VC_NUMBER = 1;
    static LogStream log = LogStream.getInstance();
    static final SmbTransport NULL_TRANSPORT = new SmbTransport();
    int flags2 = FLAGS2;
    int maxMpxCount = MAX_MPX_COUNT;
    int snd_buf_size = SND_BUF_SIZE;
    int rcv_buf_size = RCV_BUF_SIZE;
    int capabilities = CAPABILITIES;
    int sessionKey = 0;
    boolean useUnicode = USE_UNICODE;
    String tconHostName;
    ServerData server;
    SigningDigest digest = null;

    static synchronized SmbTransport getSmbTransport(UniAddress address, int port) {
        return SmbTransport.getSmbTransport(address, port, LADDR, LPORT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized SmbTransport getSmbTransport(UniAddress address, int port, InetAddress localAddr, int localPort) {
        SmbTransport conn;
        LinkedList linkedList = CONNECTIONS;
        synchronized (linkedList) {
            if (SSN_LIMIT != 1) {
                ListIterator iter = CONNECTIONS.listIterator();
                while (iter.hasNext()) {
                    conn = (SmbTransport)iter.next();
                    if (!conn.matches(address, port, localAddr, localPort) || SSN_LIMIT != 0 && conn.sessions.size() >= SSN_LIMIT) continue;
                    return conn;
                }
            }
            conn = new SmbTransport(address, port, localAddr, localPort);
            CONNECTIONS.add(0, conn);
        }
        return conn;
    }

    SmbTransport(UniAddress address, int port, InetAddress localAddr, int localPort) {
        this.address = address;
        this.port = port;
        this.localAddr = localAddr;
        this.localPort = localPort;
        this.sessions = new LinkedList();
        this.responseTable = new HashMap();
        this.outLock = new Object();
        this.state = 0;
        for (int i = 0; i < MAX_MPX_COUNT; ++i) {
            this.mids[i] = new Mid();
        }
    }

    SmbTransport() {
    }

    synchronized SmbSession getSmbSession() {
        return this.getSmbSession(new NtlmPasswordAuthentication(null, null, null));
    }

    synchronized SmbSession getSmbSession(NtlmPasswordAuthentication auth) {
        SmbSession ssn;
        ListIterator iter = this.sessions.listIterator();
        while (iter.hasNext()) {
            ssn = (SmbSession)iter.next();
            if (!ssn.matches(auth)) continue;
            ssn.auth = auth;
            return ssn;
        }
        ssn = new SmbSession(this.address, this.port, this.localAddr, this.localPort, auth);
        ssn.transport = this;
        this.sessions.add(ssn);
        return ssn;
    }

    boolean matches(UniAddress address, int port, InetAddress localAddr, int localPort) {
        InetAddress defaultLocal = null;
        try {
            defaultLocal = InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        int p1 = port == 0 || port == 139 ? 0 : port;
        int p2 = this.port == 0 || this.port == 139 ? 0 : this.port;
        InetAddress la1 = localAddr == null ? defaultLocal : localAddr;
        InetAddress la2 = this.localAddr == null ? defaultLocal : this.localAddr;
        return address.equals(this.address) && p1 == p2 && la1.equals(la2) && localPort == this.localPort;
    }

    boolean hasCapability(int cap) throws SmbException {
        if (this.state == 0) {
            this.negotiate();
        }
        return (this.capabilities & cap) == cap;
    }

    boolean isSignatureSetupRequired(NtlmPasswordAuthentication auth) {
        return (this.flags2 & 4) != 0 && this.digest == null && auth != NtlmPasswordAuthentication.NULL && !NtlmPasswordAuthentication.NULL.equals(auth);
    }

    void ensureOpen() throws IOException {
        if (this.socket == null) {
            NbtAddress naddr;
            Object obj = this.address.getAddress();
            if (obj instanceof NbtAddress) {
                naddr = (NbtAddress)obj;
            } else {
                try {
                    naddr = NbtAddress.getByName(((InetAddress)obj).getHostAddress());
                }
                catch (UnknownHostException uhe) {
                    naddr = null;
                }
            }
            String calledName = this.address.firstCalledName();
            while (true) {
                try {
                    this.socket = new NbtSocket(naddr, calledName, this.port, this.localAddr, this.localPort);
                }
                catch (NbtException ne) {
                    if (ne.errorClass == 2 && (ne.errorCode == 130 || ne.errorCode == 128)) {
                        if (LogStream.level <= 2) continue;
                        ne.printStackTrace(log);
                        continue;
                    }
                    throw ne;
                    if ((calledName = this.address.nextCalledName()) != null) continue;
                }
                break;
            }
            if (calledName == null) {
                throw new IOException("Failed to establish session with " + this.address);
            }
            this.tconHostName = calledName == "*SMBSERVER     " ? this.address.getHostAddress() : calledName;
            if (TCP_NODELAY) {
                this.socket.setTcpNoDelay(true);
            }
            this.in = new PushbackInputStream(this.socket.getInputStream(), 64);
            this.out = this.socket.getOutputStream();
            this.thread = new Thread((Runnable)this, "JCIFS-SmbTransport");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryClose(boolean inError) {
        if (this.socket == null) {
            inError = true;
        }
        ListIterator iter = this.sessions.listIterator();
        while (iter.hasNext()) {
            SmbSession ssn = (SmbSession)iter.next();
            ssn.logoff(inError);
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        this.digest = null;
        this.in = null;
        this.out = null;
        this.socket = null;
        this.thread = null;
        this.responseTable.clear();
        this.referrals.clear();
        this.sessions.clear();
        LinkedList linkedList = CONNECTIONS;
        synchronized (linkedList) {
            CONNECTIONS.remove(this);
        }
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        Mid mid = new Mid();
        while (this.thread == Thread.currentThread()) {
            Object object;
            try {
                block42: {
                    block38: {
                        ServerMessageBlock response;
                        block43: {
                            Enumeration e;
                            block45: {
                                int nbtlen;
                                int m;
                                block46: {
                                    block44: {
                                        block41: {
                                            block40: {
                                                this.socket.setSoTimeout(SO_TIMEOUT);
                                                m = 0;
                                                while (m < 4) {
                                                    int i = this.in.read();
                                                    if (i < 0) {
                                                        return;
                                                    }
                                                    if ((i & 0xFF) == MAGIC[m]) {
                                                        ++m;
                                                        continue;
                                                    }
                                                    if ((i & 0xFF) == 255) {
                                                        m = 1;
                                                        continue;
                                                    }
                                                    m = 0;
                                                }
                                                nbtlen = 4 + this.in.available();
                                                byte[] byArray = rcv_buf;
                                                // MONITORENTER : rcv_buf
                                                SmbTransport.rcv_buf[0] = -1;
                                                SmbTransport.rcv_buf[1] = 83;
                                                SmbTransport.rcv_buf[2] = 77;
                                                SmbTransport.rcv_buf[3] = 66;
                                                if (this.in.read(rcv_buf, 4, 28) != 28) {
                                                    // MONITOREXIT : byArray
                                                    return;
                                                }
                                                ((PushbackInputStream)this.in).unread(rcv_buf, 0, 32);
                                                if (rcv_buf[0] != -1 || rcv_buf[1] != 83 || rcv_buf[2] != 77) break block40;
                                                if (rcv_buf[3] == 66) break block41;
                                            }
                                            if (LogStream.level > 1) {
                                                log.println("bad smb header, purging session message: " + this.address);
                                            }
                                            this.in.skip(this.in.available());
                                            // MONITOREXIT : byArray
                                            continue;
                                        }
                                        if ((rcv_buf[9] & 0x80) != 128) break block42;
                                        mid.mid = (short)(ServerMessageBlock.readInt2(rcv_buf, 30) & 0xFFFF);
                                        response = (ServerMessageBlock)this.responseTable.get(mid);
                                        if (response == null) {
                                            if (LogStream.level > 1) {
                                                log.println("no handler for mid=" + mid.mid + ", purging session message: " + this.address);
                                            }
                                            this.in.skip(this.in.available());
                                            // MONITOREXIT : byArray
                                            continue;
                                        }
                                        object = response;
                                        // MONITORENTER : object
                                        response.useUnicode = this.useUnicode;
                                        if (LogStream.level > 2) {
                                            log.println("new data read from socket: " + this.address);
                                        }
                                        if (!(response instanceof SmbComTransactionResponse)) break block43;
                                        e = (Enumeration)((Object)response);
                                        if (!e.hasMoreElements()) break block44;
                                        e.nextElement();
                                        m = response.readWireFormat(this.in, rcv_buf, 0);
                                        if (m == nbtlen) break block45;
                                        break block46;
                                    }
                                    if (LogStream.level > 2) {
                                        log.println("more responses to transaction than expected");
                                    }
                                    // MONITOREXIT : object
                                    // MONITOREXIT : byArray
                                    continue;
                                }
                                if (LogStream.level > 1) {
                                    log.println("decoded " + m + " but nbtlen=" + nbtlen + ", purging session message");
                                }
                                this.in.skip(this.in.available());
                            }
                            response.received = true;
                            if (LogStream.level > 2) {
                                log.println(response);
                            }
                            if (response.errorCode != 0 || !e.hasMoreElements()) {
                                ((SmbComTransactionResponse)response).hasMore = false;
                                if (this.digest != null) {
                                    Object object2 = this.outLock;
                                    // MONITORENTER : object2
                                    this.digest.verify(rcv_buf, 0, response);
                                    // MONITOREXIT : object2
                                }
                                response.notify();
                                break block38;
                            } else {
                                this.ensureOpen();
                            }
                            break block38;
                        }
                        response.readWireFormat(this.in, rcv_buf, 0);
                        response.received = true;
                        if (LogStream.level > 2) {
                            ServerMessageBlock smb = response;
                            do {
                                log.println(smb);
                                if (!(smb instanceof AndXServerMessageBlock)) break;
                            } while ((smb = ((AndXServerMessageBlock)smb).andx) != null);
                            if (LogStream.level > 5) {
                                Hexdump.hexdump(log, rcv_buf, 0, Math.min(response.length, 1024));
                            }
                        }
                        if (this.digest != null) {
                            Object object3 = this.outLock;
                            // MONITORENTER : object3
                            this.digest.verify(rcv_buf, 0, response);
                            // MONITOREXIT : object3
                        }
                        response.notify();
                    }
                    // MONITOREXIT : object
                }
                // MONITOREXIT : byArray
            }
            catch (InterruptedIOException iioe) {
                if (this.responseTable.size() == 0) {
                    this.tryClose(false);
                    continue;
                }
                if (LogStream.level <= 1) continue;
                log.println("soTimeout has occured but there are " + this.responseTable.size() + " pending requests");
            }
            catch (IOException ioe) {
                object = this;
                // MONITORENTER : object
                this.tryClose(true);
                // MONITOREXIT : object
                if (LogStream.level <= 0 || ioe.getMessage().startsWith("Connection reset")) continue;
                log.println(ioe.getMessage() + ": " + this.address);
                ioe.printStackTrace(log);
            }
        }
    }

    synchronized DfsReferral getDfsReferral(NtlmPasswordAuthentication auth, String path) throws SmbException {
        int s;
        int p;
        int i;
        DfsReferral dr = new DfsReferral();
        SmbTree ipc = this.getSmbSession(auth).getSmbTree("IPC$", null);
        Trans2GetDfsReferralResponse resp = new Trans2GetDfsReferralResponse();
        ipc.sendTransaction(new Trans2GetDfsReferral(path), resp);
        String subpath = path.substring(0, resp.pathConsumed);
        String node = resp.referral.node;
        if (subpath.charAt(0) != '\\' || (i = subpath.indexOf(92, 1)) < 2 || (p = subpath.indexOf(92, i + 1)) < i + 2 || node.charAt(0) != '\\' || (s = node.indexOf(92, 1)) < 2) {
            throw new SmbException("Invalid DFS path: " + path);
        }
        int n = node.indexOf(92, s + 1);
        if (n == -1) {
            n = node.length();
        }
        dr.path = subpath.substring(p);
        dr.node = node.substring(0, n);
        dr.nodepath = node.substring(n);
        dr.server = node.substring(1, s);
        dr.share = node.substring(s + 1, n);
        dr.resolveHashes = auth.hashesExternal;
        return dr;
    }

    synchronized DfsReferral lookupReferral(String unc) {
        ListIterator iter = this.referrals.listIterator();
        while (iter.hasNext()) {
            int i;
            DfsReferral dr = (DfsReferral)iter.next();
            int len = dr.path.length();
            for (i = 0; i < len && i < unc.length() && dr.path.charAt(i) == unc.charAt(i); ++i) {
            }
            if (i != len || len != unc.length() && unc.charAt(len) != '\\') continue;
            return dr;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void send(ServerMessageBlock request, ServerMessageBlock response) throws SmbException {
        block43: {
            Mid mid = null;
            if (this.state == 0) {
                this.negotiate();
            }
            request.flags2 |= this.flags2;
            request.useUnicode = this.useUnicode;
            if (response == null) {
                Object object = this.outLock;
                // MONITORENTER : object
                try {
                    mid = this.aquireMid();
                    request.mid = mid.mid;
                    this.ensureOpen();
                    byte[] byArray = snd_buf;
                    // MONITORENTER : snd_buf
                    request.digest = this.digest;
                    request.response = null;
                    int length = request.writeWireFormat(snd_buf, 4);
                    this.out.write(snd_buf, 4, length);
                    this.out.flush();
                    if (LogStream.level > 2) {
                        ServerMessageBlock smb = request;
                        do {
                            log.println(smb);
                            if (!(smb instanceof AndXServerMessageBlock)) break;
                        } while ((smb = ((AndXServerMessageBlock)smb).andx) != null);
                        if (LogStream.level > 5) {
                            Hexdump.hexdump(log, snd_buf, 0, Math.min(request.length, 1024));
                        }
                    }
                    // MONITOREXIT : byArray
                    return;
                }
                catch (IOException ioe) {
                    this.tryClose(true);
                    throw new SmbException("An error occured sending the request.", (Throwable)ioe);
                }
                finally {
                    this.releaseMid(mid);
                }
            }
            ServerMessageBlock serverMessageBlock = response;
            // MONITORENTER : serverMessageBlock
            try {
                try {
                    Object ioe = this.outLock;
                    // MONITORENTER : ioe
                    response.received = false;
                    mid = this.aquireMid();
                    request.mid = mid.mid;
                    this.responseTable.put(mid, response);
                    this.ensureOpen();
                    byte[] byArray = snd_buf;
                    // MONITORENTER : snd_buf
                    if (this.digest != null) {
                        request.digest = this.digest;
                        request.response = response;
                    }
                    int length = request.writeWireFormat(snd_buf, 4);
                    this.out.write(snd_buf, 4, length);
                    this.out.flush();
                    if (LogStream.level > 2) {
                        ServerMessageBlock smb = request;
                        do {
                            log.println(smb);
                            if (!(smb instanceof AndXServerMessageBlock)) break;
                        } while ((smb = ((AndXServerMessageBlock)smb).andx) != null);
                        if (LogStream.level > 5) {
                            Hexdump.hexdump(log, snd_buf, 0, request.length);
                        }
                    }
                    // MONITOREXIT : byArray
                    // MONITOREXIT : ioe
                    response.wait(response.responseTimeout == 1L ? (long)RESPONSE_TIMEOUT : response.responseTimeout);
                }
                catch (InterruptedException ie) {
                    this.tryClose(true);
                    Object var14_18 = null;
                    this.responseTable.remove(mid);
                    Object object = this.outLock;
                    // MONITORENTER : object
                    this.releaseMid(mid);
                    // MONITOREXIT : object
                    break block43;
                }
                catch (IOException ioe) {
                    this.tryClose(true);
                    throw new SmbException("An error occured sending the request.", (Throwable)ioe);
                }
                Object var14_17 = null;
                this.responseTable.remove(mid);
                Object object = this.outLock;
                // MONITORENTER : object
                this.releaseMid(mid);
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                this.responseTable.remove(mid);
                Object object = this.outLock;
                // MONITORENTER : object
                this.releaseMid(mid);
                // MONITOREXIT : object
                throw throwable;
            }
        }
        // MONITOREXIT : serverMessageBlock
        if (!response.received) {
            this.tryClose(true);
            throw new SmbException("Timeout waiting for response from server: " + this.address);
        }
        if (response.verifyFailed) {
            this.tryClose(true);
            throw new SmbException("Unverifiable signature: " + this.address);
        }
        response.errorCode = SmbException.getStatusByCode(response.errorCode);
        switch (response.errorCode) {
            case 0: {
                return;
            }
            case -1073741790: 
            case -1073741718: 
            case -1073741715: 
            case -1073741714: 
            case -1073741713: 
            case -1073741712: 
            case -1073741711: 
            case -1073741710: 
            case -1073741260: {
                throw new SmbAuthException(response.errorCode);
            }
            case -1073741225: {
                if (request.auth == null) {
                    throw new SmbException(response.errorCode, null);
                }
                DfsReferral dr = this.getDfsReferral(request.auth, request.path);
                this.referrals.add(dr);
                throw dr;
            }
        }
        throw new SmbException(response.errorCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void sendTransaction(SmbComTransaction request, SmbComTransactionResponse response) throws SmbException {
        Mid mid = null;
        this.negotiate();
        request.flags2 |= this.flags2;
        request.useUnicode = this.useUnicode;
        request.maxBufferSize = this.snd_buf_size;
        response.received = false;
        response.hasMore = true;
        response.isPrimary = true;
        try {
            Object object;
            Object object2;
            ServerMessageBlock interimResponse;
            request.txn_buf = BufferCache.getBuffer();
            response.txn_buf = BufferCache.getBuffer();
            request.nextElement();
            if (request.hasMoreElements()) {
                interimResponse = new SmbComBlankResponse();
                object2 = interimResponse;
                // MONITORENTER : object2
                try {
                    object = this.outLock;
                    // MONITORENTER : object
                    mid = this.aquireMid();
                    request.mid = mid.mid;
                    this.responseTable.put(mid, interimResponse);
                    this.ensureOpen();
                    byte[] byArray = snd_buf;
                    // MONITORENTER : snd_buf
                    request.digest = this.digest;
                    request.response = response;
                    int length = request.writeWireFormat(snd_buf, 4);
                    this.out.write(snd_buf, 4, length);
                    this.out.flush();
                    if (LogStream.level > 2) {
                        log.println(request);
                        if (LogStream.level > 5) {
                            Hexdump.hexdump(log, snd_buf, 0, request.length);
                        }
                    }
                    // MONITOREXIT : byArray
                    // MONITOREXIT : object
                    interimResponse.wait(RESPONSE_TIMEOUT);
                    if (!((SmbComBlankResponse)interimResponse).received) {
                        throw new SmbException("Timeout waiting for response from server: " + this.address);
                    }
                    ((SmbComBlankResponse)interimResponse).errorCode = SmbException.getStatusByCode(((SmbComBlankResponse)interimResponse).errorCode);
                    switch (((SmbComBlankResponse)interimResponse).errorCode) {
                        case 0: {
                            break;
                        }
                        case -1073741790: 
                        case -1073741718: 
                        case -1073741715: 
                        case -1073741714: 
                        case -1073741713: 
                        case -1073741712: 
                        case -1073741711: 
                        case -1073741710: 
                        case -1073741260: {
                            throw new SmbAuthException(((SmbComBlankResponse)interimResponse).errorCode);
                        }
                        case -1073741225: {
                            if (request.auth == null) {
                                throw new SmbException(((SmbComBlankResponse)interimResponse).errorCode, null);
                            }
                            DfsReferral dr = this.getDfsReferral(request.auth, request.path);
                            this.referrals.add(dr);
                            throw dr;
                        }
                        default: {
                            throw new SmbException(((SmbComBlankResponse)interimResponse).errorCode, null);
                        }
                    }
                    Object var12_12 = null;
                    this.responseTable.remove(mid);
                    Object object3 = this.outLock;
                    // MONITORENTER : object3
                    this.releaseMid(mid);
                    // MONITOREXIT : object3
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    this.responseTable.remove(mid);
                    Object object4 = this.outLock;
                    // MONITORENTER : object4
                    this.releaseMid(mid);
                    // MONITOREXIT : object4
                    throw throwable;
                }
                request.nextElement();
            }
            interimResponse = response;
            // MONITORENTER : interimResponse
            try {
                object2 = this.outLock;
                // MONITORENTER : object2
                mid = this.aquireMid();
                request.mid = mid.mid;
                this.responseTable.put(mid, response);
                do {
                    this.ensureOpen();
                    object = snd_buf;
                    // MONITORENTER : snd_buf
                    request.digest = this.digest;
                    request.response = response;
                    int length = request.writeWireFormat(snd_buf, 4);
                    this.out.write(snd_buf, 4, length);
                    this.out.flush();
                    if (LogStream.level > 2) {
                        log.println(request);
                        if (LogStream.level > 5) {
                            Hexdump.hexdump(log, snd_buf, 0, request.length);
                        }
                    }
                    // MONITOREXIT : object
                } while (request.hasMoreElements() && request.nextElement() != null);
                // MONITOREXIT : object2
                do {
                    response.received = false;
                    response.wait(response.responseTimeout == 1L ? (long)RESPONSE_TIMEOUT : response.responseTimeout);
                    if (!response.received) break;
                } while (response.hasMoreElements());
                Object var19_17 = null;
                this.responseTable.remove(mid);
                Object object5 = this.outLock;
                // MONITORENTER : object5
                this.releaseMid(mid);
                // MONITOREXIT : object5
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                this.responseTable.remove(mid);
                Object object6 = this.outLock;
                // MONITORENTER : object6
                this.releaseMid(mid);
                // MONITOREXIT : object6
                throw throwable;
            }
        }
        catch (InterruptedException ie) {
            this.tryClose(true);
        }
        catch (IOException ioe) {
            this.tryClose(true);
            throw new SmbException("An error occured sending the request.", (Throwable)ioe);
        }
        finally {
            BufferCache.releaseBuffer(request.txn_buf);
            BufferCache.releaseBuffer(response.txn_buf);
        }
        if (!response.received) {
            this.tryClose(true);
            throw new SmbException("Timeout waiting for response from server: " + this.address);
        }
        if (response.verifyFailed) {
            this.tryClose(true);
            throw new SmbException("Unverifiable signature: " + this.address);
        }
        response.errorCode = SmbException.getStatusByCode(response.errorCode);
        switch (response.errorCode) {
            case 0: {
                return;
            }
            case -1073741790: 
            case -1073741718: 
            case -1073741715: 
            case -1073741714: 
            case -1073741713: 
            case -1073741712: 
            case -1073741711: 
            case -1073741710: 
            case -1073741260: {
                throw new SmbAuthException(response.errorCode);
            }
            case -1073741225: {
                if (request.auth == null) {
                    throw new SmbException(response.errorCode, null);
                }
                DfsReferral dr = this.getDfsReferral(request.auth, request.path);
                this.referrals.add(dr);
                throw dr;
            }
        }
        throw new SmbException(response.errorCode, null);
    }

    synchronized void negotiate() throws SmbException {
        if (this == NULL_TRANSPORT) {
            throw new RuntimeException("Null transport cannot be used");
        }
        if (this.state >= 1) {
            return;
        }
        this.state = 1;
        if (LogStream.level > 2) {
            log.println("requesting negotiation with " + this.address);
        }
        SmbComNegotiateResponse response = new SmbComNegotiateResponse();
        this.send(new SmbComNegotiate(), response);
        if (response.dialectIndex > 10) {
            this.tryClose(true);
            throw new SmbException("This client does not support the negotiated dialect.");
        }
        this.server = new ServerData();
        this.server.securityMode = response.securityMode;
        this.server.security = response.security;
        this.server.encryptedPasswords = response.encryptedPasswords;
        this.server.signaturesEnabled = response.signaturesEnabled;
        this.server.signaturesRequired = response.signaturesRequired;
        this.server.maxMpxCount = response.maxMpxCount;
        this.server.maxNumberVcs = response.maxNumberVcs;
        this.server.maxBufferSize = response.maxBufferSize;
        this.server.maxRawSize = response.maxRawSize;
        this.server.sessionKey = response.sessionKey;
        this.server.capabilities = response.capabilities;
        this.server.serverTime = response.serverTime;
        this.server.serverTimeZone = response.serverTimeZone;
        this.server.encryptionKeyLength = response.encryptionKeyLength;
        this.server.encryptionKey = response.encryptionKey;
        this.server.oemDomainName = response.oemDomainName;
        this.flags2 = this.server.signaturesRequired || this.server.signaturesEnabled && SIGNPREF ? (this.flags2 |= 4) : (this.flags2 &= 0xFFFB);
        this.maxMpxCount = this.maxMpxCount < this.server.maxMpxCount ? this.maxMpxCount : this.server.maxMpxCount;
        this.maxMpxCount = this.maxMpxCount < 1 ? 1 : this.maxMpxCount;
        this.snd_buf_size = this.snd_buf_size < this.server.maxBufferSize ? this.snd_buf_size : this.server.maxBufferSize;
        this.capabilities &= this.server.capabilities;
        if ((this.capabilities & 4) == 0) {
            if (FORCE_UNICODE) {
                this.capabilities |= 4;
            } else {
                this.useUnicode = false;
                this.flags2 &= Short.MAX_VALUE;
            }
        }
    }

    public String toString() {
        String ret = "SmbTransport[address=" + this.address;
        ret = this.socket == null ? ret + ",port=,localAddr=,localPort=]" : ret + ",port=" + this.socket.getPort() + ",localAddr=" + this.socket.getLocalAddress() + ",localPort=" + this.socket.getLocalPort() + "]";
        return ret;
    }

    Mid aquireMid() throws SmbException {
        int i;
        if (this.mid_next == 0) {
            this.mid_next = (short)(this.mid_next + 1);
        }
        while (true) {
            for (i = 0; i < this.maxMpxCount && this.mids[i].mid != 0; ++i) {
            }
            if (i != this.maxMpxCount) break;
            try {
                this.outLock.wait();
            }
            catch (InterruptedException ie) {
                throw new SmbException("Interrupted aquiring mid", (Throwable)ie);
            }
        }
        short s = this.mid_next;
        this.mid_next = (short)(s + 1);
        this.mids[i].mid = s;
        return this.mids[i];
    }

    void releaseMid(Mid mid) {
        for (int i = 0; i < this.maxMpxCount; ++i) {
            if (this.mids[i].mid != mid.mid) continue;
            mid.mid = 0;
            this.outLock.notify();
            return;
        }
        if (LogStream.level > 1) {
            log.println("mid not found");
        }
    }

    class ServerData {
        byte flags;
        int flags2;
        int maxMpxCount;
        int maxBufferSize;
        int sessionKey;
        int capabilities;
        String oemDomainName;
        int securityMode;
        int security;
        boolean encryptedPasswords;
        boolean signaturesEnabled;
        boolean signaturesRequired;
        int maxNumberVcs;
        int maxRawSize;
        long serverTime;
        int serverTimeZone;
        int encryptionKeyLength;
        byte[] encryptionKey;

        ServerData() {
        }
    }

    class Mid {
        short mid;

        Mid() {
        }

        public int hashCode() {
            return this.mid;
        }

        public boolean equals(Object obj) {
            return ((Mid)obj).mid == this.mid;
        }
    }
}

