/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import jcifs.smb.SmbFile;

public class Handler
extends URLStreamHandler {
    static final URLStreamHandler SMB_HANDLER = new Handler();

    static String unescape(String str) throws NumberFormatException, UnsupportedEncodingException {
        byte[] b = new byte[1];
        if (str == null) {
            return null;
        }
        int len = str.length();
        char[] out = new char[len];
        int state = 0;
        int j = 0;
        block4: for (int i = 0; i < len; ++i) {
            switch (state) {
                case 0: {
                    char ch = str.charAt(i);
                    if (ch == '%') {
                        state = 1;
                        continue block4;
                    }
                    out[j++] = ch;
                    continue block4;
                }
                case 1: {
                    b[0] = (byte)(Integer.parseInt(str.substring(i, i + 2), 16) & 0xFF);
                    out[j++] = new String(b, 0, 1, "ASCII").charAt(0);
                    ++i;
                    state = 0;
                }
            }
        }
        return new String(out, 0, j);
    }

    protected int getDefaultPort() {
        return 139;
    }

    public URLConnection openConnection(URL u) throws IOException {
        return new SmbFile(u);
    }

    protected void parseURL(URL u, String spec, int start, int limit) {
        int port;
        String host = u.getHost();
        if (spec.equals("smb://")) {
            spec = "smb:////";
            limit += 2;
        } else if (!spec.startsWith("smb://") && host != null && host.length() == 0) {
            spec = "//" + spec;
            limit += 2;
        }
        super.parseURL(u, spec, start, limit);
        String userinfo = u.getUserInfo();
        String path = u.getPath();
        String ref = u.getRef();
        try {
            userinfo = Handler.unescape(userinfo);
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        if (ref != null) {
            path = path + '#' + ref;
        }
        if ((port = u.getPort()) == -1) {
            port = this.getDefaultPort();
        }
        this.setURL(u, "smb://", u.getHost(), port, u.getAuthority(), userinfo, path, u.getQuery(), null);
    }
}

