.if n .ds Q \&"
.if t .ds Q ``
.if n .ds U \&"
.if t .ds U ''
.TH "gv" 1 
.tr \&
.nr bi 0
.nr ll 0
.nr el 0
.de DS
..
.de DE
..
.de Pp
.ie \\n(ll>0 \{\
.ie \\n(bi=1 \{\
.nr bi 0
.if \\n(t\\n(ll=0 \{.IP \\(bu\}
.if \\n(t\\n(ll=1 \{.IP \\n+(e\\n(el.\}
.\}
.el .sp 
.\}
.el \{\
.ie \\nh=1 \{\
.LP
.nr h 0
.\}
.el .PP 
.\}
..
.SH \fBSynopsis\fP 

.Pp
.DS
.sp 
.ft CR
.nf
gv [ filename ]
   [-monochrome] [-grayscale] [-color]
   [-resolution <dpi>] [-dpi <dpi>]
   [-xdpi <dpi>] [-ydpi <dpi>]
   [-[no]safer] [-[no]quiet] [-arguments <arguments>]
   [-page <label>] [-[no]center]
   [-letter] [-tabloid] [-ledger] [-legal] [-folio]
   [-a0] [-a1] [-a2] [-a3] [-a4] [-a5] [-b4] [-b5]
   [-quarto] [-10x14] [-statement] [-executive]
   [-portrait] [-landscape] [-upsidedown] [-seascape]
   [-magstep <n>]
   [-swap] [-noswap]
   [-antialias] [-noantialias]
   [-dsc] [-nodsc]
   [-eof] [-noeof]
   [-watch] [-nowatch]
   [-?] [-h] [-help]
   [-resize] [-noresize]
   [-geometry [<width>][x<height>][{+-}<xoffset>{+-}<yoffset>]
   [-ad <resource file>]
   [-style <resource file>]
   [<other toolkit options>]
.DE
.fi 
.ec
.ft P
.sp

.SH \fBDescription\fP 

.Pp
.Pp
gv allows to view and navigate through
PostScript and PDF documents on an X display
by providing a user interface for the ghostscript interpreter.
.Pp
Please note that gv is derived from Tim Theisen's
ghostview 1.5.
.Pp
.SH \fBOptions\fP 

.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-ad <resource file>\fP"
.nr bi 1
.Pp
Read and use additional resources from the file
<resource file>.
These resources have higher priority than those provided
in the context of the -style <resource file> option.
.IP "\fB-antialias\fP, \fB-noantialias\fP"
.nr bi 1
.Pp
Whether to use antialiasing.
.IP "\fB-arguments <arguments>\fP"
.nr bi 1
.Pp
Start ghostscript with additional options as specified by the
string <arguments>.
.IP "\fB-center\fP, \fB-nocenter\fP"
.nr bi 1
.Pp
Whether the page should be centered automatically.
.IP "\fB-dpi <dpi>\fP, \fB-resolution <dpi>\fP"
.nr bi 1
.Pp
Sets the resolution to <dpi> dots per inch.
.IP "\fB-dsc\fP, \fB-nodsc\fP"
.nr bi 1
.Pp
Determines if document structuring convention (DSC) comments
should be respected or ignored.
If -nodsc is used gv will not attempt to examine
the structure of the document but will pass the file
to the ghostscript interpreter as a whole. In this case no page numbers
are shown and freely moving around in the document is not possible.
This option may help when viewing files not conforming
to the document structuring conventions.
.IP "\fB-eof\fP, \fB-noeof\fP"
.nr bi 1
.Pp
Defines the behaviour of the postscript scanner used to
examine the structure of the document.
If -noeof is used the scanner will ignore end of file (EOF)
comments. This may help when viewing documents which import other
documents without enclosing them within the proper
"BeginDocument" and "EndDocument" comments.
If -eof is used, the scanner treats an EOF comment as
marking the end of the file.
.IP "\fB-h\fP, \fB-?\fP "
.nr bi 1
.Pp
Display a short help message and exit.
.IP "\fB-help\fP"
.nr bi 1
.Pp
Display a more explicit help message and exit.
.IP "\fB-magstep <n>\fP"
.nr bi 1
.Pp
Sets the magstep to <n>. <n> must be an integer 
in the range of allowed magsteps.
.IP "\fB-monochrome\fP, \fB-grayscale\fP, \fB-color\fP"
.nr bi 1
.Pp
Sets the color palette to be used.
.IP "\fB-page <label>\fP"
.nr bi 1
.Pp
Display the page with label <label> first.
.IP "\fB-<paper-size>\fP"
.nr bi 1
.Pp
Sets the paper-size. Valid values for <paper-size> are:
.DS
.sp 
.ft CR
.nf
   Paper Size  X (pts)  Y (pts)   X cm    Y cm
   -------------------------------------------
   letter        612      792    21.59   27.94
   tabloid       792     1224    27.94   43.18
   ledger       1224      792    43.18   27.94
   legal         612     1008    21.59   35.56
   statement     396      612    13.97   21.59
   executive     540      720    19.05   25.40
   a0           2384     3371    84.09  118.92
   a1           1685     2384    59.46   84.09
   a2           1192     1685    42.04   59.46
   a3            843     1192    29.73   42.04
   a4            596      843    21.02   29.73
   a5            421      596    14.87   21.02
   b4            729     1032    25.01   35.35
   b5            516      729    17.67   25.01
   folio         612      936    21.59   33.02
   quarto        610      780    21.52   27.52
   10x14         720     1008    25.40   35.56
   
.DE
.fi 
.ec
.ft P
.sp
.IP "\fB-portrait\fP, \fB-landscape\fP, \fB-seascape\fP, \fB-upsidedown\fP"
.nr bi 1
.Pp
Sets the orientation.
.IP "\fB-quiet\fP, \fB-noquiet\fP"
.nr bi 1
.Pp
Whether to start ghostscript with the -dQUIET option.
.IP "\fB-resize\fP, \fB-noresize\fP"
.nr bi 1
.Pp
Whether gv is allowed to automatically fit the
size of its window to the size of the displayed page.
.IP "\fB-safer\fP, \fB-nosafer\fP"
.nr bi 1
.Pp
Whether to start ghostscript with the -dSAFER option.
.IP "\fB-style <resource file>\fP"
.nr bi 1
.Pp
Read and use additional resources from the file <resource file>.
These resources have  lower priority than those provided
in the context of the -ad <resource file> option.
.IP "\fB-swap\fP, \fB-noswap\fP"
.nr bi 1
.Pp
Whether to interchange the meaning of the orientations
landscape and seascape.
.IP "\fB-watch\fP, \fB-nowatch\fP"
.nr bi 1
.Pp
The -watch option causes gv to check the document
periodically. If changes are detected gv will
automatically display the newer version of the file.
The document is by default checked once every second. 
This can be changed via the watchFileFrequency resource.
Note that sending gv the SIGHUP signal also causes
an update of the displayed document. This method
may be used by document creators to trigger gv
remotely.
.IP "\fB-xdpi <dpi>\fP, \fB-ydpi <dpi>\fP"
.nr bi 1
.Pp
Sets the horizontal, vertical resolution to <dpi> dots
per inch. 
.if \n(ll>1 .RE
.nr ll -1

.SH \fBResources\fP 

.Pp
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fBResource files\fP"
.nr bi 1
.Pp
When starting gv, preferences are read from
.nr ll +1
.nr t\n(ll 0
.if \n(ll>1 .RS
.nr bi 1
.Pp
\fBa system specific resource file\fP
(on some systems this is 
\*Q/etc/X11/app-defaults/GV\*U).
Administrators may want to modify this file in order
to set up gv according to the local needs of their system.
A copy of this file (\*QGV.ad\*U) may also be found in the
library directory of gv (which is most probably either 
\*Q/usr/local/lib/gv/\*U or \*Q/usr/lib/gv/\*U).
.nr bi 1
.Pp
\fB\*Q~/.gv\*U\fP.
This file is not required but it may express the user's preferences.
Users may want to use \*QGV.user.ad\*U (to be found in the library
directory of gv) as a template for this file.
.if \n(ll>1 .RE
.nr ll -1

These two files are not the only sources of preferences
taken into account when gv is started. However, in practice
these are the most important.
.Pp
.if \n(ll>1 .RE
.nr ll -1

.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fBGeneral resources of gv\fP"
.nr bi 1
.Pp
.DS
.sp 
.ft CR
.nf
Name                  Class      Default Value
----------------------------------------------
antialias             Boolean    False
autoCenter            Boolean    True
autoResize            Boolean    True
confirmPrint          Boolean    True
confirmQuit           int        1
ignoreEOF             Boolean    True
respectDSC            Boolean    True
reverseScrolling      Boolean    False
swapLandscape         Boolean    False
scratchDir            String     ~/
defaultSaveDir        String     ~/
watchFile             Boolean    False
watchFileFrequency    int        1000
dirs                  String     see below
filter                String     see below
filters               String     see below
maximumWidth          String     screen-20
maximumHeight         String     screen-44
minimumWidth          int        400
minimumHeight         int        400
magstep               int        0
minimumMagstep        int        -7
maximumMagstep        int        7
orientation           String     automatic
fallbackOrientation   String     portrait
pageMedia             String     automatic
fallbackPageMedia     String     a4
.DE
.fi 
.ec
.ft P
.sp

.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "antialias"
.nr bi 1
.Pp
Whether antialiasing should be used.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "autoCenter"
.nr bi 1
.Pp
Whether the displayed page should automatically be centered 
(for instance when opening a new file).
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "autoResize"
.nr bi 1
.Pp
Whether gv is allowed to resize the main window
according to the size of the current page.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "confirmPrint"
.nr bi 1
.Pp
Whether printing requires an extra confirmation.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "confirmQuit"
.nr bi 1
.Pp
Whether leaving gv requires extra confirmation.
Valid values are \*Q0\*U (Never), \*Q1\*U
(When processing) and \*Q2\*U (Always).
The default value is \*Q1\*U, which causes
a confirmation request when trying to leave gv
in the presence of pending PDF to Postscript conversions.
.IP "ignoreEOF"
.nr bi 1
.Pp
Defines the behaviour of the postscript scanner as described
in the Options section.
Valid values are \*QTrue\*U and \*QFalse\*U.   
.IP "respectDSC"
.nr bi 1
.Pp
Determines whether gv should attempt to respect document 
structuring comments.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "reverseScrolling"
.nr bi 1
.Pp
Defines the interpretation of directions when
scrolling with the mouse.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "swapLandscape"
.nr bi 1
.Pp
Whether the meaning of \*Qlandscape\*U and \*Qseacape\*U
should be interchanged.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "scratchDir"
.nr bi 1
.Pp
Specifies a directory used to store temporary data.
.IP "defaultSaveDir"
.nr bi 1
.Pp
Specifies the default destination directory for files to be saved.
.IP "watchFile"
.nr bi 1
.Pp
Whether the document should be checked periodically and updated
automatically if  changes are detected.
Valid values are \*QTrue\*U and \*QFalse\*U.
.IP "watchFileFrequency"
.nr bi 1
.Pp
Defines the time in milliseconds elapsing between successive
checks of the document when watchFile is set to \*QTrue\*U.
Allowed values must be larger than 500.
.IP "dirs"
.nr bi 1
.Pp
Defines a list of directories accessible via the Directories
menu in the file selection window.
Example:
.Pp
.DS
.sp 
.ft CR
.nf
   GV*dirs:\\n\\ 
   Home\\n\\ 
   Tmp\\n\\ 
   /usr/doc\\n\\ 
.DE
.fi 
.ec
.ft P
.sp

The special value \*QHome\*U corresponds to the users home directory,
the value \*QTmp\*U corresponds to the scratch directory as defined
by the scratchDir resource.
.IP "filter"
.nr bi 1
.Pp
Defines the default filter to be used when displaying a directory
contents in the file selection window.
A filter is specified according to the syntax
.DS
.sp 
.ft CR
.nf
   <filter>    := [<filespecs>] [no <filespecs>]
   <filespecs> := <filespec> [<filespecs>]
   <filespec>  := filename possibly including wildcards '*'
                  which match any character.
.DE
.fi 
.ec
.ft P
.sp

Example: The filter
.DS
.sp 
.ft CR
.nf
   GV*filter: *.ps *.pdf no .*
.DE
.fi 
.ec
.ft P
.sp

screens out all files with names starting with a dot
and keeps of the remaining ones only those which end
on \*Q.ps\*U or \*Q.pdf\*U.
.IP "filters"
.nr bi 1
.Pp
Defines a list of filters offered in the Filters
menu of the file selection window.
Example:
.Pp
.DS
.sp 
.ft CR
.nf
   GV*filters:\\n\\ 
   None\\n\\ 
   *.ps* *.pdf*  no  .*\\n\\ 
   no  .*
.DE
.fi 
.ec
.ft P
.sp
.Pp
Note that the filter \*QNone\*U has a special meaning
causing all files to be displayed when the corresponding
menu entry is selected.
.IP "maximumWidth, maximumHeight"
.nr bi 1
.Pp
When resizing gv will not attempt to exceed the size specified
by these resources.
These resources may be specified as a positive integer
or as \*Qscreen\*U, optionally combined with
a positive or negative offset.
The default values listed above provide examples for this syntax.
\*Qscreen\*U will automatically be replaced by the size of the
screen.
.IP "minimumWidth, minimumHeight"
.nr bi 1
.Pp
Defines a minimum size for the main window.
Valid values for both resources are positive integers larger
than 200.
.IP "magstep"
.nr bi 1
.Pp
Sets the initial magnification.
Allowed values are integers.
.IP "minimumMagstep, maximumMagstep"
.nr bi 1
.Pp
Defines a range of allowed magsteps.
Valid values for both resources are integers.
.IP "orientation"
.nr bi 1
.Pp
Sets the initial orientation. Valid values are 
\*Qportrait\*U, \*Qlandscape\*U,\*Qseascape\*U,
\*Qupside-down\*U and
\*Qautomatic\*U.
\*Qautomatic\*U causes gv to attempt
to derive the correct orientation from document structuring
comments.
.IP "fallbackOrientation"
.nr bi 1
.Pp
Defines the paper-size to be used when automatic orientation
detetction fails.  Valid values are 
\*Qportrait\*U, \*Qlandscape\*U,\*Qseascape\*U 
and \*Qupside-down\*U.
.IP "pagemedia"
.nr bi 1
.Pp
Sets the paper-size. 
Allowd values are as given in the above list of paper-sizes.
Specifying
\*Qautomatic\*U causes gv to attempt
to derive the correct paper-size from document structuring
comments.
.IP "fallbackPageMedia"
.nr bi 1
.Pp
Defines the paper-size to be used when automatic paper-size 
detetction fails.  Valid values are as given in the  above
list of paper-sizes.
.if \n(ll>1 .RE
.nr ll -1
.if \n(ll>1 .RE
.nr ll -1

.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fBResources for the File Selection popup\fP"
.nr bi 1
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "GV*dirs"
.nr bi 1
.Pp
Defines a list of directories which are offered in 
the 'Directories' menu of the file selection window.
.IP "GV*filters"
.nr bi 1
.Pp
Defines a set of filters which can be accessed in the 'Filters'
menu of the file selection window.
.IP "GV*filter"
.nr bi 1
.Pp
Defines the initial filter in the the file selection popup.
The default value of this resource is set to 'no .*'.
.if \n(ll>1 .RE
.nr ll -1
.if \n(ll>1 .RE
.nr ll -1

.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fBResources of type \*QGVintern\*U\fP"
.nr bi 1
.Pp
For security reasons some preferences are handled differently
than the \*QGeneral resources\*U listed above.
The default values of these resources of type \*QGVintern\*U
are defined at compile time and can only be overriden in the 
user specific resource file.
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "GVintern.printCommand"
.nr bi 1
.Pp
The command used for printing a file.
The command may contain multiple '%s' wildcards
which will be replaced by the name of the file to be 
printed.
.IP "GVintern.gsInterpreter"
.nr bi 1
.Pp
The command used to start the ghostscript interpreter.
.IP "GVintern.gsCmdScanPDF"
.nr bi 1
.Pp
The command used to extract document structuring comments
from a PDF file.
.IP "GVintern.gsCmdConvPDF"
.nr bi 1
.Pp
The command used to convert a PDF file to PostScript.
.IP "GVintern.gsX11Device"
.nr bi 1
.Pp
The ghostscript command line option which activates the
\*QX11\*U device. 
.IP "GVintern.gsX11AlphaDevice"
.nr bi 1
.Pp
The ghostscript command line option which activates the
\*QX11\*U device with antialiasing enabled. 
.IP "GVintern.gsSafer"
.nr bi 1
.Pp
Determines whether ghostscript should be started with the
\*Q-dSAFER\*U command line option.
.IP "GVintern.gsQuiet"
.nr bi 1
.Pp
Determines whether ghostscript should be started with the
\*Q-dQUIET\*U command line option.
.IP "GVintern.gsArguments"
.nr bi 1
.Pp
May be used to provide additional command line options for the
ghostscript interpreter.
Starting gv with the \*Q-arguments <arguments>\*U
option will override this resource setting.
.if \n(ll>1 .RE
.nr ll -1
.if \n(ll>1 .RE
.nr ll -1

.SH \fBMouse and key bindings\fP 

.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fBMouse bindings in the Main and the Zoom window\fP"
.nr bi 1
.Pp
The following mouse events are defined when the mouse pointer
is either on the displayed page or on a zoomed area:
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-\fP press button 1, move mouse, release button 1"
.nr bi 1
.Pp
Scrolls the displayed page 'proportionally'.
.IP "\fB-\fP press button 3, move mouse, release button 3"
.nr bi 1
.Pp
Scrolls the displayed page 'absolutely'.
.IP "\fB-\fP double-click with button 1"
.nr bi 1
.Pp
In the main window this displays the previous/next page
if the double-click occured in the left/right half of the
window.
In a zoom window it does nothing.
.IP "\fB-\fP press button 2, release button 2"
.nr bi 1
.Pp
Pops up a small menu which allows to choose a magnification
for a certain area around the current mouse position.
After selecting a magnification a zoom window pops up
displaying the area at the chosen scale.
.IP "\fB-\fP press button 2, move mouse, release button 2"
.nr bi 1
.Pp
This draws and thereby defines a rectangular region which
can be displayed in a zoom window. The magnification for the
area can be selected by means of a popup menu which appears after
releasing button 2.
.IP " \fB-\fP press button 1, press button 2"
.nr bi 1
.Pp
Redisplays the current page. This event sequence works only
in the main window.
.IP "\fB-\fP press button 3, release button 3"
.nr bi 1
.Pp
Pops up a small menu which offers a few standard actions
like 'Redisplay', 'Mark Page', etc.
.if \n(ll>1 .RE
.nr ll -1
.IP "\fBMouse bindings in the File Selection popup\fP"
.nr bi 1
.Pp
The following mouse events are defined when the mouse pointer is
in the window of either a file or a directory list:
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-\fP press button 1, move mouse, release button 1"
.nr bi 1
.Pp
Scrolls a file or directory list 'proportionally'.
.IP "\fB-\fP press button 2, move mouse, release button 2"
.nr bi 1
.Pp
Scrolls a file or directory list 'absolutely'.
.IP "\fB-\fP press button 2, release button 2"
.nr bi 1
.Pp
Scrolls a file or directory list one page up/down
if the button was pressed in the upper/lower half of the list.
.IP "\fB-\fP double-click with button 1 on a filename"
.nr bi 1
.Pp
Selects the file and closes the File Selection popup.
.IP "\fB-\fP click with button 1 on a directory name"
.nr bi 1
.Pp
Causes the contents of this directory to be displayed.
.if \n(ll>1 .RE
.nr ll -1
.IP "\fBMouse bindings in the Table of Contents\fP"
.nr bi 1
.Pp
The following mouse events are defined when the mouse pointer is
in the window showing a list of page numbers of the
current file:
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-\fP press button 1, move mouse, release button 1"
.nr bi 1
.Pp
Scrolls the table of contents.
.IP "\fB-\fP press button 1 on a page number"
.nr bi 1
.Pp
Go to this page.
.IP "\fB-\fP press button 2 on a page number"
.nr bi 1
.Pp
Mark this page if it is unmarked, but unmark it if it is marked.
.IP "\fB-\fP press button 2, move mouse, release button 2"
.nr bi 1
.Pp
Marks/unmarks all unmarked/marked pages in the region
crossed by the mouse pointer during the movement.
.if \n(ll>1 .RE
.nr ll -1
.IP "\fBMouse bindings in the Panner widget\fP"
.nr bi 1
.Pp
The Panner widget is the rectangular region located close to the
left edge of the main window. It indicates the size and the
position of the visible area of the current page relative to the
total page.
.Pp
The following mouse events are defined when the mouse pointer is
in this region:
.Pp
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "\fB-\fP press button 1, move mouse"
.nr bi 1
.Pp
Scrolls the displayed page.
.IP "\fB-\fP press button 2"
.nr bi 1
.Pp
Display the previous page.
.IP "\fB-\fP press button 3"
.nr bi 1
.Pp
Display the next page.
.if \n(ll>1 .RE
.nr ll -1
.IP "\fBKey Bindings\fP"
.nr bi 1
.Pp
.DS
.sp 
.ft CR
.nf
A          Toggle antialiasing on and off
C          Center the page
O          Open a new file
Q          Quit gv
R          Reopen the current file
Z          Toggle gv's resizing behaviour
I          Respect/Ignore document structuring
E          Respect/Ignore EOF comments
W          Watch file / Don't watch file
S          Save the marked pages
Shift-S    Save the current file
P          Print the marked pages
Shift-P    Print the current file
B          Go to the previous page
BackSpace  Go to the previous page
Delete     Go to the previous page
Prior      Go to the previous page
F          Go to the next page
Space      Go to the next page
Return     Go to the next page
Next       Go to the next page
\&.          Redisplays the current page
Ctrl-L     Redisplays the current page
M          Mark the current page
N          Unmark the current page
Shift-7    Set magstep to -7
Shift-6    Set magstep to -6
Shift-5    Set magstep to -5
Shift-4    Set magstep to -4
Shift-3    Set magstep to -3
Shift-2    Set magstep to -2
Shift-1    Set magstep to -1
0          Set magstep to 0
1          Set magstep to 1
2          Set magstep to 2
3          Set magstep to 3
4          Set magstep to 4
5          Set magstep to 5
6          Set magstep to 6
7          Set magstep to 7
+          Increase magstep by 1
-          Decrease magstep by 1
U          Scroll up
D          Scroll down
H          Scroll left
K          Scroll up
J          Scroll down
L          Scroll right
Arrow      Scroll in the direction of the arrow
.DE
.fi 
.ec
.ft P
.sp
.if \n(ll>1 .RE
.nr ll -1

.SH Features 

.Pp
.SH \fBScrolling\fP 

.Pp
It is probably a de facto standard of user interfaces
that windows are supposed to be scrolled by means of
scrollbars attached to their sides.
However, for various reasons the use of scrollbars
has been minimized in gv.
.Pp
Instead, in all windows with obscured data scrolling
may be performed by
pressing button1, moving the mouse, releasing button1
directly in the window. This includes the displayed page,
zoom popups, the table of contents and the file and 
directory lists displayed in the file selection popup.
.Pp
.SH \fBDisplaying new versions of a document\fP 

.Pp
During document creation it is usually desirable to
always display the newest version of the document in work.
.Pp
Instead of explicitly loading it via the file selection
popup the most recent version can be displayed by
pressing the \*QUpdate File\*U button in the main window.
Choosing the \*QUpdate File\*U entry in the menu that pops
up when clicking with the third mouse button anywhere on the
displayed page certainly has the same effect.
.Pp
More comfortable is the "Watch File" feature which may
be switched on by selecting the corresponding entry in the
\*QState\*U menu. If activated gv will check
every now and then if a new version of the displayed
file exists. If so it will be displayed automatically.
By default the file is checked about once every
second.
.Pp
Finally it may also be left to the document creating program
to trigger gv to update its display. To do so the
program should send the SIGHUP signal to gv.
For instance at the end of a shell script generating a
postscript file from latex sources the line
.DS
.sp 
.ft CR
.nf
   kill -SIGHUP <gv_pid>
.DE
.fi 
.ec
.ft P
.sp

may be added (here \f(CR<gv_pid>\fP is the process id of
gv). Executing the script and thereby creating a new
version of the document will then also cause the
result to be displayed instantaneously.
.Pp
.Pp
.SH Availability 

.Pp
The source code of the most recent version of gv may be
obtained from the following sources:
.nr ll +1
.nr t\n(ll 2
.if \n(ll>1 .RS
.IP "World Wide Web:"
.nr bi 1
.Pp
http://wwwthep.physik.uni-mainz.de/~plass/gv/
.IP "Anonymous ftp:"
.nr bi 1
.Pp
ftp://thep.physik.uni-mainz.de/pub/gv/
.if \n(ll>1 .RE
.nr ll -1

.SH Authors 

.Pp
.DS
.sp 
.ft CR
.nf
Johannes Plass             plass@thep.physik.uni-mainz.de
                           Department of Physics
                           Johannes Gutenberg University
                           Mainz, Germany

gv is derived from GhostView 1.5, created by
          Tim Theisen      Systems Programmer
Internet: tim@cs.wisc.edu  Department of Computer Sciences
    UUCP: uwvax!tim        University of Wisconsin-Madison
   Phone: (608)262-0438    1210 West Dayton Street
     FAX: (608)262-9777    Madison, WI   53706
.DE
.fi 
.ec
.ft P
.sp

.Pp
.SH Suggestions and bug reports 

.Pp
Please send suggestions or bug reports to plass@thep.physik.uni-mainz.de.
.Pp
.Pp
.Pp
.Pp
