/*
**
** TocP.h
**
** Copyright (C) 1995-1997 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@thep.physik.uni-mainz.de)
**           Department of Physics
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

#ifndef _TocP_h
#define _TocP_h

#include "paths.h"
#include "Toc.h"
#include INC_XAW(LabelP.h)

typedef struct _TocClass {
  int makes_compiler_happy;  /* not used */
} TocClassPart;

typedef struct _TocClassRec {
  CoreClassPart    core_class;
  SimpleClassPart  simple_class;
  ThreeDClassPart  threeD_class;
  LabelClassPart   label_class;
  TocClassPart     toc_class;
} TocClassRec;

extern TocClassRec tocClassRec;

typedef struct {
  /* resources */
  String         toc;
  Dimension      mark_shadow_width;
  Dimension      selected_shadow_width;
  Dimension      highlighted_shadow_width;
  Pixel          mark_background;
  Pixel          selected_background;
  Pixel          highlighted_background;
  /* private state */
  int entries;
  GC background_GC;
  GC mark_background_GC;
  GC selected_background_GC;
  GC highlighted_background_GC;
  int selected;
  int highlighted;
} TocPart;

typedef struct _TocRec {
  CorePart       core;
  SimplePart     simple;
  ThreeDPart     threeD;
  LabelPart      label;
  TocPart        toc;
} TocRec;

#endif /* _TocP_h */


