/*
**
** Toc.h
**
** Copyright (C) 1995-1997 Johannes Plass
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** Author:   Johannes Plass (plass@thep.physik.uni-mainz.de)
**           Department of Physics
**           Johannes Gutenberg-University
**           Mainz, Germany
**
*/

#ifndef _Toc_h_
#define _Toc_h_

#include "paths.h"
#include INC_XAW(Label.h)

#define XawTocAll     -13
#define XawTocEven    -12
#define XawTocOdd     -11
#define XawTocCurrent -10
#define XawTocInvalid  -1
#define XawTocSet       1
#define XawTocUnset     2
#define XawTocToggle    3

#define XtNtoc "toc"
#define XtCToc "Toc"
#define XtNmarkShadowWidth "markShadowWidth"
#define XtNselectedShadowWidth "selectedShadowWidth"
#define XtNhighlightedShadowWidth "highlightedShadowWidth"
#define XtNmarkBackground "markBackground"
#define XtCMarkBackground "MarkBackground"
#define XtNselectedBackground "selectedBackground"
#define XtCSelectedBackground "SelectedBackground"
#define XtNhighlightedBackground "highlightedBackground"
#define XtCHighlightedBackground "HighlightedBackground"

extern WidgetClass tocWidgetClass;

typedef struct _TocClassRec   *TocWidgetClass;
typedef struct _TocRec        *TocWidget;

extern int                     TocHighlighted (
#if NeedFunctionPrototypes
    Widget
#endif
);

extern int                     TocSelected (
#if NeedFunctionPrototypes
    Widget
#endif
);

extern int                     TocEntries (
#if NeedFunctionPrototypes
    Widget
#endif
);

extern char*                   TocToc (
#if NeedFunctionPrototypes
    Widget
#endif
);

extern int                     TocEntryOfPosition (
#if NeedFunctionPrototypes
    Widget,
    int
#endif
);

extern void                     TocChangeMark (
#if NeedFunctionPrototypes
    Widget,
    int,
    int
#endif
);

extern void                     TocChangeSelected (
#if NeedFunctionPrototypes
    Widget,
    int,
    int
#endif
);

extern void                     TocChangeHighlighted (
#if NeedFunctionPrototypes
    Widget,
    int,
    int
#endif
);

#endif /* _Toc_h_ */
