//**************************************************************************
//*                     This file is part of the                           *
//*                      Mpxplay - audio player.                           *
//*                  The source code of Mpxplay is                         *
//*        (C) copyright 1998-2005 by PDSoft (Attila Padar)                *
//*                    http://mpxplay.cjb.net                              *
//*                  email: mpxplay@freemail.hu                            *
//**************************************************************************
//*  This program is distributed in the hope that it will be useful,       *
//*  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
//*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                  *
//*  Please contact with the author (with me) if you want to use           *
//*  or modify this source.                                                *
//**************************************************************************
//function: visual plug-in sample (black screen)

#include <display\visualpi.h>
#include <newfunc\newfunc.h>
#include <newfunc\dll_load.h>

static struct mpxplay_resource_s *mrs;

static struct local_data_s{
 display_visual_data_s *vds;
}local_datas;

static void *vis_init(display_visual_data_s *vds)
{
 struct local_data_s *lds=&local_datas; // it's static here, but it also can be a dynamic field allocated by malloc()

 lds->vds=vds;

 return (void *)lds;
}

static void vis_close(void *ldp)
{
 //nothing to do now (else free memory fields here)
}

static int vis_start(void *ldp)
{
 struct local_data_s *lds=ldp;
 display_visual_data_s *vds=lds->vds;

 vds->displaymode=0;            // disable display/desktop refresh of Mpxplay

 mrs->pds_textdisplay_clrscr(); // clear screen

 return 1; // successfully started
}

static void vis_stop(void *ldp)
{
 //struct local_data_s *lds=ldp;
 //display_visual_data_s *vds=lds->vds;

 //you have to restore the original display-mode (by BIOS or VESA), if it's changed in vis_start()
}

static void vis_draw(void *ldp)
{
 //keep blank (black) screen (else visual effect runs here)
}


static display_visual_func_s vis_blank_callbacks={
 &vis_init,      //
 &vis_close,     //
 &vis_start,     // called at start of visual-effect
 &vis_stop,      // called at stop of visual-effect
 &vis_draw,      // called FPS times per sec
 20 // FPS: 1-110 (if it's 0, then a default built-in value is used (currently 18))
};

static mpxplay_module_entry_s vis_blank_module_entry={
 MPXPLAY_DLLMODULETYPE_DISPLAY_VISUALPI,// module major-type
 0,                                     // module minor-type
 "BLACK",                               // module minor-name (rename it !!!)
 MPXPLAY_DLLMODULEVER_DISPLAY_VISUALPI, // current module (structure) version
 (void *)&vis_blank_callbacks           // callback functions (in a structure)
};

static mpxplay_dll_entry_s mpxplay_dll_entry_structure={
 MPXPLAY_DLLENTRY_STRUCTURE_VERSION,
 {
  &vis_blank_module_entry,
  NULL
 }
};

extern void dllstrtr_update_crwdata(unsigned long *cwd);

long __export mpxplay_dll_entrypoint(struct mpxplay_resource_s *p_mrs,unsigned long *crwdata_begin)
{
 mrs=p_mrs;
 //dllstrtr_update_crwdata(crwdata_begin); // this DLL doesn't need it
 return (long)(&mpxplay_dll_entry_structure);
}
