;=============================================================================
; beep.inc:	procedure for generating sound signal.
;
; Copyright (c) 2007 Oleg O. Chukaev.
; This code is free software distributed under the terms of the GNU GPL.
; See the file COPYING or http://www.gnu.org/licenses/licenses.html.
;
;-----------------------------------------------------------------------------
; Procedures:
;	beep_core		sleep
;
; Macros:
;	define_beep_core	define_sleep
;
; Used global variables:
;	---
;
; Used global constants:
;	BIOS_TIMER
;=============================================================================


;=============================================================================
; beep_core
;-----------------------------------------------------------------------------
; NOT A PROCEDURE! Generates beep. Code from Freemacs.
; In:	---
; Out:	---
; Modf:	AX
; Call:	sleep
; Use:	---
;
%macro		define_beep_core	0
beep_core:
		call	sleep
		mov	al,0b6h		;Channel 2, LSB then MSB, Square Wave, Binary
		out	43h,al		;Program 8253 command register
		mov	ax,2000		;Get the frequency to be generated
		out	42h,al		;Load Channel 2 count register LSB
		mov	al,ah
		out	42h,al		;Load Channel 2 count register MSB
		in	al,61h		;Read settings from 8255 PPI I/O Port "PB"
		push	ax		;Save original settings in AH
		or	al,3		;Enable Timer Channel 2 & Speaker data
		out	61h,al		;program the 8255 with new setting-speaker on
		call	sleep		;Wait for a while.
		pop	ax		;Get original 8255 Port "PB" settings
		out	61h,al		;Reset port to original values-speaker off
%endmacro
;
;=============================================================================
; sleep
;-----------------------------------------------------------------------------
; Stops program execution by 1/18.2 sec.
; In:	---
; Out:	---
; Modf:	AX
; Call:	---
; Use:	---
;
%macro		define_sleep		0
sleep:
		push	ds
		xor	ax,ax
		mov	ds,ax
		mov	ax,[BIOS_TIMER]	;Get the current timer value.
@@wait:
		cmp	ax,[BIOS_TIMER]	;Did the timer value "tick"?
		je	@@wait		;No - keep waiting for a tick.
		pop	ds
		ret
%endmacro
;
;=============================================================================
; E0F
;=============================================================================


