/*
 *      readhelp.c
 *
 *      Copyright 2009 Blair <blair@blair-laptop>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */

#include "helpcomp.h"
#include "fdav.h"

#define HELP_BUTTON_INDEX   0
#define HELP_BUTTON_KEYWRDS 1
#define HELP_BUTTON_BACK    2
#define HELP_BUTTON_FORWRD  3
#define HELP_BUTTON_EXIT    4

const char *help_common_buttons[] = {
    "Index", "Keywords", "Back", "Forward", "Exit", NULL
};

static newtComponent form = NULL, helptext, buttons[ HELP_BUTTON_EXIT + 1 ], *links;

void tui_help_get_form( HELP *hfile, int page )
{
    int page_size, i, w;
    char *p;
    char *page_buf, *write_buf;
    static int last_page_displayed = -1;

    if( page != last_page_displayed ) {
        if( form ) newtFormDestroy( form );
        form = newtForm( NULL, NULL, 0 );
        for( i = 0, w = 0; i <= HELP_BUTTON_EXIT; i++ ) {
            buttons[ i ] = newtButton( w, 17, help_common_buttons[ i ] );
            newtFormAddComponent( form, buttons[ i ] );
            w += 17;
        }

        last_page_displayed = page;
        page_size = help_pagesize( hfile, page );
        page_buf = help_readpage( hfile, page );
        write_buf = malloc( page_size * 2 );
        if( write_buf == NULL ) {
            if( page_buf ) free( page_buf );
            page_buf = NULL;
        }

        if( page_buf && write_buf ) for( i = w = 0; i < page_size; i++ ) {
            switch( page_buf[ i ] ) {
                case '\\':
                    switch( tolower( page_buf[ ++i ] ) ) {
                        case 'n':
                            write_buf[ w++ ] = '\n';
                            break;
                        case 't':
                            write_buf[ w++ ] = '\t';
                            break;
                        case '\\':
                            write_buf[ w++ ] = '\\';
                            break;
                        default:
                            write_buf[ w++ ] = '\\';
                            write_buf[ w++ ] = page_buf[ i ];
                    }
                    break;
                case '\0':
                    write_buf[ w++ ] = '<';
                    p = help_pagetitle( hfile, help_link_to_page( hfile, &page_buf[ i ] ) );
                    strcpy( &write_buf[ w ], p );
                    w += strlen( p );
                    write_buf[ w++ ] = '>';
                    i += 3;
                    break;
                default:
                    write_buf[ w++ ] = page_buf[ i ];
            }
        }
        write_buf[ w ] = '\0';

        helptext = newtTextbox( 0, 0, 76, 16, NEWT_FLAG_SCROLL | NEWT_FLAG_WRAP );
        newtTextboxSetText( helptext, write_buf ? write_buf : "Could not display help page" );
        newtFormAddComponent( form, helptext );
        if( page_buf ) free( page_buf );
        if( write_buf ) free( write_buf );
    }
}

void tui_view_help( int fdav_page )
{
    HELP *hfile = help_open( fdav_helpfile );
    int npages = hfile ? help_pages( hfile ) : -1;
    struct newtExitStruct einf;

    if( hfile == NULL ) {
        newtWinMessage( "FDAV Help", "OK", "Could not open the help file \"%s\"", fdav_helpfile );
        return;
    }

    newtCenteredWindow( 78, 21, "FDAV Help" );
    do {
        tui_help_get_form( hfile, fdav_page );
        newtFormRun( form, &einf );
        if( einf.reason == NEWT_EXIT_COMPONENT ) {
            if( einf.u.co == buttons[ HELP_BUTTON_FORWRD ] ) {
                fdav_page++;
                if( fdav_page >= npages ) fdav_page = 0;
            }
            if( einf.u.co == buttons[ HELP_BUTTON_BACK ] ) {
                fdav_page--;
                if( fdav_page < 0 ) fdav_page = npages - 1;
            }
        }
    } while( einf.reason != NEWT_EXIT_COMPONENT || einf.u.co != buttons[ HELP_BUTTON_EXIT ] );

    newtFormDestroy( form );
    form = NULL;
    newtPopWindow();
}
