include	clib.inc
include	dir.inc
include	io.inc
include	iost.inc
include	string.inc
include	errno.inc
include tv.inc
include	conio.inc
include	version.inc
include mouse.inc

	.186

	public	main
	public	tvflag
	public	fsflag
	public	searchstring
	public	configpath
	public	configfile
	public	tv_class
	public	tv_clversion
	public	tv_classsize
	public	tv_classrow

	extrn	_argc:word
	extrn	_argv:dword
	extrn	tvmem_offs:dword
	extrn	tvmem_size:dword

_DATA	SEGMENT

cp_info	label byte
	db	'Text View Version ',VERS?,' Copyright (c) 1998-2010 Hjort Nidudsson',13,10
size_info = $ - offset cp_info

cp_usage label byte
	db	'Syntax is: TV [-options] [file]',13,10
	db	13,10
	db	'  -t',9,9,   	'View Text',13,10
	db	'  -b',9,9,   	'View Binary',13,10
	db	'  -h',9,9,   	'View Hex',13,10
	db	'  -m',9,9,	'View Memory [00000..FFFFF]',13,10
	db	'  -o<offset>',9, 'Start offset',13,10
	db	'  -s<size>',9,	'Limit size of memory to <size>',13,10
	db	'  -q',9,9,	'quiet - no logo',13,10
size_usage = $ - offset cp_usage

option_q	db 0
tv_cfg		db 'tv.cfg',0
tv_ini		db 'tv.ini',0
arg_file	dd 0
arg_offset	dd 0
arg_size	dd 000FFFFFh
configpath	db WMAXPATH dup(0)
configfile	db WMAXPATH dup(0)

tvflag		db _TV_HEXOFFSET
fsflag		db 0
searchstring	db 128 dup(0)
tv_clversion	dw CLVERSION
tv_classsize	dw CLCOUNT
tv_classrow	dw CLCOUNT
tv_class	S_CLASS CLCOUNT dup(<'byte',1,CLTYPE_BYTE,CLFORM_HEX>)
size_config	= $ - offset tvflag

_DATA	ENDS

_TEXT	SEGMENT

main	PROC
	cmp	_argc,1
	jne	read_config
    print_usage:
	mov	cx,size_usage
	mov	dx,offset cp_usage
	call	stderrmsg
	xor	ax,ax
	ret
    read_config:
	mov	bx,word ptr _argv
	invoke	strcpy, addr configpath, [bx]
	invoke	strfn, dx::ax
	mov	bx,ax
	mov	byte ptr [bx-1],0
	invoke	strfcat, addr configfile, addr configpath, addr tv_ini
	invoke	strfcat, addr configpath, 0, addr tv_cfg
	invoke	osopen, dx::ax, _A_NORMAL, M_RDONLY, A_OPEN
	mov	si,ax
	inc	ax
	jz	@F
	invoke	osread, si, addr tvflag, size_config
	invoke	close, si
    @@:
	xor	ax,ax
    init_args:
	mov	searchstring,al
	mov	si,1
    arg_loop:
	cmp	si,_argc
	jae	init_info
	les	bx,_argv
	mov	ax,si
	inc	si
	shl	ax,2
	add	bx,ax
	les	bx,es:[bx]
	mov	ax,es:[bx]
	cmp	al,'?'
	je	print_usage
	cmp	al,'/'
	je	options
	cmp	al,'-'
	je	options
	mov     word ptr arg_file,bx
	mov	word ptr arg_file+2,es
	jmp	arg_loop
    options:
	mov	al,ah
	or	al,20h
	cmp	al,'t'
	je	case_t
	cmp	al,'b'
	je	case_b
	cmp	al,'h'
	je	case_h
	cmp	al,'m'
	je	case_m
	cmp	al,'o'
	je	case_o
	cmp	al,'q'
	je	case_q
	jmp	print_usage
    case_t:
	and	tvflag,not (_TV_HEXVIEW or _TV_BINVIEW)
	jmp	arg_loop
    case_b:
	or	tvflag,_TV_BINVIEW
    case_h:
	or	tvflag,_TV_HEXVIEW
	jmp	arg_loop
    case_m:
	mov	STDI.ios_flag,IO_MEMREAD
	jmp	arg_loop
    case_o:
	add	bx,2
	invoke	strtol, es::bx
	stom	arg_offset
	jmp	arg_loop
    case_q:
	inc	option_q
	jmp	arg_loop
    init_info:
	cmp	option_q,0
	jne	init_file
	mov	cx,size_info
	mov	dx,offset cp_info
	call	stderrmsg
    init_file:
	cmp	STDI.ios_flag,IO_MEMREAD
	je	call_tview
	invoke	access, arg_file, 0
	or	ax,ax
	jz	call_tview
	invoke	strcpy, addr cp_info, arg_file
	call	eropen
	xor	ax,ax
	ret
    call_tview:
  ifdef __MOUSE__
	call	mouseinit
	call	mouseon
  endif
	pushm	arg_file
	pushm	arg_offset
	pushm	arg_offset
	pushm	arg_size
	call	tview
  ifdef __MOUSE__
	call	mouseoff
  endif
	invoke	osopen, addr configpath, _A_NORMAL, M_WRONLY, A_CREATE or A_TRUNC
	cmp	ax,-1
	jz	toend
	push	ax
	invoke	oswrite, ax, addr tvflag, size_config
	call	close
    toend:
	xor	ax,ax
	ret
main	ENDP

_TEXT	ENDS

	END
