; TISAVE.ASM--
; Copyright (c) 2011 Hjort Nidudsson
;
; 08/19/2011
;
include	clib.inc
include	dobj.inc
include	tinfo.inc
ifdef __TE__
include	io.inc
include	iost.inc
include	string.inc

	public	tisave		; AX
	public	tiflush		; AX

	extrn	tiftime:	NEAR
	extrn	ticontinue:	NEAR
	extrn	tiflushl:	NEAR

_DATA	SEGMENT

cp_extbak db	'.bak',0
cp_exttmp db	'.$$$',0

_DATA	ENDS

_TEXT	SEGMENT

tisave	PROC
	mov	bx,ax
	test	[bx.ti_flag],_T_FILE
	jnz	tiflush
	jmp	ticontinue
tisave ENDP

tiflush	PROC PASCAL
local	path[WMAXPATH]:byte
	push	si
	push	di
	mov	si,ax
	lea	di,path
	invoke	strcpy, ss::di, [si.ti_file]
	invoke	setfext, ss::di, addr cp_exttmp
	invoke	oopen, dx::ax, M_WRONLY
	jz	tiflush_end
	xor	ax,ax
	cwd
	mov	cx,[si.ti_lcnt]
	dec	cx
	mov	bx,ax
	dec	bx
	call	tiflushl
	jnz	tiflush_eof
	mov	ax,offset STDO
	call	oclose
	invoke	remove, ss::di
	xor     di,di
	jmp	tiflush_end
    tiflush_eof:
	call	oflush
	mov	ax,offset STDO
	call	oclose
	test	[si.ti_flag],_T_USEBAKFILE
	jz	tiflush_nobackup
	invoke	setfext, ss::di, addr cp_extbak
	invoke	remove, [si.ti_file]
	invoke	rename, ss::di, [si.ti_file]
	invoke	setfext, ss::di, addr cp_exttmp
	jmp	tiflush_rename
    tiflush_nobackup:
	invoke	remove, [si.ti_file]
    tiflush_rename:
	invoke	rename, ss::di, [si.ti_file]
	inc	ax
	mov	di,ax
	mov	ax,si
	and	[si.ti_flag],not _T_MODIFIED
	call	tiftime
	mov     [si.ti_time],ax
	mov     [si.ti_date],ax
    tiflush_end:
	mov	ax,di
	or	ax,ax
	pop	di
	pop	si
	ret
tiflush ENDP

_TEXT	ENDS
endif
	END
