;************** Inflate and Explode
;
;  inflate.c -- by Mark Adler
;  explode.c -- by Mark Adler
;
; Change history:
; 03/31/2010	Removed 386 instructions
; ../../1997	Modified for Doszip

include	clib.inc
include	iost.inc
include	malloc.inc
include	string.inc
include	unzip.inc
include	errno.inc

	.186

	public	zip_inflate
	public	zip_explode

_TEXT	SEGMENT

BBL	EQU	WORD PTR STDI.ios_bb_ax
BBH	EQU	WORD PTR STDI.ios_bb_dx

GETBITS	PROC
	CMP	AX,STDI.ios_l
	JA	GETBITS_02
	MOV	CX,AX
	MOV	AX,1
	SHL	AX,CL
	DEC	AX
	MOV	DX,AX
	AND	AX,BBL
	INC	CX
GETBITS_01:
	RET
GETBITS_02:
	MOV	CX,BX
	MOV	BX,STDI.ios_i
	CMP	BX,STDI.ios_c
	JE	GETBITS_04
GETBITS_03:
	PUSH	AX
	INC	STDI.ios_i
	LES	AX,DWORD PTR STDI
	ADD	BX,AX
	MOV	AH,0
	MOV	AL,ES:[BX]
	MOV	DX,AX
	MOV	BX,CX
	MOV	CX,STDI.ios_l
	SHL	AX,CL
	OR	BBL,AX
	MOV	AL,8
	ADD	BYTE PTR STDI.ios_l,AL
	CMP	CL,AL
	POP	AX
	JBE	GETBITS
	NEG	CL
	ADD	CL,16
	SHR	DX,CL
	OR	BBH,DX
	JMP	GETBITS
GETBITS_04:
	PUSH	CX
	PUSH	AX
	CALL	ofread
	POP	DX
	POP	CX
	JZ	GETBITS_01
	MOV	AX,DX
	MOV	BX,STDI.ios_i
	JMP	GETBITS_03
GETBITS	ENDP

DUMPBITS PROC
	SUB	BYTE PTR STDI.ios_l,CL
	MOV	AX,BBH
	SHR	BBH,CL
	SHR	BBL,CL
	NEG	CL
	ADD	CL,16
	SHL	AX,CL
	OR	BBL,AX
	RET
DUMPBITS ENDP

GETDUMP	PROC
	CALL	GETBITS
	JZ	GETDUMP_00
	PUSH	AX
	DEC	CX
	CALL	DUMPBITS
	INC	CX
	POP	AX
GETDUMP_00:
	RET
GETDUMP	ENDP

;----------------------------------------------------------------------------
; Free the malloc'ed tables built by huft_build(), which makes a linked
; list of the tables it made, with the links in a dummy first entry of
; each table.

HUFT_FREE PROC
	PUSH	BP
	MOV	BP,SP
	LES	BX,[BP+4]
HUFT_FREE_00:
	OR	BX,BX
	JZ	HUFT_FREE_01
	SUB	BX,6
	PUSH	WORD PTR ES:[BX+4]
	PUSH	WORD PTR ES:[BX+2]
	PUSH	ES
	PUSH	BX
	CALL	free
	POP	BX
	POP	ES
	JMP	HUFT_FREE_00
HUFT_FREE_01:
	POP	BP
	RET	4
HUFT_FREE ENDP

BMAX	= 16	; Maximum bit length of any code (16 for explode)
N_MAX	= 288	; Maximum number of codes in any set

HUFT_BUILD PROC
;------	Args
; b	[BP+24]	DWORD		code lengths in bits (all assumed <= BMAX)
; n	[BP+22]	WORW		number of codes (assumed <= N_MAX)
; s	[BP+20]	WORW		number of simple-valued codes (0..s-1)
; d	[BP+16]	DWORD		list of base values for non-simple codes
; e	[BP+12]	DWORD		list of extra bits for non-simple codes
; t	[BP+8]	DWORD		result: starting table
; m	[BP+4]	DWORD		maximum lookup bits, returns actual
;------	Locals
; z	[BP-2]	WORD 		number of entries in current table
; y	[BP-4]	WORD 		number of dummy codes added
; w	[BP-6]	WORD 		bits before this table == (l * h)
; p	[BP-8]	WORD 		pointer into c[], b[], or v[]
; l	[BP-10]	WORD		stack of bits per table
; k	[BP-12]	WORD 		number of bits in current code
; i	[BP-14]	WORD 		counter, current code
; g	[BP-16]	WORD 		maximum code length
; el	[BP-20]	WORD		length of EOB code (value 256)
; a	[BP-22]	WORD		counter for codes of length k
; q	[BP-26]	DWORD 		points to current table
; r	[BP-32]	HUFT 		table entry for structure assignment
; x	[BP-66]	WORD[MAXBIT+1]	bit offsets, then code stack
; lx	[BP-100] WORD[MAXBIT+1]	memory for l[-1..BMAX-1]
; c	[BP-134] WORD[MAXBIT+1]	bit length count table
; u	[BP-198] DWORD[MAXBIT] 	table stack
; v	[BP-774] WORD[MAXCODE]	values in order of bit length
	PUSH	BP
	MOV	BP,SP
	MOV	CX,774
	SUB	SP,CX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	SS
	LEA	AX,[BP-774]
	PUSH	AX
	PUSH	CX
	CALL	memzero
	;--------------------------------------------------------------------
	; Generate counts for each bit length
	;--------------------------------------------------------------------
	LEA	AX,[BP-98]
	MOV	[BP-10],AX
	MOV	CX,[BP+22]
	LDS	DI,[BP+24]
	MOV	AX,BMAX
	CMP	CX,256		; set length of EOB code, if any
	JBE	HUFT_BUILD_00
	MOV	AX,[DI+512]
HUFT_BUILD_00:
	MOV	[BP-20],AX
	LEA	DX,[BP-134]
HUFT_BUILD_01:
	MOV	BX,[DI]
	ADD	DI,2
	ADD	BX,BX
	ADD	BX,DX
	INC	WORD PTR [BX]
	DEC	CX
	JNZ	HUFT_BUILD_01
	MOV	BX,DX
	MOV	AX,[BP+22]
	CMP	AX,[BX]
	JNE	HUFT_BUILD_02
	XOR	AX,AX		; null input--all zero length codes
	LES	BX,[BP+8]
	MOV	ES:[BX],AX
	MOV	ES:[BX+2],AX
	LES	BX,[BP+4]
	MOV	ES:[BX],AX
	JMP	HUFT_BUILD_38
	;--------------------------------------------------------------------
	; Find minimum and maximum length, bound *m by those
	;--------------------------------------------------------------------
HUFT_BUILD_02:
	MOV	DI,1
	XOR	AX,AX
HUFT_BUILD_03:
	MOV	BX,DI
	ADD	BX,BX
	ADD	BX,DX
	CMP	AX,[BX]
	JNZ	HUFT_BUILD_04
	INC	DI
	CMP	DI,BMAX
	JNA	HUFT_BUILD_03
HUFT_BUILD_04:
	MOV	[BP-12],DI	; minimum code length
	LES	BX,[BP+4]
	CMP	ES:[BX],DI
	JNB	HUFT_BUILD_05
	MOV	ES:[BX],DI
HUFT_BUILD_05:
	MOV	CX,BMAX
	XOR	AX,AX
HUFT_BUILD_06:
	MOV	BX,CX
	ADD	BX,BX
	ADD	BX,DX
	CMP	AX,[BX]
	JNE	HUFT_BUILD_07
	DEC	CX
	JNZ	HUFT_BUILD_06
HUFT_BUILD_07:
	MOV	[BP-16],CX	; maximum code length
	MOV	BX,[BP+4]
	CMP	CX,ES:[BX]
	JNB	HUFT_BUILD_08
	MOV	ES:[BX],CX
	;--------------------------------------------------------------------
	; Adjust last length count to fill out codes, if needed
	;--------------------------------------------------------------------
HUFT_BUILD_08:
	MOV	SI,CX
	MOV	CX,DI
	MOV	AX,1
	SHL	AX,CL
	MOV	CX,AX
HUFT_BUILD_09:
	CMP	DI,SI
	JNB	HUFT_BUILD_10
	MOV	BX,DI
	ADD	BX,BX
	ADD	BX,DX
	SUB	CX,[BX]
	JL	HUFT_BUILD_12	; bad input: more codes than bits
	ADD	CX,CX
	INC	DI
	JMP	HUFT_BUILD_09
	;--------------------------------------------------------------------
	; Generate starting offsets into the value table for each length
	;--------------------------------------------------------------------
HUFT_BUILD_10:
	MOV	BX,SI
	ADD	BX,BX
	ADD	BX,DX
	SUB	CX,[BX]
	JL	HUFT_BUILD_12
	ADD	[BX],CX
	MOV	[BP-4],CX
	XOR	AX,AX
	LEA	BX,[BP-64]
	MOV	[BX],AX
	MOV	DI,DX
	ADD	DI,2
HUFT_BUILD_11:
	DEC	SI
	JZ	HUFT_BUILD_13
	ADD	AX,[DI]
	ADD	DI,2
	ADD	BX,2
	MOV	[BX],AX
	JMP	HUFT_BUILD_11
HUFT_BUILD_12:
	MOV	AX,ER_ZIP
	JMP	HUFT_BUILD_39
	;--------------------------------------------------------------------
	; Make a table of values in order of bit lengths
	;--------------------------------------------------------------------
HUFT_BUILD_13:
	XOR	CX,CX
	MOV	SI,[BP+24]
HUFT_BUILD_14:
	MOV	AX,[SI]
	ADD	SI,2
	OR	AX,AX
	JZ	HUFT_BUILD_15
	ADD	AX,AX
	LEA	BX,[BP-66]
	ADD	BX,AX
	MOV	AX,[BX]
	INC	WORD PTR [BX]
	ADD	AX,AX
	LEA	BX,[BP-774]
	ADD	BX,AX
	MOV	[BX],CX
HUFT_BUILD_15:
	INC	CX
	CMP	CX,[BP+22]
	JB	HUFT_BUILD_14
	;--------------------------------------------------------------------
	; Generate the Huffman codes and for each, make the table entries
	;--------------------------------------------------------------------
	XOR	AX,AX
	MOV	[BP-14],AX
	MOV	[BP-66],AX
	MOV	[BP-100],AX
	MOV	SI,-1
	LEA	AX,[BP-774]
	MOV	[BP-8],AX
	JMP	HUFT_BUILD_35
	;--------------------------------------------------------------------
	; compute minimum size table less than or equal to *m bits
	;--------------------------------------------------------------------
HUFT_BUILD_16:
	MOV	[BP-6],AX
	INC	SI
	MOV	AX,[BP-16]	; upper limit
	SUB	AX,[BP-6]
	MOV	[BP-2],AX
	LES	BX,[BP+4]
	CMP	AX,ES:[BX]
	JBE	HUFT_BUILD_17
	MOV	AX,ES:[BX]
	MOV	[BP-2],AX
HUFT_BUILD_17:
	MOV	AX,[BP-12]
	SUB	AX,[BP-6]
	MOV	DI,AX
	MOV	CX,AX
	MOV	AX,1
	SHL	AX,CL
	MOV	CX,AX
	MOV	DX,[BP-22]
	INC	DX
	CMP	AX,DX
	JBE	HUFT_BUILD_19
	SUB	CX,DX
	LEA	BX,[BP-134]
	MOV	AX,[BP-12]
	ADD	AX,AX
	ADD	BX,AX
HUFT_BUILD_18:
	MOV	AX,[BP-2]
	INC	DI
	CMP	DI,AX
	JNB	HUFT_BUILD_19
	MOV	AX,CX
	ADD	AX,AX
	MOV	CX,AX
	ADD	BX,2
	CMP	AX,[BX]
	JBE	HUFT_BUILD_19
	MOV	AX,[BX]
	SUB	CX,AX
	JMP	HUFT_BUILD_18
HUFT_BUILD_19:
	MOV	AX,[BP-6]
	ADD	AX,DI
	CMP	AX,[BP-20]
	JBE	HUFT_BUILD_20
	MOV	AX,[BP-20]
	CMP	[BP-6],AX
	JNB	HUFT_BUILD_20
	SUB	AX,[BP-6]
	MOV	DI,AX
HUFT_BUILD_20:
	MOV	AX,1
	MOV	CX,DI
	SHL	AX,CL
	MOV	[BP-2],AX
	MOV	BX,SI
	ADD	BX,BX
	ADD	BX,[BP-10]
	MOV	[BX],DI
	INC	AX
	ADD	AX,AX
	MOV	DX,AX
	ADD	AX,AX
	ADD	AX,DX
	PUSH	AX
	CALL	malloc
	JNZ	HUFT_BUILD_22
	OR	SI,SI
	JZ	HUFT_BUILD_21
	PUSH	WORD PTR [BP-196]
	PUSH	WORD PTR [BP-198]
	CALL	HUFT_FREE
HUFT_BUILD_21:
	JMP	HUFT_BUILD_37
	;--------------------------------------------------------------------
	; link to list for huft_free()
	;--------------------------------------------------------------------
HUFT_BUILD_22:
	LES	BX,[BP+8]
	ADD	AX,6
	MOV	[BP-26],AX
	MOV	[BP-24],DX
	MOV	ES:[BX],AX
	MOV	ES:[BX+2],DX
	SUB	AX,4
	MOV	[BP+8],AX
	MOV	[BP+10],DX
	MOV	ES,DX
	MOV	BX,AX
	XOR	AX,AX
	MOV	ES:[BX],AX
	MOV	ES:[BX+2],AX
	MOV	AX,SI
	ADD	AX,AX
	ADD	AX,AX
	LEA	BX,[BP-198]
	ADD	BX,AX
	MOV	AX,[BP-26]
	MOV	[BX],AX
	MOV	AX,[BP-24]
	MOV	[BX+2],AX
	MOV	AX,SI
	OR	AX,AX
	JZ	HUFT_BUILD_23
	ADD	AX,AX		; connect to last table, if there is one
	LEA	BX,[BP-66]      ; save pattern for backing up
	ADD	BX,AX
	MOV	DX,[BP-14]
	MOV	[BX],DX
	MOV	BX,[BP-10]	; bits to dump before this table
	ADD	BX,AX
	SUB	BX,2
	MOV	CX,[BX]
	MOV	[BP-31],CL
	MOV	BX,AX           ; bits in this table
	MOV	AX,16
	ADD	AX,DI
	MOV	[BP-32],AL
	MOV	AX,[BP-26]	; pointer to this table
	MOV	[BP-30],AX
	MOV	AX,[BP-24]
	MOV	[BP-28],AX
	MOV	AX,[BP-6]
	SUB	AX,CX
	MOV	DX,AX
	MOV	AX,1
	MOV	CX,[BP-6]
	SHL	AX,CL
	DEC	AX
	MOV	CX,[BP-14]
	AND	CX,AX
	MOV	AX,CX
	MOV	CX,DX
	SHR	AX,CL
	ADD	AX,AX
	MOV	DX,AX
	ADD	AX,AX
	ADD	DX,AX
	MOV	AX,SI
	DEC	AX
	ADD	AX,AX
	ADD	AX,AX
	LEA	BX,[BP-198]	; connect to last table
	ADD	BX,AX
	MOV	AX,[BX]
	ADD	AX,DX
	MOV	DX,[BX+2]
	MOV	ES,DX
	MOV	BX,AX
	MOV	AX,[BP-32]
	MOV	ES:[BX],AX
	MOV	AX,[BP-30]
	MOV	ES:[BX+2],AX
	MOV	AX,[BP-28]
	MOV	ES:[BX+4],AX
HUFT_BUILD_23:
	MOV	AX,SI
	ADD	AX,AX
	MOV	BX,[BP-10]
	ADD	BX,AX
	MOV	AX,[BP-6]
	ADD	AX,[BX]
	CMP	AX,[BP-12]
	JGE	HUFT_BUILD_24
	JMP	HUFT_BUILD_16
HUFT_BUILD_24:
	MOV	AX,[BP-12]
	SUB	AX,[BP-6]
	MOV	[BP-31],AL
	MOV	AX,[BP+22]
	ADD	AX,AX
	LEA	DX,[BP-774]
	ADD	AX,DX
	MOV	BX,[BP-8]
	CMP	BX,AX
	JB	HUFT_BUILD_25
	MOV	BYTE PTR [BP-32],99	; out of values--invalid code
	JMP	HUFT_BUILD_27
HUFT_BUILD_25:
	MOV	AX,[BX]
	CMP	AX,[BP+20]
	JNB	HUFT_BUILD_26
	ADD	WORD PTR [BP-8],2
	MOV	[BP-30],AX		; simple code is just the value
	MOV	BYTE PTR [BP-32],16
	CMP	AX,256			; 256 is end-of-block code
	JB	HUFT_BUILD_27
	MOV	BYTE PTR [BP-32],15
	JMP	HUFT_BUILD_27
HUFT_BUILD_26:				; non-simple--look up in lists
	ADD	WORD PTR [BP-8],2
	SUB	AX,[BP+20]
	ADD	AX,AX
	LES	BX,[BP+12]
	ADD	BX,AX
	MOV	DL,ES:[BX]
	MOV	[BP-32],DL
	LES	BX,[BP+16]
	ADD	BX,AX
	MOV	AX,ES:[BX]
	MOV	[BP-30],AX
HUFT_BUILD_27:
	MOV	CX,[BP-12]
	SUB	CX,[BP-6]
	MOV	AX,1
	SHL	AX,CL
	MOV	[BP-18],AX
	MOV	CX,[BP-6]
	MOV	AX,[BP-14]
	SHR	AX,CL
	MOV	CX,AX
	MOV	AX,[BP-24]
	MOV	ES,AX
HUFT_BUILD_28:
	CMP	CX,[BP-2]
	JNB	HUFT_BUILD_29
	MOV	AX,CX
	ADD	AX,AX
	MOV	DX,AX
	ADD	AX,AX
	ADD	AX,DX
	MOV	BX,[BP-26]
	ADD	BX,AX
	MOV	AX,[BP-32]
	MOV	ES:[BX],AX
	MOV	AX,[BP-30]
	MOV	ES:[BX+2],AX
	MOV	AX,[BP-28]
	MOV	ES:[BX+4],AX
	ADD	CX,[BP-18]
	JMP	HUFT_BUILD_28
HUFT_BUILD_29:
	MOV	CX,[BP-12]
	DEC	CX
	MOV	AX,1
	SHL	AX,CL
	MOV	CX,AX
	MOV	DI,[BP-14]
HUFT_BUILD_30:
	TEST	DI,CX
	JZ	HUFT_BUILD_31
	XOR	DI,CX
	SHR	CX,1
	JMP	HUFT_BUILD_30
HUFT_BUILD_31:
	XOR	DI,CX
	MOV	[BP-14],DI
HUFT_BUILD_32:			; backup over finished tables
	MOV	AX,1
	MOV	CX,[BP-6]
	SHL	AX,CL
	DEC	AX
	MOV	DX,DI
	AND	DX,AX
	MOV	BX,SI
	ADD	BX,BX
	LEA	AX,[BP-66]
	ADD	BX,AX
	CMP	DX,[BX]
	JE	HUFT_BUILD_33
	DEC	SI
	MOV	AX,SI
	ADD	AX,AX
	MOV	BX,[BP-10]
	ADD	BX,AX
	MOV	AX,[BX]
	SUB	[BP-6],AX
	JMP	HUFT_BUILD_32
HUFT_BUILD_33:
	MOV	AX,[BP-22]
	DEC	WORD PTR [BP-22]
	OR	AX,AX
	JZ	HUFT_BUILD_34
	JMP	HUFT_BUILD_23
HUFT_BUILD_34:
	INC	WORD PTR [BP-12]
HUFT_BUILD_35:
	MOV	AX,[BP-12]
	CMP	AX,[BP-16]
	JG	HUFT_BUILD_36
	MOV	BX,AX
	ADD	BX,BX
	LEA	AX,[BP-134]
	ADD	BX,AX
	MOV	AX,[BX]
	MOV	[BP-22],AX
	JMP	HUFT_BUILD_33
HUFT_BUILD_36:
	MOV	BX,[BP-10]
	MOV	AX,[BX]
	LES	BX,[BP+4]
	MOV	ES:[BX],AX	; return actual size of base table
	MOV	AX,1            ; Return true (1) --warning error--
	CMP	WORD PTR [BP-4],0
	JZ	HUFT_BUILD_38   ; if we were given an incomplete table
	CMP	WORD PTR [BP-16],1
	JE	HUFT_BUILD_38
	JMP	HUFT_BUILD_39
HUFT_BUILD_37:
	MOV	AX,ER_MEM
	JMP	HUFT_BUILD_39
HUFT_BUILD_38:
	XOR	AX,AX
HUFT_BUILD_39:
	POP	DS
	POP	DI
	POP	SI
	MOV	SP,BP
	POP	BP
	RET	24
HUFT_BUILD ENDP

;************** Explode an imploded compressed stream

; Get the bit lengths for a code representation from the compressed
; stream. If gettree() returns 4, then there is an error in the data.
; Otherwise zero is returned.

EXPLODE_GETTREE PROC
	MOV	DI,AX
	CALL	ogetc
	INC	AX
	PUSH	AX
	XOR	SI,SI
EXPLODE_GETTREE_00:
	CALL	ogetc
	MOV	DX,AX
	AND	AX,000Fh
	MOV	CX,AX
	INC	CX
	AND	DX,00F0h
	SHR	DX,4
	INC	DX
	MOV	AX,DX
	ADD	AX,SI
	CMP	AX,DI
	JA	EXPLODE_GETTREE_03
EXPLODE_GETTREE_01:
	LEA	BX,[BP-540]
	MOV	AX,SI
	ADD	AX,AX
	ADD	BX,AX
	MOV	[BX],CX
	INC	SI
	DEC	DX
	JNZ	EXPLODE_GETTREE_01
	POP	AX
	DEC	AX
	JZ	EXPLODE_GETTREE_02
	PUSH	AX
	JMP	EXPLODE_GETTREE_00
EXPLODE_GETTREE_02:
	CMP	SI,DI
	JNE	EXPLODE_GETTREE_04
	RET
EXPLODE_GETTREE_03:
	POP	AX
EXPLODE_GETTREE_04:
	MOV	AX,4
	OR	AX,AX
	RET
EXPLODE_GETTREE ENDP

EXPLODE_INIT PROC
	XOR	AX,AX
	MOV	STDI.ios_l,AX
	MOV	BBL,AX
	MOV	BBH,AX
	MOV	[BP-6],AX
	MOV	AX,zip_local.lz_fsize_ax
	MOV	[BP-20],AX
	MOV	AX,zip_local.lz_fsize_dx
	MOV	[BP-18],AX
	RET
EXPLODE_INIT ENDP

DECODEHUFT PROC
	CALL	GETBITS
DECODEHUFT_00:
	NOT	AX
	AND	AX,DX
	ADD	AX,AX
	ADD	BX,AX
	ADD	AX,AX
	ADD	BX,AX
	MOV	ES,SI
	MOV	CL,ES:[BX.huft_b]
	CALL	DUMPBITS
	XOR	AX,AX
	MOV	AL,ES:[BX.huft_e]
	MOV	SI,AX
	MOV	AL,0
	CMP	SI,16
	JBE	DECODEHUFT_01
	INC	AX
	CMP	SI,99
	JE	DECODEHUFT_01
	SUB	SI,16
	MOV	AX,SI
	PUSH	ES
	CALL	GETBITS
	POP	ES
	MOV	SI,ES:[BX+4]
	MOV	BX,ES:[BX+2]
	JMP	DECODEHUFT_00
DECODEHUFT_01:
	OR	AX,AX
	RET
DECODEHUFT ENDP

EXPLODE_DOCOPY PROC
	MOV	AX,[BP-4]
	CALL	GETDUMP
	MOV	DI,AX
	MOV	BX,[BP-30]
	MOV	SI,[BP-28]
	MOV	AX,[BP-22]
	CALL	DECODEHUFT
	JZ	EXPLODE_DOCOPY_00
	JMP	EXPLODE_DOCOPY_11
EXPLODE_DOCOPY_00:
	MOV	DX,ES:[BX+2]
	MOV	AX,STDO.ios_i
	SUB	AX,DI
	SUB	AX,DX
	MOV	DI,AX
	MOV	AX,[BP-24]
	MOV	BX,[BP-34]
	MOV	SI,[BP-32]
	CALL	DECODEHUFT
	JZ	EXPLODE_DOCOPY_01
	JMP	EXPLODE_DOCOPY_10
EXPLODE_DOCOPY_01:
	MOV	AX,ES:[BX+2]
	XCHG	SI,AX
	OR	AX,AX
	JZ	EXPLODE_DOCOPY_02
	MOV	AX,8
	CALL	GETDUMP
	ADD	SI,AX
EXPLODE_DOCOPY_02:
	XOR	AX,AX
	MOV	DX,[BP-20]
	MOV	BX,[BP-18]
	MOV	[BP-20],AX
	MOV	[BP-18],AX
	MOV	AX,SI
	OR	BX,BX
	JNZ	EXPLODE_DOCOPY_03
	CMP	DX,AX
	JBE	EXPLODE_DOCOPY_04
EXPLODE_DOCOPY_03:
	SUB	DX,AX
	SBB	BX,0
	MOV	[BP-20],DX
	MOV	[BP-18],BX
EXPLODE_DOCOPY_04:
	AND	DI,OSIZE-1
	MOV	AX,DI
	CMP	AX,STDO.ios_i
	JA	EXPLODE_DOCOPY_05
	MOV	AX,STDO.ios_i
EXPLODE_DOCOPY_05:
	MOV	CX,OSIZE
	SUB	CX,AX
	CMP	CX,SI
	JNA	EXPLODE_DOCOPY_06
	MOV	CX,SI
EXPLODE_DOCOPY_06:
	SUB	SI,CX
	MOV	AX,STDO.ios_i
	ADD	STDO.ios_i,CX
	PUSH	DS
	PUSH	SI
	MOV	SI,DI
	ADD	DI,CX
	PUSH	DI
	CLD
	MOV	BX,STDO.ios_bp_ax
	MOV	DX,STDO.ios_bp_dx
	MOV	ES,DX
	MOV	DS,DX
	MOV	DI,BX
	ADD	DI,AX
	ADD	BX,SI
	CMP	AX,SI
	MOV	SI,BX
	JBE	EXPLODE_DOCOPY_11
EXPLODE_DOCOPY_07:
	REP	MOVSB
EXPLODE_DOCOPY_08:
	POP	DI
	POP	SI
	POP	DS
	CMP	STDO.ios_i,OSIZE
	JNB	EXPLODE_DOCOPY_12
EXPLODE_DOCOPY_09:
	OR	SI,SI
	JNZ	EXPLODE_DOCOPY_04
	XOR	AX,AX
EXPLODE_DOCOPY_10:
	RET
EXPLODE_DOCOPY_11:
	MOV	AL,[BP-6]
	OR	AL,AL
	JNZ	EXPLODE_DOCOPY_07
	REP	STOSB
	JMP	EXPLODE_DOCOPY_08
EXPLODE_DOCOPY_12:
	CALL	oflush
	MOV	[BP-6],AL
	JNZ	EXPLODE_DOCOPY_09
	MOV	AX,ER_DISK
	RET
EXPLODE_DOCOPY ENDP

; Decompress the imploded data using coded literals and a sliding
; window (of size 2^(6+bdl) bytes).

EXPLODE_LIT PROC
	CALL	EXPLODE_INIT
EXPLODE_LIT_00:
	XOR	AX,AX
	CMP	AX,[BP-18]
	JNE	EXPLODE_LIT_06
	CMP	AX,[BP-20]
	JE	EXPLODE_LIT_03
EXPLODE_LIT_06:
	INC	AL
	CALL	GETDUMP
	OR	AL,AL
	JZ	EXPLODE_LIT_01
	SUB	WORD PTR [BP-20],1
	SBB	WORD PTR [BP-18],0
	MOV	BX,[BP-38]
	MOV	SI,[BP-36]
	MOV	AX,[BP-26]
	CALL	DECODEHUFT
	JNZ	EXPLODE_LIT_04
	MOV	AL,ES:[BX+2]
	CALL	oputc
	JZ	EXPLODE_LIT_05
	CMP	AX,STDO.ios_i
	JBE	EXPLODE_LIT_00
	MOV	[BP-6],AL
	JMP	EXPLODE_LIT_00
EXPLODE_LIT_01:
	CALL	EXPLODE_DOCOPY
EXPLODE_LIT_02:
	OR	AX,AX
	JNZ	EXPLODE_LIT_04
	JMP	EXPLODE_LIT_00
EXPLODE_LIT_03:
	CALL	oflush
EXPLODE_LIT_05:
	DEC	AX
EXPLODE_LIT_04:
	RET
EXPLODE_LIT ENDP

; Decompress the imploded data using uncoded literals and a sliding
; window (of size 2^(6+bdl) bytes).

EXPLODE_NOLIT PROC
	CALL	EXPLODE_INIT
EXPLODE_NOLIT_00:
	XOR	AX,AX
	CMP	[BP-18],AX
	JNE	EXPLODE_NOLIT_06
	CMP	[BP-20],AX
	JE	EXPLODE_NOLIT_03
EXPLODE_NOLIT_06:
	INC	AX
	CALL	GETDUMP
	OR	AL,AL
	JZ	EXPLODE_NOLIT_02
	SUB	WORD PTR [BP-20],1
	SBB	WORD PTR [BP-18],0
	MOV	AX,8
	CALL	GETDUMP
	JZ	EXPLODE_NOLIT_04
	CALL	oputc
	JZ	EXPLODE_NOLIT_05		; Out of space..
	CMP	AX,STDO.ios_i
	JBE	EXPLODE_NOLIT_00
	MOV	[BP-6],AL
	JMP	EXPLODE_NOLIT_00
EXPLODE_NOLIT_01:
	OR	AX,AX
	JZ	EXPLODE_NOLIT_00
	JMP	EXPLODE_NOLIT_04
EXPLODE_NOLIT_02:
	CALL	EXPLODE_DOCOPY
	JMP	EXPLODE_NOLIT_01
EXPLODE_NOLIT_03:
	CALL	oflush
EXPLODE_NOLIT_05:
	DEC	AX
EXPLODE_NOLIT_04:
	RET
EXPLODE_NOLIT ENDP

zip_explode PROC DIST
	PUSH	BP
	MOV	BP,SP
	SUB	SP,540
	PUSH	SI
	PUSH	DI
	XOR	AX,AX
	MOV	[BP-38],AX
	MOV	[BP-36],AX
	MOV	AX,7
	MOV	[BP-24],AX
	CMP	zip_local.lz_csize_dx,0003h
	JB	EXPLODE_00
	CMP	zip_local.lz_csize_ax,0D40h
	JBE	EXPLODE_00
	INC	AX
EXPLODE_00:
	MOV	[BP-22],AX
	TEST	zip_local.lz_flag,0004h
	JZ	EXPLODE_04
	MOV	WORD PTR [BP-26],9
	MOV	AX,256
	CALL	EXPLODE_GETTREE
	JNZ	EXPLODE_03
	PUSH	SS
	LEA	AX,[BP-540]
	PUSH	AX
	PUSH	256
	PUSH	256
	XOR	DX,DX
	PUSH	DX
	PUSH	DX
	PUSH	DX
	PUSH	DX
	PUSH	SS
	ADD	AX,540-38
	PUSH	AX
	PUSH	SS
	ADD	AX,38-26
	PUSH	AX
	CALL	HUFT_BUILD
	OR	AX,AX
	JNZ	EXPLODE_01
	MOV	AX,64
	CALL	EXPLODE_GETTREE
	JZ	EXPLODE_06
	JMP	EXPLODE_02
EXPLODE_01:
	CMP	AX,1
	JNE	EXPLODE_03
EXPLODE_02:
	PUSH	AX
	pushm	[BP-38]
	CALL	HUFT_FREE
	POP	AX
EXPLODE_03:
	POP	DI
	POP	SI
	MOV	SP,BP
	POP	BP
	RET
EXPLODE_04:
	MOV	AX,64
	CALL	EXPLODE_GETTREE
	JZ	EXPLODE_05
	JMP	EXPLODE_03
EXPLODE_05:
	MOV	DX,OFFSET cplen2
	JMP	EXPLODE_07
EXPLODE_06:
	MOV	DX,OFFSET cplen3
EXPLODE_07:
	PUSH	SS
	LEA	AX,[BP-540]
	PUSH	AX
	PUSH	0040h
	PUSH	0000h
	PUSH	DS
	PUSH	DX
	PUSH	DS
	PUSH	OFFSET exextra
	PUSH	SS
	ADD	AX,540-34
	PUSH	AX
	PUSH	SS
	ADD	AX,34-24
	PUSH	AX
	CALL	HUFT_BUILD
	OR	AX,AX
	JNZ	EXPLODE_12
	MOV	AX,64
	CALL	EXPLODE_GETTREE
	JNZ	EXPLODE_13
	PUSH	SS
	LEA	AX,[BP-540]
	PUSH	AX
	PUSH	0040h
	PUSH	0000h
	MOV	WORD PTR [BP-4],7
	MOV	DX,OFFSET cpdist8
	TEST	zip_local.lz_flag,2
	JNZ	EXPLODE_08
	MOV	DX,OFFSET cpdist4
	DEC	BYTE PTR [BP-4]
EXPLODE_08:
	PUSH	DS
	PUSH	DX
	PUSH	DS
	PUSH	OFFSET exextra
	PUSH	SS
	ADD	AX,540-30
	PUSH	AX
	PUSH	SS
	ADD	AX,30-22
	PUSH	AX
	CALL	HUFT_BUILD
	OR	AX,AX
	JNZ	EXPLODE_10
	CMP	AX,[BP-38]
	JE	EXPLODE_09
	CALL	EXPLODE_LIT
	JMP	EXPLODE_11
EXPLODE_09:
	CALL	EXPLODE_NOLIT
	JMP	EXPLODE_11
EXPLODE_10:
	CMP	AX,1
	JNE	EXPLODE_13
EXPLODE_11:
	PUSH	AX
	pushm	[BP-30]
	CALL	HUFT_FREE
	POP	AX
	JMP	EXPLODE_13
EXPLODE_12:
	CMP	AX,1
	JNE	EXPLODE_14
EXPLODE_13:	PUSH	AX
	pushm	[BP-34]
	CALL	HUFT_FREE
	POP	AX
EXPLODE_14:
	JMP	EXPLODE_02
zip_explode ENDP

;************** Decompress the codes in a compressed block

INFLATECODE00 PROC
	CALL	GETBITS
	ADD	AX,AX
	ADD	BX,AX
	ADD	AX,AX
	ADD	BX,AX
	MOV	ES,SI
	XOR	AX,AX
	MOV	AL,ES:[BX.huft_e]
	MOV	SI,AX
	CMP	AL,16
	JA	INFLC0_01
INFLC0_00:
	MOV	CL,ES:[BX.huft_b]
	CALL	DUMPBITS
	XOR	AX,AX
	RET
INFLC0_01:
	CMP	AL,99
	JE	INFLC0_E99
INFLC0_02:
	MOV	CL,ES:[BX.huft_b]
	CALL	DUMPBITS
	SUB	SI,16
	MOV	AX,SI
	MOV	SI,ES
	CALL	GETBITS
	MOV	ES,SI
	LES	BX,ES:[BX+2]
	ADD	AX,AX
	ADD	BX,AX
	ADD	AX,AX
	ADD	BX,AX
	XOR	AX,AX
	MOV	AL,ES:[BX.huft_e]
	MOV	SI,AX
	CMP	AL,16
	JA	INFLC0_01
	JMP	INFLC0_00
INFLC0_E99:
	MOV	AX,1
	OR	AL,AL
	RET
INFLATECODE00 ENDP

INFLATE_CODES PROC
	PUSH	BP
	MOV	BP,SP
	PUSH	SI
	PUSH	DI
INFLATE_CODES_00:
	MOV	SI,[BP+14]
	MOV	BX,[BP+12]
	MOV	AX,[BP+6]
	CALL	INFLATECODE00
	JZ	INFLATE_CODES_13
	JMP	INFLATE_CODES_12
INFLATE_CODES_13:
	CMP	SI,16
	JNE	INFLATE_CODES_01
	MOV	AL,ES:[BX+2]
	CALL	oputc
	JNZ	INFLATE_CODES_00
	JMP	INFLATE_CODES_10
INFLATE_CODES_01:
	CMP	SI,15
	JNE	INFLATE_CODES_14
	JMP	INFLATE_CODES_11
INFLATE_CODES_14:
	MOV	AX,SI
	MOV	SI,ES
	CALL	GETDUMP
	MOV	ES,SI
	ADD	AX,ES:[BX+2]
	MOV	DI,AX
	MOV	SI,[BP+10]
	MOV	BX,[BP+8]
	MOV	AX,[BP+4]
	CALL	INFLATECODE00
	JNZ	INFLATE_CODES_12
	PUSH	ES:[BX.huft_n]
	MOV	AX,SI
	CALL	GETDUMP
	MOV	DX,AX
	MOV	AX,STDO.ios_i
	POP	BX
	SUB	AX,BX
	SUB	AX,DX
	MOV	BX,AX
INFLATE_CODES_02:
	AND	BX,OSIZE-1
	MOV	CX,OSIZE
	MOV	AX,BX
	CMP	AX,STDO.ios_i
	JA	INFLATE_CODES_03
	MOV	AX,STDO.ios_i
INFLATE_CODES_03:
	SUB	CX,AX
	CMP	CX,DI
	JNA	INFLATE_CODES_04
	MOV	CX,DI
INFLATE_CODES_04:
	SUB	DI,CX
	MOV	AX,STDO.ios_i
	ADD	STDO.ios_i,CX
	PUSH	DS
	MOV	DX,STDO.ios_bp_dx
	MOV	SI,STDO.ios_bp_ax
	MOV	DS,DX
	MOV	ES,DX
	MOV	DX,DI
	MOV	DI,SI
	ADD	DI,AX
	ADD	SI,BX
	ADD	BX,CX
	ADD	AX,CX
	CLD
	REP	MOVSB
	MOV	DI,DX
	POP	DS
	CMP	AX,OSIZE
	JNB	INFLATE_CODES_06
INFLATE_CODES_05:
	OR	DI,DI
	JNZ	INFLATE_CODES_02
	JMP	INFLATE_CODES_00
INFLATE_CODES_06:
	PUSH	BX
	CALL	oflush
	POP	BX
	JNZ	INFLATE_CODES_05
INFLATE_CODES_10:
	MOV	AX,ER_DISK
	JMP	INFLATE_CODES_12
INFLATE_CODES_11:
	XOR	AX,AX
INFLATE_CODES_12:
	POP	DI
	POP	SI
	POP	BP
	RET	12
INFLATE_CODES ENDP

;************** Decompress an inflated type 1 (fixed Huffman codes) block

INFLATE_FIXED PROC
	PUSH	BP
	MOV	BP,SP
	SUB	SP,576
	PUSH	DI
	LEA	DI,[BP-576]
	XOR	AX,AX
	CMP	WORD PTR fixed_tl,AX
	JE	INFF_00
	JMP	INFLFX_01
INFF_00:
	MOV	BX,DI
	PUSH	SS
	POP	ES
	CLD
	MOV	CX,144
	MOV	AX,8
	REP	STOSW
	MOV	CX,112
	MOV	AX,9
	REP	STOSW
	MOV	CX,24
	MOV	AX,7
	REP	STOSW
	MOV	CX,8
	MOV	AX,8
	REP	STOSW
	MOV	DI,BX
	MOV	fixed_bl,7
	PUSH	SS
	PUSH	DI
	PUSH	0120h
	PUSH	0101h
	PUSH	DS
	PUSH	OFFSET cplens
	PUSH	DS
	PUSH	OFFSET cplext
	PUSH	DS
	PUSH	OFFSET fixed_tl
	PUSH	DS
	PUSH	OFFSET fixed_bl
	CALL	HUFT_BUILD
	OR	AX,AX
	JZ	INFLFX_00
	MOV	WORD PTR fixed_tl,0
	JMP	INFLFX_02
INFLFX_00:
	MOV	DX,DI
	MOV	CX,30
	MOV	AX,5
	PUSH	SS
	POP	ES
	CLD
	REP	STOSW
	MOV	fixed_bd,5
	MOV	DI,DX
	MOV	AX,DS
	PUSH	SS
	PUSH	DI
	PUSH	001Eh
	PUSH	0000h
	PUSH	AX
	PUSH	OFFSET cpdist
	PUSH	AX
	PUSH	OFFSET cpdext
	PUSH	AX
	PUSH	OFFSET fixed_td
	PUSH	AX
	PUSH	OFFSET fixed_bd
	CALL	HUFT_BUILD
	CMP	AX,1
	JBE	INFLFX_01
	PUSH	AX
	pushm	fixed_tl
	CALL	HUFT_FREE
	MOV	WORD PTR fixed_tl,0
	POP	AX
	JMP	INFLFX_02
INFLFX_01:
	pushm	fixed_tl
	pushm	fixed_td
	PUSH	fixed_bl
	PUSH	fixed_bd
	CALL	INFLATE_CODES
	OR	AX,AX
	JZ	INFLFX_02
	MOV	AX,1
INFLFX_02:
	POP	DI
	MOV	SP,BP
	POP	BP
	RET
INFLATE_FIXED ENDP

;************** Decompress an inflated type 2 (dynamic Huffman codes) block

INFLATE_DYNAMIC	PROC
	PUSH	BP
	MOV	BP,SP
	SUB	SP,662
	PUSH	SI
	PUSH	DI
	MOV	AX,5
	CALL	GETDUMP
	ADD	AX,257
	MOV	[BP-4],AX
	MOV	AX,5
	CALL	GETDUMP
	INC	AX
	MOV	[BP-2],AX
	MOV	AX,4
	CALL	GETDUMP
	ADD	AX,4
	MOV	[BP-6],AX
	CMP	WORD PTR [BP-4],288 ; (286) PKZIP_BUG_WORKAROUND
	JA	INFLDYN_00
	CMP	WORD PTR [BP-2],32  ;  (30) PKZIP_BUG_WORKAROUND
	JBE	INFLDYN_01
INFLDYN_00:
	MOV	AX,1
	JMP	INFLDYN_23
INFLDYN_01:
	XOR	SI,SI
	LEA	DI,[BP-662]
	JMP	INFLDYN_03
INFLDYN_02:
	MOV	AX,3
	CALL	GETDUMP
	MOV	DX,AX
	MOV	BX,SI
	ADD	BX,BX
	MOV	AX,[BX+border]
	ADD	AX,AX
	MOV	BX,DI
	ADD	BX,AX
	MOV	[BX],DX
	INC	SI
INFLDYN_03:
	CMP	SI,[BP-6]
	JB	INFLDYN_02
	JMP	INFLDYN_05
INFLDYN_04:
	MOV	BX,SI
	ADD	BX,BX
	MOV	AX,[BX+border]
	ADD	AX,AX
	MOV	BX,DI
	ADD	BX,AX
	XOR	AX,AX
	MOV	[BX],AX
	INC	SI
INFLDYN_05:
	MOV	AX,19
	CMP	SI,AX
	JB	INFLDYN_04
	MOV	WORD PTR [BP-10],7
	PUSH	SS
	PUSH	DI
	PUSH	AX
	PUSH	AX
	XOR	AX,AX
	PUSH	AX
	PUSH	AX
	PUSH	AX
	PUSH	AX
	PUSH	SS
	LEA	AX,[BP-18]
	PUSH	AX
	PUSH	SS
	ADD	AX,8
	PUSH	AX
	CALL	HUFT_BUILD
	CMP	WORD PTR [BP-10],0
	JNE	INFLDYN_06
	MOV	AX,1		; no bit lengths
INFLDYN_06:
	OR	AX,AX
	JZ	INFLDYN_08
	CMP	AX,1
	JNE	INFLDYN_07
	PUSH	AX
	pushm	[BP-18]
	CALL	HUFT_FREE
	POP	AX
INFLDYN_07:
	JMP	INFLDYN_23	; incomplete code set
INFLDYN_08:
	MOV	AX,[BP-4]
	ADD	AX,[BP-2]
	MOV	[BP-20],AX
	XOR	AX,AX
	MOV	SI,AX
	MOV	DI,AX
INFLDYN_09:
	CMP	SI,[BP-20]
	JB	INFLDYN_10
	JMP	INFLDYN_19
INFLDYN_10:
	MOV	AX,[BP-18]
	MOV	[BP-14],AX
	MOV	AX,[BP-16]
	MOV	[BP-12],AX
	MOV	AX,[BP-10]
	CALL	GETBITS
	ADD	AX,AX
	MOV	BX,AX
	ADD	AX,AX
	ADD	AX,BX
	ADD	[BP-14],AX
	LES	BX,[BP-14]
	MOV	CL,BYTE PTR ES:[BX+1]
	CALL	DUMPBITS
	MOV	AX,ES:[BX+2]
	CMP	AX,16
	JE	INFLDYN_12
	JA	INFLDYN_13
	MOV	DI,AX
	MOV	BX,SI
	INC	SI
	ADD	BX,BX
	ADD	BX,BP
	SUB	BX,662
	MOV	[BX],AX
	JMP	INFLDYN_09
INFLDYN_11:
	OR	DX,DX
	JZ	INFLDYN_09
	DEC	DX
	MOV	BX,SI
	INC	SI
	ADD	BX,BX
	ADD	BX,BP
	SUB	BX,662
	MOV	[BX],DI
	JMP	INFLDYN_11
INFLDYN_12:
	MOV	AX,2
	CALL	GETDUMP
	ADD	AX,3
	MOV	DX,AX
	ADD	AX,SI
	CMP	AX,[BP-20]
	JBE	INFLDYN_11
	MOV	AX,1
	JMP	INFLDYN_23
INFLDYN_13:
	CMP	AX,17
	JNE	INFLDYN_18
	MOV	AX,3
	CALL	GETDUMP
	ADD	AX,3
	MOV	DX,AX
INFLDYN_14:
	ADD	AX,SI
	CMP	AX,[BP-20]
	JBE	INFLDYN_15
	MOV	AX,1
	JMP	INFLDYN_23
INFLDYN_15:
	XOR	DI,DI
	XOR	AX,AX
	OR	DX,DX
	JMP	INFLDYN_17
INFLDYN_16:
	MOV	BX,SI
	INC	SI
	ADD	BX,BX
	ADD	BX,BP
	SUB	BX,662
	MOV	[BX],AX
	DEC	DX
INFLDYN_17:
	JNZ	INFLDYN_16
	JMP	INFLDYN_09
INFLDYN_18:
	MOV	AX,7
	CALL	GETDUMP
	ADD	AX,11
	MOV	DX,AX
	JMP	INFLDYN_14
INFLDYN_19:
	pushm	[BP-18]
	CALL	HUFT_FREE
	MOV	AX,zlbits
	MOV	[BP-10],AX
	PUSH	SS
	LEA	AX,[BP-662]
	PUSH	AX
	PUSH	WORD PTR [BP-4]
	PUSH	257
	PUSH	DS
	PUSH	OFFSET cplens
	PUSH	DS
	PUSH	OFFSET cplext
	PUSH	SS
	ADD	AX,662-18
	PUSH	AX
	PUSH	SS
	ADD	AX,8
	PUSH	AX
	CALL	HUFT_BUILD
	CMP	WORD PTR [BP-10],0
	JNZ	INFLDYN_20
	MOV	AX,1
INFLDYN_20:
	OR	AX,AX
	JZ	INFLDYN_24
	CMP	AX,1
	JNE	INFLDYN_23
INFLDYN_21:
	PUSH	AX
	pushm	[BP-18]
	CALL	HUFT_FREE
	POP	AX
	JMP	INFLDYN_23
INFLDYN_22:
	pushm	[BP-18]
	CALL	HUFT_FREE
	pushm	[BP-14]
	CALL	HUFT_FREE
	XOR	AX,AX
INFLDYN_23:
	POP	DI
	POP	SI
	MOV	SP,BP
	POP	BP
	RET
INFLDYN_24:
	MOV	AX,zdbits
	MOV	[BP-8],AX
	PUSH	SS
	LEA	AX,[BP-662]
	ADD	AX,[BP-4]
	ADD	AX,[BP-4]
	PUSH	AX
	PUSH	WORD PTR [BP-2]
	PUSH	0
	PUSH	DS
	PUSH	OFFSET cpdist
	PUSH	DS
	PUSH	OFFSET cpdext
	PUSH	SS
	LEA	AX,[BP-14]
	PUSH	AX
	PUSH	SS
	ADD	AX,6
	PUSH	AX
	CALL	HUFT_BUILD
	CMP	WORD PTR [BP-10],0
	JNE	INFLDYN_25
	CMP	WORD PTR [BP-4],257
	JBE	INFLDYN_25
	MOV	AX,1
	JMP	INFLDYN_21
INFLDYN_25:
	CMP	AX,1
	JNE	INFLDYN_26
	XOR	AX,AX
INFLDYN_26:
	OR	AX,AX
	JNZ	INFLDYN_21
	pushm	[BP-18]
	pushm	[BP-14]
	PUSH	[BP-10]
	PUSH	[BP-8]
	CALL	INFLATE_CODES
	OR	AX,AX
	JZ	INFLDYN_22
	MOV	AX,1
	JMP	INFLDYN_23
INFLATE_DYNAMIC	ENDP

;****** Decompress an inflated type 0 (stored) block.

INFLATE_STORED PROC
	PUSH	SI
	MOV	STDI.ios_l,0
	MOV	AX,16
	CALL	GETDUMP
	MOV	SI,AX
	MOV	AX,16
	CALL	GETDUMP
	NOT	AX
	CMP	AX,SI
	JNE	INFLATE_STORED_01
INFLATE_STORED_00:
	OR	SI,SI
	JZ	INFLATE_STORED_02
	DEC	SI
	MOV	AX,8
	CALL	GETDUMP
	JZ	INFLATE_STORED_01
	CALL	oputc
	JNZ	INFLATE_STORED_00
	MOV	AX,ER_DISK
	JMP	INFLATE_STORED_03
INFLATE_STORED_01:
	MOV	AX,1
	JMP	INFLATE_STORED_03
INFLATE_STORED_02:
	XOR	AX,AX
INFLATE_STORED_03:
	POP	SI
	RET
INFLATE_STORED ENDP

INFLATE_BLOCK PROC
	PUSH	DI
	MOV	AX,1
	CALL	GETDUMP
	MOV	DI,AX
	MOV	AX,2
	CALL	GETDUMP
	MOV	DX,AX
	CMP	AX,2
	JE	INFLBLK_02
	CMP	AX,1
	JE	INFLBLK_00
	OR	AX,AX
	JZ	INFLBLK_01
	JMP	INFLBLK_04
INFLBLK_00:
	CALL	INFLATE_FIXED
	JMP	INFLBLK_03
INFLBLK_01:
	CALL	INFLATE_STORED
	JMP	INFLBLK_03
INFLBLK_02:
	CALL	INFLATE_DYNAMIC
INFLBLK_03:
	MOV	zresult,AX
	JMP	INFLBLK_05
INFLBLK_04:
	MOV	zresult,ER_ZIP
INFLBLK_05:
	MOV	AX,DI
	POP	DI
	RET
INFLATE_BLOCK ENDP

FREE_BLOCK PROC
	CMP	WORD PTR fixed_tl,AX
	JZ	FREE_BLOCK_00
	pushm	fixed_td
	CALL	HUFT_FREE
	pushm	fixed_tl
	CALL	HUFT_FREE
	XOR	AX,AX
	MOV	WORD PTR fixed_td,AX
	MOV	WORD PTR fixed_tl,AX
FREE_BLOCK_00:
	RET
FREE_BLOCK ENDP

zip_inflate PROC DIST
	PUSH	DI
	XOR	AX,AX
	MOV	BBL,AX
	MOV	BBH,AX
	MOV	zresult,AX
INFLATE_00:
	CALL	INFLATE_BLOCK
	CMP	zresult,0
	JNE	INFLATE_02
	OR	AX,AX
	JZ	INFLATE_00
	CALL	oflush
	JNZ	INFLATE_02
	MOV	zresult,ER_USERABORT
	TEST	STDO.ios_flag,IO_ERROR
	JZ	INFLATE_02
INFLATE_01:
	MOV	zresult,ER_DISK
INFLATE_02:
	CALL	FREE_BLOCK
	MOV	AX,zresult
	POP	DI
	RET
zip_inflate ENDP

_TEXT	ENDS

_DATA	SEGMENT

zresult		DW	0
fixed_bd	DW	0
fixed_bl	DW	0
fixed_td	DD	0
fixed_tl	DD	0

border		DW	16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15
cplens		DW	3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51
		DW	59,67,83,99,115,131,163,195,227,258,0,0
cplext		DW	0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5
		DW	5,5,5,0,99,99
cpdist		DW	1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257
		DW	385,513,769,1025,1537,2049,3073,4097,6145,8193
		DW	12289,16385,24577
cpdext		DW	0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9
		DW	10,10,11,11,12,12,13,13
zlbits		DW	9
zdbits		DW	6
cplen2		DW	2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17
		DW	18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34
		DW	35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51
		DW	52,53,54,55,56,57,58,59,60,61,62,63,64,65
cplen3		DW	3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18
		DW	19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35
		DW	36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52
		DW	53,54,55,56,57,58,59,60,61,62,63,64,65,66
exextra		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
		DW	8
cpdist4		DW	1,65,129,193,257,321,385,449,513,577,641,705
		DW	769,833,897,961,1025,1089,1153,1217,1281,1345,1409,1473
		DW	1537,1601,1665,1729,1793,1857,1921,1985,2049,2113,2177
		DW	2241,2305,2369,2433,2497,2561,2625,2689,2753,2817,2881
		DW	2945,3009,3073,3137,3201,3265,3329,3393,3457,3521,3585
		DW	3649,3713,3777,3841,3905,3969,4033
cpdist8		DW	1,129,257,385,513,641,769,897,1025,1153,1281
		DW	1409,1537,1665,1793,1921,2049,2177,2305,2433,2561,2689
		DW	2817,2945,3073,3201,3329,3457,3585,3713,3841,3969,4097
		DW	4225,4353,4481,4609,4737,4865,4993,5121,5249,5377,5505
		DW	5633,5761,5889,6017,6145,6273,6401,6529,6657,6785,6913
		DW	7041,7169,7297,7425,7553,7681,7809,7937,8065

_DATA	ENDS

	END
