	.186

include	clib.inc
ifdef __EDIT__
include	tinfo.inc
include	malloc.inc

	public	tigetline
	public	timemline

_TEXT	SEGMENT

tigetline PROC
	mov	dx,tinfo
tigetline ENDP

timemline PROC
	push	si
	push	di
	mov	di,ax
	mov	si,dx
	mov	ax,[si.ti_flag]
	test	ax,_T_LINEBUF
	jz	timemline_nol
	cmp	di,[si.ti_brow]
	jnb	timemline_null
	and	ax,_T_EMMBUF
	mov	ax,[si.ti_bcol]
	jz	timemline_malloc
	shl	ax,2			; align segment
	mul	di   			; DX to page
	cmp	dx,[si.ti_emmp]
	jne	timemline_setpage
    timemline_pageok:
	mov	[si.ti_emmp],dx		; save page offset
	shr	ax,6
    timemline_ok:
	add	ax,[si.ti_bpdx]		; + segment
	mov	dx,ax
	xor	ax,ax
	cmp	di,[si.ti_lcnt]
	jnb	timemline_new
	or	dx,dx
	clc
    timemline_end:
	pop	di	; Carry set if new line
	pop	si
	ret
    timemline_nol:
	mov	ax,[si.ti_bpax]
	mov	dx,[si.ti_bpdx]
    timemline_new:
	or	dx,dx
	stc
	jmp	timemline_end
    timemline_malloc:
	shr	ax,4			; line size in para
	mul	di			; * line offset
	jmp	timemline_ok
    timemline_setpage:
	push	dx
	push	ax
	pushm	[si.ti_bpax]
	push	[si.ti_emmh]
	push	dx
	pushm	[si.ti_bpax]
	push	[si.ti_emmh]
	push	[si.ti_emmp]
	call	emmwrite
	or	ax,ax
	jnz	timemline_emmfail
	call	emmread
	or	ax,ax
	pop	ax
	pop	dx
	jz	timemline_pageok
    timemline_null:		; ZF and CF set on error
	xor	ax,ax
	cwd
	jmp	timemline_new
    timemline_emmfail:
	add	sp,12
	DPUSH	[si.ti_emmp]
	tracev	"fail: emmwrite(%d)",2
	jmp	timemline_null
timemline ENDP

_TEXT	ENDS
endif
	END
