include	clib.inc
include	version.inc
include	malloc.inc
include	string.inc
include	stdio.inc
include	stdlib.inc
include	io.inc
include	dir.inc
include	dos.inc
include	errno.inc
include	iost.inc
include	clip.inc
include	conio.inc
include	mouse.inc
include	keyb.inc
include	math.inc
include	tview.inc

	.186

	public	textview

	extrn	tvflag: BYTE
	extrn	fsflag: BYTE
	extrn	tvmem_offs: DWORD
	extrn	tvmem_size: DWORD
	extrn	IDD_TVHELP:WORD
	extrn	IDD_TVCOPY:WORD
	extrn	IDD_TVSEEK:WORD
if USE_TVCLASS
	extrn	tv_clversion:WORD
	extrn	tv_classsize:WORD
	extrn	tv_classrow:WORD
	extrn	tv_class:S_CLASS
	extrn	IDD_TVCLASS:WORD
	extrn	IDD_TVCLSAVE:WORD
	extrn	IDD_TVCLFORM:WORD
	extrn	wgetfile:DIST
	CLFLAGS	= _D_DOPEN or _D_ONSCR or _D_MYBUF
endif

S_TEXTVIEW 	STRUC
tv_offset_ax	DW ?
tv_offset_dx	DW ?
tv_fsize_ax	DW ?
tv_fsize_dx	DW ?
tv_xflag	DW ?		; config flag
tv_dialog_ax	DW ?		; main dialog pointer
tv_dialog_dx	DW ?
tv_tdialog_ax	DW ?		; global dialog pointer
tv_tdialog_dx	DW ?
tv_rowcnt	DW ?		; max lines (23/48)
tv_lcount	DW ?		; lines on screen
tv_scount_ax	DW ?		; bytes on screen
tv_scount_dx	DW ?
tv_maxcol_ax	DW ?		; max linesize on screen
tv_maxcol_dx	DW ?
tv_curcol_ax	DW ?		; current line offset (col)
tv_curcol_dx	DW ?
tv_screen	DD ?		; screen buffer
tv_switch	DW ?		; main switch
tv_cursor	DD ?		; cursor (old)
tv_oldupd	DW ?		; update proc (old)
tv_s_dlg	DD ?		; search dialog
tv_s_offs	DD ?		; search offset
tv_static_count	DW ?		; line count
tv_bsize	DW ?		; buffer size
tv_xpos		DW ?		; temp (mouse)
tv_ypos		DW ?		; temp (mouse)
tv_zpos		DW ?		; temp (mouse)
tv_tmp_ax	DW ?	 	; temp 32
tv_tmp_dx	DW ?
tv_line_table	DD  50 dup(?)	; line offset in file
tv_static_table	DD 256 dup(?)	; offset of first 256 lines
if USE_TVCLASS
 tv_CLDLG	S_DOBJ <?>
 tv_CLOBJ	S_TOBJ CLCOUNT dup(<?>)
endif
;---
tv_stack_size	DW ?		; push bp
tv_arg_return	PF ?
tv_arg_memz_ax	DW ?
tv_arg_memz_dx	DW ?
tv_arg_memo_ax	DW ?
tv_arg_memo_dx	DW ?
tv_arg_offs_ax	DW ?
tv_arg_offs_dx	DW ?
tv_arg_file_ax	DW ?
tv_arg_file_dx	DW ?
S_TEXTVIEW ENDS

_DATA	SEGMENT

if USE_TVCLASS

cp_tcl	db	'*.tcl',0
format_s db	'%s',0
format_d db	'%d',0
format_u db	'%u',0
format_b db	'%b',0
format_ld db	'%ld',0
format_lu db	'%lu',0
format_lb db	'%lb',0
format_lbb db	'%lb%lb',0
format_02X db	'%02X',0
format_04X db	'%04X',0
format_08X db	'%08lX',0
format_16X db	'%08lX%08lX',0

format_byte 	label word
	dw 	offset format_d
	dw 	offset format_u
	dw 	offset format_02X
	dw 	offset format_b

format_word 	label word
	dw 	offset format_d
	dw 	offset format_u
	dw 	offset format_04X
	dw 	offset format_lb

format_dword 	label word
	dw 	offset format_ld
	dw 	offset format_lu
	dw 	offset format_08X
	dw 	offset format_lbb

endif

format_8ld	DB '%-8ld',0
format_10u	DB '%010lu',0
format_08lXh	DB '%08lXh',0

cp_deci		DB 'Dec'
cp_hex		DB 'Hex  '
cp_ascii	DB 'Ascii'
if USE_TVCLASS
cp_class	DB 'Class'
endif
cp_wrap		DB 'Wrap  '
cp_unwrap	DB 'Unwrap'
cp_memory	DB 'MEMORY',0
cp_byte		DB 'byte',0

format_3d	DB '%3d',0

key_global LABEL WORD
	DW	KEY_F1
	DW	KEY_F2
	DW	KEY_F3
	DW	KEY_F4
	DW	KEY_F5
	DW	KEY_F6
	DW	KEY_F7
	DW	KEY_F8
	DW	KEY_F10
	DW	KEY_ESC
	DW	KEY_ALTX
	DW	KEY_CTRLF5
	DW	KEY_ALTF5
	DW	KEY_CTRLB

global_count =	14

key_local LABEL WORD
	DW	KEY_UP
	DW	KEY_DOWN
	DW	KEY_PGUP
	DW	KEY_PGDN
	DW	KEY_LEFT
	DW	KEY_RIGHT
	DW	KEY_HOME
	DW	KEY_END
	DW	KEY_CTRLL
	DW	KEY_CTRLE
	DW	KEY_CTRLX
	DW	KEY_CTRLR
	DW	KEY_CTRLC
	DW	KEY_CTRLUP
	DW	KEY_CTRLDN
	DW	KEY_CTRLLEFT
	DW	KEY_CTRLRIGHT
	DW	KEY_SHIFTF3
	DW	KEY_CTRLEND
	DW	KEY_CTRLHOME
if USE_TVCLASS
	DW	KEY_ENTER
	DW	KEY_KPENTER
	DW	KEY_CTRLF2
	DW	KEY_CTRLF3
 local_count = 	38
else
 local_count = 	33
endif

proc_label LABEL WORD
	DW	OFFSET cmhelp
	DW	OFFSET cmwrap
	DW	OFFSET cmsearch
	DW	OFFSET cmhex
	DW	OFFSET cmcopy
	DW	OFFSET cmoffset
	DW	OFFSET cmseek
	DW	OFFSET cmbinary
	DW	OFFSET cmquit
	DW	OFFSET cmquit
	DW	OFFSET cmquit
	DW	OFFSET cmcolor
	DW	OFFSET cmconsole
	DW	OFFSET cmconsole
	DW	OFFSET event_UP
	DW	OFFSET event_DOWN
	DW	OFFSET event_PGUP
	DW	OFFSET event_PGDN
	DW	OFFSET event_LEFT
	DW	OFFSET event_RIGHT
	DW	OFFSET event_HOME
	DW	OFFSET event_END
	DW	OFFSET event_search
	DW	OFFSET event_UP
	DW	OFFSET event_DOWN
	DW	OFFSET event_PGUP
	DW	OFFSET event_PGDN
	DW	OFFSET event_PGUP
	DW	OFFSET event_PGDN
	DW	OFFSET event_PGLEFT
	DW	OFFSET event_PGRIGHT
	DW	OFFSET event_search
	DW	OFFSET event_toend
	DW	OFFSET event_tostart
if USE_TVCLASS
	DW	OFFSET event_ENTER
	DW	OFFSET event_ENTER
	DW	OFFSET event_clsave
	DW	OFFSET event_clload
endif

ifdef __MOUSE__

label_scroll LABEL WORD
	DW	OFFSET mouse_scroll_delay
	DW	OFFSET mouse_scroll_up
	DW	OFFSET mouse_scroll_down
	DW	OFFSET mouse_scroll_left
	DW	OFFSET mouse_scroll_right

endif

resource label word
	DW	?
	DW	_D_MUSER or _D_RESAT or _D_MYBUF,0,0
	DB	80
rs_rcrow label byte
	DB	25,0F0h,50h,3Ah

rs_atcnt label word
	DW	?
	DB	19h
	DW	01F0h
	DB	19h
	DW	01F0h
	DB	19h
	DW	01F0h
	DB	19h
	DW	01F0h
	DB	19h
	DB	3Ah,3Fh,3Fh,240,7,3Ah,3Fh,3Fh,240,9,3Ah
	DB	3Fh,3Fh,240,9,3Ah,3Fh,3Fh,240,8,3Ah,3Fh,3Fh
	DB	240,7,3Ah,3Fh,3Fh,240,6,3Ah,3Fh,3Fh,240,10,3Ah
	DB	240,3,3Fh,240,6,3Ah
	DB	' Text View:',240,50,' col',240,11,' 100%'
rs_chcnt label word
	DW	?
	DB	' '
	DW	01F0h
	DB	' '
	DW	01F0h
	DB	' '
	DW	01F0h
	DB	' '
	DW	01F0h
	DB	' F1 Help  F2',240,9,' F3 Search  F4'
	DB	240,8,' F5 Copy  F6 Dec  F7 Seek',240,5,' Esc Quit '

;******** Resource begin TVABOUT *
;	{ 0x005C,   1,   0, {15, 7,50,10} },
;	{ 0x0000,   0, 'O', {20, 8, 8, 1} },
;******** Resource data  *******************
TVABOUT_RC LABEL WORD
	DW	0044Ch	; Alloc size
	DW	0005Ch,00001h,0070Fh,00A32h,00000h,04F00h,00814h,00108h
	DW	032F0h,0F150h,02A72h,003F0h,05C50h,004F0h,02050h,029F0h
	DW	0F02Ah,02009h,015F0h,0F02Ah,02016h,06241h,0756Fh,0F074h
	DW	0204Eh,06854h,02065h,06F44h,07A73h,07069h,04320h,06D6Fh
	DW	0616Dh,0646Eh,07265h,05420h,07865h,02074h,06976h,07765h
	DW	07265h,0202Ch;,03276h,0312Eh,0F033h,0000Bh,06F43h,07970h
	DB	'v'
	DB	DOSZIP_VSTR
	DB	0F0h
	DW	0000Bh,06F43h,07970h
	DW	06972h,06867h,02074h,06328h,02029h,03931h,03739h,0322Dh
	DW	03130h,02030h,06A48h,0726Fh,02074h,0694Eh,07564h,07364h
	DW	06F73h,0F06Eh,0000Bh,027F0h,0F0C4h,0000Bh,0694Ch,06563h
	DW	0736Eh,03A65h,004F0h,02000h,04E47h,02055h,06547h,0656Eh
	DW	06172h,0206Ch,07550h,06C62h,06369h,04C20h,06369h,06E65h
	DW	06573h,0F020h,0000Ah,07542h,06C69h,02064h,06144h,06574h
	DW	0003Ah;,03200h,02035h,0754Ah,0206Ch,03032h,03131h,05420h
	DB	' '
	DB	DOSZIP_DSTR
	DW	05420h
	DW	06D69h,03A65h;,03020h,03A32h,03331h,0303Ah,0F030h,0004Ch
	DB	' '
	DB	DOSZIP_TIME
	DB	0F0h
	DW	0004Ch
	DW	003F0h,04F20h,0F04Bh,02003h,020DCh,029F0h,0F000h,0DF08h
	DW	0F020h,00014h,02A2Ah
;******** Resource end   TVABOUT *

_DATA	ENDS

_TEXT	SEGMENT

ifdef __MIO__

normalize PROC
	mov	cl,dh
	shl	dx,4
	add	ax,dx
	adc	cl,0
	shr	cl,4
	mov	dl,cl
	mov	dh,0
	ret
normalize ENDP

endif

cmp_bbscount1_fsize PROC
	mov	ax,[bp.tv_scount_ax]
	mov	dx,[bp.tv_scount_dx]
	add	ax,STDI.ios_bb_ax
	adc	dx,STDI.ios_bb_dx
cmp_bbscount1_fsize ENDP

cmp_dxax1_fsize PROC
	add	ax,1
	adc	dx,0
cmp_dxax1_fsize ENDP

cmp_dxax_fsize PROC
	cmp	dx,[bp.tv_fsize_dx]
	jne	cmp_dxax_fsize_00
	cmp	ax,[bp.tv_fsize_ax]
    cmp_dxax_fsize_00:
	ret
cmp_dxax_fsize ENDP

cmp_fsize_null PROC
	xor	ax,ax
	cwd
	jmp	cmp_dxax_fsize
cmp_fsize_null ENDP

cmp_offset_fsize PROC
	mov	ax,[bp.tv_offset_ax]
	mov	dx,[bp.tv_offset_dx]
	jmp	cmp_dxax_fsize
cmp_offset_fsize ENDP

cmp_dxax_offset PROC
	cmp	dx,[bp.tv_offset_dx]
	jne	cmp_exit
	cmp	ax,[bp.tv_offset_ax]
	ret
cmp_dxax_offset ENDP

cmp_offset_bb PROC
	mov	ax,[bp.tv_offset_ax]
	mov	dx,[bp.tv_offset_dx]
cmp_offset_bb ENDP

cmp_dxax_bb PROC
	cmp	dx,STDI.ios_bb_dx
	jne	cmp_exit
	cmp	ax,STDI.ios_bb_ax
    cmp_exit:
	ret
cmp_dxax_bb ENDP

cmp_curcol_bb PROC
	mov	ax,[bp.tv_curcol_ax]
	mov	dx,[bp.tv_curcol_dx]
	jmp	cmp_dxax_bb
cmp_curcol_bb ENDP

cmp_dxax_curcol PROC
	cmp	dx,[bp.tv_curcol_dx]
	jne	cmp_exit
	cmp	ax,[bp.tv_curcol_ax]
	ret
cmp_dxax_curcol ENDP

cmp_dxax_maxcol PROC
	cmp	dx,[bp.tv_maxcol_dx]
	jne	cmp_exit
	cmp	ax,[bp.tv_maxcol_ax]
	ret
cmp_dxax_maxcol ENDP

cmp_dxax_bx PROC
	cmp	dx,[bx+2]
	jne	cmp_exit
	cmp	ax,[bx]
	ret
cmp_dxax_bx ENDP

cmp_bx_fsize PROC
	mov	ax,[bx]
	mov	dx,[bx+2]
	jmp	cmp_dxax_fsize
cmp_bx_fsize ENDP

add_offset PROC
	push	bx
	lea	bx,[bp.tv_line_table]
	mov	ax,[bp.tv_lcount]
	shl	ax,2
	add	bx,ax
	mov	ax,[bp.tv_offset_ax]
	mov	dx,[bp.tv_offset_dx]
	mov	[bx],ax
	mov	[bx+2],dx
	inc	[bp.tv_lcount]
	pop	bx
	ret
add_offset ENDP

getlinesize PROC
	shl	ax,2
	lea	bx,[bp.tv_line_table]
	add	bx,ax
	mov	dx,[bx+6]
	mov	ax,[bx+4]
	mov	cx,[bx+2]
	mov	bx,[bx]
	sub	ax,bx
	sbb	dx,cx
	ret
getlinesize ENDP

setmaxcol PROC
	xor	cx,cx
    setmaxcol_00:
	cmp	cx,[bp.tv_lcount]
	jnb	setmaxcol_02
	mov	ax,cx
	push	bx
	push	cx
	call	getlinesize
	pop	cx
	pop	bx
	call	cmp_dxax_maxcol
	jbe	setmaxcol_01
	mov	[bp.tv_maxcol_ax],ax
	mov	[bp.tv_maxcol_dx],dx
    setmaxcol_01:
	inc	cx
	jmp	setmaxcol_00
    setmaxcol_02:
	ret
setmaxcol ENDP

getc	PROC
	call	ogetc
	jz	getc_clc	; eof
	add	[bp.tv_offset_ax],1
	adc	[bp.tv_offset_dx],0
    getc_cmp:
	cmp	al,13
	je	getc_stc
	cmp	al,10
	je	getc_stc
    getc_clc:	; CF clear: normal byte or eof
	clc
	ret
    getc_stc:	; CF set: new line
	inc	ah
	stc
	ret
getc	ENDP

ungetc	PROC
	call	oungetc
	jz	getc_clc
	sub	[bp.tv_offset_ax],1
	sbb	[bp.tv_offset_dx],0
	jmp	getc_cmp
ungetc	ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

read_static_table PROC	; offset of first 256 lines
	push	di
	lea	di,[bp.tv_static_table]
	xor	ax,ax
	cwd
	mov	[di],ax
	mov	[di+2],ax
	add	di,4
	mov	[bp.tv_offset_ax],ax
	mov	[bp.tv_offset_dx],ax
	mov	[bp.tv_static_count],1
	call	oseek_dxax
	jz	static_table_05
    static_table_00:
	call	getc
	jc	static_table_02
	jnz	static_table_00
    static_table_01:
	call	static_table_add
	call	static_table_add
	dec	[bp.tv_static_count]
	jmp	static_table_04
    static_table_02:
	call	getc
	jz	static_table_01
	jc	static_table_03
	call	ungetc
    static_table_03:
	call	static_table_add
	mov	ax,[bp.tv_static_count]
	cmp	ax,253
	jna	static_table_00
    static_table_04:
	dec	[bp.tv_static_count]
    static_table_05:
	pop	di
	ret
    static_table_add:
	mov	ax,[bp.tv_offset_ax]
	mov	dx,[bp.tv_offset_dx]
	mov	[di],ax
	mov	[di+2],dx
	add	di,4
	inc	[bp.tv_static_count]
	ret
read_static_table ENDP

read_line_table	PROC ; read line offset in file
	push	si
	mov	[bp.tv_lcount],1
	mov	ax,STDI.ios_bb_ax
	mov	dx,STDI.ios_bb_dx
	mov	WORD PTR [bp.tv_line_table],ax
	mov	WORD PTR [bp.tv_line_table+2],dx
	mov	[bp.tv_offset_ax],ax
	mov	[bp.tv_offset_dx],dx
	mov	bl,tvflag
  if USE_TVCLASS
	test	bl,_TV_HEXVIEW or _TV_CLASSVIEW
  else
	test	bl,_TV_HEXVIEW
  endif
	jz	line_table_txt
	jmp	line_table_hex
    line_table_txt:
	test	bl,_TV_WRAPLINES
	jnz	line_table_end
	lea	bx,[bp.tv_static_table]
	mov	cx,[bp.tv_static_count]
    line_table_static:
	call	cmp_dxax_bx
	je	line_table_stfound
	add	bx,4
	dec	cx
	jnz	line_table_static
	xor	bx,bx
    line_table_stfound:
	or	bx,bx
	jz	line_table_read
    line_table_add:
	add	bx,4
	mov	ax,[bx]
	mov	dx,[bx+2]
	mov	[bp.tv_offset_ax],ax
	mov	[bp.tv_offset_dx],dx
	call	add_offset
	mov	ax,[bp.tv_lcount]
	cmp	ax,[bp.tv_rowcnt]
	ja	line_table_max
	dec	cx
	jnz	line_table_add
	call	cmp_offset_fsize
	je	line_table_max
    line_table_read:
	call	oseek_dxax
	jz	line_table_end
	mov	si,8000h
    line_table_getc:
	call	ogetc
	jz	line_table_eof
	add	[bp.tv_offset_ax],1
	adc	[bp.tv_offset_dx],0
	cmp	al,0Dh
	je	line_table_crlf
	cmp	al,0Ah
	je	line_table_crlf
	dec	si
	jz	line_table_crlf
	jmp	line_table_getc
    line_table_eof:
	call	add_offset
	call	add_offset
	dec	[bp.tv_lcount]
    line_table_max:
	dec	[bp.tv_lcount]
    line_table_end:
	pop	si
	jnz	init_screenbuf
	ret
    line_table_hex:
	call	oseek_dxax
	jz	line_table_end
	mov	si,8
	test	tvflag,_TV_BINVIEW
	jnz	line_table_8
	add	si,si
    line_table_8:
	xor	cx,cx
    line_table_loop:
	mov	ax,[bp.tv_offset_ax]
	mov	dx,[bp.tv_offset_dx]
	mov	bx,si
  if USE_TVCLASS
	test	tvflag,_TV_CLASSVIEW
	jz	line_table_addsi
	push	ax
	mov	bx,offset tv_class
	mov	ax,cx
	shl	ax,5
	add	bx,ax
	mov	bx,[bx.cl_size]
	pop	ax
  endif
    line_table_addsi:
	add	ax,bx
	adc	dx,0
	mov	[bp.tv_offset_ax],ax
	mov	[bp.tv_offset_dx],dx
	call	cmp_dxax_fsize
	ja	line_table_beof
	call	add_offset
	inc	cx
	cmp	cx,[bp.tv_rowcnt]
	jb	line_table_loop
	jmp	line_table_eof
    line_table_beof:
	mov	ax,[bp.tv_fsize_ax]
	mov	dx,[bp.tv_fsize_dx]
	mov	[bp.tv_offset_ax],ax
	mov	[bp.tv_offset_dx],dx
	jmp	line_table_eof
    line_table_crlf:
	call	getc
	jz	line_table_eof
	jc	line_table_14
	call	ungetc
    line_table_14:
	call	add_offset
	mov	ax,[bp.tv_lcount]
	cmp	ax,[bp.tv_rowcnt]
	ja	line_table_max
	jmp	line_table_getc
read_line_table ENDP

init_screenbuf PROC
	push	di
	mov	al,40
	mov	cx,[bp.tv_rowcnt]
	mul	cl
	mov	cx,ax
	les	di,[bp.tv_screen]
	mov	ax,2020h
	cld
	rep	stosw
	pop	di
	mov	ax,STDI.ios_bb_ax
	mov	dx,STDI.ios_bb_dx
	mov	[bp.tv_offset_ax],ax
	mov	[bp.tv_offset_dx],dx
init_screenbuf ENDP

oseek_dxax PROC
	push	dx
	push	ax
	push	SEEK_SET
	call	oseekl
	ret
oseek_dxax ENDP

parse_line PROC
	push	si
	push	di
	xor	si,si
    parse_line_00:
	call	getc
	jz	parse_line_02
	jc	parse_line_04
	cmp	al,9
	je	parse_line_TAB
	mov	es:[di],al
	inc	di
	inc	si
    parse_line_01:
	cmp	si,80
	je	parse_line_07
	jb	parse_line_00
    parse_line_02:
	pop	di
	pop	si
	jz	parse_line_03
	add	di,80
    parse_line_03:
	ret
    parse_line_04:
	call	getc
	jna	parse_line_02
    parse_line_05:
	sub	[bp.tv_offset_ax],1
	sbb	[bp.tv_offset_dx],0
	dec	STDI.ios_i
	jmp	parse_line_02
    parse_line_TAB:
	sub	si,di
	add	di,8
	and	di,0FFF8h
	add	si,di
	jmp	parse_line_01
    parse_line_07:
	call	getc
	jz	parse_line_02
	jc	parse_line_04
	jmp	parse_line_05
parse_line ENDP

read_wrap PROC
	call	read_line_table
	jz	read_wrap_02
	push	di
	les	di,[bp.tv_screen]
	xor	ax,ax
	mov	[bp.tv_bsize],ax
	mov	[bp.tv_lcount],ax
    read_wrap_00:
	mov	ax,[bp.tv_bsize]
	inc	[bp.tv_bsize]
	cmp	ax,[bp.tv_rowcnt]
	jnc	read_wrap_01
	call	add_offset
	call	parse_line
	jnz	read_wrap_00
    read_wrap_01:
	mov	ax,[bp.tv_offset_ax]
	mov	dx,[bp.tv_offset_dx]
	sub	ax,STDI.ios_bb_ax
	sbb	dx,STDI.ios_bb_dx
	mov	[bp.tv_scount_ax],ax
	mov	[bp.tv_scount_dx],dx
	or	ax,1
	pop	di
	ret
    read_wrap_02:
	xor	ax,ax
	ret
read_wrap ENDP

read_text PROC
	call	read_line_table
	jz	read_text_04
	call	setmaxcol
	push	di
	les	di,[bp.tv_screen]
	mov	[bp.tv_bsize],0
    read_text_00:
	mov	ax,[bp.tv_bsize]
	inc	[bp.tv_bsize]
	cmp	ax,[bp.tv_lcount]
	jnc	read_text_02
	call	getlinesize
	add	[bp.tv_scount_ax],ax
	adc	[bp.tv_scount_dx],dx
	call	cmp_dxax_curcol
	ja	read_text_01
	add	di,80
	jmp	read_text_00
    read_text_01:
	add	bx,[bp.tv_curcol_ax]
	add	cx,[bp.tv_curcol_dx]
	mov	ax,bx
	mov	dx,cx
	call    oseek_dxax
	jz	read_text_04
	call	parse_line
	jnz	read_text_00
    read_text_02:
	or	ax,1
    read_text_03:
	pop	di
	ret
    read_text_04:
	xor	ax,ax
	jmp	read_text_03
read_text ENDP

mk_hexword PROC
	mov	ah,al
	and	ax,0FF0h
	shr	al,04h
	add	ax,3030h
	cmp	ah,39h
	jbe	mk_hexword_00
	add	ah,07h
    mk_hexword_00:
	cmp	al,39h
	jbe	mk_hexword_01
	add	al,07h
    mk_hexword_01:
	ret
mk_hexword ENDP

print_offset PROC	; cx = index, es:di = buffer
	lea	bx,[bp.tv_line_table]
	mov	ax,cx
	shl	ax,2
	add	ax,3
	add	bx,ax
	mov	dx,4
	test	tvflag,_TV_HEXOFFSET or _TV_BINVIEW
	jnz	print_hexoffset
	push	[bx-1]
	push	[bx-3]
	mov	ax,OFFSET format_10u
	mov	dx,es
	mov	bx,di
	call	@sprintf
	add	sp,4
	add	di,9
	jmp	print_offset_end
    print_hexoffset:
	mov	al,[bx]
	call	mk_hexword
	stosw
	dec	bx
	dec	dx
	jnz	print_hexoffset
	inc	di
    print_offset_end:
	ret
print_offset ENDP

read_hex PROC
	call	read_line_table
	jnz	read_hex_do
    read_hex_end:
	ret
    read_hex_do:
	call	ogetc
	jz	read_hex_end
	dec	STDI.ios_i
	mov	ax,8
	test	tvflag,_TV_BINVIEW
	jnz	read_hex_binary
	add	ax,ax
    read_hex_binary:
	mul	[bp.tv_rowcnt]
	cmp	ax,STDI.ios_c
	ja	read_hex_03
	mov	STDI.ios_c,ax
    read_hex_03:
	mov	ax,STDI.ios_c
	xor	cx,cx
	mov	[bp.tv_scount_ax],ax
	mov	[bp.tv_scount_dx],cx
	push	di
	les	di,[bp.tv_screen]
    read_hex_04:
	push	di
	call	print_offset
	mov	dx,STDI.ios_c
	mov	ax,8
	test	tvflag,_TV_BINVIEW
	jnz	read_hex_07
	add	ax,ax
	add	di,3
    read_hex_07:
	cmp	dx,ax
	jb	read_hex_08
	mov	dx,ax
    read_hex_08:
	or	dx,dx
	jz	read_hex_16
	sub	STDI.ios_c,dx
	mov	bx,di
	add	bx,51
	push	cx
	mov	cx,dx
	xor	dx,dx
    read_hex_09:
	test	tvflag,_TV_BINVIEW
	jnz	read_hex_11
    read_hex_10:
	cmp	dx,8
	jnz	read_hex_11
	mov	al,179
	stosb
	inc	di
    read_hex_11:
	mov	ax,STDI.ios_i
	push	es
	push	bx
	les	bx,DWORD PTR STDI
	add	bx,ax
	mov	al,es:[bx]
	pop	bx
	pop	es
	inc	STDI.ios_i
	test	tvflag,_TV_BINVIEW
	jnz	read_hex_12
	mov	es:[bx],al
	call	mk_hexword
	stosw
	inc	di
	inc	bx
	inc	dx
	dec	cx
	jnz	read_hex_10
	jmp	read_hex_15
    read_hex_12:
	mov	ah,al
	push	cx
	mov	cx,8
    read_hex_13:
	mov	al,ah
	shl	ah,1
	and	al,80h
	mov	al,'1'
	jnz	read_hex_14
	mov	al,'0'
    read_hex_14:
	mov	es:[di],al
	inc	di
	dec	cx
	jnz	read_hex_13
	pop	cx
	inc	di
	inc	dx
	dec	cx
	jnz	read_hex_09
    read_hex_15:
	pop	cx
	pop	di
	add	di,80
	inc	cx
	cmp	cx,[bp.tv_lcount]
	jnc	read_hex_17
	jmp	read_hex_04
    read_hex_16:
	pop	di
    read_hex_17:
	or	ax,1
	pop	di
	ret
read_hex ENDP

if USE_TVCLASS

class_getformat PROC
	mov	ah,0
	mov	al,[si.cl_format]
	add	ax,ax
	add	ax,dx
	mov	bx,ax
	mov	ax,[bx]
	mov	dx,word ptr [bp.tv_screen+2]
	mov	bx,di
	ret
class_getformat ENDP

read_class PROC
	push	si
	push	di
	call	read_line_table
	jnz	read_class_format
    read_class_end:
	pop	di
	pop	si
	ret
    read_class_ok:
	or	al,1
	jmp	read_class_end
    read_class_format:
	call	ogetc
	jz	read_class_end
	dec	STDI.ios_i
	mov	bx,offset tv_class
	xor	ax,ax
	mov	ch,al
	mov	cl,[bp.tv_CLDLG.dl_count]
    read_class_getsize:
	add	ax,[bx.cl_size]
	add	bx,SIZE S_CLASS
	dec	cx
	jnz	read_class_getsize
	mov	tv_classsize,ax
	cmp	ax,STDI.ios_c
	ja	read_class_sizeok
	mov	STDI.ios_c,ax
    read_class_sizeok:
	mov	ax,STDI.ios_c
	xor	cx,cx
	mov	[bp.tv_scount_ax],ax
	mov	[bp.tv_scount_dx],cx
	les	di,[bp.tv_screen]
    read_class_do:
	push	di
	call	print_offset
	add	di,3
	mov	si,offset tv_class
	mov	ax,cx
	shl	ax,5
	add	si,ax
	push	ds
	push	si
	mov	ax,offset format_s
	mov	dx,word ptr [bp.tv_screen+2]
	mov	bx,di
	call	@sprintf
	add	sp,4
	add	di,28
	les	bx,STDI
	add	bx,STDI.ios_i
	mov	al,[si.cl_type]
	cmp	al,CLTYPE_CHAR
	je	read_class_char
	cmp	al,CLTYPE_WORD
	je	read_class_word
	cmp	al,CLTYPE_DWORD
	je	read_class_dword
	cmp	al,CLTYPE_QWORD
	je	read_class_qword
	cmp	[si.cl_size],1
	jne	read_class_bytes
	mov	dx,offset format_byte
	mov	al,es:[bx]
	cmp	[si.cl_format],CLFORM_UNSIGNED
	jne	read_class_signed
	mov	ah,0
	jmp	read_class_int
    read_class_signed:
	cbw
	jmp	read_class_int
    read_class_bytes:
	cmp	al,CLTYPE_BYTE
	je	read_class_byte
	jmp	read_class_break
    read_class_loop:
	pop	di
	add	di,80
	mov	ax,[si.cl_size]
	add	STDI.ios_i,ax
	inc	cx
	cmp	cl,[bp.tv_CLDLG.dl_count]
	jnb	read_class_break
	cmp	cx,[bp.tv_lcount]
	jb	read_class_do
    read_class_break:
	pop	di
	jmp	read_class_ok
    read_class_char:
	mov	ax,[si.cl_size]
	push	cx
	mov	cx,39
	cmp	cx,ax
	jb	read_class_strl
	mov	cx,ax
    read_class_strl:
	mov	dx,ds
	mov	bx,si
	mov	ax,STDI.ios_i
	lds	si,STDI
	add	si,ax
	assert	cx,0,jne,"read_class"
	rep	movsb
	mov	ds,dx
	mov	si,bx
	pop	cx
	jmp	read_class_loop
    read_class_byte:
	mov	ax,[si.cl_size]
	mov	dx,13
	cmp	dx,ax
	jb	read_class_btrl
	mov	dx,ax
    read_class_btrl:
	assert	dx,0,jne,"read_class"
    read_class_xloop:
	mov	al,es:[bx]
	call	mk_hexword
	stosw
	inc	di
	inc	bx
	dec	dx
	jnz	read_class_xloop
	jmp	read_class_loop
    read_class_word:
	mov	dx,offset format_word
	mov	ax,es:[bx]
    read_class_int:
	push	ax
	call	class_getformat
	call	@sprintf
	add	sp,2
	jmp	read_class_loop
    read_class_dword:
	push	word ptr es:[bx+2]
	push	word ptr es:[bx]
	mov	dx,offset format_dword
	call	class_getformat
	call	@sprintf
	add	sp,4
	jmp	read_class_loop
    read_class_qword:
	cmp	[si.cl_format],CLFORM_UNSIGNED
	ja	read_class_qbin
	push	cx
	push	es
	push	bx
	push	es:[bx+6]
	push	es:[bx+4]
	push	es:[bx+2]
	push	es:[bx]
	call	qwtostr
	pop	bx
	pop	es
	pop	cx
	push	dx
	push	ax
	mov	ax,offset format_s
	mov	dx,word ptr [bp.tv_screen+2]
	mov	bx,di
	call	@sprintf
	add	sp,4
	jmp	read_class_loop
    read_class_qbin:
	push	es:[bx+2]
	push	es:[bx]
	push	es:[bx+6]
	push	es:[bx+4]
	mov	ax,offset format_16X
	mov	dx,word ptr [bp.tv_screen+2]
	mov	bx,di
	call	@sprintf
	add	sp,8
	jmp	read_class_loop
read_class ENDP

init_class PROC
	push	si
	push	di
	movmmax	[bp.tv_tdialog_ax],tdialog
	xor	ax,ax
	mov	cx,CLCOUNT
	lea	si,[bp.tv_CLDLG]
	mov	word ptr tdialog,si
	mov	word ptr tdialog+2,ss
	mov	[si.dl_flag],CLFLAGS
	mov	[si.dl_index],al
	mov	[si.dl_count],cl
	mov	[si.dl_rect_x],al
	mov	[si.dl_rect_y],1
	mov	[si.dl_rect_c],80
	mov	[si.dl_rect_r],cl
	mov	al,_scrcol
	add	ax,ax
	mov	[si.dl_wp_ax],ax
	mov	ax,_scrseg
	mov	[si.dl_wp_dx],ax
	lea	ax,[bp.tv_CLOBJ]
	mov	[si.dl_object_ax],ax
	mov	[si.dl_object_dx],ss
	mov	di,offset tv_class
	add	si,16
	xor	ax,ax
	mov	dx,ax
    init_class_loop:
	mov	[si.to_flag],_O_XHTML
	mov	[si.to_count],al
	mov	[si.to_ascii],al
	mov	[si.to_rect_x],al
	mov	[si.to_rect_y],dl
	mov	[si.to_rect_c],80
	mov	[si.to_rect_r],1
	mov	[si.to_data_ax],ax
	mov	[si.to_data_dx],ax
	inc	dx
	add	si,16
	dec	cx
	jnz	init_class_loop
	pop	di
	pop	si
	ret
init_class ENDP

event_clsave PROC
	test	tvflag,_TV_CLASSVIEW
	jz      event_clsave_end
	push	ds
	push	IDD_TVCLSAVE
	call	rsopen
	jz      event_clsave_end
	push	dx
	push	ax
	push	tv_classrow
	mov	ax,offset format_u
	mov	dx,es:[bx.to_data_dx+16]
	mov	bx,es:[bx.to_data_ax+16]
	call	@sprintf
	add	sp,2
	call	tdmodal
	or	ax,ax
	jz	event_clsave_end
	push	es:[bx.to_data_dx+16]
	push	es:[bx.to_data_ax+16]
	call	strtol
	or	ax,ax
	jz	event_clsave_end
	cmp	ax,512
	ja	event_clsave_end
	mov	tv_classrow,ax
	mov	ax,2
	mov	bx,offset cp_tcl
	call	wgetfile
	jz	event_clsave_end
	push	ax
	push	ax
	push	ds
	push	offset tv_clversion
	push	TCLSIZE
	call	oswrite
	call	close
    event_clsave_end:
	ret
event_clsave ENDP

event_clload PROC
	push	si
	push	di
	test	tvflag,_TV_CLASSVIEW
	jz      event_clload_end
	mov	ax,3
	mov	bx,offset cp_tcl
	call	wgetfile
	jz	event_clload_end
	mov	si,offset _bufin
	push	ax
	push	ax
	push	ds
	push	si
	push	TCLSIZE
	call	osread
	mov	di,ax
	call	close
	cmp	di,TCLSIZE
	jne	event_clload_end
	mov	ax,[si]
	cmp	ax,CLVERSION
	jne	event_clload_end
	mov	ax,[si+4]
	lea	di,[si+6]
	mov	cx,ax
	mov	tv_classrow,ax
	xor	dx,dx
	cmp	ax,CLCOUNT
	jbe	event_clload_loop
	mov	cx,CLCOUNT
	mov	tv_classrow,cx
    event_clload_loop:
	mov	[di.cl_name+27],0
	mov	ax,[di.cl_size]
	or	ax,ax
	jnz	event_clload_l01
	inc	ax
    event_clload_l01:
	cmp     ax,512
	jbe     event_clload_l02
	mov	ax,512
    event_clload_l02:
	mov	[di.cl_size],ax
	add	dx,ax
	cmp	[di.cl_type],CLTYPE_QWORD
	jbe	event_clload_l03
	mov	[di.cl_type],CLTYPE_QWORD
    event_clload_l03:
	cmp	[di.cl_format],CLFORM_BINARY
	jbe	event_clload_l04
	mov	[di.cl_format],CLFORM_BINARY
    event_clload_l04:
	add	di,SIZE S_CLASS
	dec	cx
	jnz	event_clload_loop
	mov	tv_classsize,dx
	mov	ax,tv_classrow
	mov	[bp.tv_CLDLG.dl_count],al
	push	ds
	push	offset tv_clversion
	push	ds
	push	si
	push	TCLSIZE
	call	memcpy
	call	reread
    event_clload_end:
	pop	di
	pop	si
	ret
event_clload ENDP

event_ENTER PROC
	push	si
	push	di
	test	tvflag,_TV_CLASSVIEW
	jz	event_ENTER_end
	mov	si,offset tv_class
	xor	ax,ax
	mov	al,[bp.tv_CLDLG.dl_index]
	shl	ax,5
	add	si,ax
	push	ds
	push	IDD_TVCLASS
	call	rsopen
	jz	event_ENTER_end
	push	dx
	push	ax
	push	ds
	push	IDD_TVCLASS
	push	dx
	push	ax
	push	dx
	push	ax
	mov	cx,dx
	push	es:[bx.to_data_dx+6*16]
	push	es:[bx.to_data_ax+6*16]
	push	ss
	push	si
	call	strcpy
	mov	es,cx
	mov	dx,cx
	mov	cx,bx
	mov	bx,es:[bx.to_data_ax+1*16]
	mov	ax,offset format_d
	push	[si.cl_size]
	call	@sprintf
	mov	bx,cx
	mov	bx,es:[bx.to_data_ax+2*16]
	mov	ax,offset format_d
	call	@sprintf
	add	sp,2
	mov	al,[si.cl_type]
	mov	bx,cx
	mov	es:[bx.dl_index],al
	call	tdinit
	call	rsevent
	mov	di,es
	or	ax,ax
	jnz	event_ENTER_do
	call	twclose
	mov	ax,dx
	jmp	event_ENTER_end
    event_ENTER_do:
	push	ax
	push	ss
	push	si
	push	es:[bx.to_data_dx+6*16]
	push	es:[bx.to_data_ax+6*16]
	push	27
	call	strncpy
	pop	ax
	mov	es,di
	cmp	ax,6
	jnb	event_ENTER_close
	dec	ax
	mov	[si.cl_type],al
	cmp	al,CLTYPE_BYTE
	je	event_ENTER_byte
	cmp	al,CLTYPE_CHAR
	je	event_ENTER_char
	cmp	al,CLTYPE_WORD
	je	event_ENTER_word
	cmp	al,CLTYPE_DWORD
	je	event_ENTER_dword
	mov	ax,8
	jmp	event_ENTER_count
    event_ENTER_word:
	mov	ax,2
	jmp	event_ENTER_count
    event_ENTER_dword:
	mov	ax,4
	jmp	event_ENTER_count
    event_ENTER_byte:
	push	es:[bx.to_data_dx+2*16]
	push	es:[bx.to_data_ax+2*16]
	jmp	event_ENTER_strcount
    event_ENTER_char:
	push	es:[bx.to_data_dx+1*16]
	push	es:[bx.to_data_ax+1*16]
    event_ENTER_strcount:
	call	strtol
	cmp	ax,512
	jbe	event_ENTER_setcount
	mov	ax,512
    event_ENTER_setcount:
	or	ax,ax
	jnz	event_ENTER_doset
	inc	ax
    event_ENTER_doset:
	mov	[si.cl_size],ax
	cmp	ax,1
	jne	event_ENTER_close
	cmp	[si.cl_type],CLTYPE_CHAR
	je	event_ENTER_close
    event_ENTER_count:
	mov	[si.cl_size],ax
	push	ds
	push	IDD_TVCLFORM
	call	rsopen
	push	dx
	push	ax
	mov	al,[si.cl_format]
	mov	es:[bx.dl_index],al
	call	tdmodal
	or	ax,ax
	jnz	event_ENTER_format
	inc	ax
    event_ENTER_format:
	dec	ax
	mov	[si.cl_format],al
    event_ENTER_close:
	call	twclose
	call	reread
    event_ENTER_end:
	xor	ax,ax
	pop	di
	pop	si
	ret
event_ENTER ENDP

endif

previous_line PROC
	mov	ax,STDI.ios_bb_ax
	mov	dx,STDI.ios_bb_dx
	mov	[bp.tv_offset_ax],ax
	mov	[bp.tv_offset_dx],dx
	mov	cx,dx
	or	cx,ax
	jnz	prevline_size?
    prevline_00:
	xor	ax,ax
	cwd
	ret
    prevline_size?:
	call	cmp_dxax_fsize
	jbe	prevline_hex?
    fsize_to_bb:
	mov	ax,[bp.tv_fsize_ax]
	mov	dx,[bp.tv_fsize_dx]
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
	ret
    prevline_hex?:
	xor	cx,cx
	mov	bl,tvflag
  if USE_TVCLASS
	test	bl,_TV_HEXVIEW or _TV_CLASSVIEW
	jz	previous_text
	test	bl,_TV_CLASSVIEW
	jz	previous_hex
	mov	bx,1
	jmp	previous_hex_00
    previous_hex:
  else
	test	bl,_TV_HEXVIEW
	jz	previous_text
  endif
	test	bl,_TV_BINVIEW
	mov	bx,8
	jnz	previous_hex_00
	mov	bx,16
    previous_hex_00:
	cmp	dx,cx
	jne	previous_hex_01
	cmp	ax,bx
    previous_hex_01:
	jbe	prevline_00
	sub	ax,bx
	sbb	dx,cx
	ret
    previous_text:
	lea	bx,[bp.tv_static_table]	; get last offset
	mov	ax,[bp.tv_static_count]
	shl	ax,2
	add	bx,ax
	mov	ax,[bx]
	mov	dx,[bx+2]
	call	cmp_dxax_offset
	jb	previous_seek_back
	mov	ax,[bp.tv_offset_ax]
	mov	dx,[bp.tv_offset_dx]
	mov	cx,[bp.tv_static_count]
	dec	cx
    previous_static_00:
	lea	bx,[bp.tv_static_table]
	push	ax
	mov	ax,cx
	shl	ax,2
	add	bx,ax
	pop	ax
	call	cmp_dxax_bx
	ja	previous_static_01
	or	cx,cx
	jz	prevline_00
	dec	cx
	jmp	previous_static_00
    previous_static_01:
	mov	ax,[bx]
	mov	dx,[bx+2]
	jmp	prevline_wrap?
    previous_seek_back:
	mov	ax,[bp.tv_offset_ax]
	mov	dx,[bp.tv_offset_dx]
	call	oseek_dxax
	jz	previous_seek_00
	call	ungetc
	jz	previous_seek_00
	push	si
	mov	si,8000h
	jnc	previous_back_01
	call	ungetc
	jz	prevline_si00
    previous_back_01:
	call	oungetc
	jz	prevline_si00
	sub	[bp.tv_offset_ax],1
	sbb	[bp.tv_offset_dx],0
	cmp	al,0Dh
	je	prevline_seek_01
	cmp	al,0Ah
	je	prevline_seek_01
	dec	si
	jz	prevline_seek_01
	jmp	previous_back_01
    prevline_si00:
	pop	si
    previous_seek_00:
	jmp	prevline_00
    prevline_seek_01:
	pop	si
	mov	ax,[bp.tv_offset_ax]
	mov	dx,[bp.tv_offset_dx]
	add	ax,1
	adc	dx,0
    prevline_wrap?:
	test	tvflag,_TV_WRAPLINES
	jnz	prevline_wrap
	ret
    prevline_wrap:
	call	cmp_dxax_bb
	ja	prevline_wrap_home
	mov	bx,STDI.ios_bb_ax
	mov	cx,STDI.ios_bb_dx
	sub	bx,ax
	sbb	cx,dx
	or	cx,cx
	jnz	prevline_wrap_00
	cmp	bx,8000h
	jb	prevline_wrap_01
    prevline_wrap_00:
	add	ax,bx
	adc	dx,cx
	sub	ax,80
	sbb	dx,0
    prevline_wrap_01:
	mov	[bp.tv_offset_ax],ax
	mov	[bp.tv_offset_dx],dx
	mov	[bp.tv_tmp_ax],ax
	mov	[bp.tv_tmp_dx],dx
	call	oseek_dxax
	jz	prevline_wrap_home
	push	di
    prevline_wrap_02:
	les	di,[bp.tv_screen]
	call	parse_line
	jz	prevline_wrap_end
	call	cmp_offset_bb
	jae	prevline_wrap_end
	mov	[bp.tv_tmp_ax],ax
	mov	[bp.tv_tmp_dx],dx
	jmp	prevline_wrap_02
    prevline_wrap_home:
	jmp	prevline_00
    prevline_wrap_end:
	pop	di
	mov	ax,[bp.tv_tmp_ax]
	mov	dx,[bp.tv_tmp_dx]
	ret
previous_line ENDP

tvread	PROC
	xor	ax,ax
	mov	[bp.tv_scount_ax],ax
	mov	[bp.tv_scount_dx],ax
	mov	al,tvflag
	test	al,_TV_HEXVIEW
	jnz	tvread_hex
  if USE_TVCLASS
	test	al,_TV_CLASSVIEW
	jz	tvread_text
	call	read_class
	ret
    tvread_text:
  endif
	test	al,_TV_WRAPLINES
	jnz	tvread_wrap
	call	read_text
	ret
    tvread_wrap:
	call	read_wrap
	ret
    tvread_hex:
	call	read_hex
	ret
tvread	ENDP

reread	PROC
	call	tvread
	jz	reread_00
	call	putscreen
	mov	ax,1
    reread_00:
	ret
reread	ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

putscreen PROC
	mov	ax,[bp.tv_scount_ax]
	mov	dx,[bp.tv_scount_dx]
	add	ax,STDI.ios_bb_ax
	adc	dx,STDI.ios_bb_dx
	mov	cx,dx
	or	cx,ax
	jz	putscreen_00
	xor	cx,cx
	mov	bx,100
	call	MUL32
	mov	bx,[bp.tv_fsize_ax]
	mov	cx,[bp.tv_fsize_dx]
	call	DIV32
	and	ax,007Fh
	cmp	ax,100
	jbe	putscreen_01
    putscreen_00:
	mov	ax,100
    putscreen_01:
	push	ax
	mov	ax,OFFSET format_3d
	xor	cx,cx
	mov	bx,75
	call	@scputf
	push	[bp.tv_curcol_dx]
	push	[bp.tv_curcol_ax]
	mov	ax,OFFSET format_8ld
	mov	bx,65
	call	@scputf
	add	sp,6
	mov	ax,[bp.tv_fsize_ax]
	or	ax,[bp.tv_fsize_dx]
	jz	putscreen_04
    putscreen_02:
  ifdef __MOUSE__
	call	mousehide
  endif
	mov	ax,_scrseg
	mov	es,ax
	mov	al,_scrcol
	mov	ah,0
	add	ax,ax
	push	ds
	push	si
	push	di
	mov	di,ax
	mov	bx,ax
	mov	dx,ax
	mov	cl,80
	mov	ch,byte ptr [bp.tv_rowcnt]
	lds	si,[bp.tv_screen]
	cld
    putscreen_03:
	movsb
	inc	di
	dec	cl
	jnz	putscreen_03
	mov	cl,80
	add	bx,dx
	mov	di,bx
	dec	ch
	jnz	putscreen_03
	pop	di
	pop	si
	pop	ds
  ifdef __MOUSE__
	call	mouseshow
  endif
    putscreen_04:
	ret
putscreen ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

event_HOME PROC
	xor	ax,ax
  if USE_TVCLASS
	test	tvflag,_TV_CLASSVIEW
	jz	event_HOME_00
	les	bx,tdialog
	cmp	es:[bx.dl_index],al
	je	event_HOME_00
	mov	es:[bx.dl_index],al
	ret
    event_HOME_00:
  endif
	mov	[bp.tv_curcol_ax],ax
	mov	[bp.tv_curcol_dx],ax
  ifdef __MIO__
	mov	ax,[bp.tv_arg_memo_ax]
	mov	dx,[bp.tv_arg_memo_dx]
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
  else
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,ax
  endif
	jmp	reread
event_HOME ENDP

event_END PROC
  if USE_TVCLASS
	test	tvflag,_TV_HEXVIEW or _TV_CLASSVIEW
  else
	test	tvflag,_TV_HEXVIEW
  endif
	jnz	event_END_hex
	mov	ax,[bp.tv_lcount]
	cmp	ax,[bp.tv_rowcnt]
	jb	event_END_00
	call	cmp_bbscount1_fsize
	jae	event_END_00
	call	fsize_to_bb
	jmp	event_PGUP_text
    event_END_hex:
  if USE_TVCLASS
	test	tvflag,_TV_CLASSVIEW
	jz	event_END_hex_00
	les	bx,tdialog
	mov	al,es:[bx.dl_count]
	dec	al
	cmp	al,es:[bx.dl_index]
	je	event_END_hex_00
	mov	es:[bx.dl_index],al
	ret
    event_END_hex_00:
  endif
	mov	ax,[bp.tv_rowcnt]
	mov	cl,3
	test	tvflag,_TV_BINVIEW
	jnz	event_END_binary
	inc	cl
    event_END_binary:
	xor	dx,dx
	shl	ax,cl
	call	cmp_dxax1_fsize
	jae	event_END_00
	sub	ax,[bp.tv_fsize_ax]
	sbb	dx,[bp.tv_fsize_dx]
	not	ax
	not	dx
	add	ax,18
	adc	dx,0
	and	al,0F0h
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
	jmp	reread
    event_END_00:
	ret
event_END ENDP

event_UP PROC
  if USE_TVCLASS
	test	tvflag,_TV_CLASSVIEW
	jz	event_UP_01
	les	bx,tdialog
	xor	ax,ax
	cmp	es:[bx.dl_index],al
	je	event_UP_01
	dec	es:[bx.dl_index]
	ret
    event_UP_01:
  endif
	call	previous_line
	call	cmp_dxax_bb
	jz	event_UP_00
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
	jmp	reread
    event_UP_00:
	ret
event_UP ENDP

event_DOWN PROC
	mov	al,tvflag
  if USE_TVCLASS
	test	al,_TV_CLASSVIEW
	jz	event_DOWN_do
	les	bx,tdialog
	mov	ah,es:[bx.dl_count]
	dec	ah
	cmp	ah,es:[bx.dl_index]
	je	event_DOWN_do
	inc	es:[bx.dl_index]
	jmp	event_DOWN_03
    event_DOWN_do:
  endif
	xor	cx,cx
  if USE_TVCLASS
	test	al,_TV_HEXVIEW or _TV_CLASSVIEW
	jz	event_DOWN_02
	test	al,_TV_CLASSVIEW
	jz	event_DOWN_hex
	mov	bx,1
	jmp	event_DOWN_00
    event_DOWN_hex:
  else
	test	al,_TV_HEXVIEW
	jz	event_DOWN_02
  endif
	mov	bx,8
	test	al,_TV_BINVIEW
	jnz	event_DOWN_00
	add	bx,bx
    event_DOWN_00:
	call	cmp_bbscount1_fsize
	jnb	event_DOWN_03
	add	ax,bx
	adc	dx,cx
	call	cmp_dxax_fsize
	jb	event_DOWN_01
	jmp	event_END
    event_DOWN_01:
	add	STDI.ios_bb_ax,bx
	adc	STDI.ios_bb_dx,cx
	jmp	reread
    event_DOWN_02:
	mov	ax,[bp.tv_lcount]
	cmp	ax,[bp.tv_rowcnt]
	jb	event_DOWN_03
	lea	bx,[bp.tv_line_table]
	add	bx,4
	mov	ax,[bx]
	mov	dx,[bx+2]
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
	jmp	reread
    event_DOWN_03:
	xor	ax,ax
	ret
event_DOWN ENDP

event_PGUP PROC
	mov	cl,tvflag
  if USE_TVCLASS
	xor	ax,ax
	test	cl,_TV_CLASSVIEW
	jz	event_PGUP_do
	les	bx,tdialog
	cmp	es:[bx.dl_index],al
	je	event_PGUP_do
	mov	es:[bx.dl_index],al
	jmp	event_PGUP_04
    event_PGUP_do:
  endif
	mov	ax,STDI.ios_bb_ax
	mov	dx,STDI.ios_bb_dx
	mov	bx,ax
	or	bx,dx
	jz	event_PGUP_04
  if USE_TVCLASS
	test	cl,_TV_HEXVIEW or _TV_CLASSVIEW
  else
	test	cl,_TV_HEXVIEW
  endif
	jz	event_PGUP_text
	mov	ax,[bp.tv_rowcnt]
	test	cl,_TV_BINVIEW
	mov	cl,4
	jz	event_PGUP_00
	mov	cl,3
    event_PGUP_00:
	shl	ax,cl
	xor	dx,dx
	call	cmp_dxax_bb
	jnb	event_PGUP_02
	sub	STDI.ios_bb_ax,ax
	sbb	STDI.ios_bb_dx,dx
	jmp	event_PGUP_03
    event_PGUP_02:
	xor	ax,ax
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,ax
    event_PGUP_03:
	jmp	reread
    event_PGUP_04:
	ret
    event_PGUP_text:
	push	di
	mov	di,1
	test	tvflag,_TV_WRAPLINES
	jnz	event_PGUP_wrap
    event_PGUP_06:
	call	previous_line
	call	cmp_dxax_bb
	jz	event_PGUP_08
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
	inc	di
	cmp	di,[bp.tv_rowcnt]
	jnz	event_PGUP_06
    event_PGUP_08:
	pop	di
	jmp	reread
    event_PGUP_wrap:
	call	cmp_dxax_fsize
	jne	event_PGUP_06
	mov	di,[bp.tv_rowcnt]
	dec	di
    event_PGUP_10:
	call	previous_line
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
	dec	di
	jnz	event_PGUP_10
	jmp	event_PGUP_08
event_PGUP ENDP

event_PGDN PROC
	mov	al,tvflag
  if USE_TVCLASS
	test	al,_TV_CLASSVIEW
	jz	event_PGDN_do
	les	bx,tdialog
	mov	al,es:[bx.dl_count]
	dec	al
	cmp	es:[bx.dl_index],al
	je	event_PGDN_do
	mov	es:[bx.dl_index],al
	jmp	event_PGDN_03
    event_PGDN_do:
  endif
	call	cmp_bbscount1_fsize
	jnb	event_PGDN_03
  if USE_TVCLASS
	test	tvflag,_TV_HEXVIEW or _TV_CLASSVIEW
  else
	test	tvflag,_TV_HEXVIEW
  endif
	jz	event_PGDN_01
	mov	cx,dx
	mov	bx,ax
	mov	ax,[bp.tv_rowcnt]
	push	cx
	mov	cl,4
	test	tvflag,_TV_BINVIEW
	jz	event_PGDN_00
	dec	cl
    event_PGDN_00:
	shl	ax,cl
	pop	cx
	xor	dx,dx
	add	bx,ax
	adc	cx,dx
	cmp	cx,[bp.tv_fsize_dx]
	jne	event_PGDN_04
	cmp	bx,[bp.tv_fsize_ax]
    event_PGDN_04:
	jnc	event_PGDN_02
	add	STDI.ios_bb_ax,ax
	adc	STDI.ios_bb_dx,dx
	jmp	reread
    event_PGDN_01:
	mov	ax,[bp.tv_lcount]
	cmp	ax,[bp.tv_rowcnt]
	jnz	event_PGDN_03
	mov	ax,[bp.tv_lcount]
	dec	ax
	shl	ax,2
	lea	bx,[bp.tv_line_table]
	add	bx,ax
	call	cmp_bx_fsize
	jnb	event_PGDN_02
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
	jmp	reread
    event_PGDN_02:
	jmp	event_END
    event_PGDN_03:
	ret
event_PGDN ENDP

event_LEFT PROC
	test	tvflag,_TV_HEXVIEW or _TV_BINVIEW or _TV_WRAPLINES
	jnz	event_LEFT_00
	mov	ax,[bp.tv_curcol_ax]
	or	ax,[bp.tv_curcol_dx]
	jz	event_LEFT_00
	sub	[bp.tv_curcol_ax],1
	sbb	[bp.tv_curcol_dx],0
	jmp	reread
    event_LEFT_00:
	ret
event_LEFT ENDP

event_PGLEFT PROC
	test	tvflag,_TV_HEXVIEW or _TV_BINVIEW or _TV_WRAPLINES
	jnz	event_PGLEFT_02
	mov	ax,[bp.tv_curcol_ax]
	mov	dx,[bp.tv_curcol_dx]
	mov	cx,dx
	or	cx,ax
	jz	event_PGLEFT_02
	or	dx,dx
	jnz 	event_PGLEFT_00
	cmp	ax,80
	jnbe	event_PGLEFT_00
	xor	ax,ax
	cwd
	jmp	event_PGLEFT_01
    event_PGLEFT_00:
	sub	ax,80
	sbb	dx,0
    event_PGLEFT_01:
	mov	[bp.tv_curcol_ax],ax
	mov	[bp.tv_curcol_dx],dx
	jmp	reread
    event_PGLEFT_02:
	ret
event_PGLEFT ENDP

event_RIGHT PROC
	test	tvflag,_TV_HEXVIEW or _TV_BINVIEW or _TV_WRAPLINES
	jnz	event_RIGHT_00
	mov	ax,[bp.tv_curcol_ax]
	mov	dx,[bp.tv_curcol_dx]
	call	cmp_dxax_maxcol
	jae	event_RIGHT_00
	add	[bp.tv_curcol_ax],1
	adc	[bp.tv_curcol_dx],0
	jmp	reread
    event_RIGHT_00:
	ret
event_RIGHT ENDP

event_PGRIGHT PROC
	test	tvflag,_TV_HEXVIEW or _TV_BINVIEW or _TV_WRAPLINES
	jnz	event_PGRIGHT_00
	mov	ax,[bp.tv_curcol_ax]
	mov	dx,[bp.tv_curcol_dx]
	call	cmp_dxax_maxcol
	jb	event_PGRIGHT_01
    event_PGRIGHT_00:
	ret
    event_PGRIGHT_01:
	add	ax,80
	adc	dx,0
	call	cmp_dxax_maxcol
	jb	event_PGRIGHT_02
	mov	ax,[bp.tv_maxcol_ax]
	mov	dx,[bp.tv_maxcol_dx]
    event_PGRIGHT_02:
	mov	[bp.tv_curcol_ax],ax
	mov	[bp.tv_curcol_dx],dx
	jmp	reread
event_PGRIGHT ENDP

event_toend PROC
	test	tvflag,_TV_HEXVIEW or _TV_BINVIEW or _TV_WRAPLINES
	jnz	event_toend_00
	mov	ax,[bp.tv_maxcol_ax]
	mov	dx,[bp.tv_maxcol_dx]
	or	dx,dx
	jnz	event_toend_01
	cmp	ax,80
	jnbe	event_toend_01
    event_toend_00:
	ret
    event_toend_01:
	sub	ax,20
	sbb	dx,0
    event_toend_02:
	mov	[bp.tv_curcol_ax],ax
	mov	[bp.tv_curcol_dx],dx
	jmp	reread
event_toend ENDP

event_tostart PROC
	xor	ax,ax
	cwd
	jmp	event_toend_02
event_tostart ENDP

event_search PROC
	call	continuesearch
	or	ax,ax
	jnz	event_tostart
	ret
event_search ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

cmsearch PROC
	and	STDI.ios_flag,not IO_SEARCHMASK
	mov	al,fsflag
	and	ax,IO_SEARCHMASK
	or	STDI.ios_flag,ax
	push	[bp.tv_fsize_dx]
	push	[bp.tv_fsize_ax]
	call	cmdsearch
	push	ax
	and	fsflag,not IO_SEARCHMASK
	mov	ax,STDI.ios_flag
	and	STDI.ios_flag,not (IO_SEARCHSET or IO_SEARCHCUR)
	and	al,IO_SEARCHMASK
	or	fsflag,al
	pop	ax
	or	ax,ax
	jz	cmsearch_00
	jmp	reread
    cmsearch_00:
	ret
cmsearch ENDP

cmseek_offset PROC
	push	dx
	push	ax
	mov	dx,STDI.ios_bb_dx
	mov	ax,STDI.ios_bb_ax
	add	ax,[bp.tv_curcol_ax]
	adc	dx,[bp.tv_curcol_dx]
	push	dx
	push	ax
	xor	ax,ax
	mov	[bp.tv_curcol_ax],ax
	mov	[bp.tv_curcol_dx],ax
	mov	ax,OFFSET format_08lXh
	test	tvflag,_TV_HEXOFFSET
	jnz	cmseek_offset_hex
	mov	ax,OFFSET format_lu
    cmseek_offset_hex:
	mov	dx,es:[bx+26]
	mov	bx,es:[bx+24]
	call	@sprintf
	add	sp,4
	call	tdinit
	ret
cmseek_offset ENDP

cmseek	PROC
	push	ds
	push	IDD_TVSEEK
	call	rsopen
	jz	cmseek_02
	push	dx
	push	ax
	push	ds
	push	IDD_TVSEEK
	push	dx
	push	ax
	call	cmseek_offset
	call	rsevent
	call	twclose
	mov	ax,dx
	or	ax,ax
	jz	cmseek_02
	push	es:[bx+26]
	push	es:[bx+24]
	call	strtol
  ifdef __MIO__
	test	STDI.ios_flag,IO_MEMREAD
	jz	cmseek_00
	call	normalize
  endif
    cmseek_00:
	call	cmp_dxax_fsize
	ja	cmseek_01
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
	xor	ax,ax
	inc	ax
	jz	cmseek_02
	jmp	reread
    cmseek_01:
	xor	ax,ax
    cmseek_02:
	ret
cmseek	ENDP

cmcopy	PROC
	push	ds
	push	IDD_TVCOPY
	call	rsopen
	jnz	cmcopy_01
    cmcopy_00:
	ret
    cmcopy_01:
	push	dx
	push	ax
	push	ds
	push    IDD_TVCOPY
	push	dx
	push	ax
	mov	[bp.tv_tmp_ax],ax
	mov	[bp.tv_tmp_dx],dx
	test	tvflag,_TV_CLIPBOARD
	jz	cmcopy_02
	or	BYTE PTR es:[bx+4*16],_O_FLAGB
    cmcopy_02:
	call	cmseek_offset
	call	rsevent
	or	ax,ax
	jz	cmcopy_close
	push	es:[bx+26]
	push	es:[bx+24]
	and	tvflag,not _TV_CLIPBOARD
	test	BYTE PTR es:[bx+4*16],_O_FLAGB
	jz	cmcopy_03
	or	tvflag,_TV_CLIPBOARD
    cmcopy_03:
	call	strtol
	call	cmp_dxax_fsize
	jb	cmcopy_05
	xor	ax,ax
    cmcopy_close:
	call	twclose
	mov	ax,dx
	or	ax,ax
	ret
    cmcopy_04:
	mov	ax,1
	jmp	cmcopy_close
    cmcopy_05:
	push	dx
	push	ax
	push	SEEK_SET
	call	oseek
	jz	cmcopy_06
	test	tvflag,_TV_CLIPBOARD
	jnz	cmcopy_07
	mov	ax,OSTDO
	call	oinitst
	jz	cmcopy_close
	les	bx,DWORD PTR [bp.tv_tmp_ax]
	push	es:[bx+58]
	push	es:[bx+56]
	call	ogetouth
	cmp	ax,-1
	je	cmcopy_06
	mov	STDO.ios_file,ax
	les	bx,DWORD PTR [bp.tv_tmp_ax]
	push	es:[bx+42]
	push	es:[bx+40]
	call	strtol
	push	dx
	push	ax
	call	ocopy
	call	oflush
	mov	ax,OSTDO
	call	oclose
    cmcopy_06:
	mov	ax,OSTDO
	call	ofreest
	jmp	cmcopy_04
    cmcopy_07:
	les	bx,DWORD PTR [bp.tv_tmp_ax]
	push	es:[bx+42]
	push	es:[bx+40]
	call	strtol
	or	dx,dx
	jnz	cmcopy_04
	or	ax,ax
	jz	cmcopy_04
	cmp	ax,STDI.ios_c
	jna	cmcopy_08
	jmp	cmcopy_04
    cmcopy_08:
	push	STDI.ios_bp_dx
	push	STDI.ios_bp_ax
	push	ax
	call	ClipboardInit
	call	ClipboardOpen
	call	ClipboardEmpty
	call	ClipboardCopy
	call	ClipboardClose
	call	ClipboardFree
	jmp	cmcopy_04
cmcopy	ENDP

cmmcopy PROC
  ifdef __MOUSE__
	push	bp
	mov	bp,sp
	sub	sp,81
	push	si
	push	di
	push	ds
	call	mousex
	mov	bx,ax
	call	mousey
	mov	bh,al
	call	@rcsprc
	mov	ds,dx
	mov	si,ax
	lea	di,[bp-81]
	mov	cx,80
	sub	cl,bl
	mov	bx,di
	push	ss
	pop	es
	cld
    cmmcopy_loop:
	lodsw
	stosb
	dec	cx
	jnz	cmmcopy_loop
	xor	ax,ax
	stosb
	pop	ds
	push	ss
	push	bx
	call	strtrim
	jz      cmmcopy_end
	push	ss
	push	bx
	push	ax
	call	ClipboardInit
	call	ClipboardOpen
	call	ClipboardEmpty
	call	ClipboardCopy
	call	ClipboardClose
	call	ClipboardFree
    cmmcopy_end:
	pop	di
	pop	si
	mov	sp,bp
	pop	bp
  endif
	ret
cmmcopy	ENDP

update_dialog PROC
	mov	bx,0100h
	mov	dx,[bp.tv_rowcnt]
	mov	cx,80
	mov	al,at_background[B_Desktop]
	or	al,at_foreground[F_Desktop]
	test	tvflag,_TV_HIGHCOLOR
	jz	update_dialog_00
	or	al,0Fh
    update_dialog_00:
	call	@scputa
	inc	bh
	dec	dx
	jnz	update_dialog_00
	mov	bl,35
	mov	cx,5
	mov	ax,OFFSET cp_hex
  if USE_TVCLASS
	test	tvflag,_TV_HEXVIEW or _TV_CLASSVIEW
	jz	update_dialog_01
	mov	ax,OFFSET cp_class
	test	tvflag,_TV_HEXVIEW
	jnz	update_dialog_01
  else
	test	tvflag,_TV_HEXVIEW
	jz	update_dialog_01
  endif
	mov	ax,OFFSET cp_ascii
    update_dialog_01:
	call	@scputds
	mov	bl,13
	inc	cl
	mov	ax,OFFSET cp_unwrap
	test	tvflag,_TV_WRAPLINES
	jnz	update_dialog_02
	mov	ax,OFFSET cp_wrap
    update_dialog_02:
	call	@scputds
	mov	bl,54
	mov	cl,3
	mov	ax,OFFSET cp_deci
	test	tvflag,_TV_HEXOFFSET
	jnz	update_dialog_03
	mov	ax,OFFSET cp_hex
    update_dialog_03:
	call	@scputds
	ret
update_dialog ENDP

update_reread PROC
	call	update_dialog
	jmp	reread
update_reread ENDP

if_fsize PROC
	mov	ax,[bp.tv_fsize_dx]
	or	ax,[bp.tv_fsize_ax]
	jnz	if_fsize_01
	pop	ax
	xor	ax,ax
    if_fsize_01:
	ret
if_fsize ENDP

cmwrap	PROC
	call	if_fsize
	test	tvflag,_TV_HEXVIEW
	jnz	cmwrap_00
	xor	tvflag,_TV_WRAPLINES
	jmp	update_reread
    cmwrap_00:
	xor	ax,ax
	ret
cmwrap	ENDP

cmoffset PROC
	call	if_fsize
	xor	tvflag,_TV_HEXOFFSET
	jmp	update_reread
cmoffset ENDP

cmbinary PROC
	call	if_fsize
	test	tvflag,_TV_HEXVIEW
	jnz	cmbinary_00
	or	tvflag,_TV_HEXVIEW or _TV_BINVIEW
	jmp	update_reread
    cmbinary_00:
	xor	tvflag,_TV_BINVIEW
	jmp	update_reread
cmbinary ENDP

cmhex	PROC
	call	if_fsize
	mov	al,tvflag
	mov	ah,al
	and	al,not (_TV_HEXVIEW or _TV_CLASSVIEW or _TV_BINVIEW)
  if USE_TVCLASS
	test	ah,_TV_HEXVIEW or _TV_CLASSVIEW
	jz	cmhex_setx
	test	ah,_TV_CLASSVIEW
	jnz	cmhex_set
	or	al,_TV_CLASSVIEW
	jmp	cmhex_set
    cmhex_setx:
  else
	test	ah,_TV_HEXVIEW
	jnz	cmhex_set
  endif
	or	al,_TV_HEXVIEW
    cmhex_set:
	mov	tvflag,al
	and	al,_TV_HEXVIEW or _TV_CLASSVIEW
	jnz	cmhex_hex
	call	cmp_curcol_bb
	jna	cmhex_00
	jmp	update_reread
    cmhex_00:
	sub	STDI.ios_bb_ax,ax
	sbb	STDI.ios_bb_dx,dx
	jmp	update_reread
    cmhex_hex:
	mov	ax,[bp.tv_curcol_ax]
	mov	dx,[bp.tv_curcol_dx]
	add	STDI.ios_bb_ax,ax
	adc	STDI.ios_bb_dx,dx
	xor	ax,ax
	mov	[bp.tv_curcol_ax],ax
	mov	[bp.tv_curcol_dx],ax
	jmp	update_reread
cmhex	ENDP

cmcolor	PROC
	xor	tvflag,_TV_HIGHCOLOR
	call	update_dialog
	mov	ax,1
	ret
cmcolor	ENDP

cmabout PROC DIST
	push	ds
	push	offset TVABOUT_RC;IDD_TVABOUT
	call	rsmodal
	ret
cmabout ENDP

cmhelp	PROC
	push	ds
	push	IDD_TVHELP
	call	rsopen
	jz	cmhelp_end
	push	dx
	push	ax
	push	ds
	push	IDD_TVHELP
	push	dx
	push	ax
	mov	ax,offset cmabout
	mov	es:[bx.to_proc_ax+32],ax
	mov	es:[bx.to_proc_dx+32],cs
	LPUSH	cs
	push	ax
	call	thelp_set
	call	rsevent
	call	twclose
	call	thelp_pop
    cmhelp_end:
	ret
cmhelp	ENDP

cmquit	PROC
	mov	ax,1
	mov	[bp.tv_switch],ax
	dec	ax
	ret
cmquit	ENDP

cmconsole PROC
	mov	ax,[bp.tv_dialog_ax]
	mov	dx,[bp.tv_dialog_dx]
	push	dx
	push	ax
	push	dx
	push	ax
	call	twhide
    cmconsole_00:
	call	getkey
	or	ax,ax
	jz	cmconsole_00
	call	twshow
	ret
cmconsole ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ifdef __MOUSE__

mouse_scroll PROC
	xor	cx,cx
	mov	es,cx
	mov	cl,es:[0484h]
	xor	bx,bx
	cmp	cx,24
	jz	mouse_scroll_00
	shr	ax,1
	shr	dx,1
    mouse_scroll_00:
	cmp	dx,8
	jc	mouse_scroll_07
	cmp	dx,16
	ja	mouse_scroll_06
	cmp	dx,8
	jc	mouse_scroll_03
	cmp	dx,16
	ja	mouse_scroll_03
	cmp	ax,31
	jc	mouse_scroll_05
	cmp	ax,50
	ja	mouse_scroll_04
	cmp	dx,12
	jnz	mouse_scroll_01
	cmp	ax,39
	ja	mouse_scroll_04
	jmp	mouse_scroll_05
    mouse_scroll_01:
	cmp	dx,11
	jb	mouse_scroll_02
	cmp	dx,13
	ja	mouse_scroll_02
	cmp	ax,36
	jb	mouse_scroll_05
	cmp	ax,45
	ja	mouse_scroll_04
    mouse_scroll_02:
	cmp	dx,12
	jb	mouse_scroll_07
	ja	mouse_scroll_06
    mouse_scroll_03:
	ret
    mouse_scroll_04:
	inc	bx
    mouse_scroll_05:
	inc	bx
    mouse_scroll_06:
	inc	bx
    mouse_scroll_07:
	inc	bx
	push	bx
	cmp	ax,37
	jb	mouse_scroll_09
	cmp	ax,43
	jb	mouse_scroll_08
	mov	bx,79
	sub	bx,ax
	mov	ax,bx
	jmp	mouse_scroll_09
    mouse_scroll_08:
	xor	ax,ax
    mouse_scroll_09:
	shl	ax,2
	cmp	dx,12
	je	mouse_scroll_10
	jb	mouse_scroll_11
	mov	cx,24
	sub	cx,dx
	mov	dx,cx
	jmp	mouse_scroll_11
    mouse_scroll_10:
	xor	dx,dx
    mouse_scroll_11:
	add	dx,dx
	add	dx,dx
	pop	bx
	ret
    mouse_scroll_proc:
	call	mousey
	push	ax
	call	mousex
	pop	dx
	call	mouse_scroll
	ret
    mouse_scroll_up:
	mov	ax,KEY_UP
	jmp	mouse_scroll_updn
    mouse_scroll_down:
	mov	ax,KEY_DOWN
    mouse_scroll_updn:
	push	dx
	jmp	mouse_scroll_event
    mouse_scroll_left:
	push	ax
	mov	ax,KEY_LEFT
	jmp	mouse_scroll_event
    mouse_scroll_right:
	push	ax
	mov	ax,KEY_RIGHT
    mouse_scroll_event:
	call	tview_event
	pop	ax
	mov	di,ax
    mouse_scroll_delay:
	or	di,di
	jz	mouse_scroll_delay_00
	push	di
	call	delay
    mouse_scroll_delay_00:
	ret
    scroll:
	push	di
	xor	di,di
	call	mouse_scroll_proc
	add	bx,bx
	call	[bx+label_scroll]
	pop	di
	ret
mouse_scroll ENDP

mouse_event PROC
	call	mousep
	jz	mouse_event_07
	cmp	ax,2
	je	mouse_event_09
	call	mousex
	mov	[bp.tv_xpos],ax
	call	mousey
	mov	[bp.tv_ypos],ax
	dec	ax
	cmp	ax,[bp.tv_rowcnt]
	jne	mouse_event_08
	call	msloop
	mov	ax,[bp.tv_xpos]
	cmp	al,9
	jnb	mouse_event_00
	jmp	cmhelp
    mouse_event_00:
	je	mouse_event_07
	cmp	al,20
	jnb	mouse_event_01
	jmp	cmwrap
    mouse_event_01:
	jz	mouse_event_07
	cmp	al,31
	jnb	mouse_event_02
	jmp	cmsearch
    mouse_event_02:
	je	mouse_event_07
	cmp	al,41
	jnb	mouse_event_03
	jmp	cmhex
    mouse_event_03:
	je	mouse_event_07
	cmp	al,50
	jnb	mouse_event_04
	jmp	cmcopy
    mouse_event_04:
	je	mouse_event_07
	cmp	al,58
	jnb	mouse_event_05
	jmp	cmoffset
    mouse_event_05:
	je	mouse_event_07
	cmp	al,66
	jnbe	mouse_event_06
	jmp	cmseek
    mouse_event_06:
	cmp	al,70
	jbe	mouse_event_07
	call	cmquit
    mouse_event_07:
	xor	ax,ax
	ret
    mouse_event_08:
	call	mousep
	cmp	ax,1
	jne	mouse_event_07
	call	scroll
	jmp	mouse_event_08
    mouse_event_09:
	call	cmmcopy
	call	msloop
	ret
mouse_event ENDP

endif ; __MOUSE__

tview_event PROC
	mov	cx,local_count
	xor	bx,bx
	mov	dx,[bp.tv_fsize_ax]
	or	dx,[bp.tv_fsize_dx]
	jnz	tview_event_00
	mov	cx,global_count
    tview_event_00:
	cmp	ax,[bx+key_global]
	je	tview_event_01
	add	bx,2
	loop	tview_event_00
	ret
    tview_event_01:
	jmp	[bx+proc_label]
tview_event ENDP

modal	PROC
	cmp	[bp.tv_switch],0
	jne	modal_exit
  if USE_TVCLASS
	test	tvflag,_TV_CLASSVIEW
	jz	modal_event
	call	tdxcellevent
	cmp	ax,-1
	je	modal_event
	jmp	modal_hndevent
  endif
    modal_event:
  ifdef __MOUSE__
	call	mousep
	or	ax,ax
	jnz	modal_mouse
  endif
	call	getkey
    modal_hndevent:
	or	ax,ax
	jz	modal_event
	call	tview_event
	jmp	modal
  ifdef __MOUSE__
    modal_mouse:
	call	mouse_event
	call	msloop
	jmp	modal
  endif
    modal_exit:
	xor	ax,ax
	ret
modal	ENDP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dummy_update PROC DIST
	xor	ax,ax
	ret
dummy_update ENDP

textview PROC DIST
	push	bp
	mov	ax,tv_stack_size
	sub	sp,ax
	mov	bp,sp
	push	si
	push	di
	push	ss
	push	bp
	push	ax
	call	memzero
  ifdef __MIO__
	mov	ax,[bp.tv_arg_memz_ax]
	mov	WORD PTR tvmem_size,ax
	mov	ax,[bp.tv_arg_memz_dx]
	mov	WORD PTR tvmem_size+2,ax
	mov	ax,[bp.tv_arg_memo_ax]
	mov	dx,[bp.tv_arg_memo_dx]
	call	normalize
	mov	WORD PTR tvmem_offs,ax
	mov	WORD PTR tvmem_offs+2,dx
  endif
	mov	ax,[bp.tv_arg_offs_ax]
	mov	dx,[bp.tv_arg_offs_dx]
  ifdef __MIO__
	and	STDI.ios_flag,IO_MEMREAD
	jz	textview_00
	call	normalize		; offset == pointer
    textview_00:
  endif
	mov	[bp.tv_offset_ax],ax
	mov	[bp.tv_offset_dx],dx
	mov	STDI.ios_bb_ax,ax
	mov	STDI.ios_bb_dx,dx
	xor	ax,ax			; init resource
	mov	al,_scrrow
	dec	al
	mov	[bp.tv_rowcnt],ax	; adapt to current screen size
	add	al,2
	mov	rs_rcrow,al
	mov	dx,160
	mul	dl
	add	ax,16
	mov	resource,ax
	mov	ax,[bp.tv_rowcnt]
	mov	dx,80
	mul	dl
	sub	ax,4
	mov	si,ax
	mov	di,offset rs_chcnt
	mov	bx,offset rs_atcnt
	mov	cx,4
    textview_rsloop:
	mov	ax,0FFFh
	cmp	si,ax
	jbe	textview_rsbreak
	sub	si,ax
	mov	ah,0FFh
	mov	[bx],ax
	mov	[di],ax
	add	bx,3
	add	di,3
	inc	si
	loop	textview_rsloop
    textview_rsbreak:
	mov	ax,si
	or	ax,0F000h
	xchg	al,ah
	mov	[bx],ax
	add	ah,2
	mov	[di],ax
	mov	STDI.ios_size,8000h	; init stream
	xor	ax,ax
	and	STDI.ios_flag,IO_MEMREAD
  ifdef __MIO__
	jnz	textview_02
  endif
	push	[bp.tv_arg_file_dx]	; open file
	push	[bp.tv_arg_file_ax]
	push	ax
	push	ax
	push	A_OPEN
	call	osopen
	cmp	ax,-1
	jne	textview_01
	dec	ax
	jmp	textview_05
    textview_01:
	mov	STDI.ios_file,ax
    textview_02:
  if USE_TVCLASS
	call	init_class
  endif
	push	0C00Ch
	call	malloc
	mov	STDI.ios_bp_ax,ax
	mov	STDI.ios_bp_dx,dx
	mov	bx,ax
	add	ax,800Ch
	mov	WORD PTR [bp.tv_screen],ax
	mov	WORD PTR [bp.tv_screen+2],dx
	or	bx,bx
	jz	textview_03
	push	ds
	push	OFFSET resource
	call	rsopen
	jnz	textview_06
	push	STDI.ios_bp_dx
	push	STDI.ios_bp_ax
	call	free
    textview_03:
  ifdef __MIO__
	test	STDI.ios_flag,IO_MEMREAD
	jnz	textview_04
  endif
	push	STDI.ios_file
	call	close
    textview_04:
	mov	ax,1
    textview_05:
	mov	STDI.ios_size,ISIZE
	pop	di
	pop	si
	add	sp,tv_stack_size
	pop	bp
	ret	16
    textview_06:
	mov	[bp.tv_dialog_ax],ax
	mov	[bp.tv_dialog_dx],dx
	push	dx
	push	ax
	call	twshow
  ifdef __MOUSE__
	call	mouseoff
  endif
	mov	ax,[bp.tv_arg_file_ax]
	mov	dx,[bp.tv_arg_file_dx]
	mov	bx,12
	mov	cx,30
	or	ax,ax
	jnz	textview_07
	mov	dx,ds
	mov	ax,OFFSET cp_memory
     textview_07:
	call	@scpath
	add	ax,14
	mov	si,ax
  ifdef __MIO__
	mov	ax,WORD PTR tvmem_size
	mov	dx,WORD PTR tvmem_size+2
	test	STDI.ios_flag,IO_MEMREAD
	jnz	textview_08
  endif
	mov	ax,4202h
	mov	bx,STDI.ios_file
	xor	cx,cx
	xor	dx,dx
	int	21h
	jc	textview_09
    textview_08:
	mov	[bp.tv_fsize_ax],ax
	mov	[bp.tv_fsize_dx],dx
    textview_09:
	push	0
	push	0
	push	dx
	push	ax
	call	qwtobstr
	mov	bx,si
	xor	cx,cx
	call	@scputs
	add	bl,al
	mov	ax,OFFSET cp_byte
	call	@scputs
	push	ss
	lea	ax,[bp.tv_cursor]
	push	ax
	call	getcursor
	push	0
	push	1
	call	gotoxy
	call	cursoroff
	LPUSH	WORD PTR tupdate+2
	push	WORD PTR tupdate
	LMOV	WORD PTR tupdate+2,cs
	mov	WORD PTR tupdate,OFFSET dummy_update
  ifdef __MOUSE__
	call	mouseon
  endif
	call	update_dialog
  ifdef __MOUSE__
	call	msloop
  endif
	call	read_static_table
	call	reread
	call	modal
	pop	ax
	LPOP	dx
	mov	WORD PTR tupdate,ax
	LMOV	WORD PTR tupdate+2,dx
	push	STDI.ios_bp_dx
	push	STDI.ios_bp_ax
	call	free
	push	[bp.tv_dialog_dx]
	push	[bp.tv_dialog_ax]
	call	twclose
  ifdef __MIO__
	test	STDI.ios_flag,IO_MEMREAD
	jnz	textview_10
  endif
	push	STDI.ios_file
	call	close
    textview_10:
	xor	ax,ax
	mov	STDI.ios_flag,ax
	movmmax	tdialog,[bp.tv_tdialog_ax]
	push	WORD PTR [bp.tv_cursor+2]
	push	WORD PTR [bp.tv_cursor]
	call	setcursor
	xor	ax,ax
	jmp	textview_05
textview ENDP

_TEXT	ENDS

PPROC	tview,	fn:DWORD, off:DWORD
	push	WORD PTR fn+2
	push	WORD PTR fn
	push	WORD PTR off+2
	push	WORD PTR off
	push	0
	push	0
	push	000Fh
	push	0FFFFh
	call	textview
	ret
PEND	tview

	END
