; Change history:
; 11/17/2008	- added KEY_HOME and KEY_END
; 11/16/2008	- added KEY_KPENTER

include	clib.inc
include	keyb.inc
include	conio.inc
include	mouse.inc
include	dos.inc

	.186

	public	tdialog
	public	tdllist
	public	tdpbuttevent
	public	tdradioevent
	public	tdcheckevent
	public	tdxcellevent
	public	tdteditevent
	public	tdmenusevent

USE_MDALTKEYS	= 1

_TEXT  	SEGMENT

dummy_update PROC
	xor	ax,ax
	ret
dummy_update ENDP

tdshortkey PROC
	push	ax
	test	es:[bx.to_flag],_O_DEACT
	jnz	tdshortkey_nil
	cmp	es:[bx.to_ascii],0
	jz	tdshortkey_nil
	and	al,0DFh
	cmp	es:[bx.to_ascii],al
	jz	tdshortkey_00
	mov	al,es:[bx.to_ascii]
	and	al,0DFh
	sub	al,'A'
	push	bx
	mov	bh,0
	mov	bl,al
	cmp	ah,[bx+key_scancode]
	pop	bx
	jnz	tdshortkey_nil
    tdshortkey_00:
	or	ax,1
	jmp	tdshortkey_end
    tdshortkey_nil:
	xor	ax,ax
    tdshortkey_end:
	pop	ax
	ret
tdshortkey ENDP

handle_event PROC
	or	ax,ax
	jnz	handle_event_do
	ret
    handle_event_do:
	push	si
	push	di
	xor	dx,dx
	mov	si,dx
	mov	cx,dx
	les	bx,tdialog
	mov	cl,es:[bx.dl_count]
	MLES	bx,DWORD PTR es:[bx.dl_object_ax]
	cmp	ax,KEY_F1
	je	handle_event_help
	or	cl,cl
	jz	handle_event_null
    handle_event_loop:
	test	es:[bx.to_flag],_O_GLCMD
	jz	handle_event_shkey
	mov	dx,es:[bx.to_data_ax]
	mov	di,es:[bx.to_data_dx]
    handle_event_shkey:
	call	tdshortkey
	jnz	handle_event_si_to_index
	add	bx,16
	inc	si
	dec	cx
	jnz	handle_event_loop
	or	dx,dx
	jz	handle_event_null
	mov	bx,dx
	mov	es,di
    handle_event_gloop:
	cmp	es:[bx.gl_key],0
	jz	handle_event_null
	cmp	es:[bx],ax
	je	handle_event_found
	add	bx,size S_GLCMD
	jmp	handle_event_gloop
    handle_event_found:
	call	es:[bx.S_GLCMD.gl_proc]
	jmp	handle_event_end
    handle_event_null:
	xor	ax,ax
	jmp	handle_event_end
    handle_event_si_to_index:
	mov	ax,si
	les	bx,tdialog
	mov	es:[bx.dl_index],al
    handle_event_one:
	mov	ax,1
    handle_event_end:
	mov	result,ax
	pop	di
	pop	si
	ret
    handle_event_help:
	xor	ax,ax
	les	bx,tdialog
	test	es:[bx.dl_flag],_D_DHELP
	jz	handle_event_end
	cmp	word ptr thelp,ax
	jz	handle_event_end
	call	thelp
	mov	ax,_C_NORMAL
	jmp	handle_event_end
handle_event ENDP

test_event PROC
	xor	bx,bx
    test_event_loop:
	cmp	ax,[bx+keytable]
	je	test_event_found
	add	bx,2
	dec	cx
	jnz	test_event_loop
	call	handle_event
	ret
    test_event_found:
	call	[bx+proctab]
	ret
test_event ENDP

ldobject_cursor PROC
	push	ax
	MPUSH	ds
	push	offset ocurs
	call	getcursor
	pop	ax
ldobject_cursor ENDP

ldobject PROC
	les	bx,tdialog
	cmp	es:[bx.dl_count],0
	je	ldobject_end
	or	ax,ax
	jnz	ldobject_index
	mov	al,es:[bx.dl_index]
	inc	ax
    ldobject_index:
	mov	dx,es:[bx+4]
	MLES	bx,dword ptr es:[bx.dl_object_ax]
	dec	ax
	shl	ax,4
	add	ax,bx
	mov	word ptr tobjp,ax
	mov	word ptr tobjp+2,es
	mov	bx,ax
	mov	ax,es:[bx]
	mov	oflag,ax
	mov	ax,word ptr es:[bx.to_rect_c]
	mov	word ptr orect+2,ax
	mov	ax,word ptr es:[bx.to_rect_x]
	add	ax,dx
	mov	word ptr orect,ax
	mov	ah,0
	mov	oxpos,ax
	mov	al,orect.rc_y
	mov	oypos,ax
	mov	al,orect.rc_col
	mov	oxlen,ax
	mov	ax,es:[bx]
	ret
    ldobject_end:
	xor	ax,ax
	ret
ldobject ENDP

ifdef __MOUSE__
omousecmd PROC
	call	mousex
	push	ax
	call	mousey
	pop	dx
	cmp	ax,oypos
	jne	omousecmd_nil
	mov	ax,oxpos
	dec	ax
	cmp	dx,ax
	jb	omousecmd_nil
	add	ax,2
	cmp	dx,ax
	jbe	omousecmd_one
    omousecmd_nil:
	xor	ax,ax
	mov	ax,MOUSECMD
	ret
    omousecmd_one:
	or	ax,1
	ret
omousecmd ENDP
endif

exechild PROC
	inc	ax
	call	ldobject
	cmp	es:[bx.to_proc_ax],0
	jz	exechild_end
  ifdef LPROG
	call	dword ptr es:[bx.to_proc_ax]
  else
	call	es:[bx.to_proc_ax]
  endif
	mov	result,ax
	cmp	ax,_C_REOPEN
	jne	exechild_end
	les	bx,tdialog
	mov	al,es:[bx.dl_index]
	push	ax
	push	tdsegdl
	push	tdoffdl
	call	tdinit
	pop	ax
	les	bx,tdialog
	mov	es:[bx.dl_index],al
    exechild_end:
	ret
exechild ENDP

cl_to_index PROC
	dec	cx
	mov	[di.dl_index],cl
	mov	ax,1
	or	ax,ax
	ret
cl_to_index ENDP

cl_to_index_if_act PROC
	test	es:[si.to_flag],_O_DEACT
	jz	cl_to_index
	xor	ax,ax
	ret
cl_to_index_if_act ENDP

previtem PROC
	push	ds
	push	si
	push	di
	lds	di,tdialog
	xor	cx,cx
	add	cl,[di.dl_index]
	jz	previtem_00
	les	si,dword ptr [di.dl_object_ax]
	mov	ax,cx
	dec	ax
	shl	ax,4
	add	si,ax
    previtem_set:
	call	cl_to_index_if_act
	jnz	previtem_break
	sub	si,size S_TOBJ
	dec	cx
	jnz	previtem_set
    previtem_break:
	jnz	previtem_end
	xor	cx,cx
    previtem_00:
	add	cl,[di.dl_count]
	jz	previtem_02
	mov	bl,[di.dl_index]
	mov	si,[di.dl_object_ax]
	mov	ax,cx
	dec	ax
	shl	ax,4
	add	si,ax
	xor	ax,ax
    previtem_01:
	cmp	bl,cl
	ja	previtem_02
	test	es:[si.to_flag],_O_DEACT
	jz	previtem_04
	sub	si,size S_TOBJ
	dec	cx
	jnz	previtem_01
    previtem_02:
	xor	ax,ax
    previtem_end:
	pop	di
	pop	si
	pop	ds
	ret
    previtem_04:
	call	cl_to_index
	jmp	previtem_end
previtem ENDP

itemleft PROC
	push	ds
	push	si
	push	di
	lds	di,tdialog
	xor	cx,cx
	add	cl,[di.dl_index]
	jz	itemleft_nil
	les	si,dword ptr [di.dl_object_ax]
	mov	ax,cx
	dec	ax
	shl	ax,4
	add	si,ax
	mov	bx,es:[si+20]
    itemleft_loop:
	cmp	bh,es:[si+5]
	jne	itemleft_next
	cmp	bl,es:[si+4]
	jbe	itemleft_next
	call	cl_to_index_if_act
	jnz	itemleft_end
    itemleft_next:
	sub	si,16
	dec	cx
	jnz	itemleft_loop
    itemleft_nil:
	xor	ax,ax
    itemleft_end:
	pop	di
	pop	si
	pop	ds
	ret
itemleft ENDP

nextitem PROC
	push	ds
	push	si
	push	di
	lds	di,tdialog
	xor	dx,dx
	xor	cx,cx
	mov	dl,[di+2]
	mov	cl,[di+3]
	inc	cx
	les	si,[di+12]
	mov	ax,cx
	shl	ax,4
	add	si,ax
	inc	cx
    nextitem_00:
	cmp	cx,dx
	ja	nextitem_01
	call	cl_to_index_if_act
	jnz	nextitem_04
	inc	cx
	add	si,16
	jmp	nextitem_00
    nextitem_01:
	xor	dx,dx
	mov	dl,es:[si+3]
	inc	dx
	mov	cx,1
	mov	si,[di+12]
    nextitem_02:
	cmp	cx,dx
	ja	nextitem_03
	call	cl_to_index_if_act
	jnz	nextitem_04
	inc	cx
	add	si,16
	jmp	nextitem_02
    nextitem_03:
	xor	ax,ax
    nextitem_04:
	pop	di
	pop	si
	pop	ds
	ret
nextitem ENDP

itemright PROC
	push	ds
	push	si
	push	di
	lds	di,tdialog
	xor	dx,dx
	xor	cx,cx
	mov	dl,byte ptr [di+2]
	mov	cl,byte ptr [di+3]
	inc	cx
	les	si,[di+12]
	mov	ax,cx
	shl	ax,4
	add	si,ax
	mov	bx,es:[si-12]
	inc	cx
    itemright_00:
	cmp	cx,dx
	ja	itemright_02
	cmp	bh,es:[si+5]
	jnz	itemright_01
	cmp	bl,es:[si+4]
	jnb	itemright_01
	call	cl_to_index_if_act
	jnz	itemright_end
    itemright_01:
	inc	cx
	add	si,16
	jmp	itemright_00
    itemright_02:
	xor	ax,ax
    itemright_end:
	pop	di
	pop	si
	pop	ds
	ret
itemright ENDP

xbuttxchg PROC
	mov	bl,byte ptr oxpos
	mov	bh,byte ptr oypos
	call	@getxyw
	xchg	si,ax
	mov	cx,1
	call	@scputw
	add	bl,byte ptr oxlen
	dec	bl
	call	@getxyw
	xchg	di,ax
	call	@scputw
	ret
xbuttxchg ENDP

ifdef __MOUSE__

xbuttms	PROC
	push	si
	push	di
	mov	si,' '
	mov	di,si
	call	xbuttxchg
	inc	bl
	call	@getxyw
	push	ax
	sub	bl,byte ptr oxlen
	inc	bh
	inc	bl
	call	@getxyw
	push	ax
	mov	al,byte ptr oflag
	and	ax,000Fh
	push	ax
	jnz	xbuttms_00
	mov	cl,byte ptr oxlen
	mov	al,' '
	call	@scputw
	add	bl,cl
	dec	bh
	dec	bl
	mov	cl,1
	call	@scputw
    xbuttms_00:
	call	msloop
	call	xbuttxchg
	pop	dx
	pop	ax
	pop	di
	or	dx,dx
	jnz	xbuttms_end
	mov	cx,oxlen
	mov	bh,byte ptr oypos
	mov	bl,byte ptr oxpos
	inc	bh
	inc	bl
	call	@scputw
	add	bl,byte ptr oxlen
	dec	bh
	dec	bl
	mov	cl,1
	mov	ax,di
	call	@scputw
    xbuttms_end:
	pop	di
	pop	si
	ret
xbuttms	ENDP

cmdmouse PROC
	push	si
	push	di
	les	bx,tdialog
	mov	si,word ptr es:[bx.dl_rect_c]
	mov	di,word ptr es:[bx.dl_rect_x]
	call	mousex
	mov	cx,ax
	call	mousey
	mov	dx,ax
	push	si
	push	di
	push	cx
	push	dx
	call	rcxyrow
	jz	cmdmouse_00
	cmp	ax,1
	jne	cmdmouse_02
	push	tdsegdl
	push	tdoffdl
	call	twmove
	jmp	cmdmouse_04
    cmdmouse_00:
	mov	result,_C_ESCAPE
    cmdmouse_01:
	pop	di
	pop	si
	ret
    cmdmouse_02:
	mov	al,es:[bx.dl_count]
	mov	ah,0
	or	ax,ax
	jz	cmdmouse_04
	mov	si,ax
	les	bx,dword ptr es:[bx.dl_object_ax]
    cmdmouse_03:
	mov	ax,word ptr es:[bx.to_rect_x]
	add	ax,di
	push	word ptr es:[bx.to_rect_c]
	push	ax
	push	cx
	push	dx
	call	rcxyrow
	jnz	cmdmouse_05
	add	bx,size S_TOBJ
	dec	si
	jnz	cmdmouse_03
    cmdmouse_04:
	call	msloop
	mov	result,_C_NORMAL
	jmp	cmdmouse_01
    cmdmouse_05:
	les	bx,tdialog
	mov	ah,0
	mov	al,es:[bx.dl_count]
	sub	ax,si
	mov	si,ax
	inc	ax
	call	ldobject
	test	ax,_O_DEACT
	jnz	cmdmouse_11
	les	bx,tdialog
	mov	ax,si
	mov	es:[bx.dl_index],al
	mov	ax,oflag
	and	al,0Fh
	cmp	al,_O_TBUTT
	je	cmdmouse_06
	cmp	al,_O_PBUTT
	jne	cmdmouse_07
    cmdmouse_06:
	call	xbuttms
    cmdmouse_07:
	mov	ax,oflag
	test	ax,_O_DEXIT
	jnz	cmdmouse_00
	test	ax,_O_CHILD
	jz	cmdmouse_09
    cmdmouse_08:
	mov	ax,si
	call	exechild
	jmp	cmdmouse_01
    cmdmouse_09:
	and	ax,000Fh
	cmp	al,_O_TBUTT
	je	cmdmouse_10
	cmp	al,_O_PBUTT
	je	cmdmouse_10
	cmp	al,_O_MENUS
	je	cmdmouse_10
	cmp	al,_O_XHTML
	je	cmdmouse_10
	mov	result,_C_NORMAL
	jmp	cmdmouse_01
    cmdmouse_10:
	mov	result,_C_RETURN
	jmp	cmdmouse_01
    cmdmouse_11:
	and	al,0Fh
	cmp	al,_O_LLMSU
	je	cmdmouse_13
	cmp	al,_O_LLMSD
	je	cmdmouse_14
	cmp	al,_O_MOUSE
	jne	cmdmouse_12
	test	cx,_O_CHILD
	jnz	cmdmouse_08
    cmdmouse_12:
	call	mousex
	mov	cx,ax
	call	mousey
	mov	dx,ax
	jmp	cmdmouse_04
    cmdmouse_13:
	call	TDLLISTMOUSEUP
	jmp	cmdmouse_01
    cmdmouse_14:
	call	TDLLISTMOUSEDN
	jmp	cmdmouse_01
cmdmouse ENDP

mousedelay PROC
	call	mousep
	jnz	mousedelay_do
	ret
    mousedelay_do:
	call	scroll_delay
	call	scroll_delay
	or	ax,1
	ret
mousedelay ENDP

TDLLISTMOUSEUP PROC
	les	bx,tdllist
	xor	ax,ax
	cmp	ax,es:[bx.ll_count]
	jz	TDRETNORMAL
	mov	dx,es:[bx]
	mov	es:[bx.ll_celoff],ax
	les	bx,tdialog
	cmp	dl,es:[bx.dl_index]
	mov	es:[bx.dl_index],dl
	jz	LLMUP_00
	ret
LLMUP_00:
	call	case_UP
	or	ax,ax
	jz	TDRETNORMAL
	call	mousedelay
	jnz	LLMUP_00
	jmp	TDRETNORMAL
TDLLISTMOUSEUP ENDP

TDLLISTMOUSEDN PROC
	les	bx,tdllist
	xor	ax,ax
	cmp	ax,es:[bx.ll_count]
	jz	TDRETNORMAL
	mov	ax,es:[bx.ll_numcel]
	dec	ax
	mov	es:[bx.ll_celoff],ax
	add	ax,es:[bx]
	les	bx,tdialog
	cmp	al,es:[bx.dl_index]
	mov	es:[bx.dl_index],al
	jz	LLMDN_00
	xor	ax,ax
	ret
LLMDN_00:
	call	case_DOWN
	or	ax,ax
	jz	TDRETNORMAL
	call	mousedelay
	jnz	LLMDN_00
TDLLISTMOUSEDN ENDP

else

case_MOUSE PROC
	mov	result,_C_NORMAL
	ret
case_MOUSE ENDP

endif ; __MOUSE__

TDRETNORMAL PROC
  ifdef __MOUSE__
	call	msloop
	inc	ax	; _C_NORMAL
  else
	mov	ax,_C_NORMAL
  endif
	ret
TDRETNORMAL ENDP

TDLISTITEM PROC
	xor	ax,ax
	call	ldobject
	test	ax,_O_LLIST
	jnz	TDLISTITEM_00
	and	al,0Fh
	cmp	al,_O_MENUS
	jz	TDLISTITEM_00
	mov	result,_C_NORMAL
	pop	ax
    TDLISTITEM_00:
	ret
TDLISTITEM ENDP

case_HOME PROC
	call	TDLISTITEM
	mov	ax,0
	jz	case_HOME_00
	les	bx,tdllist
	mov	es:[bx.S_LOBJ.ll_index],ax
	mov	es:[bx.S_LOBJ.ll_celoff],ax
	push	es:[bx.S_LOBJ.ll_dlgoff]
	call    es:[bx.S_LOBJ.ll_proc]
	pop	ax
    case_HOME_00:
	les	bx,tdialog
	mov	es:[bx.dl_index],al
	call	nextitem
	call	previtem
	ret
case_HOME ENDP

case_LEFT PROC
	xor	ax,ax
	call	ldobject
	test	ax,_O_LLIST
	jz	case_LEFT_00
	jmp	case_PGUP
    case_LEFT_00:
	and	ax,000Fh
	cmp	ax,_O_MENUS
	jz	case_LEFT_01
	call	itemleft
	jz	case_UP
	ret
    case_LEFT_01:
	jmp	case_EXIT
case_LEFT ENDP

case_RIGHT PROC
	xor	ax,ax
	call	ldobject
	test	ax,_O_LLIST
	jz	case_RIGHT_00
	jmp	case_PGDN
    case_RIGHT_00:
	and	ax,000Fh
	cmp	ax,_O_MENUS
	jz	case_RIGHT_01
	call	itemright
	jz	case_DOWN
	ret
    case_RIGHT_01:
	jmp	case_EXIT
case_RIGHT ENDP

case_UP PROC
	xor	ax,ax
	call	ldobject
	and	ax,_O_LLIST
	jz	case_UP_01
	xor	ax,ax
	les	bx,tdllist
	cmp	ax,es:[bx.ll_celoff]
	jne	case_UP_01
	cmp	ax,es:[bx.ll_index]
	je	case_UP_00
	mov	dx,es:[bx.ll_dlgoff]
	les	bx,tdialog
	cmp	es:[bx.dl_index],dl
	je	case_UP_02
	mov	es:[bx.dl_index],dl
	inc	ax
    case_UP_00:
	ret
    case_UP_01:
	call	previtem
	ret
    case_UP_02:
	les	bx,tdllist
	dec	es:[bx.ll_index]
	jmp	case_LLPROC
case_UP	ENDP

case_DOWN PROC
	xor	ax,ax
	call	ldobject
	and	ax,_O_LLIST
	jz	case_NEXT
	les	bx,tdllist
	mov	cx,es:[bx.ll_dcount]
	mov	dx,es:[bx.ll_celoff]
	mov	ax,cx
	dec	ax
	cmp	ax,dx
	jz	case_DOWN_00
	mov	ax,dx
	add	ax,es:[bx.ll_index]
	inc	ax
	cmp	ax,es:[bx.ll_count]
	jb	case_NEXT
    case_DOWN_00:
	mov	ax,es:[bx]
	add	ax,dx
	les	bx,tdialog
	mov	ah,es:[bx.dl_index]
	mov	es:[bx.dl_index],al
	cmp	al,ah
	jne	case_NORMAL
	les	bx,tdllist
	mov	ax,es:[bx.ll_count]
	sub	ax,es:[bx.ll_index]
	sub	ax,cx
	jle	return_NULL
	inc	es:[bx.ll_index]
case_DOWN ENDP

case_LLPROC PROC
	call	es:[bx.S_LOBJ.ll_proc]
	jmp	return_AX
case_LLPROC ENDP

case_EXIT PROC
	inc	di
case_EXIT ENDP

return_NULL PROC
	xor	ax,ax
return_NULL ENDP

return_AX PROC
	mov	result,ax
	ret
return_AX ENDP

case_NORMAL PROC
	mov	result,_C_NORMAL
	ret
case_NORMAL ENDP

case_TAB PROC
	xor	ax,ax
	call	ldobject
	and	ax,_O_LLIST
	jz	case_NEXT
	les	bx,tdllist
	mov	ax,es:[bx.ll_dlgoff]
	add	ax,es:[bx.ll_dcount]
	les	bx,tdialog
	mov	es:[bx.dl_index],al
	jmp	case_NORMAL
case_TAB ENDP

case_NEXT PROC
	jmp	nextitem
case_NEXT ENDP

case_ESC PROC
	mov	result,_C_ESCAPE
	ret
case_ESC ENDP

case_PGUP PROC
	call	TDLISTITEM
	jz	case_PGUP_02
	les	bx,tdllist
	xor	ax,ax
	cmp	ax,es:[bx.ll_celoff]
	jz	case_PGUP_01
	mov	es:[bx.ll_celoff],ax
	mov	ax,es:[bx.ll_dlgoff]
	les	bx,tdialog
	mov	es:[bx.dl_index],al
    case_PGUP_00:
	mov	result,_C_NORMAL
	ret
    case_PGUP_01:
	cmp	ax,es:[bx.ll_index]
	jz	case_PGUP_00
	mov	ax,es:[bx.ll_dcount]
	cmp	ax,es:[bx.ll_index]
	jbe	case_PGUP_03
    case_PGUP_02:
	jmp	case_HOME
    case_PGUP_03:
	sub	es:[bx.ll_index],ax
	jmp	case_LLPROC
case_PGUP ENDP

case_PGDN PROC
	call	TDLISTITEM
	jz	case_END
	les	bx,tdllist
	mov	ax,es:[bx.ll_dcount]
	dec	ax
	cmp	ax,es:[bx.ll_celoff]
	jz	case_PGDN_00
	mov	ax,es:[bx.ll_numcel]
	add	ax,es:[bx]
	dec	ax
	les	bx,tdialog
	mov	es:[bx.dl_index],al
	mov	result,_C_NORMAL
	ret
    case_PGDN_00:
	add	ax,es:[bx.ll_celoff]
	add	ax,es:[bx.ll_index]
	inc	ax
	cmp	ax,es:[bx.ll_count]
	jnb	case_END
	mov	ax,es:[bx.ll_dcount]
	add	es:[bx.ll_index],ax
	jmp	case_LLPROC
case_PGDN ENDP

case_END PROC
	call	TDLISTITEM
	jnz	case_END_00
	les	bx,tdialog
	mov	al,es:[bx.dl_count]
	dec	al
	mov	es:[bx.dl_index],al
	call	previtem
	call	nextitem
	ret
    case_END_00:
	les	bx,tdllist
	mov	ax,es:[bx.ll_count]
	cmp	ax,es:[bx.ll_dcount]
	jnb	case_END_01
	mov	ax,es:[bx.ll_numcel]
	dec	ax
	mov	es:[bx.ll_celoff],ax
	add	ax,es:[bx]
	les	bx,tdialog
	mov	es:[bx.dl_index],al
	mov	result,_C_NORMAL
	ret
    case_END_01:
	sub	ax,es:[bx.ll_dcount]
	cmp	ax,es:[bx.ll_index]
	jz	case_END_02
	mov	es:[bx.ll_index],ax
	mov	ax,es:[bx.ll_dcount]
	dec	ax
	mov	es:[bx.ll_celoff],ax
	add	ax,es:[bx]
	les	bx,tdialog
	mov	es:[bx.dl_index],al
	les	bx,tdllist
	jmp	case_LLPROC
    case_END_02:
	jmp	return_NULL
case_END ENDP

case_ENTER PROC
	xor	ax,ax
	call	ldobject
	and	ax,_O_CHILD
	mov	ax,_C_RETURN
	jnz	case_ENTER_00
	mov	result,ax
	ret
    case_ENTER_00:
	les	bx,tdialog
	mov	ah,0
	mov	al,es:[bx.dl_index]
	call	exechild
	ret
case_ENTER ENDP

OGOTOXY	PROC
	xor	ax,ax
	call	ldobject_cursor
	call	cursoron
	inc	oxpos
	push	oxpos
	push	oypos
	call	gotoxy
	ret
OGOTOXY	ENDP

XORRADIOFLAG PROC
	xor	ax,ax
	call	ldobject
	and	ax,_O_RADIO
	jz	XORRADIOFLAG_00
  ifdef __MOUSE__
	call	msloop
  else
	xor	ax,ax
  endif
	ret
    XORRADIOFLAG_00:
	les	bx,tdialog
	xor	cx,cx
	add	cl,es:[bx.dl_count]
	jz	XORRADIOFLAG_03
	MLES	bx,dword ptr es:[bx.dl_object_ax]
    XORRADIOFLAG_01:
	test	byte ptr es:[bx.to_flag],_O_RADIO
	jz	XORRADIOFLAG_02
	and	byte ptr es:[bx.to_flag],not _O_RADIO
	push	es
	push	bx
	push	cx
	push	tdsegdl
	push	tdoffdl
	push	es
	push	bx
	call	tdinitobj
	pop	cx
	pop	bx
	pop	es
    XORRADIOFLAG_02:
	add	bx,16
	dec	cx
	jnz	XORRADIOFLAG_01
	xor	ax,ax
	call	ldobject
	or	byte ptr es:[bx.to_flag],_O_RADIO
	push	tdsegdl
	push	tdoffdl
	push	es
	push	bx
	call	tdinitobj
  ifdef __MOUSE__
	call	msloop
	inc	ax
  else
	mov	ax,_C_NORMAL
  endif
    XORRADIOFLAG_03:
	ret
XORRADIOFLAG ENDP

ORETURN	PROC
	push	ax
	push	word ptr ocurs+2
	push	word ptr ocurs
	call	setcursor
	pop	ax
	ret
ORETURN	ENDP

TDXORSWITCH PROC
	xor	ax,ax
	call	ldobject
	xor	ax,_O_FLAGB
	mov	es:[bx],ax
	test	ax,_O_FLAGB
	mov	ax,' '
	jz	TDXORSWITCH_00
	mov	al,'x'
    TDXORSWITCH_00:
	mov	bx,word ptr orect
	inc	bl
	mov	cx,1
	call	@scputw
  ifdef __MOUSE__
	call	msloop
  else
	xor	ax,ax
  endif
	ret
TDXORSWITCH ENDP

ifdef __MOUSE__

TDTESTXYROW PROC
	push	word ptr orect+2
	push	word ptr orect
	call	mousex
	push	ax
	call	mousey
	push	ax
	call	rcxyrow
	mov	ax,MOUSECMD
	ret
TDTESTXYROW ENDP

endif

TDSELECTOBJ PROC
	push	word ptr orect+2
	push	word ptr orect
	MPUSH	ds
	push	offset xlbuf
	call	rcread
	mov	al,at_background[B_DarkGray]
	mov	bx,offset xlbuf
	push	ds
	pop	es
	mov	cx,oxlen
	call	@wcputbg
	push	word ptr orect+2
	push	word ptr orect
	MPUSH	ds
	push	offset xlbuf
	call	rcxchg
	ret
TDSELECTOBJ ENDP

TDESELECTOBJ PROC
	push	ax
	push	word ptr orect+2
	push	word ptr orect
	MPUSH	ds
	push	offset xlbuf
	call	rcwrite
	pop	ax
	ret
TDESELECTOBJ ENDP

if USE_MDALTKEYS

case_ALTUP PROC
	mov	ax,offset rcmoveup
	jmp	case_ALTMOVE
case_ALTUP ENDP

case_ALTDN PROC
	mov	ax,offset rcmovedn
	jmp	case_ALTMOVE
case_ALTDN ENDP

case_ALTLEFT PROC
	mov	ax,offset rcmoveleft
	jmp	case_ALTMOVE
case_ALTLEFT ENDP

case_ALTRIGHT PROC
	mov	ax,offset rcmoveright
case_ALTRIGHT ENDP

case_ALTMOVE PROC
	les	bx,tdialog
	test	es:[bx.dl_flag],_D_DMOVE
	jz	case_ALTMOVE_00
	push	word ptr es:[bx.dl_rect_c]
	push	word ptr es:[bx.dl_rect_x]
	push	es:[bx.dl_wp_dx]
	push	es:[bx.dl_wp_ax]
	push	es:[bx.dl_flag]
	LPUSH	cs
	call	ax
	les	bx,tdialog
	mov	es:[bx+4],dx
    case_ALTMOVE_00:
	ret
case_ALTMOVE ENDP

endif

_TEXT	ENDS

;************** Public

DPROC	tdpbuttevent
	push	si
	push	di
	xor	ax,ax
	call	ldobject_cursor
	call	cursoron
	mov	ax,oxpos
	inc	ax
	push	ax
	push	oypos
	call	gotoxy
	mov	al,byte ptr oflag
	and	al,0Fh
	cmp	al,_O_TBUTT
	je	tdpbuttevent_00
	call	cursoroff
    tdpbuttevent_00:
	mov	si,16
	mov	di,17
	call	xbuttxchg
	call	tgetevent
	push	ax
	call	xbuttxchg
	push	word ptr ocurs+2
	push	word ptr ocurs
	call	setcursor
	pop	ax
	pop	di
	pop	si
	ret
PEND	tdpbuttevent

DPROC	tdradioevent
	call	OGOTOXY
    tdradioevent_00:
	call	tgetevent
  ifdef __MOUSE__
	cmp	ax,MOUSECMD
	je	tdradioevent_01
  endif
	cmp	ax,KEY_SPACE
	je	tdradioevent_02
	jmp	tdradioevent_03
  ifdef __MOUSE__
    tdradioevent_01:
	call	omousecmd
	jz	tdradioevent_03
  endif
    tdradioevent_02:
	call	XORRADIOFLAG
	test	oflag,_O_EVENT
	jz	tdradioevent_00
	mov	ax,KEY_SPACE
    tdradioevent_03:
	call	ORETURN
	ret
PEND	tdradioevent

DPROC	tdcheckevent
	call	OGOTOXY
    tdcheckevent_00:
	call	tgetevent
  ifdef __MOUSE__
	cmp	ax,MOUSECMD
	je	tdcheckevent_01
  endif
	cmp	ax,KEY_SPACE
	je	tdcheckevent_02
	jmp	tdcheckevent_03
  ifdef __MOUSE__
    tdcheckevent_01:
	call	omousecmd
	jz	tdcheckevent_03
  endif
    tdcheckevent_02:
	call	TDXORSWITCH
	test	oflag,_O_EVENT
	jz	tdcheckevent_00
	mov	ax,KEY_SPACE
    tdcheckevent_03:
	call	ORETURN
	ret
PEND	tdcheckevent

DPROC	tdxcellevent
	xor	ax,ax
	call	ldobject
	jz	tdxcellevent_00
	call	cursoroff
    tdxcellevent_00:
	test	oflag,_O_LLIST
	jz	tdxcellevent_01
	les	bx,tdialog
	mov	ah,0
	mov	al,es:[bx.dl_index]
	les	bx,tdllist
	cmp	ax,es:[bx.ll_dlgoff]
	jb	tdxcellevent_01
	sub	ax,es:[bx.ll_dlgoff]
	cmp	ax,es:[bx.ll_numcel]
	jnb	tdxcellevent_01
	mov	es:[bx.ll_celoff],ax
    tdxcellevent_01:
	call	TDSELECTOBJ
    tdxcellevent_02:
	call	tgetevent
  ifdef __MOUSE__
	cmp	ax,MOUSECMD
	jne	tdxcellevent_07
	call	TDTESTXYROW
	jz	tdxcellevent_07
	push	oxpos
	push	oypos
	push	oxlen
	call	mousewait
	mov	ax,oflag
	and	ax,000Fh
	cmp	ax,_O_XHTML
	mov	ax,KEY_ENTER
	jz	tdxcellevent_07
	push	si
	mov	si,10
    tdxcellevent_03:
	push	16
	call	delay
	call	mousep
	jnz	tdxcellevent_04
	dec	si
	jnz	tdxcellevent_03
    tdxcellevent_04:
	call	mousep
	jz	tdxcellevent_05
	call	TDTESTXYROW
	jz	tdxcellevent_05
	mov	ax,KEY_ENTER
	jmp	tdxcellevent_06
    tdxcellevent_05:
	xor	ax,ax
    tdxcellevent_06:
	pop	si
  endif
    tdxcellevent_07:
	or	ax,ax
	jz	tdxcellevent_02
	call	TDESELECTOBJ
	ret
PEND	tdxcellevent

DPROC	tdteditevent
	xor	ax,ax
	call	ldobject
	mov	dx,es:[bx]
	push	es:[bx.to_data_dx]
	push	es:[bx.to_data_ax]
	push	word ptr es:[bx.to_rect_c]
	mov	ax,word ptr es:[bx.to_rect_x]
	mov	ch,0
	mov	cl,es:[bx.to_count]
	les	bx,tdialog
	add	ax,es:[bx+4]
	push	ax
	shl	cx,4
	and	dx,_O_DTEXT
	jz	tdteditevent_00
	or	cx,8000h
    tdteditevent_00:
	push	cx
	call	tdedit
	ret
PEND	tdteditevent

DPROC	tdmenusevent
	xor	ax,ax
	call	ldobject_cursor
	call	cursoroff
	mov	ax,es:[bx.to_data_ax]
	or	ax,ax
	jz	tdmenusevent_01
	push	es:[bx.to_data_dx]
	push	ax
	xor	ax,ax
	mov	es,ax
	mov	bh,es:[0484h]
	mov	bl,20
	mov	al,' '
	mov	ah,at_background[B_Menus]
	or	ah,at_foreground[F_Menus]
	mov	cx,68
	call	@scputw
	mov	ax,offset format_s
	mov	cx,003Ah
	call	@scputf
	add	sp,DPTRZ
    tdmenusevent_01:
	call	TDSELECTOBJ
	call	tgetevent
	call	TDESELECTOBJ
	push	ax
	push	word ptr ocurs+2
	push	word ptr ocurs
	call	setcursor
	pop	ax
	ret
PEND	tdmenusevent

PPROC	tdevent, dialog:dword
local	prevdlg:dword	; init tdialog
local	cursor:	dword	; init cursor
	push	si
	push	di
	mov	ax,word ptr tdialog+2
	mov	word ptr prevdlg+2,ax
	mov	ax,word ptr tdialog
	mov	word ptr prevdlg,ax
	mov	dx,word ptr dialog+2
	mov	word ptr tdialog+2,dx
	mov	ax,word ptr dialog
	mov	word ptr tdialog,ax
	les	bx,tdialog
	mov	si,es:[bx]
	test	si,_D_DOPEN
	jnz	tdevent_isopen
	push	dx
	push	ax
	call	twopen
	jz	tdevent_end
    tdevent_isopen:
	test	si,_D_ONSCR
	jnz	tdevent_isvisible
	push	tdsegdl
	push	tdoffdl
	call	twshow
	or	ax,ax
	jz	tdevent_end
    tdevent_isvisible:
	lea	ax,cursor
	push	ss
	push	ax
	call	getcursor
	call	cursoroff
	xor	ax,ax
	les	bx,tdialog
	cmp	es:[bx.dl_count],al
	je	tdevent_noobj
	call	ldobject
	and	ax,_O_DEACT
	jz	tdevent_modal
	call	nextitem
	jnz	tdevent_modal
    tdevent_noobj:
	call	tgetevent
	mov	cx,9
	call	test_event
	mov	ax,result
	cmp	ax,_C_ESCAPE
	je	tdevent_cancel
	cmp	ax,_C_RETURN
	je	tdevent_cancel
	jmp	tdevent_noobj
    tdevent_end:
	les	bx,dialog
	mov	dx,word ptr prevdlg+2
	mov	word ptr tdialog+2,dx
	mov	dx,word ptr prevdlg
	mov	word ptr tdialog,dx
	pop	di
	pop	si
	or	ax,ax
	ret
    tdevent_oevent:
    ifdef LPROG
	call	dword ptr es:[bx.to_proc_ax]
    else
	call	es:[bx.to_proc_ax]
    endif
	jmp	tdevent_test
    tdevent_modal:
  ifdef __MOUSE__
	call	msloop
  else
	xor	ax,ax
  endif
	xor	di,di
    tdevent_continue:
	xor	ax,ax
	mov	result,ax
	call	ldobject
	and	ax,_O_EVENT
	jnz	tdevent_oevent
	mov	ax,es:[bx]
	and	ax,000Fh
	cmp	al,6
	ja	tdevent_tbutt
	add	ax,ax
	xchg	bx,ax
	LPUSH	cs
	call	[bx+eventproc]
	jmp	tdevent_test
    tdevent_cancel:
	mov	event,0
	jmp	tdevent_exit
    tdevent_tbutt:
	cmp	al,_O_TBUTT
	mov	ax,KEY_ESC
	jne	tdevent_test
	call	tdpbuttevent
    tdevent_test:
	mov	event,ax
	mov	cx,key_count
	call	test_event
	mov	ax,result
	cmp	ax,_C_ESCAPE
	je	tdevent_cancel
	cmp	ax,_C_RETURN
	je	tdevent_return
	or	di,di
	jz	tdevent_continue
    tdevent_exit:
	push	word ptr cursor+2
	push	word ptr cursor
	call	setcursor
	mov	ax,event
	or	ax,ax
	jmp	tdevent_end
    tdevent_return:
	cmp	event,KEY_ENTER
	jne	tdevent_index
	xor	ax,ax
	call	ldobject
	and	ax,_O_DEXIT
	jnz	tdevent_cancel
    tdevent_index:
	les	bx,tdialog
	mov	ah,0
	mov	al,es:[bx.dl_index]
	inc	ax
	mov	event,ax
	jmp	tdevent_exit
PEND	tdevent

_DATA	SEGMENT

tdialog	label	dword
tdoffdl	dw	?
tdsegdl	dw	?
tdllist	label	dword
tdoffll	dw	?
tdsegll	dw	?
tdoffss	dw	?

ocurs	dd	?
tobjp	dd	?
oflag	dw	?
orect	dd	?
oxpos	dw	?
oypos	dw	?
oxlen	dw	?
xlbuf	dw 	80 dup(?)

event	dw	?
result	dw	?

proctab label word
	dw	case_ESC
	dw	case_ESC
  if USE_MDALTKEYS
	dw	case_ALTUP
	dw	case_ALTDN
	dw	case_ALTLEFT
	dw	case_ALTRIGHT
  endif
	dw      case_ENTER
	dw      case_ENTER
  ifdef __MOUSE__
	dw      cmdmouse
  endif
	dw      case_LEFT
	dw      case_UP
	dw      case_RIGHT
	dw      case_DOWN
	dw      case_HOME
	dw      case_END
	dw      case_TAB
	dw      case_PGUP
	dw      case_PGDN

keytable label word
	dw      KEY_ESC
	dw      KEY_ALTX
  if USE_MDALTKEYS
	dw	KEY_ALTUP
	dw	KEY_ALTDN
	dw	KEY_ALTLEFT
	dw	KEY_ALTRIGHT
  endif
	dw      KEY_ENTER
	dw      KEY_KPENTER
  ifdef __MOUSE__
	dw	MOUSECMD
  endif
	dw      KEY_LEFT
	dw      KEY_UP
	dw      KEY_RIGHT
	dw      KEY_DOWN
	dw      KEY_HOME
	dw      KEY_END
	dw      KEY_TAB
	dw      KEY_PGUP
	dw      KEY_PGDN

if USE_MDALTKEYS
 ifdef __MOUSE__
  key_count =	18
 else
  key_count =	17
 endif
else
 ifdef __MOUSE__
  key_count =	14
 else
  key_count =	13
 endif
endif

eventproc label word
	dw	offset tdpbuttevent
	dw	offset tdradioevent
	dw	offset tdcheckevent
	dw	offset tdxcellevent
	dw	offset tdteditevent
	dw	offset tdmenusevent
	dw	offset tdxcellevent

format_s db	'%s',0

_DATA	ENDS

	END
