include	clib.inc
include	clip.inc
include	malloc.inc
include	string.inc
include	conio.inc

_TEXT	SEGMENT

ClearClipboard PROC
	xor	ax,ax
	mov	word ptr Clipbsize,ax
	mov	word ptr Clipbsize+2,ax
	mov	ax,word ptr Clipboard
	mov	dx,word ptr Clipboard+2
	or	ax,ax
	jnz	ClearClipboard_00
	or	dx,dx
	jz	ClearClipboard_end
    ClearClipboard_00:
	push	dx
	push	ax
	xor	ax,ax
	mov	word ptr Clipboard,ax
	mov	word ptr Clipboard+2,ax
	call	free
    ClearClipboard_end:
	ret
ClearClipboard ENDP

INT_2F	PROC
	xor	ax,ax
	cmp	WINOLDAP,ax
	je	INT_2F_end
	mov	ax,dx
	int	2Fh
    INT_2F_end:
	ret
INT_2F	ENDP

_TEXT	ENDS

DPROC	ClipboardFree
	call	ClearClipboard
	ret
PEND	ClipboardFree

DPROC	ClipboardInit
	xor	ax,ax
	mov	WINOLDAP,ax
	test	console,CON_CLIPB
	jz	ClipboardInit_00
	mov	ax,1700h
	int	2Fh
	mov	dx,ax
	xor	ax,ax			; AX <> 1700h
	cmp	dx,1700h        	; - AL = WINOLDAP major version
	jz	ClipboardInit_00	; - AH = WINOLDAP minor version
	mov	WINOLDAP,dx
    ClipboardInit_00:
	inc	ax
	ret
PEND	ClipboardInit

DPROC	ClipboardOpen
	mov	dx,1701h
	call	INT_2F
	xor	ax,ax
	inc	ax
	ret
PEND	ClipboardOpen

DPROC	ClipboardClose
	mov	dx,1708h
	call	INT_2F
	ret
PEND	ClipboardClose

DPROC	ClipboardEmpty
	mov	dx,1702h
	call	INT_2F
	call	ClearClipboard
	ret
PEND	ClipboardEmpty

PPROC	ClipboardCopy, string:DPTR, len:word
	call	ClearClipboard
	xor	ax,ax
	cmp	WINOLDAP,ax
	je	ClipboardCopy_00
	mov	dx,1		; set type to text
	mov	cx,len		; SI:CX = size of data
	push	si
	mov	si,ax		; HSIZE = 0
	MLES	bx,string	; ES:BX = data
	mov	ax,1703h
	int	2Fh
	pop	si
	or	ax,ax
	jnz	ClipboardCopy_01
    ClipboardCopy_00:
	mov	ax,len
	inc	ax
	push	ax
	call	malloc
	jz	ClipboardCopy_01
	mov	word ptr Clipboard,ax
	mov	word ptr Clipboard+2,dx
	mov	es,dx
	mov	bx,ax
	mov	cx,len
	mov	Clipbsize,cx
	add	bx,cx
	mov	byte ptr es:[bx],0
	push	dx
	push	ax
	pushm	string
	push	cx
	call	memcpy
    ClipboardCopy_01:
	ret
PEND	ClipboardCopy

DPROC	ClipboardPaste
	xor	dx,dx
	cmp	WINOLDAP,dx
	je	ClipboardPaste_01
	inc	dx
	mov	ax,1704h
	int	2Fh
	or	dx,dx
	jnz	ClipboardPaste_01
	or	ax,ax
	jz	ClipboardPaste_01
	cmp	ax,MAXCLIPSIZE
	jae	ClipboardPaste_01
	push	ax
	push	ax
	call	ClearClipboard
	call	malloc
	pop	cx
	jz	ClipboardPaste_02
	mov	Clipbsize,cx
	mov	word ptr Clipboard,ax
	mov	word ptr Clipboard+2,dx
	push	dx
	push	ax
	push	cx
	call	memzero
	mov	dx,1
	les	bx,Clipboard
	mov	ax,1705h
	int	2Fh
    ClipboardPaste_00:
	mov	cx,word ptr Clipboard
	mov	dx,word ptr Clipboard+2
	jmp	ClipboardPaste_02
    ClipboardPaste_01:
	xor	cx,cx
	mov	dx,ax
	cmp	ax,Clipbsize
	jne	ClipboardPaste_00
    ClipboardPaste_02:
	mov	ax,cx
	or	ax,ax
	ret
PEND	ClipboardPaste

DPROC	ClipboardSize
	xor	dx,dx
	cmp	WINOLDAP,dx
	je	ClipboardSize_00
	inc	dx
	mov	ax,1704h
	int	2Fh
	or	dx,dx
	jz	ClipboardSize_01
    ClipboardSize_00:
	mov	ax,Clipbsize
    ClipboardSize_01:
	xor	dx,dx
	ret
PEND	ClipboardSize

_DATA	SEGMENT

WINOLDAP  dw	0
Clipbsize dw	0
Clipboard dd	0

_DATA	ENDS

	END
