# BUILDASM.MAK--
# Makes a library for a single memory model
#
# Output: Cx or LIBx or CLIBx
# Syntax: [NMAKE|WMAKE|MAKE] xxx=x [MDL|W0X|NOX|DEBUG]
#
#  MDL=c  Memory model (c or l)
#  W0X=1  Open Watcom C library
#  NOX=1  No eXtra - tiny version
#
# Default: LIBL
#

!ifndef MDL
MDL=l
!endif

!ifdef W0X
CFG=/D__WCC__
!else
! ifdef NOX
CFG=/D__NOX__
! endif
!endif

# Get Doszip root directory and flags
!include ..\srcpath

!if $(DEBUG)
SRCASM=$(ROT)\src\clib\src\*.ASM
OUTLIB=$(ROT)\lib\c$(MDL)
!else
SRCASM=src\*.asm
!ifdef W0X
OUTLIB=$(ROT)\lib\clib$(MDL)
!else
OUTLIB=$(ROT)\lib\lib$(MDL)
!endif
!endif

$(OUTLIB).LIB:
 @for %f in ($(SRCASM)) do $(AC) $(AF) %f
!ifdef 	__WCC__
 @for %f in (*.OBJ) do @%append OBJECTS -+%f
!else
 @for %f in (*.OBJ) do echo -+%f & >> OBJECTS
 @echo -+ALLOC.OBJ >> OBJECTS
!endif
!ifdef 	__BCC__
 tlib $(OUTLIB) /C @OBJECTS
!endif
!ifdef 	__MCC__
 lib $(OUTLIB) /I /NOLOGO @OBJECTS;
!endif
!ifdef 	__WCC__
 wlib -q -c $(OUTLIB) @OBJECTS.
!endif
 @del *.obj
 @del OBJECTS
 @if exist $(OUTLIB).bak del $(OUTLIB).bak
