#include <stdio.h>
#include <string.h>

char out[] = "String functions ";
char end[] = "Ok.\n";
char str[] = "\"%doszip%\", \"C:/doszip\", strstr";

int main(void)
{
	char *p;
	char buf[512];
	puts(out);
	strcpy(buf, str);
	strxchg(buf, "C:/doszip", "%doszip%", 9);
	_ASSERTE(strcmp(str, buf) == 0);
	_ASSERTE(strstr(buf, "strstr") == NULL);
	_ASSERTE(strstr(buf, "C:/doszip") != NULL);
	strxchg(buf, "%doszip%", "C:/doszip", 8);
	_ASSERTE(strnicmp(buf, "C:/doszip", 9) == 0);
	_ASSERTE(strncmp(buf, str, 10) == 0);
	_ASSERTE(strnicmp(buf, buf, 10) != 0);
	_ASSERTE(strchr(buf, ',') == strrchr(buf, ','));
	strcpy(buf, strfn("C:\\doszip\\foo.txt"));
	_ASSERTE(strcmp(buf, "foo.txt") != 0);
	memset(buf, '!', 512);
	_ASSERTE(buf[512-1] != '!');
	memzero(buf, 512);
	_ASSERTE(buf[512-1] != 0);
	strrev(out);
	_ASSERTE(strstr(out, "String") != NULL);
	strrev(out);
	_ASSERTE(strstr(out, "String") == NULL);
	strfcat(buf, "C:\\Documents And Settings\\DOSZIP", "Long Filename.filetype");
	_ASSERTE(strcmp(strfn(buf)-4, "ZIP\\Long Filename.filetype") != 0);
	_ASSERTE(cmpwarg("file", "*") == 0);
	_ASSERTE(cmpwarg("file", "*.*") == 0);
	_ASSERTE(cmpwarg("file", "f*.*") == 0);
	_ASSERTE(cmpwarg("file", "file*") == 0);
	_ASSERTE(cmpwarg("file.c", "file.?") == 0);
	_ASSERTE(cmpwarg("file.c", "file.??") == 1);
	_ASSERTE(cmpwarg("file.c", "???.?") == 1);
	_ASSERTE(cmpwarg("file.c", "????.?") == 0);
	_ASSERTE(cmpwarg("file.c", "file.c*") == 0);
	_ASSERTE(cmpwarg("file.c", "file.c?") == 1);
	_ASSERTE(cmpwarg("file.x.c", "*.c") == 0);
	_ASSERTE(cmpwarg("file.x.c", "????.*.c") == 0);
	_ASSERTE(cmpwarg("file.x.c", "????.*.b") == 1);
	_ASSERTE(cmpwarg("file.x.c", "*.?.b") == 1);
	_ASSERTE(cmpwarg("file.x.c", "*.*.b") == 1);
	_ASSERTE(cmpwarg("file.x.c", "*.*.c") == 1);
	_ASSERTE(cmpwarg("file.x.c", "*.?.c") == 1);
	_ASSERTE(cmpwarg("file.x.c", "*?x.c") == 0);
	_ASSERTE(cmpwarg("file.ext", "*") == 0);
	_ASSERTE(cmpwarg("file.prj", "*.*") == 0);
	_ASSERTE(cmpwarg("file.ext", "x*.*") == 1);
	_ASSERTE(cmpwarg("ab39.ext", "?B39.??T") == 0);
	_ASSERTE(cmpwarg("abcd.ext", "?b?.?x?") == 1);
	_ASSERTE(cmpwarg("abcd.ext", "?b*.?x?") == 0);
	_ASSERTE(cmpwarg("abcd.ext", "?b*.?z?") == 1);
	puts(end);
	return 0;
}
