; Change history:
; 10/21/2009	added pre-selected default text
; 10/20/2009	fixed bug in selected text
; 10/11/2009	fixed bug in tiputs
; 09/21/2009	fixed bug in ClipboardCut

include	clib.inc
include	clip.inc
include	dos.inc
include	string.inc
include	dialog.inc
include	malloc.inc

	.186

CONTINUE EQU	0	; continue edit
RETEVENT EQU	1	; return current event (keystroke)
CMFAILED EQU	2	; operation fail (end of line/buffer)

_DATA	SEGMENT

base	DD ?	; base pointer
xpos	DW ?	; text window x,y
ypos	DW ?
cols	DW ?	; size of screen-line
bcol	DW ?	; size of buffer-line
xoff	DW ?	; offset on screen
boff	DW ?	; offset in buffer (start of screen-line)
bcnt	DW ?	; byte count in line
if USE_CLIPBOARD
 clst	DD ?	; Clipboard start
 clen	DD ?	; Clipboard end
endif
 clat	DW ?	; Normal string attrib

ti_proctab LABEL WORD
	DW	ticontinue
	DW      tinextword
	DW      tiprevword
	DW      tidelete
	DW      tiesc
	DW      timouse
	DW      tileft
	DW      tiright
	DW      tihome
	DW      titoend
	DW      tibacksp
	DW      tiesc
	DW      tiesc
	DW      tiesc

ti_keytable LABEL WORD
	DW	CONTINUE
	DW      KEY_CTRLRIGHT
	DW      KEY_CTRLLEFT
	DW      KEY_DEL

ti_skipkeys LABEL WORD
	DW      KEY_ESC		; 011B
	DW      MOUSECMD	; FFFE
	DW      KEY_LEFT	; 4B00
	DW      KEY_RIGHT	; 4D00
	DW      KEY_HOME	; 4700
	DW      KEY_END 	; 4F00
	DW      KEY_BKSP	; 0E08
	DW      KEY_TAB		; 0F09
	DW      KEY_ENTER	; 1C0D
	DW      KEY_KPENTER	; E00D
	DW	KEY_UP		; 4800
	DW	KEY_DOWN	; 5000

ti_key_count =	14

_DATA	ENDS

_TEXT	SEGMENT

ticurlp	PROC
	les	BX,base ; current line offset (in buffer)
	mov	DX,ES
	mov	AX,BX	; return DX:AX and ES:BX
	ret
ticurlp	ENDP

ticursp	PROC
	call	ticurlp		; current line offset (on screen)
	add	AX,boff
	mov	BX,AX
	ret
ticursp	ENDP

ticurp	PROC
	call	ticurlp		; current char offset (on screen)
	add	AX,boff
	add	AX,xoff
	mov	BX,AX
	ret
ticurp	ENDP

nocando	PROC
	push	9
	push	1
	call	beep	; end of line/buffer
	mov	AX,CMFAILED
	ret
nocando	ENDP

tihome	PROC
	xor	AX,AX
	mov	xoff,AX
	mov	boff,AX
	ret
tihome	ENDP

titoend	PROC
	mov	DX,cols
	dec	DX
	mov	AX,bcnt
	cmp	AX,DX
	jle	tiend_00
	mov	AX,DX
tiend_00:
	mov	xoff,AX	; MIN(bcnt, cols - 1);
	mov	DX,bcnt
	sub	DX,cols
	inc	DX
	xor	AX,AX
	cmp	AX,DX
	jg	tiend_01
	mov	AX,DX
tiend_01:
	mov	boff,AX	; MAX(bcnt - cols + 1, 0);
	mov	AX,boff
	dec	AX
	cmp	AX,bcnt
	jne	tiend_02
	dec	boff	; if (bcnt == bcol - 1) boff--;
tiend_02:
	mov	AX,CONTINUE
	ret
titoend	ENDP

tiseto	PROC
	call	ticurlp
	push	DX
	push	AX
	xor	AX,AX
	add	BX,bcol
	dec	BX
	mov	ES:[BX],AL	; line[bcol - 1] = 0;
	call	strlen
	mov	bcnt,AX		; byte count in line
	mov	DX,boff		; test if char is visible
	add	DX,xoff
	cmp	DX,AX
	jb	tiseto_00
	call	titoend         ; if not --> to end of line
	mov	AX,1
	ret
tiseto_00:
	xor	AX,AX
	ret
tiseto	ENDP

tiputl	PROC
	push	DS	; print out ES:BX to screen
	push	SI
if USE_CLIPBOARD
	push	DI
	MOV	DI,BX
endif
	push	ES
	push	BX
	mov	BH,BYTE PTR ypos
	mov	BL,BYTE PTR xpos
	call	@getxyp	; ES:BX to screen
if USE_CLIPBOARD
	push	BX
	inc	BX
	mov	AH,at_background[B_DarkGray]
	mov	CX,cols
tiputl_00:
	cmp	DI,WORD PTR clen
	jge	tiputl_02
	cmp	DI,WORD PTR clst
	jl	tiputl_01
	mov	ES:[BX],AH
tiputl_01:
	inc	DI
	add	BX,2
	dec	CX
	jnz	tiputl_00
tiputl_02:
	pop	BX
endif
	mov	CX,cols
	pop	SI	; DS:SI to string
	pop	DS
tiputl_03:
	mov	AL,[SI]
	inc	SI
	or	AL,AL
	jz	tiputl_04
	mov	ES:[BX],AL
	add	BX,2
	dec	CX
	jnz	tiputl_03
tiputl_04:
if USE_MOUSE
	call	mouseshow
endif
if USE_CLIPBOARD
	pop	DI
endif
	pop	SI
	pop	DS
	ret
tiputl	ENDP

tiputs	PROC
	mov	BH,BYTE PTR ypos
	mov	BL,BYTE PTR xpos
	mov	CX,cols
	mov	AL,tclrascii
if USE_CLIPBOARD
	mov	AH,BYTE PTR clat
	call	@scputw
else
	call	@scputc
endif
	push	WORD PTR base+2
	push	WORD PTR base
	call	strlen
	cmp	AX,boff
	jbe	puts_00
	les	BX,base
	add	BX,boff
	call	tiputl
puts_00:
	mov	AX,xpos
	add	AX,xoff
	push	AX
	push	ypos
	call	gotoxy
	xor	AX,AX
	ret
tiputs	ENDP

tiputc	PROC
	cmp	AL,tminascii
	jb	tiputc_00
	cmp	AL,tmaxascii
	ja	tiputc_00
	inc	bcnt
	MOV	BX,bcnt
	mov	DX,bcol
	cmp	DX,bcnt
	jbe	tiputc_02
	push	AX
	call	ticurp
	push	DX
	inc	AX
	push	AX
	push	DX
	push	BX
	mov	AX,bcol
	sub	AX,xoff
	sub	AX,boff
	dec	AX
	push	AX
	call	memmove
	mov	ES,DX
	dec	AX
	mov	BX,AX
	pop	AX
	mov	ES:[BX],AL
	inc	xoff
	mov	AX,cols
	cmp	xoff,AX
	jl	tiputc_01
	dec	AX
	mov	xoff,AX
	add	AX,boff
	cmp	bcnt,AX
	jbe	tiputc_01
	inc	xoff
	jmp	tiputc_01
tiputc_00:
	mov	AX,RETEVENT
	ret
tiputc_01:
	mov	AX,CONTINUE
	ret
tiputc_02:
	dec	DX
	mov	bcnt,DX
	call	nocando
	ret
tiputc	ENDP

tinextword PROC
	call	ticurp
	xor	AX,AX
	cmp	AL,ES:[BX]
	jz	nextw_06
	mov	AX,boff
	add	AX,xoff
	cmp	AX,bcnt
	mov	AX,' '
	jnb	nextw_06
	cmp	ES:[BX+1],AH
	jz	nextw_06
	push	BX
	inc	BX
	push	ES
	push	BX
	push	AX
	call	strchr
	pop	BX
	jz	nextw_05
	mov	ES,DX
	xchg	AX,BX
nextw_00:
	cmp	BYTE PTR ES:[BX],' '
	jne	nextw_01
	inc	BX
	jmp	nextw_00
nextw_01:
	sub	BX,AX
	jmp	nextw_04
nextw_02:
	dec	BX
	mov	AX,cols
	dec	AX
	cmp	AX,xoff
	jbe	nextw_03
	inc	xoff
	jmp	nextw_04
nextw_03:
	inc	boff
nextw_04:
	or	BX,BX
	jnz	nextw_02
	jmp	nextw_06
nextw_05:
	call	titoend
	ret
nextw_06:
	mov	AX,CONTINUE
	ret
tinextword ENDP

tiback	PROC
	mov	AX,CMFAILED
	cmp	CX,xoff
	je	back_00
	dec	xoff
	xor	AX,AX
	ret
back_00:
	cmp	CX,boff
	je	back_01
	dec	boff
	xor	AX,AX
back_01:
	ret
tiback	ENDP

tiprevword PROC
	mov	AX,boff
	add	AX,xoff
	or	AX,AX
	jz	prevw_03
	call	ticurp
	dec	BX
	mov	DL,' '
	xor	CX,CX
prevw_00:
	cmp	ES:[BX],DL
	ja	prevw_01
	call	tiback
	dec	BX
	jmp	prevw_00
prevw_01:
	cmp	BX,AX
	jbe	prevw_02
	call	tiback
	dec	BX
	cmp	ES:[BX],DL
	ja	prevw_01
prevw_02:
	cmp	AX,BX
	jnz	prevw_03
	xor	AX,AX
	mov	boff,AX
	mov	xoff,AX
prevw_03:
	mov	AX,CONTINUE
	ret
tiprevword ENDP

tidelete PROC
	call	ticurp
	cmp	BYTE PTR ES:[BX],0
	je	delete_00
	dec	bcnt
	push	DX
	push	BX
	inc	BX
	push	DX
	push	BX
	call	strcpy
delete_00:
	mov	AX,CONTINUE
	ret
tidelete ENDP

tibacksp PROC
	xor	CX,CX
	mov	AX,boff
	add	AX,xoff
	or	AX,AX
	jz	backsp_00
	call	tiback
	dec	bcnt
	call	ticurp
	push	DX
	push	BX
	inc	BX
	push	DX
	push	BX
	call	strcpy
	mov	AX,CONTINUE
	ret
backsp_00:
	call	nocando
	ret
tibacksp ENDP

timouse	PROC
if USE_MOUSE
	call	mousey
	cmp	AX,ypos
	jne	mouse_01
	call	mousex
	mov	DX,xpos
	cmp	AL,DL
	jb	mouse_01
	add	DX,cols
	cmp	AX,DX
	jnb	mouse_01
	sub	AX,xpos
	mov	xoff,AX
	mov	AX,WORD PTR base
	add	AX,boff
	push	WORD PTR base+2
	push	AX
	call	strlen
	cmp	AX,xoff
	jnb	mouse_00
	mov	xoff,AX
mouse_00:
	mov	AX,xpos
	add	AX,xoff
	push	AX
	push	ypos
	call	gotoxy
	call	msloop
	jmp	ticontinue
mouse_01:
	mov	AX,RETEVENT
	ret
else
	mov	AX,CONTINUE
	ret
endif
timouse	ENDP

tiesc	PROC
	mov	AX,RETEVENT
	ret
tiesc	ENDP

tileft	PROC
	xor	CX,CX
	call	tiback
	ret
tileft	ENDP

ticontinue PROC
	xor	AX,AX
	ret
ticontinue ENDP

tiright	PROC
	call	ticurp
	mov	AL,ES:[BX]
	sub	BX,xoff
	or	AL,AL
	jz	right_00
	mov	AX,cols
	dec	AX
	cmp	AX,xoff
	jbe	right_00
	inc	xoff
	jmp	ticontinue
right_00:
	push	DX
	push	BX
	call	strlen
	cmp	AX,cols
	jb	right_01
	inc	boff
	jmp	ticontinue
right_01:
	call	nocando
	ret
tiright	ENDP

if USE_CLIPBOARD

SETCLIPBOARD PROC
	call	ticurp	; set clipboard to current position
	mov	WORD PTR clst,AX
	mov	WORD PTR clst+2,DX
	mov	WORD PTR clen,AX
	mov	WORD PTR clen+2,DX
	ret
SETCLIPBOARD ENDP

CLIPBOARDDELETE	PROC
	mov	AX,WORD PTR clen
	sub	AX,WORD PTR clst
	jz	CLPD_01
	push	WORD PTR clst+2
	push	WORD PTR clst
	push	WORD PTR clen+2
	push	WORD PTR clen
	call	strcpy
	mov	DX,WORD PTR clen
	sub	DX,AX
	mov	BX,WORD PTR base
	add	BX,boff
	add	BX,xoff
	cmp	AX,BX
	je	CLPD_00
	sub	xoff,DX
CLPD_00:
	call	tiseto
	call	SETCLIPBOARD
	xor	AX,AX
	inc	AX
CLPD_01:
	ret
CLIPBOARDDELETE	ENDP

CLIPBOARDCUT PROC
	mov	DX,AX
	mov	AX,WORD PTR clen
	sub	AX,WORD PTR clst
	jle	CLPCUT_00
	push	DX
	push	WORD PTR clst+2
	push	WORD PTR clst
	push	AX
	call	ClipboardOpen
	call	ClipboardEmpty
	call	ClipboardCopy
	call	ClipboardClose
	pop	AX
	or	AX,AX
	jz	CLPCUT_00
	call	CLIPBOARDDELETE
CLPCUT_00:
	call	SETCLIPBOARD
	xor	AX,AX
	ret
CLIPBOARDCUT ENDP

CLIPBOARDGET PROC
	push	SI
	push	DI
	push	xoff
	push	boff
	call	CLIPBOARDDELETE
	call	ClipboardOpen
	call	ClipboardSize
	or	AX,AX
	jz	clget_01
	cmp	AX,1FFFh
	ja	clget_01
	mov	SI,AX
	call	ClipboardPaste
	jz	clget_01
	push	DX
	push	AX
	call	ClipboardClose
	pop	DI
	pop	ES
clget_00:
	mov	AL,ES:[DI]
	or	AL,AL
	jz	clget_01
	inc	DI
	push	ES
	call	tiputc
	pop	ES
	or	AX,AX
	jnz	clget_01
	dec	SI
	jnz	clget_00
clget_01:
	pop	DX
	pop	AX
	mov	xoff,AX
	mov	boff,DX
	xor	AX,AX
	pop	DI
	pop	SI
	ret
CLIPBOARDGET ENDP

CLIPBOARDEVENT PROC
	push	SI
	mov	SI,AX
	mov	AX,WORD PTR clst
	cmp	AX,WORD PTR clen
	jne	CLPE_00
	call	SETCLIPBOARD
CLPE_00:
	cmp	SI,KEY_CTRLINS
	je	CLPE_05
	cmp	SI,KEY_CTRLDEL
	je	CLPE_06
	les	BX,keyshift
	mov	AX,ES:[BX]
	and	AX,3
	jnz	CLPE_01
	cmp	SI,KEY_DEL
	jne	CLPE_12
	call	CLIPBOARDDELETE
	jz	CLPE_02
	xor	AX,AX
	jmp	CLPE_03
CLPE_01:
	cmp	SI,KEY_INS
	je	CLPE_04
	cmp	SI,KEY_DEL
	je	CLPE_06
	cmp	SI,KEY_HOME
	je	CLPE_08
	cmp	SI,KEY_LEFT
	je	CLPE_08
	cmp	SI,KEY_RIGHT
	je	CLPE_08
	cmp	SI,KEY_END
	je	CLPE_08
CLPE_12:
	cmp	SI,KEY_ESC
	je	CLPE_02
if USE_MOUSE
	cmp	SI,MOUSECMD
	je	CLPE_02
endif
	cmp	SI,KEY_BKSP
	je	CLPE_02
	cmp	SI,KEY_TAB
	je	CLPE_02
	cmp	SI,KEY_ENTER
	je	CLPE_02
	cmp	SI,KEY_KPENTER
	je	CLPE_02
	mov	AX,SI
	or	AL,AL
	jz	CLPE_02
	call	CLIPBOARDDELETE
CLPE_02:
	call	SETCLIPBOARD
	mov	AX,SI
CLPE_03:
	pop	SI
	ret
CLPE_04:
	call	CLIPBOARDGET
	jmp	CLPE_03
CLPE_05:
	xor	AX,AX
	jmp	CLPE_07
CLPE_06:
	mov	AX,1
CLPE_07:
	call	CLIPBOARDCUT
	jmp	CLPE_03
CLPE_08:
	mov	AX,SI
	call	tievent
	or	AX,AX
	jnz	CLPE_11
	call	ticurp
	cmp	AX,WORD PTR clst
	jb	CLPE_10
	cmp	SI,KEY_RIGHT
	jne	CLPE_09
	mov	DX,AX
	dec	DX
	cmp	DX,WORD PTR clst
	jne	CLPE_09
	cmp	DX,WORD PTR clen
	jnz	CLPE_10
CLPE_09:
	mov	WORD PTR clen,AX
	jmp	CLPE_11
CLPE_10:
	mov	WORD PTR clst,AX
CLPE_11:
	xor	AX,AX
	jmp	CLPE_03
CLIPBOARDEVENT	ENDP

endif	; Clipboard

tievent	PROC
	mov	CX,ti_key_count
	xor	BX,BX
event_00:
	cmp	AX,[BX+ti_keytable]
	je	event_01
	add	BX,2
	dec	CX
	jnz	event_00
	call	tiputc
	ret
event_01:
	jmp	[BX+ti_proctab]
tievent	ENDP

timodal	PROC
	push	SI
	push	DI
	mov	SI,CONTINUE
modal_00:
	call	tiseto
	call	tiputs
	cmp	SI,RETEVENT;CONTINUE
	je	modal_01
	call	tgetevent
if USE_CLIPBOARD
	call	CLIPBOARDEVENT
endif
	mov	DI,AX
	call	tievent
	mov	SI,AX
	jmp	modal_00
modal_01:
	call	ticurlp
	push	DX
	push	AX
	call	strlen
	mov	bcnt,AX
	mov	AX,DI
	pop	DI
	pop	SI
	ret
timodal	ENDP

if USE_CLIPBOARD
init_clipboard PROC
	mov	ax,WORD PTR base
	mov	WORD PTR clst,ax; start = end = base
	mov	WORD PTR clen,ax
	mov	ax,WORD PTR base+2
	mov	WORD PTR clst+2,ax
	mov	WORD PTR clen+2,ax
	call	ClipboardInit	; init WINOLDAP functions
	ret
init_clipboard	ENDP
endif

_TEXT	ENDS

;************** int tdedit(char *base, RECT, int bsize[, int lcount]);

if USE_MULTILINE
PPROC	tdedit, b:DWORD, rc:DWORD, bz:WORD, lc:WORD
else
PPROC	tdedit, b:DWORD, rc:DWORD, bz:WORD
endif
LOCAL	cursor:	DWORD
	lea	AX,cursor
	push	SS
	push	AX
	call	getcursor
	call	cursoron
	mov	AX,WORD PTR b
	mov	WORD PTR base,AX
	mov	AX,WORD PTR b+2
	mov	WORD PTR base+2,AX
	mov	AX,bz
	and	AX,7FFFh
	mov	bcol,AX
	call	tihome
	mov	xoff,AX
	mov	AL,BYTE PTR rc
	mov	xpos,AX
	push	AX
	mov	AL,BYTE PTR rc+1
	mov	ypos,AX
	push	AX
	mov	AL,BYTE PTR rc+2
	mov	cols,AX
	call	gotoxy
	mov	BL,BYTE PTR xpos ; get attrib of text to select
	mov	BH,BYTE PTR ypos
	call	@getxya
	mov	clat,ax         ; save text color
if USE_CLIPBOARD
	call	init_clipboard
	test	bz,8000h
	jz	tdedit_00
	call	tiseto
	call	titoend
	call	ticurp
	mov	WORD PTR clen,AX
	mov	WORD PTR clen+2,DX
tdedit_00:
endif
	call	tiseto
	call	timodal
	push	AX
	call	tiputs
	push	WORD PTR cursor+2
	push	WORD PTR cursor
	call	setcursor
	pop	AX
toend:	ret
PEND	tdedit

PPROC	tihndlevent, tinfo:DWORD, event:WORD
	push	DS
	push	OFFSET base
	push	WORD PTR tinfo+2
	push	WORD PTR tinfo
	push	SIZE S_TINFO
	call	memcpy
if USE_CLIPBOARD
	cmp	clat,0
	jne	tihe_00
	call	init_clipboard
endif
tihe_00:
	call	tiseto
	call	tiputs
	mov	AX,event
	or	AX,AX
	jnz	tihe_01
	call	tgetevent
	mov	event,AX
tihe_01:
if USE_CLIPBOARD
	call	CLIPBOARDEVENT
endif
	call	tievent
	push	AX
	call	tiseto
	call	tiputs
	push	WORD PTR tinfo+2
	push	WORD PTR tinfo
	push	DS
	push	OFFSET base
	push	SIZE S_TINFO
	call	memcpy
	pop	DX
	xor	AX,AX
	cmp	DX,RETEVENT
	jne	tihe_02
	mov	AX,event
tihe_02:
	ret
PEND	tihndlevent

	END
